/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ltpaLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private ContextManager contextManager;
    private UserRegistry registry;
    protected boolean debug = false;
    private LTPAServerObject ltpaServer;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register((Class)ltpaLoginModule.class, null, (String)"com.ibm.ejs.resources.security");

    public ltpaLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ltpaLoginModule()");
            Tr.exit((TraceComponent)tc, (String)"ltpaLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")"));
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                this.ltpaServer = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.initialize", (String)"160", (Object)this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"ERROR: Failed to get the LTPA server object.");
            }
        }
        this.contextManager = ContextManagerFactory.getInstance();
        if (this.contextManager != null) {
            this.registry = SecurityServerImpl.getRegistryImpl(this.contextManager.getDefaultRealm());
            this.contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        String[] stringArray;
        byte[] byArray;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        Callback[] callbackArray = null;
        if (!this.sharedState.containsKey("Callback")) {
            if (this.callbackHandler == null) {
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSTokenHolderCallback("Authz Token List: "), new WSRealmNameCallbackImpl("Realm Name", this.contextManager.getDefaultRealm())};
            try {
                this.callbackHandler.handle(callbackArray);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"229", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerIOException", (Object)new Object[]{this.getClass().getName(), iOException});
                this.contextManager.setRootException((Throwable)iOException);
                throw new WSLoginFailedException("IOException: " + iOException.getMessage(), (Throwable)iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"236", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerException", (Object)new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                this.contextManager.setRootException((Throwable)unsupportedCallbackException);
                throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), (Throwable)unsupportedCallbackException);
            }
            this.sharedState.put("Callback", callbackArray);
        } else {
            callbackArray = (Callback[])this.sharedState.get("Callback");
        }
        String string = null;
        String string2 = null;
        char[] cArray = null;
        byte[] byArray2 = null;
        List list = null;
        boolean bl = false;
        string = ((NameCallback)callbackArray[0]).getName();
        string2 = ((WSRealmNameCallbackImpl)callbackArray[7]).getRealmName();
        char[] cArray2 = ((PasswordCallback)callbackArray[1]).getPassword();
        if (cArray2 != null) {
            cArray = new char[cArray2.length];
            System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        if ((byArray = ((WSCredTokenCallbackImpl)callbackArray[2]).getCredToken()) != null) {
            byArray2 = CredentialsHelper.copyCredToken((byte[])byArray);
        }
        list = ((WSTokenHolderCallback)callbackArray[6]).getTokenHolderList();
        bl = ((WSServletRequestCallback)callbackArray[3]).getHttpServletRequest() != null;
        Hashtable hashtable = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (hashtable == null) {
            try {
                final Subject subject = this.subject;
                hashtable = (Hashtable)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] objectArray = subject.getPublicCredentials().toArray();
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Object[" + i + "] in public list: " + objectArray[i]));
                            }
                            if (!(objectArray[i] instanceof Hashtable) || ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return objectArray[i];
                        }
                        Object[] objectArray2 = subject.getPrivateCredentials().toArray();
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in private cred list.");
                        }
                        for (int i = 0; i < objectArray2.length; ++i) {
                            if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Object[" + i + "] in private list: " + objectArray2[i]));
                            }
                            if (!(objectArray2[i] instanceof Hashtable) || ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return objectArray2[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"328", (Object)this);
                this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
            }
            if (hashtable != null) {
                this.sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", hashtable);
            }
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uid = " + string));
            Tr.debug((TraceComponent)tc, (String)("realm = " + string2));
            Tr.debug((TraceComponent)tc, (String)("password = " + (cArray == null ? "<null>" : "XXXXXXXX")));
            Tr.debug((TraceComponent)tc, (String)("cred token = " + Util.toString((byte[])byArray2)));
            Tr.debug((TraceComponent)tc, (String)("authz token list = " + list));
            Tr.debug((TraceComponent)tc, (String)("custom properties = " + hashtable));
            Tr.debug((TraceComponent)tc, (String)("isHTTPRequest = " + bl));
        }
        if (hashtable != null && hashtable.get("com.ibm.wsspi.security.cred.uniqueId") != null && hashtable.get("com.ibm.wsspi.security.cred.userId") == null) {
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Custom login module passing in credential properties.  Handling login outside this login module.");
                Tr.exit((TraceComponent)tc, (String)"login()");
            }
            return this.succeeded;
        }
        if (hashtable != null && hashtable.get("com.ibm.wsspi.security.cred.userId") != null) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting uid and/or password from hashtable.");
            }
            string = (String)hashtable.get("com.ibm.wsspi.security.cred.userId");
            String string3 = (String)hashtable.get("com.ibm.wsspi.security.cred.password");
            if (string3 != null) {
                cArray = string3.toCharArray();
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("uid = " + string));
                Tr.debug((TraceComponent)tc, (String)("password = " + (cArray == null ? "<null>" : "XXXXXXXX")));
            }
        }
        if ((WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) && list != null && (byArray2 != null || string != null && cArray == null)) {
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security attribute propagation data has been received.  Handling login outside this login module.");
                Tr.exit((TraceComponent)tc, (String)"login()");
            }
            return this.succeeded;
        }
        if (string == null && cArray == null && byArray2 == null) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No authentication data.");
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Successfully gathered authentication information");
        }
        if (string != null && cArray != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using uid and password for authentication");
                StringBuffer stringBuffer = new StringBuffer("Authenticating \"");
                stringBuffer.append(string2).append('/').append(string).append("\"");
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
            String string4 = new String(cArray);
            stringArray = new BasicAuthData(string, string4);
            try {
                this.credential = this.ltpaServer.authenticate((BasicAuthData)stringArray);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"441", (Object)this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login()", (Object)new Object[]{wSLoginFailedException});
                }
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"448", (Object)this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login()", (Object)new Object[]{exception});
                }
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (string != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                    Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
                }
                securityManager.checkPermission((Permission)MAP_CREDENTIAL);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using uid to mapCredential");
                stringArray = new StringBuffer("Authenticating \"");
                stringArray.append(string2).append('/').append(string).append("\"");
                Tr.debug((TraceComponent)tc, (String)stringArray.toString());
            }
            try {
                if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                stringArray = this.registry.createCredential(string);
                this.credential = this.ltpaServer.createLTPAToken((WSCredential)stringArray);
            }
            catch (TokenCreationFailedException tokenCreationFailedException) {
                FFDCFilter.processException((Throwable)tokenCreationFailedException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"497", (Object)this);
                Tr.debug((TraceComponent)tc, (String)"Using uid to mapCredential");
                this.contextManager.setRootException((Throwable)tokenCreationFailedException);
                throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), (Throwable)tokenCreationFailedException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"504", (Object)this);
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (byArray2 == null) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: No authentication data");
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Using credential token for authentication");
        }
        try {
            if (bl) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Converting SSO token to authentication token.");
                }
                Token token = this.ltpaServer.validateToken(byArray2);
                stringArray = token.getAttributes("u");
                Token token2 = null;
                if (stringArray != null && stringArray[0] != null) {
                    String string5 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
                    token2 = this.ltpaServer.createLTPAToken(stringArray[0], string5);
                    this.credential = this.ltpaServer.validate(token2);
                }
            }
            if (this.credential == null) {
                this.credential = this.ltpaServer.validate(byArray2);
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"543", (Object)this);
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"549", (Object)this);
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (this.credential == null) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        Object var11_30 = null;
        try {
            this.principal = SubjectHelper.createPrincipal((WSCredential)this.credential);
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Problem creating principal.", (Object)new Object[]{wSSecurityException});
            }
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"577", (Object)this);
            this.contextManager.setRootException((Throwable)wSSecurityException);
            throw new WSLoginFailedException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating principal.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"584", (Object)this);
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        this.sharedState.put("WSCredential", this.credential);
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                Tr.debug((TraceComponent)tc, (String)("shared state contains: " + this.sharedState.keySet()));
                this.principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                this.credential = (WSCredential)this.sharedState.get("WSCredential");
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!ltpaLoginModule.this.subject.getPrincipals().contains(ltpaLoginModule.this.principal)) {
                                    ltpaLoginModule.this.subject.getPrincipals().add((Principal)ltpaLoginModule.this.principal);
                                }
                                if (!ltpaLoginModule.this.subject.getPublicCredentials().contains(ltpaLoginModule.this.credential)) {
                                    ltpaLoginModule.this.credential.set("wssecurity.identity_name", (Object)"ClientAuthenticationToken");
                                    ltpaLoginModule.this.credential.set("wssecurity.identity_value", (Object)StringBytesConversion.getConvertedBytes((String)ltpaLoginModule.this.credential.getRealmSecurityName()));
                                    ltpaLoginModule.this.subject.getPublicCredentials().add(ltpaLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.commit", (String)"686", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.commit", (String)"697", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.LoginModuleCommitError", (Object)new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug((TraceComponent)tc, (String)"Start removing ...");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (ltpaLoginModule.this.principal != null && ltpaLoginModule.this.subject.getPrincipals().contains(ltpaLoginModule.this.principal)) {
                        ltpaLoginModule.this.subject.getPrincipals().remove(ltpaLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.run", (String)"808", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.removeCredException", (Object)new Object[]{this.getClass().getName(), exception});
                }
                try {
                    if (ltpaLoginModule.this.credential != null && ltpaLoginModule.this.subject.getPublicCredentials().contains(ltpaLoginModule.this.credential)) {
                        ltpaLoginModule.this.subject.getPublicCredentials().remove(ltpaLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.run", (String)"819", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.removeCredException", (Object)new Object[]{this.getClass().getName(), exception});
                }
                if (ltpaLoginModule.this.credential != null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        this.principal = null;
        this.credential = null;
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }

    private void cleanupSharedState() {
        WSPrincipal wSPrincipal;
        WSCredential wSCredential;
        Callback[] callbackArray;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing Callbacks, WSPrincipal, and WSCredential from the shared state.");
        }
        if ((callbackArray = (Callback[])this.sharedState.get("Callback")) != null) {
            this.sharedState.remove("Callback");
        }
        if ((wSCredential = (WSCredential)this.sharedState.get("WSCredential")) != null) {
            this.sharedState.remove("WSCredential");
        }
        if ((wSPrincipal = (WSPrincipal)this.sharedState.get("WSPrincipal")) != null) {
            this.sharedState.remove("WSPrincipal");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanupSharedState()");
        }
    }
}

