/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.TokenHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class SecurityServerImpl
extends PortableRemoteObject
implements SecurityServer {
    private static final TraceComponent tc = Tr.register((Class)SecurityServerImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static UserRegistry registry = null;
    private static RoleBasedAuthorizer authorizer = null;
    private static UserRegistryImpl userRegistryImpl = null;
    private boolean securityEnabled = false;
    private static final String nullString = new String();
    private static final String[] nullStringArray = new String[0];
    private ContextManager contextManager = null;
    private static String remoteReg = null;
    private static byte[] authen_successful = new byte[]{0};
    private static byte[] authen_failure = new byte[]{-1};
    String rmiLoginConfig = null;

    public SecurityServerImpl() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        try {
            this.contextManager = ContextManagerFactory.getInstance();
            registry = this.getUserRegistry();
            this.rmiLoginConfig = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundLoginConfig");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.SecurityServerImpl.SecurityServerImpl", (String)"93", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating User Registry");
            }
            Tr.error((TraceComponent)tc, (String)"security.secsrv.find.reg", (Object)new Object[]{exception});
            throw new RemoteException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)((Object)this));
        }
    }

    public boolean simple_authenticate(BasicAuthData basicAuthData) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("simple_authenticate for user: " + basicAuthData.getUserid()));
        }
        if (remoteReg != null && (remoteReg.equalsIgnoreCase("node") || remoteReg.equalsIgnoreCase("cell"))) {
            if (registry != null) {
                try {
                    Subject subject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Using remote registry to authenticate.");
                    }
                    if ((subject = this.contextManager.login(this.contextManager.getDefaultRealm(), basicAuthData.getUserid(), basicAuthData.getPassword(), this.rmiLoginConfig, null, null, null, null)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found subject from login, returning true for simple_authenticate.");
                        }
                        return true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Subject is null after login, returning false for simple_authenticate.");
                    }
                    return false;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.SecurityServerImpl.simple_authenticate", (String)"137", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The following exception occurred in SecurityServerImpl: ", (Object)new Object[]{exception});
                    }
                    throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"simple_authenticate in bootstrap mode:forcing true");
            }
        } else {
            if (userRegistryImpl != null) {
                try {
                    Subject subject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Using local registry to authenticate.");
                    }
                    if ((subject = this.contextManager.login(this.contextManager.getDefaultRealm(), basicAuthData.getUserid(), basicAuthData.getPassword(), this.rmiLoginConfig, null, null, null, null)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Found subject from login, returning true for simple_authenticate.");
                        }
                        return true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Subject is null after login, returning false for simple_authenticate.");
                    }
                    return false;
                }
                catch (Exception exception) {
                    String string;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.SecurityServerImpl.simple_authenticate", (String)"170", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The following exception occurred in SecurityServerImpl: ", (Object)new Object[]{exception});
                    }
                    if ((string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.propagateExceptionsToClient")) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                        throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                    }
                    throw new WSLoginFailedException("Authentication Failed.  \nNote: Propagation of native registry error information is disabled by default. You may enable it by setting the property \"com.ibm.websphere.security.registry.propagateExceptionsToClient=true\" from the server's AdminConsole menu: Security -> Global Security -> Custom Properties.\n");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"simple_authenticate in bootstrap mode:forcing true");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"simple_authenticate:success");
        }
        return true;
    }

    public byte[] token_authenticate(BasicAuthData basicAuthData) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"token_authenticate");
        }
        Subject subject = null;
        try {
            subject = this.contextManager.login(this.contextManager.getDefaultRealm(), basicAuthData.getUserid(), basicAuthData.getPassword(), this.rmiLoginConfig, null, null, null, null);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login NullPointerException: ", (Object)nullPointerException.getMessage());
            }
            throw new WSLoginFailedException(nullPointerException.getMessage());
        }
        byte[] byArray = authen_failure;
        try {
            WSCredential wSCredential;
            if (subject != null && (byArray = (wSCredential = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next()).getCredentialToken()) == null) {
                byArray = authen_successful;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login ClassNotFoundException: ", (Object)classNotFoundException.getMessage());
            }
            throw new WSLoginFailedException(classNotFoundException.getMessage());
        }
        catch (CredentialDestroyedException credentialDestroyedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login CredentialDestroyedException: ", (Object)credentialDestroyedException.getMessage());
            }
            throw new WSLoginFailedException(credentialDestroyedException.getMessage());
        }
        catch (CredentialExpiredException credentialExpiredException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login CredentialDestroyedException: ", (Object)credentialExpiredException.getMessage());
            }
            throw new WSLoginFailedException(credentialExpiredException.getMessage(), (Throwable)credentialExpiredException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"token_authenticate:success");
        }
        return byArray;
    }

    public byte[] token_authenticate(String string, byte[] byArray) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"token_authenticate");
        }
        Subject subject = null;
        try {
            subject = this.contextManager.login(this.contextManager.getDefaultRealm(), byArray, this.rmiLoginConfig, null, null, null, null);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"login NullPointerException: ", (Object)nullPointerException.getMessage());
            }
            throw new WSLoginFailedException(nullPointerException.getMessage());
        }
        byte[] byArray2 = authen_failure;
        if (subject != null) {
            byArray2 = byArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"token_authenticate:success");
        }
        return byArray2;
    }

    public TokenHolder getOpaqueToken(ByteArray byteArray) throws WSLoginFailedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOpaqueToken");
        }
        byte[] byArray = null;
        TokenHolder tokenHolder = null;
        try {
            DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMap");
            if (distributedMap != null) {
                byArray = (byte[])distributedMap.get((Object)byteArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.SecurityServerImpl.getOpaqueToken", (String)"298", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exception occurred getting opaque token from distributed map.", (Object)new Object[]{exception});
            }
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "WS_OPAQUE", 1);
        }
        return tokenHolder;
    }

    public UserRegistry getRegistry(String string) throws RemoteException {
        return registry;
    }

    public static UserRegistry getRegistryImpl(String string) {
        if (remoteReg != null && (remoteReg.equalsIgnoreCase("node") || remoteReg.equalsIgnoreCase("cell"))) {
            return registry;
        }
        return userRegistryImpl;
    }

    public List getRealms() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            string = registry.getRealm();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.SecurityServerImpl.getRealms", (String)"354", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.secsrv.get.realm", (Object)new Object[]{exception});
        }
        arrayList.add(string);
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    private UserRegistry getUserRegistry() throws CustomRegistryException, NamingException, Exception {
        if (SecurityServerImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SecurityServerImpl.tc, (String)"getUserRegistry");
        }
        var4_1 = null;
        SecurityServerImpl.remoteReg = (String)SecurityConfig.getConfig().getValue("WAS_UseRemoteRegistry");
        if (SecurityServerImpl.remoteReg != null && (SecurityServerImpl.remoteReg.equalsIgnoreCase("node") || SecurityServerImpl.remoteReg.equalsIgnoreCase("cell"))) {
            if (SecurityServerImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"using remote user registry");
            }
            try {
                var4_1 = new InitialContext();
            }
            catch (NamingException var5_2) {
                FFDCFilter.processException((Throwable)var5_2, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"384", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Failed to get initial Naming Context");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.get.initCtx", (Object)new Object[]{var5_2});
                throw var5_2;
            }
            try {
                if (SecurityServerImpl.remoteReg.equalsIgnoreCase("node")) {
                    if (SecurityServerImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"looking up node's registry");
                    }
                    var3_7 = var4_1.lookup("thisNode/nodeAgent/UserRegistry");
                } else {
                    if (SecurityServerImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"looking up cell's registry");
                    }
                    var3_7 = var4_1.lookup("cell/deploymentManager/UserRegistry");
                }
                var2_9 = (UserRegistry)PortableRemoteObject.narrow((Object)var3_7, (Class)UserRegistry.class);
            }
            catch (Exception var5_3) {
                FFDCFilter.processException((Throwable)var5_3, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"406", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Failed to find user registry in name space");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.find.registry", (Object)new Object[]{var5_3});
                throw var5_3;
            }
            try {
                var4_1.rebind("UserRegistry", (Object)var2_9);
            }
            catch (NamingException var5_4) {
                FFDCFilter.processException((Throwable)var5_4, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"418", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Error binding User Registry");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.bind.registry", (Object)new Object[]{var5_4});
                throw var5_4;
            }
            try {
                var3_7 = var4_1.lookup("UserRegistry");
                var1_10 = (UserRegistry)PortableRemoteObject.narrow((Object)var3_7, (Class)UserRegistry.class);
                if (!SecurityServerImpl.tc.isDebugEnabled()) ** GOTO lbl135
                Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"looked up local UserRegistry");
            }
            catch (Exception var5_5) {
                FFDCFilter.processException((Throwable)var5_5, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"435", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Failed to find user registry in name space");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.find.registry", (Object)new Object[]{var5_5});
                throw var5_5;
            }
        } else {
            if (SecurityServerImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"creating user registry");
            }
            var5_6 = (Properties)SecurityConfig.getConfig().getValue("security.activeUserRegistry.props");
            var6_11 = SecurityConfig.expandProps(var5_6);
            var7_12 = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.props");
            if (var7_12 != null) {
                var8_13 = var7_12.keys();
                while (var8_13.hasMoreElements()) {
                    var9_14 = (String)var8_13.nextElement();
                    var6_11.put(var9_14, var7_12.get(var9_14));
                }
                var9_14 = (Boolean)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLEnabled");
                var6_11.put("sslEnabled", var9_14);
                if (var9_14.booleanValue()) {
                    var6_11.put("sslConfig", (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLConfig"));
                }
            }
            if ((var8_13 = (Properties)SecurityConfig.getConfig().getValue("CustomerUserRegistryProps")) != null) {
                var9_14 = var8_13.keys();
                while (var9_14.hasMoreElements()) {
                    var10_20 = (String)var9_14.nextElement();
                    var6_11.put(var10_20, var8_13.get(var10_20));
                }
            }
            try {
                SecurityServerImpl.userRegistryImpl = new UserRegistryImpl();
                SecurityServerImpl.userRegistryImpl.initialize(var6_11);
            }
            catch (CustomRegistryException var9_15) {
                FFDCFilter.processException((Throwable)var9_15, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"485", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Error creating User Registry");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.create.registry", (Object)new Object[]{var9_15});
                throw var9_15;
            }
            catch (Exception var9_16) {
                FFDCFilter.processException((Throwable)var9_16, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"495", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Error creating User Registry");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.create.registry", (Object)new Object[]{var9_16});
                throw var9_16;
            }
            if (this.contextManager.getPlatformHelper().isZOS()) {
                if (this.contextManager.getPlatformHelper().isServantJvm()) {
                    if (SecurityServerImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"In SR, Using Local version of userRegistryImpl");
                    }
                    return SecurityServerImpl.userRegistryImpl;
                }
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Not in the  SR, getting the InitialContext ");
                }
            }
            try {
                var4_1 = new InitialContext();
            }
            catch (NamingException var9_17) {
                FFDCFilter.processException((Throwable)var9_17, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"527", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Failed to get initial Naming Context");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.get.initCtx", (Object)new Object[]{var9_17});
                throw var9_17;
            }
            if (SecurityServerImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Once I have the IntCtx, issue a rebind on it ");
            }
            try {
                var4_1.rebind("UserRegistry", (Object)SecurityServerImpl.userRegistryImpl);
            }
            catch (NamingException var9_18) {
                FFDCFilter.processException((Throwable)var9_18, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"539", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Error binding User Registry");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.bind.registry", (Object)new Object[]{var9_18});
                throw var9_18;
            }
            if (SecurityServerImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Once rebind, narrow the PortRemoteObj ");
            }
            try {
                var3_8 = var4_1.lookup("UserRegistry");
                var1_10 = (UserRegistry)PortableRemoteObject.narrow((Object)var3_8, (Class)UserRegistry.class);
            }
            catch (Exception var9_19) {
                FFDCFilter.processException((Throwable)var9_19, (String)"com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", (String)"557", (Object)this);
                if (SecurityServerImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SecurityServerImpl.tc, (String)"Failed to find user registry in name space");
                }
                Tr.error((TraceComponent)SecurityServerImpl.tc, (String)"security.secsrv.find.registry", (Object)new Object[]{var9_19});
                throw var9_19;
            }
        }
lbl135:
        // 3 sources

        if (SecurityServerImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityServerImpl.tc, (String)"getUserRegistry");
        }
        return var1_10;
    }

    protected void setConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        if (authorizer == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"To get RoleBasedConfigurator");
                }
                RoleBasedConfigurator roleBasedConfigurator2 = roleBasedConfigurator;
                authorizer = roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", "domain");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"got RoleBasedAuthorizer");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.SecurityServerImpl.setConfigurator", (String)"582", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught retrieving RoleBasedAuthorizer");
                }
                Tr.error((TraceComponent)tc, (String)"security.secsrv.get.RoleBasedAuthorizer", (Object)new Object[]{exception});
            }
            if (userRegistryImpl != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"to set configurator for registry");
                }
                userRegistryImpl.setConfigurator(roleBasedConfigurator);
            }
        }
    }
}

