/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.os400;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.os400.OS400RegistryException;
import com.ibm.ws.security.util.RegExp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class OS400RegistryImpl
implements UserRegistry {
    private static TraceComponent tc;
    private static final int MAX_USERID_LENGTH = 10;
    private String realm;
    private String typeRealm = "";
    private boolean longPasswordEnabled = false;
    int maxUidSize = -1;
    int maxPWSize = -1;

    private native String[] ntv_getUsers(String var1, boolean var2) throws OS400RegistryException;

    private native String[] ntv_getGroupsForUser(String var1) throws OS400RegistryException;

    private native boolean ntv_isValid(String var1, boolean var2) throws OS400RegistryException;

    private native void ntv_authenticate(String var1, String var2) throws OS400RegistryException;

    private native String ntv_getDisplayName(String var1, boolean var2) throws OS400RegistryException;

    private native String[] ntv_getUsersForGroup(String var1) throws OS400RegistryException;

    private native boolean ntv_isLongPasswordEnabled() throws OS400RegistryException;

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPassword");
        }
        if (string.length() > 10 || string2.length() > this.getMaxPWSize()) {
            Tr.error((TraceComponent)tc, (String)"security.registry.checkpass.failed", (Object)new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + string.length() + ") and/or password length " + string2.length() + ") too large.");
        }
        String string3 = string.toUpperCase();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Checking password for user '" + string3 + "'."));
        }
        String string4 = string2.trim();
        string2 = null;
        try {
            if (string4.length() == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " Password has zero length");
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string, passwordCheckFailedException});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
                }
                throw passwordCheckFailedException;
            }
            if (string4.startsWith("*")) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " Password begins with *");
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string, passwordCheckFailedException});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
                }
                throw passwordCheckFailedException;
            }
            if (!this.longPasswordEnabled) {
                string4 = string4.toUpperCase();
            }
            this.ntv_authenticate(string3, string4);
            string4 = null;
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.checkPassword", (String)"191", (Object)this);
            this.logErrorCode(oS400RegistryException);
            PasswordCheckFailedException passwordCheckFailedException = null;
            switch (oS400RegistryException.getErrorCode()) {
                case 6: {
                    passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " userID/password does not exist in the registry");
                    Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string, passwordCheckFailedException});
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
                    }
                    throw passwordCheckFailedException;
                }
                case 0: 
                case 1: 
                case 2: {
                    Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, oS400RegistryException});
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)oS400RegistryException);
                    }
                    throw new CustomRegistryException(this.typeRealm + ": " + string + ", " + oS400RegistryException.getMessage());
                }
            }
            passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " Profile error occurred, error code: " + String.valueOf(oS400RegistryException.getErrorCode()));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Profile error: " + this.typeRealm + ": " + string + ", " + oS400RegistryException.getMessage()));
                Tr.debug((TraceComponent)tc, (String)("Error code: " + String.valueOf(oS400RegistryException.getErrorCode())));
            }
            Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string, passwordCheckFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)((Object)passwordCheckFailedException));
            }
            throw passwordCheckFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.checkPassword", (String)"242", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)exception);
            }
            throw new CustomRegistryException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPassword");
        }
        return string;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate");
        }
        CertificateMapNotSupportedException certificateMapNotSupportedException = new CertificateMapNotSupportedException("");
        Tr.error((TraceComponent)tc, (String)"security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)certificateMapNotSupportedException);
        }
        throw certificateMapNotSupportedException;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public String getGroupDisplayName(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName");
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        stringBuffer.append(": ");
        try {
            stringBuffer.append(this.ntv_getDisplayName(string.toUpperCase(), true));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Display name for '" + string + "': " + stringBuffer));
            }
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupDisplayName", (String)"337", (Object)this);
            this.logErrorCode(oS400RegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.groupdisplayname.error", (Object)new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName", (Object)oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName");
        }
        return stringBuffer.toString();
    }

    public String getUniqueGroupId(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId");
        }
        if (!this.isValidGroup(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Group name not found: " + string));
            }
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException(string);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniquegrpid.error", (Object)new Object[]{string, entryNotFoundException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)((Object)entryNotFoundException));
            }
            throw entryNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string.toUpperCase());
        }
        return string.toUpperCase();
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupIds");
        }
        return this.getGroupsForUser(string);
    }

    public Enumeration getGroups(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups(String)");
        }
        String[] stringArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Pattern: " + string));
            }
            stringArray = this.ntv_getUsers("*ALL", true);
            this.filterArray(stringArray, string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroups", (String)"453", (Object)this);
            this.logErrorCode(oS400RegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgroups.error", (Object)new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups(String)", (Object)oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups(String)");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Limit is " + n));
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
            }
            return result;
        }
        Enumeration enumeration = this.getGroups(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
            if (n == 0 || ++n2 != n) continue;
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
        }
        return result;
    }

    public List getGroupsForUser(String string, int n) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Limit is " + n));
        }
        int n2 = 0;
        String[] stringArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieving groups for: " + string));
            }
            stringArray = this.ntv_getGroupsForUser(string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupsForUser", (String)"529", (Object)this);
            this.logErrorCode(oS400RegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No groups for user '" + string + "'found"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
            }
            return new ArrayList(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Groups for user '" + string + "':"));
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < stringArray.length && n2++ < n; ++i) {
            arrayList.add(stringArray[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
        }
        return arrayList;
    }

    public String getGroupSecurityName(String string) throws CustomRegistryException, EntryNotFoundException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName");
        }
        if (!this.isValidGroup(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Group name not found: " + string));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName");
            }
            throw new EntryNotFoundException(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Group name found: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName");
        }
        return string.toUpperCase();
    }

    public String getUserDisplayName(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName");
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        stringBuffer.append(": ");
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Display name for '" + string + "': " + stringBuffer));
            }
            stringBuffer.append(this.ntv_getDisplayName(string.toUpperCase(), false));
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", (String)"637", (Object)this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to get display name for '" + string + "'."));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUserDisplayName");
            }
            this.throwException(oS400RegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserDisplayName");
        }
        return stringBuffer.toString();
    }

    public String getUniqueUserId(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        if (!this.isValidUser(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User name not found: " + string));
            }
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException(string);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniqueusrid.notfound", (Object)new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)((Object)entryNotFoundException));
            }
            throw entryNotFoundException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("User name found: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)string.toUpperCase());
        }
        return string.toUpperCase();
    }

    public Enumeration getUsers() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getUsers("*ALL", false);
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", (String)"711", (Object)this);
            this.logErrorCode(oS400RegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusers.error", (Object)new Object[]{"*", oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Enumeration getUsers(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers(String)");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Pattern: " + string));
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getUsers("*ALL", false);
            this.filterArray(stringArray, string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", (String)"756", (Object)this);
            this.logErrorCode(oS400RegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusers.error", (Object)new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers(String)", (Object)oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers(String)");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
            }
            return result;
        }
        Enumeration enumeration = this.getUsers(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements() && (n == 0 || n2++ < n)) {
            arrayList.add(enumeration.nextElement());
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
        }
        return result;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsersForGroup", (Object)string);
        }
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
            }
            return result;
        }
        String[] stringArray = null;
        int n2 = 0;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieving users for: " + string));
            }
            stringArray = this.ntv_getUsersForGroup(string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", (String)"828", (Object)this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error occurred: " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage()));
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.getusrsforgrp.error", (Object)new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup", (Object)oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No users for group '" + string + "'found"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
            }
            result.setList(new ArrayList(0));
            return result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Users for group '" + string + "':"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        for (int i = 0; i < stringArray.length && (n == 0 || n2++ < n); ++i) {
            arrayList.add(stringArray[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)stringArray[i]);
        }
        result.setList(arrayList);
        if (stringArray.length > n) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
        }
        return result;
    }

    public String getUserSecurityName(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName");
        }
        if (!this.isValidUser(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User name not found: " + string));
            }
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException(string);
            Tr.error((TraceComponent)tc, (String)"security.registry.usersecurityname.error", (Object)new Object[]{string, entryNotFoundException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUserSecurityName", (Object)((Object)entryNotFoundException));
            }
            throw entryNotFoundException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("User name found: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName");
        }
        return string.toUpperCase();
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        try {
            this.realm = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", (String)"929", (Object)this);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to get host name.");
                }
                this.realm = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException unknownHostException2) {
                FFDCFilter.processException((Throwable)unknownHostException2, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", (String)"952", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to get host name or IP address.");
                }
                this.realm = "UNKNOWN";
            }
        }
        this.typeRealm = this.typeRealm + "[" + this.realm + "]";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OS400RegistryImpl type and realm: " + this.typeRealm + "."));
        }
        try {
            this.longPasswordEnabled = this.ntv_isLongPasswordEnabled();
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", (String)"972", (Object)this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error occurred: " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage()));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize");
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OS400RegistryImpl longPasswordEnabled: " + this.longPasswordEnabled + "."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        boolean bl;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isValidGroup");
            }
            if (string != null && !string.equals("")) break block8;
            boolean bl2 = false;
            Object var4_5 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidGroup");
            }
            return bl2;
        }
        try {
            bl = this.ntv_isValid(string.toUpperCase(), true);
            Object var4_6 = null;
        }
        catch (OS400RegistryException oS400RegistryException) {
            try {
                FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", (String)"1013", (Object)this);
                this.logErrorCode(oS400RegistryException);
                Tr.error((TraceComponent)tc, (String)"security.registry.isvalidgroup.error", (Object)new Object[]{string, oS400RegistryException});
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_7 = null;
                    if (!tc.isEntryEnabled()) break block9;
                    Tr.exit((TraceComponent)tc, (String)"isValidGroup");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidGroup");
        }
        return bl;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        boolean bl;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isValidUser");
            }
            if (string != null && !string.equals("")) break block10;
            boolean bl2 = false;
            Object var4_5 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidUser");
            }
            return bl2;
        }
        try {
            bl = this.ntv_isValid(string.toUpperCase(), false);
            Object var4_6 = null;
        }
        catch (OS400RegistryException oS400RegistryException) {
            try {
                FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", (String)"1055", (Object)this);
                this.logErrorCode(oS400RegistryException);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error occurred: " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage()));
                }
                Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, oS400RegistryException});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)oS400RegistryException);
                }
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_7 = null;
                    if (!tc.isEntryEnabled()) break block11;
                    Tr.exit((TraceComponent)tc, (String)"isValidUser");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidUser");
        }
        return bl;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCredential", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)string);
        }
        return null;
    }

    public List getGroupsForUser(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        String[] stringArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieving groups for: " + string));
            }
            stringArray = this.ntv_getGroupsForUser(string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupsForUser", (String)"1175", (Object)this);
            this.logErrorCode(oS400RegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].trim().equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No groups for user '" + string + "'found"));
            }
            return new ArrayList(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Groups for user '" + string + "':"));
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
        }
        return arrayList;
    }

    private Enumeration arrayToEnumeration(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"arrayToEnumeration");
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("element[" + String.valueOf(i) + "]: " + stringArray[i]));
                }
                vector.addElement(stringArray[i]);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("element[" + String.valueOf(i) + "]: null"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"arrayToEnumeration");
        }
        return vector.elements();
    }

    private void filterArray(String[] stringArray, String string) {
        RegExp regExp;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterArray");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Pattern: " + string));
            }
            regExp = new RegExp(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.registry.os400.OS400RegistryImpl.filterArray", (String)"1184", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IllegalArgumentException: " + illegalArgumentException.getMessage()));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"filterArray");
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!regExp.match(stringArray[i])) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Not a match: " + stringArray[i]));
                }
                stringArray[i] = null;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("A match: " + stringArray[i]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filterArray");
        }
    }

    private void throwException(OS400RegistryException oS400RegistryException, String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"throwException");
        }
        switch (oS400RegistryException.getErrorCode()) {
            case 0: 
            case 1: 
            case 2: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"throwException");
                }
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"throwException");
        }
        throw new EntryNotFoundException(this.typeRealm + ": " + string + ", " + oS400RegistryException.getMessage());
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMaxUidSize: " + this.maxUidSize));
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMaxPWSize: " + this.maxPWSize));
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(OS400RegistryException oS400RegistryException) {
        StringBuffer stringBuffer = new StringBuffer("Native error code = ");
        stringBuffer.append(oS400RegistryException.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    static {
        String string = System.getProperty("was.install.library");
        System.load("/QSYS.LIB/" + string + ".LIB/QWASUREG.SRVPGM");
        tc = Tr.register((Class)OS400RegistryImpl.class, null, (String)"com.ibm.ejs.resources.security");
    }
}

