/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.nt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.nt.GroupEnumeration;
import com.ibm.ws.security.registry.nt.NTException;
import com.ibm.ws.security.registry.nt.UserEnumeration;
import java.util.Enumeration;
import java.util.Properties;

public class NTRegistryImpl {
    private static TraceComponent tc = Tr.register((Class)NTRegistryImpl.class, null, (String)"com.ibm.ejs.resources.security");
    private static final int NERR_BASE = 2100;
    private static final int NERR_UserNotFound = 2221;
    private static final int NERR_GroupNotFound = 2220;
    private int nativeStructure;
    private String serverName = null;
    private String realm = null;
    private String realmWithSep = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private boolean localRegistry = true;
    private boolean isLocalOrDomain = false;
    int maxUidSize = -1;
    int maxPWSize = -1;

    public NTRegistryImpl() {
        this.localRegistry = true;
    }

    public NTRegistryImpl(boolean bl) {
        this.localRegistry = bl;
    }

    int getNativeStructure() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNativeStructure");
        }
        int n = this.nativeStructure;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNativeStructure");
        }
        return n;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPassword", (Object)string);
        }
        if (string.length() > this.getMaxUidSize() || string2.length() > this.getMaxPWSize()) {
            Tr.error((TraceComponent)tc, (String)"security.registry.checkpass.failed", (Object)new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + string.length() + ") and/or password length " + string2.length() + ") too large.");
        }
        boolean bl = false;
        try {
            bl = this.p_checkPassword(string, string2);
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword");
            }
            throw new PasswordCheckFailedException("Authentication failed for user " + string + " with the following error message " + nTException.getMessage(), (Throwable)nTException);
        }
        if (bl) {
            if (this.isLocalOrDomain) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkPassword ", (Object)string);
                }
                return string;
            }
            String string3 = this.realm + "\\" + string;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword ", (Object)string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPassword ");
        }
        throw new PasswordCheckFailedException("Authentication failed for user " + string);
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName");
        }
        return NONE;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        String string2 = this.getPrivilegeAttributeId(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string2);
        }
        return string2;
    }

    public Enumeration getGroups(String string) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)string);
        }
        GroupEnumeration groupEnumeration = new GroupEnumeration(this, string, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups");
        }
        return groupEnumeration;
    }

    public String[] getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.p_getGroupsForUser(string);
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)nTException);
            }
            if (nTException.getErrorCode() == 2221) {
                throw new EntryNotFoundException(string, (Throwable)nTException);
            }
            throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
        }
        if (stringArray == null || stringArray.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No groups for user: " + string));
            }
            stringArray = new String[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
        }
        return stringArray;
    }

    public String[] getGroupIDsForUser(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupIDsForUser", (Object)string);
        }
        String[] stringArray = new String[]{};
        try {
            stringArray = this.p_getGroupIDsForUser(string);
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupIDsForUser", (Object)nTException);
            }
            if (nTException.getErrorCode() == 2221) {
                Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, nTException});
                throw new EntryNotFoundException(string, (Throwable)nTException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, nTException});
            throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupIDsForUser");
        }
        return stringArray;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string);
        }
        String string2 = this.getSecurityName0(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName");
        }
        return string2;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        try {
            String string2 = this.p_getUserName(string);
            if (string2.length() != 0) {
                string2 = this.realm + "\\" + string2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUserDisplayName");
            }
            return string2;
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUserDisplayName", (Object)nTException);
            }
            if (nTException.getErrorCode() == 2221) {
                throw new EntryNotFoundException(string, (Throwable)nTException);
            }
            throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
        }
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        String string2 = null;
        if (string != null && string.equalsIgnoreCase(this.realm)) {
            string = this.realm + "\\" + string;
        }
        string2 = this.getPrivilegeAttributeId(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)string2);
        }
        return string2;
    }

    public Enumeration getUsers(String string) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)string);
        }
        UserEnumeration userEnumeration = new UserEnumeration(this, string, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers");
        }
        return userEnumeration;
    }

    public Enumeration getUsers() throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers");
        }
        UserEnumeration userEnumeration = new UserEnumeration(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers");
        }
        return userEnumeration;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        String string2 = null;
        string2 = this.getSecurityName0(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName");
        }
        return string2;
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        String string = null;
        if (properties != null) {
            string = properties.getProperty("com.ibm.websphere.registry.UseRegistry");
        }
        if (string != null && (string.equalsIgnoreCase("Domain") || string.equalsIgnoreCase("Local"))) {
            this.isLocalOrDomain = true;
            try {
                if (string.equalsIgnoreCase("Domain")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting the Domain Name");
                    }
                    this.realm = this.p_getDomainName();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Getting the Computer Name");
                    }
                    this.realm = this.p_getMachineName();
                }
                this.p_initNativeStructure();
            }
            catch (NTException nTException) {
                FFDCFilter.processException((Throwable)nTException, (String)"com.ibm.ws.security.registry.nt.NTRegistryImpl.initialize", (String)"350", (Object)this);
                this.logErrorCode(nTException);
                Tr.error((TraceComponent)tc, (String)"security.registry.initerror", (Object)new Object[]{nTException});
                throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
            }
        }
        try {
            this.realm = this.p_getDomainName();
            if (this.realm == null && !this.localRegistry) {
                throw new CustomRegistryException("Unable to contact domain controller");
            }
            if (this.realm != null) {
                this.serverName = this.p_getDCName();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting the machine name");
                }
                this.realm = this.p_getMachineName();
            }
            this.p_initNativeStructure();
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidGroup", (Object)string);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidGroup");
            }
            return this.p_isValidGroup(string);
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidGroup", (Object)nTException);
            }
            throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
        }
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser", (Object)string);
        }
        try {
            return this.p_isValidUser(string);
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)nTException);
            }
            throw new CustomRegistryException(nTException.getMessage(), (Throwable)nTException);
        }
    }

    private String getPrivilegeAttributeId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPrivilegeAttributeId", (Object)string);
        }
        try {
            String string2 = this.p_lookupAccountName(string);
            if (string2 == null) {
                EntryNotFoundException entryNotFoundException = new EntryNotFoundException("Cannot obtain the uniqueID for " + string);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getPrivilegeAttributeId", (Object)entryNotFoundException);
                }
                throw entryNotFoundException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPrivilegeAttributeId", (Object)string2);
            }
            return string2;
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            throw new CustomRegistryException("no unique id for for :" + string, (Throwable)nTException);
        }
    }

    private String getSecurityName0(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityName0", (Object)string);
        }
        try {
            String string2 = this.p_lookupAccountSID(string);
            if (string2 == null) {
                EntryNotFoundException entryNotFoundException = new EntryNotFoundException("cannot find entry " + string);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSecurityName0", (Object)entryNotFoundException);
                }
                throw entryNotFoundException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSecurityName0");
            }
            return string2;
        }
        catch (NTException nTException) {
            this.logErrorCode(nTException);
            throw new CustomRegistryException("no security name configured for privilege id: " + string, (Throwable)nTException);
        }
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMaxUidSize: " + this.maxUidSize));
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMaxPWSize: " + this.maxPWSize));
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(NTException nTException) {
        StringBuffer stringBuffer = new StringBuffer("Native error code = ");
        stringBuffer.append(nTException.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    public static void nativeDebugTr(int n, String string) {
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Native line ");
            stringBuffer.append(n);
            stringBuffer.append(": ");
            stringBuffer.append(string);
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    public static void nativeTr(String string, char c, Object[] objectArray) {
        if (string != null) {
            switch (c) {
                case 'A': 
                case 'a': {
                    Tr.audit((TraceComponent)tc, (String)string, (Object)objectArray);
                    break;
                }
                case 'E': 
                case 'e': {
                    Tr.error((TraceComponent)tc, (String)string, (Object)objectArray);
                    break;
                }
                case 'W': 
                case 'w': {
                    Tr.warning((TraceComponent)tc, (String)string, (Object)objectArray);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Invalid msg ID: " + string), (Object)objectArray);
                }
            }
        }
    }

    private native void p_initNativeStructure() throws NTException;

    public native String p_getDomainName() throws NTException;

    public native String p_getDCName() throws NTException;

    public native String p_getMachineName() throws NTException;

    private native String[] p_getGroupsForUser(String var1) throws NTException;

    private native String p_getUserName(String var1) throws NTException;

    private native boolean p_isValidGroup(String var1) throws NTException;

    private native boolean p_isValidUser(String var1) throws NTException;

    private native boolean p_checkPassword(String var1, String var2) throws NTException;

    private native String p_lookupAccountName(String var1) throws NTException;

    private native String p_lookupAccountSID(String var1) throws NTException;

    private native String[] p_getGroupIDsForUser(String var1) throws NTException;

    static {
        System.loadLibrary("NTRegistry");
    }
}

