/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public final class RegistryUtil {
    private static TraceComponent tc = Tr.register((Class)RegistryUtil.class, null, (String)"com.ibm.ejs.resources.security");
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    public static final String nullString = new String("");
    public static final String[] nullStringArray = new String[0];
    public static final byte[] nullByteArray = new byte[0];
    public static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static String realmWithSep = null;

    protected static String getRealmWithSep(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealmWithSep", (Object)string);
        }
        if (!ctxMgr.getPlatformHelper().isZOS()) {
            if (realmWithSep == null && string != null) {
                realmWithSep = typeSeparator + string + realmSeparator;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRealmWithSep", (Object)realmWithSep);
            }
            return realmWithSep;
        }
        String string2 = null;
        if (string != null) {
            string2 = typeSeparator + string + realmSeparator;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealmWithSep", string2);
        }
        return string2;
    }

    public static String appendRealm(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("appendRealm \n type: " + string + "\n name: " + string2 + "\n realm: " + string3));
        }
        if (string2 != null && string2.length() > 0) {
            if (string.equals(NONE)) {
                string2 = string3 + realmSeparator + string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("name: " + string2));
                }
            } else {
                string2 = string + RegistryUtil.getRealmWithSep(string3) + string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("name: " + string2));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendRealm", (Object)string2);
        }
        return string2;
    }

    public static String[] appendRealm(String string, String[] stringArray, String string2) {
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (string.equals(NONE)) {
                stringBuffer.append(string2 + realmSeparator);
            } else {
                stringBuffer.append(RegistryUtil.getRealmWithSep(string2));
            }
            int n = stringBuffer.length();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.setLength(n);
                stringArray[i] = stringBuffer.append(stringArray[i]).toString();
            }
        }
        return stringArray;
    }

    public static ArrayList appendRealm(String string, List list, String string2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        stringArray = RegistryUtil.appendRealm(string, stringArray, string2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static String removeDNSpace(String string, int n) {
        char c;
        int n2;
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.indexOf(" ") == -1 || string.indexOf("=") == -1) {
            return string;
        }
        int n3 = n;
        if (n3 == -1) {
            n3 = string.indexOf(47);
        }
        if (n3 < 0 || string.length() < n3 + 2) {
            return string;
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (n2 > n3 + 1 && string.charAt(n2 - 2) != '\\' && string.charAt(n2 - 1) == ',' && string.charAt(n2) == ' ') {
                bl = true;
            }
            if (n2 > n3 + 1 && string.charAt(n2 - 1) == '=' && string.charAt(n2) == ' ') {
                bl = true;
            }
            if (n2 > n3 + 1 && string.charAt(n2 - 1) != '\\' && string.charAt(n2) == '\"') {
                bl2 = !bl2;
            }
            if ((c = (char)string.charAt(n2)) == ' ' && bl && !bl2) continue;
            bl = false;
            stringBuffer.append(c);
        }
        n2 = stringBuffer.length();
        for (c = n2 - 2; c > n3; --c) {
            if (stringBuffer.charAt(c) != ' ' || stringBuffer.charAt(c - 1) == '\\' || stringBuffer.charAt(c + 1) != ',' && stringBuffer.charAt(c + '\u0001') != '=') continue;
            stringBuffer.deleteCharAt(c);
        }
        return stringBuffer.toString();
    }

    public static boolean checkValidUserifTAM(String string, UserRegistry userRegistry) throws Exception {
        Boolean bl = Boolean.FALSE;
        final String string2 = string;
        final UserRegistry userRegistry2 = userRegistry;
        try {
            bl = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(userRegistry2.isValidUser(string2));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred calling isValidUser for Access Manager.", (Object)new Object[]{privilegedActionException.getException()});
            }
            throw privilegedActionException.getException();
        }
        if (bl.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User: " + string + " is valid in Access Manager."));
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("User: " + string + " is not valid in Access Manager."));
        }
        return false;
    }
}

