/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.policy.DynamicPolicy;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;

public final class NullDynamicPolicy
extends Policy
implements DynamicPolicy {
    private Policy policy = null;
    private boolean use_default_policy = false;
    private boolean initialize_default_policy_flag = false;
    private static final PermissionCollection EMPTY = new Permissions();
    private static final TraceComponent tc = Tr.register((Class)NullDynamicPolicy.class, null, (String)"com.ibm.ejs.resources.security");

    public NullDynamicPolicy(Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("NullDynamicPolicy(" + policy + ")"));
        }
        this.policy = policy;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NullDynamicPolicy()");
        }
    }

    public final void refresh() {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy && this.policy != null) {
            this.policy.refresh();
        }
    }

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = EMPTY;
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy && this.policy != null) {
            permissionCollection = this.policy.getPermissions(codeSource);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Permissions for \"" + codeSource + "\" = " + permissionCollection));
            }
        } else {
            permissionCollection = new Permissions();
        }
        return permissionCollection;
    }

    public final void removePolicy(Map map) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("removePolicy(" + map + ")"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removePolicy()");
            }
        }
    }

    public final void setupPolicy(Map map) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("setupPolicy(" + map + ")"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setupPolicy()");
            }
        }
    }

    public final void getSecurityPolicy(Map map, Map map2) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getSecurityPolicy(" + map + "," + map2 + ")"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSecurityPolicy()");
            }
        }
    }

    public final PermissionCollection getPermissions(CodeSource codeSource, Map map) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        PermissionCollection permissionCollection = EMPTY;
        if (this.use_default_policy && this.policy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Permissions for \"" + codeSource + "\" = " + permissionCollection));
            }
            permissionCollection = this.policy.getPermissions(codeSource);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPermissions()");
            }
        } else {
            permissionCollection = new Permissions();
        }
        return permissionCollection;
    }

    public final PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        PermissionCollection permissionCollection = EMPTY;
        if (this.use_default_policy) {
            PermissionCollection permissionCollection2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getPermissions");
            }
            permissionCollection = super.getPermissions(protectionDomain);
            if (this.policy != null && (permissionCollection2 = this.policy.getPermissions(protectionDomain)) != null) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPermissions", (Object)permissionCollection);
            }
        } else {
            permissionCollection = new Permissions();
        }
        return permissionCollection;
    }

    public final boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            boolean bl = super.implies(protectionDomain, permission);
            if (!bl && this.policy != null) {
                bl = this.policy.implies(protectionDomain, permission);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("implies -> " + bl));
            }
            return bl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"implies (no policy check) -> true");
        }
        return true;
    }

    private void initializeDefaultPolicyFlag() {
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.useDefaultPolicyWhenJ2SDisabled");
        if (bl == null || !bl.booleanValue()) {
            this.use_default_policy = false;
            this.initialize_default_policy_flag = true;
        } else {
            this.use_default_policy = true;
            this.initialize_default_policy_flag = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("use_default_policy -> " + this.use_default_policy));
        }
    }
}

