/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.KeyEncryptor;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UnsupportedEntryTypeException;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class LTPAServerObject {
    private static final TraceComponent tc = Tr.register((Class)LTPAServerObject.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final String NONE = "";
    private static final String USERTYPE = "user";
    private static final String GROUPTYPE = "group";
    private static final String ROLETYPE = "role";
    private static final String[] supportedTypes = new String[]{"group", "user"};
    private static final int GROUP = 0;
    private static final int USER = 1;
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";
    private static final String tokenFactorySeparator = "|";
    private String realm = null;
    private static UserRegistryImpl userRegistry;
    private static long expirationLimit;
    private byte[] adminPassword = null;
    private byte[] new_adminPassword = null;
    private ArrayList tokenFactory = new ArrayList();
    private static LTPAPublicKey ltpaPubKey;
    private static LTPAPrivateKey ltpaPrivKey;
    private static byte[] sharedKey;
    private static HashMap tokenFactoryMap;
    private static LTPAPublicKey new_ltpaPubKey;
    private static LTPAPrivateKey new_ltpaPrivKey;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] new_sharedKey;
    private byte[] new_privateKey;
    private byte[] new_publicKey;
    private byte[] encryptedPrivateKey;
    private byte[] encryptedSharedKey;
    private byte[] new_encryptedPrivateKey;
    private byte[] new_encryptedSharedKey;
    private static String CURRENT_LTPA_VERSION;
    public static final String SHARED_KEY_PROPERTY = "com.ibm.websphere.ltpa.3DESKey";
    public static final String PUBLIC_KEY_PROPERTY = "com.ibm.websphere.ltpa.PublicKey";
    public static final String PRIVATE_KEY_PROPERTY = "com.ibm.websphere.ltpa.PrivateKey";
    public static final String LTPA_VERSION_PROPERTY = "com.ibm.websphere.ltpa.version";
    public static final String CREATION_DATE_PROPERTY = "com.ibm.websphere.CreationDate";
    public static final String CREATION_HOST_PROPERTY = "com.ibm.websphere.CreationHost";
    public static final String LDAP_REALM_PROPERTY = "com.ibm.websphere.ltpa.Realm";
    protected static LTPAServerObject ltpaServer;
    static boolean _useFIPS;
    static String _defaultJCEProvider;
    private static final ContextManager ctxMgr;
    private static final WebSphereRuntimePermission ACCESS_LTPA_SERVER_OBJECT;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL;

    public static LTPAServerObject getLTPAServer() throws LTPAConfigException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLTPAServer");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + ACCESS_LTPA_SERVER_OBJECT.toString()));
            }
            securityManager.checkPermission((Permission)ACCESS_LTPA_SERVER_OBJECT);
        }
        if (ltpaServer == null) {
            LTPAServerObject.initLTPAServer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLTPAServer");
        }
        return ltpaServer;
    }

    private static void initLTPAServer() throws LTPAConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initLTPAServer");
        }
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
        String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        if ("LTPA".equals(string) && Boolean.TRUE.equals(bl)) {
            try {
                String string2 = (String)SecurityConfig.getConfig().getValue("security.ltpa.password");
                Long l = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
                String string3 = (String)SecurityConfig.getConfig().getValue(PRIVATE_KEY_PROPERTY);
                String string4 = (String)SecurityConfig.getConfig().getValue(PUBLIC_KEY_PROPERTY);
                String string5 = (String)SecurityConfig.getConfig().getValue(SHARED_KEY_PROPERTY);
                if (l == null || string3 == null || string4 == null || string5 == null || string2 == null) {
                    Tr.error((TraceComponent)tc, (String)"security.secsrv.badltpconfig", (Object)new Object[]{string2 != null ? "LTPA password is set" : null, l != null ? l.toString() : null, string3 != null ? "Private key is set" : null, string4 != null ? "Public key is set" : null, string5 != null ? "Shared key is set" : null});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Required LTPA configuration data is unavailable.  Initialization failed.");
                    }
                    throw new LTPAConfigException("Required LTPA configuration data is unavailable.  Initialization failed.");
                }
                long l2 = l;
                byte[] byArray = string2.getBytes("UTF8");
                ltpaServer = new LTPAServerObject(l2, byArray, string4, string3, string5);
                String string6 = (String)SecurityConfig.getConfig().getValue("com.ibm.security.useFIPS");
                if (string6.equalsIgnoreCase("true")) {
                    _useFIPS = true;
                    _defaultJCEProvider = Security.getProperty("DEFAULT_JCE_PROVIDER");
                }
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.initLTPAServer", (String)"244");
                throw lTPAConfigException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.initLTPAServer", (String)"249");
                Tr.error((TraceComponent)tc, (String)"security.secsrv.ltpaconfigerr", (Object)new Object[]{exception});
                throw new LTPAConfigException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initLTPAServer");
        }
    }

    private LTPAServerObject(long l, byte[] byArray, String string, String string2, String string3) throws LTPAConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        userRegistry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(ctxMgr.getDefaultRealm());
        expirationLimit = l;
        this.adminPassword = byArray;
        try {
            this.encryptedSharedKey = Base64Coder.base64Decode((byte[])string3.getBytes("UTF8"));
            this.encryptedPrivateKey = Base64Coder.base64Decode((byte[])string2.getBytes("UTF8"));
            this.publicKey = Base64Coder.base64Decode((byte[])string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", (String)"278", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.init.error", (Object)new Object[]{unsupportedEncodingException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LTPAServerObject", (Object)unsupportedEncodingException);
            }
            throw new LTPAConfigException(unsupportedEncodingException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", (String)"285", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.init.error", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LTPAServerObject", (Object)exception);
            }
            throw new LTPAConfigException(exception.getMessage());
        }
        ltpaPubKey = new LTPAPublicKey(this.publicKey);
        ltpaPrivKey = new LTPAPrivateKey(this.getPrivateKey(byArray, this.encryptedPrivateKey));
        sharedKey = this.getSharedKey(byArray, this.encryptedSharedKey);
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", sharedKey);
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", ltpaPubKey);
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", ltpaPrivKey);
        try {
            String string4 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.ltpa.tokenFactory");
            StringTokenizer stringTokenizer = new StringTokenizer(string4, tokenFactorySeparator);
            while (stringTokenizer.hasMoreTokens()) {
                this.findFactory(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", (String)"311", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.init.error", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LTPAServerObject", (Object)exception);
            }
            throw new LTPAConfigException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public LTPAServerObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public TokenFactory findFactory(String string) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findFactory", (Object)string);
        }
        TokenFactory tokenFactory = null;
        TokenFactory[] tokenFactoryArray = this.tokenFactory.toArray(new TokenFactory[0]);
        if (tokenFactoryArray.length > 0) {
            for (int i = 0; i < tokenFactoryArray.length; ++i) {
                if (!tokenFactoryArray[i].getClass().getName().equals(string)) continue;
                tokenFactory = tokenFactoryArray[i];
            }
        }
        if (tokenFactory == null) {
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                tokenFactory = (TokenFactory)obj;
                tokenFactory.initialize((Map)tokenFactoryMap);
                this.tokenFactory.add(tokenFactory);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.findFactory", (String)"366", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.factory.init.error", (Object)new Object[]{string, exception});
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findFactory", tokenFactory);
        }
        return tokenFactory;
    }

    public void refreshTokenFactories() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshTokenFactories");
        }
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", sharedKey);
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", ltpaPubKey);
        tokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", ltpaPrivKey);
        TokenFactory[] tokenFactoryArray = this.tokenFactory.toArray(new TokenFactory[0]);
        if (tokenFactoryArray.length > 0) {
            for (int i = 0; i < tokenFactoryArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Refreshing tokenFactory keys for: " + tokenFactoryArray[i].getClass().getName()));
                }
                tokenFactoryArray[i].initialize((Map)tokenFactoryMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refreshTokenFactories");
        }
    }

    public Token createLTPAToken(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLTPAToken", (Object)new Object[]{string, string2});
        }
        if (string2 == null) {
            throw new WSLoginFailedException("TokenFactory is null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission((Permission)MAP_CREDENTIAL);
        }
        Token token = null;
        try {
            if (LTPAServerObject.getUserRegistry() != null) {
                String string3 = null;
                string3 = string.startsWith(supportedTypes[1]) ? string : LTPAServerObject.getUserRegistry().getUniqueUserId(string);
                if (string3 == null) {
                    Tr.error((TraceComponent)tc, (String)"security.ltpa.credmap.failed.nullaccessid");
                    throw new WSLoginFailedException("Cannot create token since accessID is null");
                }
                TokenFactory tokenFactory = this.findFactory(string2);
                if (tokenFactory == null) {
                    Tr.error((TraceComponent)tc, (String)"security.ltpa.factory.null.error", (Object)new Object[]{string2});
                    throw new WSLoginFailedException("TokenFactory is null");
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.wsspi.security.cred.uniqueId", string3);
                token = tokenFactory.createToken(hashMap);
                if (token == null) {
                    Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.nulltoken");
                    throw new WSLoginFailedException("Token is null");
                }
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", (String)"477", (Object)this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", (String)"482", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.factory.tokencreate.error", (Object)new Object[]{string2, exception});
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createLTPAToken", token);
        }
        return token;
    }

    public WSCredential createLTPAToken(final WSCredential wSCredential) throws TokenCreationFailedException {
        TokenFactory tokenFactory;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLTPAToken", (Object)wSCredential);
        }
        Token token = null;
        String string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
        try {
            string = wSCredential.getAccessId();
            if (string == null) {
                Tr.error((TraceComponent)tc, (String)"security.ltpa.credmap.failed.nullaccessid");
                throw new TokenCreationFailedException("Cannot create token since accessID is null");
            }
            tokenFactory = this.findFactory(string2);
            if (tokenFactory == null) {
                Tr.error((TraceComponent)tc, (String)"security.ltpa.factory.null.error", (Object)new Object[]{string2});
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.wsspi.security.cred.uniqueId", string);
            token = tokenFactory.createToken(hashMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", (String)"522", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.factory.tokencreate.error", (Object)new Object[]{string2, exception});
            throw new TokenCreationFailedException(exception.getMessage());
        }
        string = null;
        tokenFactory = token;
        try {
            string = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Token)tokenFactory){
                private final /* synthetic */ Token val$privToken;
                {
                    this.val$privToken = token;
                }

                public Object run() throws Exception {
                    return new WSCredentialImpl(wSCredential, "oid:1.3.18.0.2.30.2", this.val$privToken, true, this.val$privToken.getExpiration());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", (String)"547", (Object)this);
            String string3 = exception != null ? exception.getMessage() : "Exception occurred creating new WS cred.";
            throw new TokenCreationFailedException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createLTPAToken", (Object)string);
        }
        return string;
    }

    public WSCredential authenticate(BasicAuthData basicAuthData) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticate");
        }
        WSCredential wSCredential = null;
        try {
            if (LTPAServerObject.getUserRegistry() == null) {
                wSCredential = ctxMgr.getUnauthenticatedCredential();
            }
            if (wSCredential == null) {
                String string = LTPAServerObject.getUserRegistry().checkPassword(basicAuthData.getUserid(), basicAuthData.getPassword());
                wSCredential = LTPAServerObject.getUserRegistry().createCredential(string);
            }
            if (wSCredential == null) {
                throw new WSLoginFailedException("Credential returned by createCredential is null");
            }
            wSCredential = this.createLTPAToken(wSCredential);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            throw wSLoginFailedException;
        }
        catch (TokenCreationFailedException tokenCreationFailedException) {
            FFDCFilter.processException((Throwable)tokenCreationFailedException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", (String)"590", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.authenticate", (Object)new Object[]{tokenCreationFailedException.getMessage()});
            throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), (Throwable)tokenCreationFailedException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", (String)"596", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.authenticate", (Object)new Object[]{exception.getMessage()});
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)wSCredential);
        }
        return wSCredential;
    }

    public WSCredential authenticateLoginToken(byte[] byArray) throws WSLoginFailedException, RemoteException {
        throw new WSLoginFailedException("LTPAServerObject: authenticateLoginToken not implemented");
    }

    public Token validateToken(byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateToken", (Object)byArray);
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate: LTPA validate failed");
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.nulltoken");
            throw new WSLoginFailedException("LTPAServerObject: token passed in is null.");
        }
        Token token = null;
        WSLoginFailedException wSLoginFailedException = null;
        try {
            if (LTPAServerObject.getUserRegistry() == null) {
                return null;
            }
            TokenFactory[] tokenFactoryArray = this.tokenFactory.toArray(new TokenFactory[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"BEGIN VALIDATING TOKEN: some errors may occur, look for SUCCESS:");
            }
            for (int i = 0; i < tokenFactoryArray.length; ++i) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Calling tokenFactory[" + i + "].validateTokenBytes()"));
                    }
                    if ((token = tokenFactoryArray[i].validateTokenBytes(byArray)) == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("SUCCESS: validated using tokenFactoryArray[" + i + "]: " + tokenFactoryArray[i].getClass().getName()));
                    }
                    return token;
                }
                catch (InvalidTokenException invalidTokenException) {
                    FFDCFilter.processException((Throwable)invalidTokenException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.validate", (String)"656", (Object)this);
                    if (i < tokenFactoryArray.length) {
                        if (wSLoginFailedException == null) {
                            wSLoginFailedException = new WSLoginFailedException(invalidTokenException.getMessage(), (Throwable)invalidTokenException);
                            continue;
                        }
                        wSLoginFailedException.addException((Throwable)invalidTokenException);
                        continue;
                    }
                    wSLoginFailedException.addException((Throwable)invalidTokenException);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred processing TokenFactory validateTokenBytes.", (Object)new Object[]{wSLoginFailedException});
                    }
                    throw wSLoginFailedException;
                }
                catch (TokenExpiredException tokenExpiredException) {
                    FFDCFilter.processException((Throwable)tokenExpiredException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.validate", (String)"677", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"security.ltpa.validate.tokenexpired", (Object)new Object[]{tokenExpiredException.getMessage()});
                    throw new WSLoginFailedException(tokenExpiredException.getMessage(), (Throwable)tokenExpiredException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.validate", (String)"683", (Object)this);
                    if (i < tokenFactoryArray.length) {
                        if (wSLoginFailedException == null) {
                            wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
                            continue;
                        }
                        wSLoginFailedException.addException((Throwable)exception);
                        continue;
                    }
                    wSLoginFailedException.addException((Throwable)exception);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred processing TokenFactory validateTokenBytes.", (Object)new Object[]{wSLoginFailedException});
                    }
                    throw wSLoginFailedException;
                }
            }
            if (token == null) {
                Tr.debug((TraceComponent)tc, (String)"security.ltpa.validate.verifytoken.failed");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"LTPAServerObject: LTPATokenFactory.validateTokenBytes internal error.");
                }
                throw new WSLoginFailedException("Token is null.");
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"security.ltpa.validate.verifytoken.failed");
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.validate", (String)"715", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LTPAServerObject: LTPAToken.getInstance internal error.", (Object)new Object[]{exception});
            }
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)((Object)exception);
            }
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateToken");
        }
        return token;
    }

    public WSCredential validate(byte[] byArray) throws WSLoginFailedException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        if ((token = this.validateToken(byArray)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate (bytes)");
            }
            return this.validate(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Problem validating token, returning null.");
        }
        throw new WSLoginFailedException("Problem validating LTPA token.");
    }

    public WSCredential validate(Token token) throws WSLoginFailedException {
        if (LTPAServerObject.getUserRegistry() == null || token == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Bootstrap mode: returning unauthenticated cred.");
            }
            try {
                WSCredential wSCredential = ctxMgr.getUnauthenticatedCredential();
                return wSCredential;
            }
            catch (WSSecurityException wSSecurityException) {
                throw new WSLoginFailedException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"validation successful - to create credential");
        }
        String string = null;
        try {
            String[] stringArray = token.getAttributes("u");
            string = this.getSecurityName(stringArray[0]);
            if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, LTPAServerObject.getUserRegistry())) {
                throw new WSLoginFailedException("User is not valid in Access Manager");
            }
            final WSCredential wSCredential = LTPAServerObject.getUserRegistry().createCredential(string);
            WSCredential wSCredential2 = null;
            final Token token2 = token;
            try {
                wSCredential2 = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(wSCredential, "oid:1.3.18.0.2.30.2", token2, true, token2.getExpiration());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", (String)"813", (Object)this);
                Exception exception = privilegedActionException.getException();
                String string2 = exception != null ? exception.getMessage() : "Exception occurred creating new WS cred.";
                throw new WSLoginFailedException(string2, (Throwable)exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate");
            }
            return wSCredential2;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.validate", (String)"824", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate: LTPA validation failed", (Object)((Object)wSLoginFailedException));
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.createcredential.failed", (Object)new Object[]{string, wSLoginFailedException});
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.validate", (String)"831", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate: LTPA validation failed", (Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.createcredential.failed", (Object)new Object[]{string, exception});
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public String validateGetUser(byte[] byArray) {
        String string;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"validateGetUser", (Object)byArray);
            }
            string = null;
            Token token = null;
            try {
                token = this.validateToken(byArray);
                if (token == null || !token.isValid()) {
                    Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.tokenexpired");
                }
                String[] stringArray = token.getAttributes("u");
                string = this.getSecurityName(stringArray[0]);
            }
            catch (Exception exception) {
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit((TraceComponent)tc, (String)"validateGetUser: LTPA token is not valid", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateGetUser", string);
        }
        return string;
    }

    public long getExpiration(byte[] byArray) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getExpiration", (Object)byArray);
        }
        if (byArray == null) {
            throw new InvalidTokenException();
        }
        long l = 0L;
        Token token = null;
        try {
            token = this.validateToken(byArray);
            if (token != null && token.isValid()) {
                l = token.getExpiration();
            }
        }
        catch (Exception exception) {
            throw new TokenExpiredException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getExpiration", (Object)new Long(l));
        }
        return l;
    }

    private String getSecurityName(String string) throws CustomRegistryException, EntryNotFoundException, UnsupportedEntryTypeException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityName", (Object)string);
        }
        String string2 = null;
        String string3 = null;
        string3 = this.getRelativeName(string);
        if (string.startsWith(supportedTypes[1])) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling userRegistry.getUserSecName");
            }
            string2 = LTPAServerObject.getUserRegistry().getUserSecurityName(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Back from  userRegistry.getUserSecName");
            }
        } else if (string.startsWith(supportedTypes[0])) {
            string2 = LTPAServerObject.getUserRegistry().getGroupSecurityName(string3);
        } else {
            UnsupportedEntryTypeException unsupportedEntryTypeException = new UnsupportedEntryTypeException("not USER or GROUP");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSecurityName", (Object)((Object)unsupportedEntryTypeException));
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.badtype", (Object)new Object[]{unsupportedEntryTypeException});
            throw unsupportedEntryTypeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSecurityName", (Object)string2);
        }
        return string2;
    }

    private String getRelativeName(String string) throws CustomRegistryException, RemoteException {
        int n = string.indexOf(realmSeparator);
        String string2 = string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelativeName", (Object)string);
        }
        this.realm = LTPAServerObject.getUserRegistry().getRealm();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("realm from userRegistry.getRealm(): " + this.realm + "\n realm length: " + this.realm.length()));
            Tr.debug((TraceComponent)tc, (String)("realmIndex: " + n));
        }
        if (n >= 0) {
            int n2 = string.indexOf(typeSeparator);
            if (n - n2 - 1 == this.realm.length() && string.startsWith(this.realm, n2 + 1)) {
                string2 = string.substring(n + 1);
            } else {
                Tr.error((TraceComponent)tc, (String)"security.ltpa.realm_mismatch");
                throw new CustomRegistryException("The realm in the token: " + string.substring(n2 + 1, n) + " does not match the current realm: " + this.realm);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelativeName", (Object)string2);
        }
        return string2;
    }

    private byte[] getPrivateKey(byte[] byArray, byte[] byArray2) {
        KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
        return keyEncryptor.decrypt((byte[])byArray2.clone());
    }

    private byte[] getSharedKey(byte[] byArray, byte[] byArray2) {
        KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
        return keyEncryptor.decrypt((byte[])byArray2.clone());
    }

    private byte[] getPublicKey() throws RemoteException {
        return this.publicKey;
    }

    private byte[] getEncPrivateKey() throws RemoteException {
        return this.encryptedPrivateKey;
    }

    private byte[] getEncSharedKey() throws RemoteException {
        return this.encryptedSharedKey;
    }

    public synchronized void generateKeys(byte[] byArray) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateKeys");
        }
        this.adminPassword = byArray;
        KeyEncryptor keyEncryptor = new KeyEncryptor(this.adminPassword);
        LTPAKeyPair lTPAKeyPair = LTPADigSignature.generateLTPAKeyPair();
        this.publicKey = lTPAKeyPair.getPublic().getEncoded();
        this.privateKey = lTPAKeyPair.getPrivate().getEncoded();
        ltpaPubKey = new LTPAPublicKey(this.publicKey);
        ltpaPrivKey = new LTPAPrivateKey(this.privateKey);
        this.encryptedPrivateKey = keyEncryptor.encrypt((byte[])this.privateKey.clone());
        new LTPACrypto();
        sharedKey = LTPACrypto.generate3DESKey();
        this.encryptedSharedKey = keyEncryptor.encrypt((byte[])sharedKey.clone());
        this.refreshTokenFactories();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateKeys");
        }
    }

    public Properties genKeys(byte[] byArray) throws Exception {
        Properties properties;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"genKeys");
            }
            KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            LTPAKeyPair lTPAKeyPair = LTPADigSignature.generateLTPAKeyPair();
            byArray2 = lTPAKeyPair.getPublic().getEncoded();
            byArray3 = lTPAKeyPair.getPrivate().getEncoded();
            byte[] byArray4 = keyEncryptor.encrypt((byte[])byArray3.clone());
            new LTPACrypto();
            byte[] byArray5 = LTPACrypto.generate3DESKey();
            byte[] byArray6 = keyEncryptor.encrypt((byte[])byArray5.clone());
            byte[] byArray7 = Base64Coder.base64Encode((byte[])byArray6);
            byte[] byArray8 = Base64Coder.base64Encode((byte[])byArray4);
            byte[] byArray9 = Base64Coder.base64Encode((byte[])byArray2);
            properties = new Properties();
            try {
                String string;
                properties.put(SHARED_KEY_PROPERTY, new String(byArray7, "UTF8"));
                properties.put(PRIVATE_KEY_PROPERTY, new String(byArray8, "UTF8"));
                properties.put(PUBLIC_KEY_PROPERTY, new String(byArray9, "UTF8"));
                properties.put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
                properties.put(CREATION_DATE_PROPERTY, new Date().toString());
                String string2 = InetAddress.getLocalHost().getHostName();
                properties.put(CREATION_HOST_PROPERTY, string2);
                ORB oRB = EJSORB.getORBInstance();
                if (oRB != null && (string = oRB.getProperty("com.ibm.CORBA.principalName")) != null && string.length() > 0) {
                    properties.put(LDAP_REALM_PROPERTY, string.substring(0, string.indexOf(realmSeparator)));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.genKeys", (String)"1067", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.exportkeys", (Object)new Object[]{unsupportedEncodingException});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unsupported encoding: UTF8");
                }
                throw new Exception(unsupportedEncodingException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Unknown host exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"genKeys");
        }
        return properties;
    }

    public void checkImportSSOProperties(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkImportSSOProperties");
        }
        String string = properties.getProperty(SHARED_KEY_PROPERTY);
        String string2 = properties.getProperty(PRIVATE_KEY_PROPERTY);
        String string3 = properties.getProperty(PUBLIC_KEY_PROPERTY);
        try {
            byte[] byArray2 = Base64Coder.base64Decode((byte[])string.getBytes("UTF8"));
            byte[] byArray3 = Base64Coder.base64Decode((byte[])string2.getBytes("UTF8"));
            byte[] byArray4 = Base64Coder.base64Decode((byte[])string3.getBytes("UTF8"));
            LTPAPublicKey lTPAPublicKey = new LTPAPublicKey(byArray4);
            byte[] byArray5 = this.getPrivateKey(byArray, byArray3);
            LTPAPrivateKey lTPAPrivateKey = new LTPAPrivateKey(byArray5);
            byte[] byArray6 = this.getSharedKey(byArray, byArray2);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.checkImportSSOProperties", (String)"1102", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Problem importingSSO keys. Using original values. Make sure that the password is correct.");
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.checkimportltpakeys", (Object)new Object[]{nullPointerException});
            throw new Exception("Problem importingSSO keys. Using original values. Make sure the password is correct.");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.checkImportSSOProperties", (String)"1109", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Problem importingSSO keys. Using original values.");
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.checkimportltpakeys", (Object)new Object[]{exception});
            throw new Exception("Problem importingSSO keys. Using original values. Check the Password. The exception is " + exception);
        }
    }

    public synchronized void importSSOProperties(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"importSSOProperties");
        }
        this.new_adminPassword = byArray;
        String string = properties.getProperty(SHARED_KEY_PROPERTY);
        String string2 = properties.getProperty(PRIVATE_KEY_PROPERTY);
        String string3 = properties.getProperty(PUBLIC_KEY_PROPERTY);
        try {
            this.new_encryptedSharedKey = Base64Coder.base64Decode((byte[])string.getBytes("UTF8"));
            this.new_encryptedPrivateKey = Base64Coder.base64Decode((byte[])string2.getBytes("UTF8"));
            this.new_publicKey = Base64Coder.base64Decode((byte[])string3.getBytes("UTF8"));
            new_ltpaPubKey = new LTPAPublicKey(this.new_publicKey);
            this.new_privateKey = this.getPrivateKey(byArray, this.new_encryptedPrivateKey);
            new_ltpaPrivKey = new LTPAPrivateKey(this.new_privateKey);
            this.new_sharedKey = this.getSharedKey(byArray, this.new_encryptedSharedKey);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.importSSOProperties", (String)"1140", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Problem importingSSO keys. Using original values.");
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.importkeys", (Object)new Object[]{exception});
            throw new Exception("Problem importingSSO keys. Using original values. The exception is " + exception.getMessage());
        }
        this.adminPassword = this.new_adminPassword;
        this.encryptedSharedKey = this.new_encryptedSharedKey;
        this.encryptedPrivateKey = this.new_encryptedPrivateKey;
        this.publicKey = this.new_publicKey;
        this.privateKey = this.new_privateKey;
        ltpaPubKey = new_ltpaPubKey;
        ltpaPrivKey = new_ltpaPrivKey;
        sharedKey = this.new_sharedKey;
        this.refreshTokenFactories();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"importSSOProperties");
        }
    }

    public Properties exportSSOProperties() throws Exception {
        Properties properties;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"exportSSOProperties");
            }
            if (this.encryptedSharedKey == null || this.encryptedPrivateKey == null || this.publicKey == null) {
                Exception exception = new Exception("Keys do not exist. Make sure the LTPA configuration is setup");
                Tr.error((TraceComponent)tc, (String)"security.ltpa.importkeys", (Object)new Object[]{exception});
                throw exception;
            }
            byte[] byArray = Base64Coder.base64Encode((byte[])this.encryptedSharedKey);
            byte[] byArray2 = Base64Coder.base64Encode((byte[])this.encryptedPrivateKey);
            byte[] byArray3 = Base64Coder.base64Encode((byte[])this.publicKey);
            properties = new Properties();
            try {
                String string;
                properties.put(SHARED_KEY_PROPERTY, new String(byArray, "UTF8"));
                properties.put(PRIVATE_KEY_PROPERTY, new String(byArray2, "UTF8"));
                properties.put(PUBLIC_KEY_PROPERTY, new String(byArray3, "UTF8"));
                properties.put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
                properties.put(CREATION_DATE_PROPERTY, new Date().toString());
                String string2 = InetAddress.getLocalHost().getHostName();
                properties.put(CREATION_HOST_PROPERTY, string2);
                ORB oRB = EJSORB.getORBInstance();
                if (oRB != null && (string = oRB.getProperty("com.ibm.CORBA.principalName")) != null && string.length() > 0) {
                    properties.put(LDAP_REALM_PROPERTY, string.substring(0, string.indexOf(realmSeparator)));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.ltpa.LTPAServerObject.exportSSOProperties", (String)"1200", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.ltpa.exportkeys", (Object)new Object[]{unsupportedEncodingException});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unsupported encoding: UTF8");
                }
                throw new Exception(unsupportedEncodingException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Unknown host exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exportSSOProperties");
        }
        return properties;
    }

    public byte[] issueLoginToken(BasicAuthData basicAuthData) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"issueLoginToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"issueLoginToken");
        }
        throw new RemoteException("issueLoginToken not implemented");
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)("to UTF8 bytes =" + unsupportedEncodingException.toString()));
        }
        return byArray;
    }

    static UserRegistryImpl getUserRegistry() {
        if (userRegistry == null) {
            userRegistry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(ctxMgr.getDefaultRealm());
        }
        return userRegistry;
    }

    static boolean useFIPS() {
        return _useFIPS;
    }

    static String defaultJCEProvider() {
        return _defaultJCEProvider;
    }

    static {
        tokenFactoryMap = new HashMap();
        CURRENT_LTPA_VERSION = "1.0";
        ltpaServer = null;
        _useFIPS = false;
        _defaultJCEProvider = "IBMJCE";
        ctxMgr = ContextManagerFactory.getInstance();
        ACCESS_LTPA_SERVER_OBJECT = new WebSphereRuntimePermission("accessLTPAServerObject");
        MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    }
}

