/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ws.security.util.ByteArray;
import java.security.PublicKey;

public final class LTPAPublicKey
implements PublicKey {
    private byte[][] rawKey;
    private byte[] encodedKey = null;
    private int nLength = 129;
    private int eLength = 3;

    public LTPAPublicKey() {
    }

    LTPAPublicKey(byte[][] byArray) {
        this.rawKey = byArray;
        this.encodedKey = this.encode();
    }

    LTPAPublicKey(byte[] byArray) {
        this.encodedKey = byArray;
        this.rawKey = this.decode(byArray);
    }

    private byte[][] decode(byte[] byArray) {
        byte[][] byArrayArray = new byte[][]{new byte[this.nLength], new byte[this.eLength]};
        ByteArray.copy((byte[])byArray, (int)0, (int)this.nLength, (byte[])byArrayArray[0], (int)0);
        ByteArray.copy((byte[])byArray, (int)this.nLength, (int)this.eLength, (byte[])byArrayArray[1], (int)0);
        return byArrayArray;
    }

    private byte[] encode() {
        int n = this.nLength + this.eLength;
        byte[] byArray = new byte[n];
        ByteArray.copy((byte[])this.rawKey[0], (int)0, (int)this.nLength, (byte[])byArray, (int)0);
        ByteArray.copy((byte[])this.rawKey[1], (int)0, (int)this.eLength, (byte[])byArray, (int)this.nLength);
        this.encodedKey = (byte[])byArray.clone();
        return byArray;
    }

    public boolean equals(Object object) {
        byte[] byArray;
        int n;
        if (this == object) {
            return true;
        }
        if (object instanceof LTPAPublicKey && (n = this.encodedKey.length) == (byArray = ((LTPAPublicKey)object).getEncoded()).length) {
            for (int i = 0; i < n; ++i) {
                if (this.encodedKey[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAlgorithm() {
        return "RSA/SHA-1";
    }

    public byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    public String getFormat() {
        return "LTPAFormat";
    }

    byte[][] getRawKey() {
        return (byte[][])this.rawKey.clone();
    }
}

