/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.localOSORB;

import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.ContextManagerPlatformInterface;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.csiv2.zOSCSIv2PerformPolicy;
import com.ibm.ws.security.localOSORB.NativeCSIv2PerformPolicyData;
import com.ibm.ws.security.localOSORB.SecurityORBInterface;
import com.ibm.ws.security.ltpa.AuthzPropToken;
import com.ibm.ws.security.token.PropagationTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;

public final class SecurityORBImpl
implements SecurityORBInterface {
    private static final TraceComponent tc = Tr.register((Class)SecurityORBImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final int IDTypeServer = 2;
    private static final int IDTypeClNative = 4;
    private static final int IDTypeClUnauthenticated = 8;
    private static final int IDTypeDefault = 14;
    private static SecurityORBImpl soi = new SecurityORBImpl();
    private ContextManagerPlatformInterface contextManager = null;
    private SecurityCache cache = null;
    private WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private int orbType = 3;
    private boolean defaultControllerOutboundIsServer = false;
    private Boolean isSAFRegistry = null;
    private Boolean securityDisabled = null;
    public static final int UID_PW_LOGIN_FAILED_MINOR = -910016206;
    public static final int LTPA_LOGIN_FAILED_MINOR = -910016205;
    public static final int UNABLE_TO_ASSERT_ID_MINOR = -910016204;

    public static final SecurityORBImpl getSecurityORB() {
        return soi;
    }

    private SecurityORBImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.contextManager = (ContextManagerPlatformInterface)ContextManagerFactory.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityCache getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCache");
        }
        SecurityORBImpl securityORBImpl = soi;
        synchronized (securityORBImpl) {
            this.cache = AuthCache.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCache", (Object)this.cache);
        }
        return this.cache;
    }

    public void initialize(String string, int n, String string2, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)new Object[]{string, new Integer(n), string2, new Integer(n2), new Integer(n3)});
        }
        this.orbType = n2;
        if (n2 != 3) {
            this.contextManager.initializePlatformData(string.trim(), n, string2, n2, n3);
        }
        this.defaultControllerOutboundIsServer = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSAFRegistry() {
        if (this.isSAFRegistry != null) {
            return this.isSAFRegistry;
        }
        SecurityORBImpl securityORBImpl = this;
        synchronized (securityORBImpl) {
            if (this.orbType != 3) {
                String string = this.contextManager.getProperty("security.use.localos.userregistry");
                this.isSAFRegistry = new Boolean(string);
            }
        }
        return this.isSAFRegistry;
    }

    private boolean isSecurityDisabled() {
        if (this.securityDisabled != null) {
            return this.securityDisabled;
        }
        this.securityDisabled = new Boolean(!this.contextManager.isServerSecurityEnabled());
        return this.securityDisabled;
    }

    public void connectReceivedCredentials(int n, byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, boolean bl, byte[] byArray4, int n3, String string, int n4, String string2, String string3, long l, byte[] byArray5, String string4) throws RemoteException {
        if (this.isSecurityDisabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectReceivedCredential", (Object)new Object[]{new Integer(n), byArray, new Integer(n2), byArray2, byArray3, new Boolean(bl), byArray4, new Integer(n3), string, new Integer(n4), string2, string3, new Long(l), byArray5, string4 == null ? "null" : "****"});
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        String string5 = (String)securityConfig.getValue("com.ibm.ws.security.defaultLoginConfig");
        Subject subject = null;
        if (n3 == 2) {
            try {
                subject = this.contextManager.getServerSubject();
            }
            catch (Exception exception) {
                throw new RemoteException("getServerSubject failure: " + exception.getMessage(), exception);
            }
        }
        if (n3 == 8 || n3 == 14) {
            try {
                subject = this.contextManager.getUnauthenticatedSubject();
            }
            catch (Exception exception) {
                throw new RemoteException("getUnauthenticatedCredential failure: " + exception.getMessage(), exception);
            }
        }
        if (null != string4) {
            try {
                subject = this.contextManager.login(string2, string != null ? string.trim() : string, string4, securityConfig.getRMIInboundLoginConfig(), null, null, null);
            }
            catch (Exception exception) {
                this.throwNoPermission(exception, -910016206);
            }
        } else if (n > 0) {
            try {
                subject = this.doCSIv2Token(n, byArray, string2, byArray4, byArray3);
            }
            catch (Exception exception) {
                this.throwNoPermission(exception, -910016205);
            }
        } else if (n2 == 0) {
            String string6;
            String string7 = string6 = string2 != null ? string2 : this.contextManager.getDefaultSAFRealm();
            if (this.orbType == 1) {
                try {
                    subject = this.contextManager.login(string6, string != null ? string.trim() : string, string5, null, null, null);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Login failed", (Object)exception);
                    }
                    if (n3 == 14 || n3 == 4) {
                        try {
                            subject = this.contextManager.getUnauthenticatedSubject();
                        }
                        catch (Exception exception2) {
                            throw new RemoteException("getUnauthenticatedCredential failure: " + exception2.getMessage(), exception2);
                        }
                    }
                    throw new RemoteException("Authentication failed", exception);
                }
            } else {
                try {
                    subject = this.contextManager.login(string6, string != null ? string.trim() : string, securityConfig.getRMIInboundLoginConfig(), null, null, null);
                }
                catch (Exception exception) {
                    throw new RemoteException("Authentication failed", exception);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("idType is " + n2));
        }
        if (n2 > 0) {
            if (n3 == 8 || n3 == 14 || "UNAUTHENTICATED".equals(new String(byArray2))) {
                try {
                    subject = this.contextManager.getUnauthenticatedSubject();
                }
                catch (Exception exception) {
                    throw new RemoteException("Could not acquire unauthenticated credential", exception);
                }
            }
            if (n > 0) {
                this.checkID(subject);
                try {
                    this.contextManager.clearCallerContext();
                }
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception from clearCallerContext", (Object)exception);
                }
            }
            try {
                subject = this.doCSIv2Token(n2, byArray2, string2, byArray4, byArray3);
            }
            catch (Exception exception) {
                this.throwNoPermission(exception, -910016204);
            }
        }
        try {
            this.contextManager.initializeCallerContext(subject);
        }
        catch (WSSecurityException wSSecurityException) {
            Tr.event((TraceComponent)tc, (String)"security.ORB.WSSecurityException", (Object)((Object)wSSecurityException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectReceivedCredential");
        }
    }

    public byte[] disconnectReceivedCredentials() {
        if (this.isSecurityDisabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"disconnectReceivedCredentials");
        }
        byte[] byArray = null;
        try {
            byte[] byArray2;
            WSCredentialImpl wSCredentialImpl;
            if (this.orbType != 3 && (wSCredentialImpl = (WSCredentialImpl)SubjectHelper.getWSCredentialFromSubject((Subject)this.contextManager.getCallerSubject())) != null && (byArray2 = wSCredentialImpl.getCredentialToken()) != null) {
                byArray = this.buildSEED(wSCredentialImpl.getRealmName(), wSCredentialImpl.getSecurityName(), wSCredentialImpl.getOID(), wSCredentialImpl.getExpiration(), byArray2.length, byArray2, 0L, null, 0L, null, 0, null, true, this.getIdentityType((WSCredential)wSCredentialImpl));
            }
            this.contextManager.clearCallerContext();
        }
        catch (Exception exception) {
            Tr.event((TraceComponent)tc, (String)"caught callerCred exception", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"disconnectReceivedCredential", byArray);
        }
        return byArray;
    }

    private X509Certificate[] convertCertificate(byte[] byArray) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertCertificate", (Object)byArray);
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(dataInputStream);
            x509CertificateArray = collection.toArray(new X509Certificate[0]);
        }
        catch (Exception exception) {
            throw new RemoteException("Certificate conversion failed", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertCertificate", (Object)x509CertificateArray);
        }
        return x509CertificateArray;
    }

    private Subject doCSIv2Token(int n, byte[] byArray, String string, byte[] byArray2, byte[] byArray3) throws Exception {
        ArrayList arrayList;
        WSOpaqueTokenHelper wSOpaqueTokenHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doCSIv2Token", (Object)new Object[]{new Integer(n), byArray, string, byArray2, byArray3});
        }
        Subject subject = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() && byArray2 != null && (subject = this.getCache().getSubject(byArray2)) != null && !this.getWSCredTokenMapper().checkValidityOfAllTokens(subject)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing expired credential from cache", (Object)subject);
                }
                wSOpaqueTokenHelper = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                this.getCache().removeEntry(wSOpaqueTokenHelper.getRealmName(), wSOpaqueTokenHelper.getSecurityName());
                subject = null;
            }
            if ((WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled()) && byArray3 != null && subject != null) {
                wSOpaqueTokenHelper = WSOpaqueTokenHelper.getInstance();
                arrayList = wSOpaqueTokenHelper.createTokenHolderListFromOpaqueToken(byArray3);
                for (int i = 0; i < arrayList.size(); ++i) {
                    TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                    if (!tokenHolder.getName().equals("com.ibm.ws.security.token.PropagationTokenImpl")) continue;
                    final PropagationTokenImpl propagationTokenImpl = new PropagationTokenImpl();
                    AuthzPropToken authzPropToken = new AuthzPropToken(tokenHolder.getBytes(), null, null, null);
                    propagationTokenImpl.initializeToken(authzPropToken);
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            String string = propagationTokenImpl.getName() + ":" + propagationTokenImpl.getVersion();
                            SecurityORBImpl.this.contextManager.setPropagationToken(string, (PropagationToken)propagationTokenImpl);
                            return null;
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.localOSORB.SecurityORBImpl.doCSIv2Token", (String)"759", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Cached login failed, logging in", (Object)exception);
            }
            subject = null;
        }
        if (subject == null) {
            if ((WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled()) && byArray3 != null) {
                wSOpaqueTokenHelper = WSOpaqueTokenHelper.getInstance();
                arrayList = wSOpaqueTokenHelper.createTokenHolderListFromOpaqueToken(byArray3);
                this.contextManager.put(wSOpaqueTokenHelper.getOpaqueTokenLookup(), (Object)arrayList);
            }
            subject = this.doCSIv2Login(n, byArray, string, byArray2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doCSIv2Token", (Object)subject);
        }
        return subject;
    }

    /*
     * Unable to fully structure code
     */
    private Subject doCSIv2Login(int var1_1, byte[] var2_2, String var3_3, byte[] var4_4) throws WSSecurityException {
        if (SecurityORBImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SecurityORBImpl.tc, (String)"doCSIv2Login", (Object)new Object[]{new Integer(var1_1), var2_2, var3_3, var4_4});
        }
        var5_5 = null;
        try {
            this.contextManager.put("CacheKeyAttribute", (Object)var4_4);
            var6_6 = SecurityConfig.getConfig().getRMIInboundLoginConfig();
            switch (var1_1) {
                case 1: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityORBImpl.tc, (String)"token login", (Object)var2_2);
                    }
                    var5_5 = this.contextManager.login(var3_3, var2_2, var6_6, null, null, null);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 3: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityORBImpl.tc, (String)"uid login", (Object)var2_2);
                    }
                    var5_5 = this.contextManager.login(var3_3, new String(var2_2));
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 4: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityORBImpl.tc, (String)"DN login", (Object)var2_2);
                    }
                    var7_9 = new X500Principal(var2_2);
                    var8_10 = var7_9.getName();
                    var8_10 = CSIUtil.getInstance().parseDN(var8_10);
                    var5_5 = this.contextManager.login(var3_3, var8_10);
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityORBImpl.tc, (String)"Certificate login", (Object)var2_2);
                    }
                    var9_11 = this.convertCertificate(var2_2);
                    var5_5 = this.contextManager.login(var3_3, var9_11, var6_6, null, null, null);
                    break;
                }
                ** default:
lbl37:
                // 1 sources

                break;
            }
        }
        catch (WSSecurityException var6_7) {
            throw var6_7;
        }
        catch (Throwable var6_8) {
            throw new WSSecurityException(var6_8.getMessage(), var6_8);
        }
        finally {
            this.contextManager.put("CacheKeyAttribute", null);
        }
        if (SecurityORBImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityORBImpl.tc, (String)"doCSIv2Login", (Object)var5_5);
        }
        return var5_5;
    }

    private WSCredentialTokenMapperInterface getWSCredTokenMapper() throws WSSecurityException {
        if (this.wsCredTokenMapper != null) {
            return this.wsCredTokenMapper;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWSCredTokenMapper");
        }
        if (this.wsCredTokenMapper == null) {
            this.wsCredTokenMapper = WSCredentialTokenMapper.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWSCredTokenMapper", (Object)this.wsCredTokenMapper);
        }
        return this.wsCredTokenMapper;
    }

    public byte[] rmiOutboundLogin(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rmiOutboundLogin", (Object)byArray);
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        byte[] byArray2 = null;
        try {
            Subject subject = this.getOutboundSubject();
            if (securityConfig.isRMIOutboundLoginEnabled() || securityConfig.isRMIOutboundPropagationEnabled()) {
                final Subject subject2 = subject;
                Subject subject3 = (Subject)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return SubjectHelper.createNewSubjectFromExisting((Subject)subject2);
                    }
                });
                NativeCSIv2PerformPolicyData nativeCSIv2PerformPolicyData = new NativeCSIv2PerformPolicyData(ByteBuffer.wrap(byArray));
                CSIv2PerformPolicy cSIv2PerformPolicy = new CSIv2PerformPolicy((zOSCSIv2PerformPolicy)nativeCSIv2PerformPolicyData);
                Subject subject4 = this.contextManager.login(securityConfig.getRMIOutboundLoginConfig(), (Object)cSIv2PerformPolicy, subject3);
                this.contextManager.setInvocationSubject(subject);
                WSCredentialImpl wSCredentialImpl = (WSCredentialImpl)SubjectHelper.getWSCredentialFromSubject((Subject)subject4);
                byte[] byArray3 = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject4);
                byte[] byArray4 = this.contextManager.getClientUniqueIDArrayForOutboundRequests(subject);
                byte[] byArray5 = wSCredentialImpl.getCredentialToken();
                if (byArray5 != null) {
                    byArray2 = this.buildSEED(wSCredentialImpl.getRealmName(), wSCredentialImpl.getSecurityName(), wSCredentialImpl.getOID(), wSCredentialImpl.getExpiration(), byArray5.length, byArray5, 0L, null, byArray3.length, byArray3, byArray4.length, byArray4, true, this.getIdentityType((WSCredential)wSCredentialImpl));
                }
            }
        }
        catch (Exception exception) {
            Tr.event((TraceComponent)tc, (String)"exception occurred in rmiOutboundLogin", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rmiOutboundLogin", byArray2);
        }
        return byArray2;
    }

    void checkID(Subject subject) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkID", (Object)subject);
        }
        boolean bl = false;
        try {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            String string = wSCredential.getSecurityName();
            bl = CSIUtil.getInstance().isTrusted(string);
        }
        catch (Exception exception) {
            throw new RemoteException("Unable to determine asserting subject's name");
        }
        if (!bl) {
            throw new RemoteException("Asserting identity is not trusted.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkID");
        }
    }

    public byte[] getCurrentCredentials() {
        byte[] byArray;
        block10: {
            if (this.isSecurityDisabled()) {
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCurrentCredentials");
            }
            byArray = null;
            try {
                Subject subject = this.getOutboundSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                if (((WSCredentialImpl)wSCredential).isServerCred() && wSCredential.getExpiration() != 0L && wSCredential.getExpiration() != -1L && !this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject, this.contextManager.getReqTimeout())) {
                    subject = this.contextManager.getServerSubject();
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                }
                byte[] byArray2 = wSCredential != null ? wSCredential.getCredentialToken() : new byte[]{};
                ArrayList arrayList = wSCredential != null ? wSCredential.getGroupIds() : null;
                byte[] byArray3 = this.arrayListToByteArray(arrayList);
                byte[] byArray4 = this.isPropagationEnabled() ? this.contextManager.getClientUniqueIDArrayForOutboundRequests(subject) : null;
                int n = byArray4 != null ? byArray4.length : 0;
                byte[] byArray5 = byArray2 = byArray2 == null ? new byte[]{} : byArray2;
                if (this.orbType != 3) {
                    if (!((WSCredentialImpl)wSCredential).isServerCred() && wSCredential.getExpiration() != 0L && wSCredential.getExpiration() != -1L && !this.getWSCredTokenMapper().checkValidityOfAllTokens(subject)) {
                        this.throwNoPermission(null, 1229079302);
                    }
                    byArray = this.buildSEED(wSCredential.getRealmName(), wSCredential.getSecurityName(), wSCredential.getOID(), wSCredential.getExpiration(), byArray2.length, byArray2, byArray3.length, byArray3, 0L, null, n, byArray4, true, this.getIdentityType(wSCredential));
                } else if ("oid:2.23.130.1.1.1".equals(wSCredential.getOID()) && !wSCredential.isUnauthenticated()) {
                    byArray = this.buildBasicAuthSEED(wSCredential.getRealmName(), wSCredential.getSecurityName(), StringBytesConversion.getConvertedString((byte[])byArray2));
                }
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block10;
                Tr.event((TraceComponent)tc, (String)"Unexpected exception on outbound", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCurrentCredentials", byArray);
        }
        return byArray;
    }

    private byte[] arrayListToByteArray(ArrayList arrayList) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"arrayListToByteArray", (Object)arrayList);
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(arrayList);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Unable to serialize list", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"arrayListToByteArray", byArray);
        }
        return byArray;
    }

    private boolean isPropagationEnabled() {
        if (this.orbType == 3) {
            return false;
        }
        return WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled();
    }

    private Subject getOutboundSubject() throws WSSecurityException {
        Subject subject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutboundSubject");
        }
        if ((subject = this.contextManager.getInvocationSubject()) == null) {
            subject = this.contextManager.getCallerSubject();
        }
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Going outbound with default creds: ", (Object)new Exception("Traceback for debug"));
            }
            subject = this.getDefaultOutboundSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutboundSubject", (Object)subject);
        }
        return subject;
    }

    private Subject getDefaultOutboundSubject() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultOutboundSubject");
        }
        Subject subject = null;
        subject = this.orbType == 1 && this.defaultControllerOutboundIsServer ? this.contextManager.getServerSubject() : this.contextManager.getUnauthenticatedSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultOutboundSubject", (Object)subject);
        }
        return subject;
    }

    private void throwNoPermission(Throwable throwable, int n) throws NO_PERMISSION {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"throwNoPermission", (Object)new Object[]{throwable, new Integer(n)});
        }
        NO_PERMISSION nO_PERMISSION = null;
        if (throwable instanceof WSLoginFailedException) {
            WSLoginFailedException wSLoginFailedException = (WSLoginFailedException)throwable;
            throwable = wSLoginFailedException.getCause();
        }
        if (throwable instanceof NO_PERMISSION) {
            nO_PERMISSION = (NO_PERMISSION)throwable;
        }
        if (nO_PERMISSION == null) {
            nO_PERMISSION = new NO_PERMISSION(n, CompletionStatus.COMPLETED_NO);
            nO_PERMISSION.initCause(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"throwNoPermission", (Object)nO_PERMISSION);
        }
        throw nO_PERMISSION;
    }

    private int getIdentityType(WSCredential wSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIdentityType", (Object)wSCredential);
        }
        WSCredentialImpl wSCredentialImpl = (WSCredentialImpl)wSCredential;
        int n = 0;
        if (wSCredentialImpl.isServerCred()) {
            n = 2;
        } else if (wSCredentialImpl.isBasicAuth()) {
            n = 8;
        } else if (wSCredentialImpl.isUnauthenticated()) {
            n = 14;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIdentityType", (Object)new Integer(n));
        }
        return n;
    }

    private native byte[] buildSEED(String var1, String var2, String var3, long var4, long var6, byte[] var8, long var9, byte[] var11, long var12, byte[] var14, int var15, byte[] var16, boolean var17, int var18);

    private native byte[] buildBasicAuthSEED(String var1, String var2, String var3);
}

