/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.icsf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class LoginTokenHeader {
    private static TraceComponent tc = Tr.register((String)LoginTokenHeader.class.getName(), (String)"Servlet_Engine");
    private static String TOKEN_TYPE = "ltf";
    private static String TOKEN_ORIGINATOR = "WASzOS";
    private static String WAS_VERSION = "4.01";
    private static String TOKEN_VERSION = "1.0";
    private static String TOKEN_FORMAT = "1.0";
    public static final String URIChallenge_TOKEN_DELIMITER = "%%%%%";
    public static final String URIChallenge_TOKEN_TYPE_TAG = "wastag_tt";
    public static final String URIChallenge_TOKEN_FIELD_DELIMITER = ",";
    public static final String URIChallenge_ORIGINATOR_TAG = "wastag_os";
    public static final String URIChallenge_ORIGINATOR_VERSION_TAG = "wastag_ov";
    public static final String URIChallenge_TOKEN_VERSION_TAG = "wastag_tv";
    public static final String URIChallenge_TOKEN_FORMAT_TAG = "wastag_tf";
    public static final String URIChallenge_USERID_TAG = "wastag_ui";
    private String tokenHeader;
    private byte[] tokenHeaderBytes;
    private String tt;
    private String os;
    private String ov;
    private String tv;
    private String tf;
    private boolean fromSecurityInfo;
    private boolean isValid;

    private void resetObject() {
        this.tokenHeader = null;
        this.tokenHeaderBytes = null;
        this.tt = null;
        this.os = null;
        this.ov = null;
        this.tv = null;
        this.tf = null;
        this.fromSecurityInfo = false;
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public LoginTokenHeader() {
        this.resetObject();
        this.tokenHeader = "%%%%%wastag_tt=lft,wastag_os=WASzOS,wastag_ov=4.01,wastag_tv=1.0,wastag_tf=1.0%%%%%";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("construct: tokenHeader=" + this.tokenHeader));
        }
        try {
            this.tokenHeaderBytes = this.tokenHeader.getBytes("UTF8");
        }
        catch (Throwable throwable) {
            this.tokenHeaderBytes = this.tokenHeader.getBytes();
        }
        this.fromSecurityInfo = true;
        this.isValid = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"construct");
        }
    }

    private boolean parseHeaderString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseHeaderString: entry");
        }
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        String string2 = string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("header=" + string2));
        }
        try {
            int n = URIChallenge_TOKEN_FIELD_DELIMITER.length();
            if (string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) == -1) {
                return bl;
            }
            if (string2.startsWith(URIChallenge_TOKEN_DELIMITER)) {
                string2 = string2.substring(URIChallenge_TOKEN_DELIMITER.length());
            }
            if (string2.length() < 1) {
                return bl;
            }
            if (string2.endsWith(URIChallenge_TOKEN_DELIMITER)) {
                string2 = string2.substring(0, string2.indexOf(URIChallenge_TOKEN_DELIMITER));
            }
            if (string2.length() < 1) {
                return bl;
            }
            if (string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) == -1) {
                return bl;
            }
            if (!string2.startsWith(URIChallenge_TOKEN_TYPE_TAG)) {
                return bl;
            }
            this.tt = string2.substring(URIChallenge_TOKEN_TYPE_TAG.length() + 1, string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER));
            if (this.tt.length() < 1) {
                return bl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tt=" + this.tt));
            }
            if ((string2 = string2.substring(string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) + n)).length() < 1) {
                return bl;
            }
            if (string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) == -1) {
                return bl;
            }
            if (!string2.startsWith(URIChallenge_ORIGINATOR_TAG)) {
                return bl;
            }
            this.os = string2.substring(URIChallenge_ORIGINATOR_TAG.length() + 1, string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER));
            if (this.os.length() < 1) {
                return bl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("os=" + this.os));
            }
            if ((string2 = string2.substring(string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) + n)).length() < 1) {
                return bl;
            }
            if (string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) == -1) {
                return bl;
            }
            if (!string2.startsWith(URIChallenge_ORIGINATOR_VERSION_TAG)) {
                return bl;
            }
            this.ov = string2.substring(URIChallenge_ORIGINATOR_VERSION_TAG.length() + 1, string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER));
            if (this.ov.length() < 1) {
                return bl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ov=" + this.ov));
            }
            if ((string2 = string2.substring(string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) + n)).length() < 1) {
                return bl;
            }
            if (string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) == -1) {
                return bl;
            }
            if (!string2.startsWith(URIChallenge_TOKEN_VERSION_TAG)) {
                return bl;
            }
            this.tv = string2.substring(URIChallenge_TOKEN_VERSION_TAG.length() + 1, string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER));
            if (this.tv.length() < 1) {
                return bl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tv=" + this.tv));
            }
            if ((string2 = string2.substring(string2.indexOf(URIChallenge_TOKEN_FIELD_DELIMITER) + n)).length() < 1) {
                return bl;
            }
            if (!string2.startsWith(URIChallenge_TOKEN_FORMAT_TAG)) {
                return bl;
            }
            this.tf = string2.substring(URIChallenge_TOKEN_FORMAT_TAG.length() + 1);
            if (this.tf.length() < 1) {
                return bl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tf=" + this.tf));
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("parseHeaderString: caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("parseHeaderString -- rc = " + bl));
        }
        return bl;
    }

    private boolean validateHeaderFields() {
        boolean bl = false;
        if (TOKEN_TYPE.equals(this.tt) && TOKEN_VERSION.equals(this.tv) && TOKEN_FORMAT.equals(this.tf)) {
            bl = true;
        }
        return bl;
    }

    LoginTokenHeader(String string) {
        this.resetObject();
        if (string == null) {
            return;
        }
        if (this.parseHeaderString(string) && this.validateHeaderFields()) {
            this.fromSecurityInfo = false;
            this.isValid = true;
        }
    }

    public boolean generatedFromSecurityInfo() {
        return this.fromSecurityInfo;
    }

    public String getHeader() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeader: tokenHeader=" + this.tokenHeader));
        }
        return this.tokenHeader;
    }

    public byte[] getHeaderBytes() {
        return this.tokenHeaderBytes;
    }

    public String getOriginator() {
        return this.os;
    }

    public String getOriginatorVersion() {
        return this.ov;
    }

    public String getTokenType() {
        return this.tt;
    }

    public String getTokenVersion() {
        return this.tv;
    }

    public String getTokenFormat() {
        return this.tf;
    }
}

