/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SAFRoleMapperFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.delegation.MethodDelegation;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.security.auth.Subject;

class SAFMethodDelegation
extends MethodDelegation {
    private static final TraceComponent tc = Tr.register((Class)SAFMethodDelegation.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final SAFRoleMapper _roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();

    SAFMethodDelegation() {
    }

    protected Subject getRunAsSpecifiedUserSubject(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunAsSpecifiedUserSubject", (Object)new Object[]{string, string2});
        }
        String string3 = _roleMapper.getProfileFromRole(string2, string);
        PlatformCredentialManager platformCredentialManager = PlatformCredentialManager.instance();
        final PlatformCredential platformCredential = platformCredentialManager.createRoleCredential(string2, string, string3);
        Subject subject = null;
        String string4 = null;
        if (platformCredential != null) {
            try {
                Subject subject2 = new Subject();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                string4 = platformCredential.getUserId();
                hashtable.put("com.ibm.wsspi.security.cred.cacheKey", platformCredential.getCacheKeyString());
                subject2.getPublicCredentials().add(hashtable);
                String string5 = contextManager.getDefaultRealm();
                String string6 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.defaultLoginConfig");
                subject = contextManager.login(string5, string4, string6, null, null, null, subject2);
                final WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        wSCredential.set("com.ibm.ws.security.zos.PlatformCredential", (Object)platformCredential);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.delegation.SAFMethodDelegation.getRoleCredential", (String)"131", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception setting PlatformCredential", (Object)privilegedActionException.getException());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.delegation.SAFMethodDelegation.getRoleCredential", (String)"136", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception during SAF role to user mapping", (Object)exception);
                }
                Tr.audit((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string4});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunAsSpecifiedUserSubject", subject);
        }
        return subject;
    }
}

