/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.UseCallerIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseSystemIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.Identity;
import com.ibm.etools.j2ee.common.RunAsSpecifiedIdentity;
import com.ibm.etools.j2ee.common.SecurityIdentity;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.WebAccessContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;

class MethodDelegation
implements Delegation {
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final TraceComponent tc = Tr.register((Class)MethodDelegation.class, (String)"Security", (String)"com.ibm.ejs.resources.security");

    MethodDelegation() {
    }

    protected boolean checkRunAsMethod(com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity securityIdentity, String string, String string2) {
        EList eList = securityIdentity.getMethodElements();
        return eList != null && eList.size() != 0 && BeanPermissionRoleMap.findMatchingMethod(string, string2, eList);
    }

    public Subject delegate(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, Subject subject, Subject subject2, SecurityBeanCookie securityBeanCookie) throws CSIException {
        EnterpriseBean enterpriseBean;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"runAsDelegation");
        }
        String string = eJBMethodInfo.getMethodSignature();
        String string2 = SecurityCollaborator.getMethodWithSignature(eJBMethodInfo.getMethodName(), string);
        boolean bl = eJBMethodInfo.isHome();
        int n = eJBMethodInfo.getInterfaceType().getValue();
        string2 = string2 + ":" + n;
        Subject subject3 = subject2;
        EList eList = securityBeanCookie.getRunAsSettings();
        String string3 = securityBeanCookie.getAppName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Checking RunAs for : App = " + string3 + " Bean = " + securityBeanCookie.getBeanName() + " Method = " + string2));
        }
        if (eList != null) {
            int n2 = eList.size();
            for (int i = 0; i < n2; ++i) {
                object = (com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity)eList.get(i);
                RunAsMode runAsMode = object.getRunAsMode();
                if (!this.checkRunAsMethod((com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity)object, securityBeanCookie.getBeanName(), string2)) continue;
                if (runAsMode instanceof UseCallerIdentity) {
                    subject3 = subject2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RunAs set to Caller Identity ");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"runAsDelegation");
                    }
                    return subject3;
                }
                if (runAsMode instanceof UseSystemIdentity) {
                    subject3 = subject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RunAs set to System Identity ");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"runAsDelegation");
                    }
                    return subject3;
                }
                if (!(runAsMode instanceof com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity)) continue;
                String string4 = ((com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity)runAsMode).getRunAsSpecifiedIdentity().getRoleName();
                subject3 = this.getRunAsSpecifiedUserSubject(string4, string3);
                if (subject3 == null) {
                    subject3 = subject2;
                }
                return subject3;
            }
        }
        if ((enterpriseBean = securityBeanCookie.getEjbJar().getEnterpriseBeanNamed(securityBeanCookie.getBeanName())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cannot find bean " + securityBeanCookie.getBeanName() + " in the jar"));
            }
            return subject3;
        }
        SecurityIdentity securityIdentity = enterpriseBean.getSecurityIdentity();
        if (securityIdentity != null) {
            if (securityIdentity instanceof com.ibm.etools.j2ee.common.UseCallerIdentity) {
                subject3 = subject2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"RunAs set to Caller Identity ");
                }
            } else if (securityIdentity instanceof RunAsSpecifiedIdentity && (subject3 = this.getRunAsSpecifiedUserSubject((String)(object = ((RunAsSpecifiedIdentity)securityIdentity).getIdentity().getRoleName()), string3)) == null) {
                subject3 = subject2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runAsDelegation");
        }
        return subject3;
    }

    public Subject delegate(Subject subject, String string, WebAccessContext webAccessContext, String string2) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("delegate " + string2));
        }
        Subject subject2 = subject;
        WebApp webApp = webAccessContext.getWebApp();
        Servlet servlet = null;
        if (webApp != null && string2 != null) {
            servlet = webApp.getServletNamed(string2);
        }
        if (servlet != null) {
            RunAsSpecifiedIdentity runAsSpecifiedIdentity = servlet.getRunAs();
            if (runAsSpecifiedIdentity != null) {
                String string3;
                Identity identity;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RunAs Specified for servlet" + string2));
                }
                if ((identity = runAsSpecifiedIdentity.getIdentity()) != null && (subject2 = this.getRunAsSpecifiedUserSubject(string3 = identity.getRoleName(), webAccessContext.getEnterpriseAppName())) == null) {
                    subject2 = subject;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Servlet not Specified in DD for servlet" + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delegate");
        }
        return subject2;
    }

    protected Subject getRunAsSpecifiedUserSubject(String string, final String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunAsSpecifiedUserSubject");
        }
        BasicAuthData basicAuthData = null;
        Subject subject = null;
        SecurityRole securityRole = WCCMHelper.createSecurityRole(null, string);
        RunAsMap runAsMap = (RunAsMap)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                SecurityCollaborator.getRunAsMapTable();
                return RunAsMapTable.getRunAsMap(string2);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RunAs set to Specified Identity : RunAs Role = " + string));
        }
        if (runAsMap != null) {
            basicAuthData = (BasicAuthData)runAsMap.getAuthData(securityRole);
            if (basicAuthData != null) {
                try {
                    subject = this.contextManager.login(this.contextManager.getDefaultRealm(), basicAuthData.getUserId(), basicAuthData.getPassword());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.getRunAsSpecifiedUserSubject", (String)"293", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception during user authentication:", (Object)exception);
                    }
                    Tr.audit((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{basicAuthData.getUserId()});
                    subject = null;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRunAsSpecifiedUserSubject");
                }
                return subject;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Application Identity Not Configured");
                Tr.debug((TraceComponent)tc, (String)"Invocation (SPECIFIED) identity is set to ClientIdentity");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunAsSpecifiedUserSubject");
        }
        return subject;
    }
}

