/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.security.auth.zOSContextManagerImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityAdminHelper;
import com.ibm.ws.security.core.SecurityComponentImpl;
import com.ibm.ws.security.core.distSecurityComponentImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.Provider;
import java.util.Properties;
import javax.security.auth.Subject;

public final class zOSSecurityComponentImpl
extends distSecurityComponentImpl {
    private static final TraceComponent tc = Tr.register((Class)zOSSecurityComponentImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
    private static final String SAFKeyRingHandler = "com.ibm.crypto.provider.safkeyring.Handler";
    private static final String SAFHWKeyRingHandler = "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler";

    zOSSecurityComponentImpl(SecurityComponentImpl securityComponentImpl) {
        super(securityComponentImpl);
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        try {
            System.loadLibrary("bbosec");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Tr.event((TraceComponent)tc, (String)"Unable to load BBOSEC DLL", (Object)unsatisfiedLinkError);
            throw new ConfigurationError((Throwable)unsatisfiedLinkError);
        }
        super.initialize(object);
        this.setupNativeConfiguration();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    private native void setupNativeConfiguration();

    void configureRoleBasedAuthz(ConfigRoot configRoot, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configureRoleBasedAuthz", (Object)new Object[]{configRoot, string});
        }
        if (!string.equals("naming-authz")) {
            super.configureRoleBasedAuthz(configRoot, string);
        } else if (string.equals("naming-authz") && this.isController()) {
            super.configureRoleBasedAuthz(configRoot, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureRoleBasedAuthz");
        }
    }

    void initializeSecurityMBeans() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSecurityMBeans");
        }
        super.initializeSecurityMBeans();
        SecurityAdminHelper.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSecurityMBeans");
        }
    }

    Subject initializeServerSubject() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeServerSubject");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Subject subject = ((zOSContextManagerImpl)contextManager).getServerSubjectInternal();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeServerSubject", (Object)subject);
        }
        return subject;
    }

    void initializeFips(Security security, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeFips", (Object)new Object[]{security, string});
        }
        this.registerCryptoProviders(security);
        super.initializeFips(security, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeFips");
        }
    }

    private void registerCryptoProviders(Security security) throws Exception {
        Provider[] providerArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCryptoProviders");
        }
        try {
            StreamHandlerUtils.addProvider((String)"safkeyring", (String)SAFKeyRingHandler);
            providerArray = java.security.Security.getProvider("IBMJCE4758");
            Provider provider = java.security.Security.getProvider("IBMJCECCA");
            if (providerArray != null || provider != null) {
                StreamHandlerUtils.addProvider((String)"safkeyringhw", (String)SAFHWKeyRingHandler);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"195", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{throwable});
            throw new ConfigurationError("Error during Security initialization", throwable);
        }
        if (tc.isDebugEnabled()) {
            providerArray = java.security.Security.getProviders();
            for (int i = 0; i < providerArray.length; ++i) {
                String string = "Provider [" + i + "]:\n" + "\tName = " + providerArray[i].getName() + "\n" + "\tVersion = " + providerArray[i].getVersion() + "\n" + "\tClass = " + providerArray[i].getClass().getName();
                Tr.debug((TraceComponent)tc, (String)string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCryptoProviders");
        }
    }

    private Provider getProviderInstance(String string, String string2) {
        Provider provider;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getProviderInstance", (Object)new Object[]{string, string2});
            }
            provider = null;
            try {
                provider = (Provider)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"provider not found", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProviderInstance", (Object)provider);
        }
        return provider;
    }

    Properties getSSLConfigProperties(SSLConfig sSLConfig, String string) {
        Properties properties;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLConfigProperties", (Object)new Object[]{sSLConfig, string});
        }
        String string3 = string2 = sSLConfig.getType() == null ? null : sSLConfig.getType().getName();
        if (string2 != null && string2.equals("SSSL")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring System SSL repertoire");
            }
            properties = new Properties();
            properties.put("com.ibm.ssl.sslType", string2);
        } else {
            properties = super.getSSLConfigProperties(sSLConfig, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLConfigProperties");
        }
        return properties;
    }

    public WSSecurityContext getWSSecurityContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWSSecurityContext");
        }
        WSSecurityContext wSSecurityContext = super.getWSSecurityContext();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWSSecurityContext", (Object)wSSecurityContext);
        }
        return wSSecurityContext;
    }

    boolean isController() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isController");
        }
        boolean bl = this.platformHelper.isControlJvm();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isController", (Object)new Boolean(bl));
        }
        return bl;
    }
}

