/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Group;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public abstract class WSAccessManager
implements AccessManager {
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ADMINAPP = "Server Administration Application";
    private static final TraceComponent tc = Tr.register((Class)WSAccessManager.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static Hashtable authzTableMap = new Hashtable(10);
    private static Hashtable contextIDTable = new Hashtable(10);
    private static AuthorizationTable adminAppAuthTable = null;
    private PluggableAuthorizationTableProxy pluggableAuthTable;
    private String serverId;
    private User userSub;
    private Group groupSub;
    private static boolean ignoreCase = false;
    private static boolean isLDAPRegistry = false;
    private static boolean isAccessManagerCreated = false;
    private static UserRegistry registry;
    private static boolean filledAccessIDs;
    private static ContextManager contextManager;
    protected RoleBasedAuthorizer adminAuthorizer;
    protected static List adminapps;

    public WSAccessManager() {
        block13: {
            WSCredential wSCredential;
            block12: {
                this.pluggableAuthTable = null;
                this.serverId = null;
                this.userSub = null;
                this.groupSub = null;
                this.adminAuthorizer = null;
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"<init>");
                }
                contextManager = ContextManagerFactory.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"admin applications", (Object)adminapps);
                }
                this.pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
                Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoreCae", (Object)bl);
                }
                if (bl != null && bl.booleanValue()) {
                    ignoreCase = true;
                }
                SecurityConfig.getConfig();
                if (SecurityConfig.isRegLDAP()) {
                    isLDAPRegistry = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"User registry type is LDAP");
                    }
                }
                try {
                    wSCredential = ContextManagerFactory.getInstance().getServerCredential();
                    this.serverId = this.getAccessId(wSCredential);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("serverId is set to: " + this.serverId));
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"164", (Object)this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)"failed to form serverId");
                }
            }
            this.groupSub = WCCMHelper.createGroup(GROUP, GROUP);
            this.userSub = WCCMHelper.createUser(USER, USER);
            try {
                wSCredential = RoleBasedConfiguratorFactory.getConfigurator();
                this.adminAuthorizer = wSCredential.getRoleBasedAuthorizer("admin-authz", "domain");
            }
            catch (RoleBasedAppException roleBasedAppException) {
                FFDCFilter.processException((Throwable)roleBasedAppException, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"180", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"failed to initialize RoleBasedAuthorizer");
            }
        }
        isAccessManagerCreated = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public static Boolean isIgnoreCase() {
        if (!isAccessManagerCreated) {
            return new Boolean(true);
        }
        return new Boolean(ignoreCase);
    }

    public static void setAccessIdsFilled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAccessIdsFilled");
        }
        filledAccessIDs = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAccessIdsFilled");
        }
    }

    public static AuthorizationTable getAdminAppAuthorizationTable() {
        return adminAppAuthTable;
    }

    public static Enumeration getAuthorizationTables() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthorizationTables");
        }
        Enumeration enumeration = authzTableMap.elements();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAuthorizationTables", enumeration);
        }
        return enumeration;
    }

    public static AuthorizationTable getAuthorizationTable(String string) {
        return (AuthorizationTable)authzTableMap.get(string);
    }

    public static void removeAuthorizationTable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAuthorizationTable", (Object)string);
        }
        authzTableMap.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAuthorizationTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAuthorizationTable(String string, AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAuthorizationTable", (Object)new Object[]{string, authorizationTable});
        }
        Hashtable hashtable = authzTableMap;
        synchronized (hashtable) {
            int n = string.lastIndexOf("_");
            String string2 = null;
            string2 = n != -1 ? string.substring(0, n) : string;
            if (authorizationTable != null) {
                if (string2.equals(ADMINAPP)) {
                    adminAppAuthTable = authorizationTable;
                }
                authzTableMap.put(string, authorizationTable);
                WSAccessManager.fillMissingAccessIds(authorizationTable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAuthorizationTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeContextID(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeContextID", (Object)new Object[]{string, string2});
        }
        Hashtable hashtable = contextIDTable;
        synchronized (hashtable) {
            if (string2 != null) {
                contextIDTable.put(string, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeContextID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContextID(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeContextID", (Object)string);
        }
        Hashtable hashtable = contextIDTable;
        synchronized (hashtable) {
            contextIDTable.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeContextID");
        }
    }

    public static String getContextID(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getContextID", (Object)string);
        }
        String string2 = (String)contextIDTable.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getContextID", (Object)string2);
        }
        return string2;
    }

    public static boolean checkIfAdminApp(String string) {
        return adminapps != null && adminapps.contains(string);
    }

    public abstract SecurityRole[] getRequiredRoles(AccessContext var1, String var2, String var3);

    public abstract boolean allowIfNoRequiredRoles();

    public abstract boolean isExcluded(AccessContext var1, String var2, String var3);

    public void checkAccess(AccessContext accessContext, Object object, Object object2, Principal principal) throws AccessException {
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAccess", (Object)new Object[]{accessContext, object, object2, principal});
        }
        String string = (String)object;
        String string2 = (String)object2;
        javax.security.auth.Subject subject = null;
        if (principal != null) {
            subject = ((WSPrincipal)principal).getSubject();
        }
        SecurityRole[] securityRoleArray = this.getRequiredRoles(accessContext, string, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Required Roles", (Object)securityRoleArray);
        }
        if (securityRoleArray == null) {
            throw new AccessException("Null required roles");
        }
        if (this.isExcluded(accessContext, string, string2)) {
            String string3 = string + ":" + string2 + " is excluded";
            throw new AccessException(string3);
        }
        if (securityRoleArray == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty required roles list defined in Authorization Constraint for the web applicaiton in the DD");
            }
            throw new AccessException("Empty required roles list defined in Authorization Constraint");
        }
        if (securityRoleArray == PermissionRoleMap.NO_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no required roles declared in the DD");
            }
            if (!this.allowIfNoRequiredRoles()) {
                throw new AccessException("No required roles defined");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAccess");
            }
            return;
        }
        if (accessContext != null && WSAccessManager.checkIfAdminApp(accessContext.getEnterpriseAppName())) {
            object3 = this.getNamesFromRoles(securityRoleArray);
            if (this.adminAuthorizer.isGrantedRole((String[])object3, subject)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAccess");
                }
                return;
            }
        } else {
            if (this.isEveryoneGranted(accessContext, securityRoleArray)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAccess");
                }
                return;
            }
            if (this.isGrantedAnyRole(accessContext, securityRoleArray, subject)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAccess");
                }
                return;
            }
        }
        object3 = new StringBuffer(128);
        ((StringBuffer)object3).append(((Object)principal).toString());
        ((StringBuffer)object3).append(" is not granted any of the required roles: ");
        int n = securityRoleArray.length;
        for (int i = 0; i < n; ++i) {
            ((StringBuffer)object3).append(securityRoleArray[i].getRoleName()).append(" ");
        }
        String string4 = ((StringBuffer)object3).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)string4);
        }
        throw new AccessException(string4);
    }

    public boolean isGrantedRole(AccessContext accessContext, SecurityRole securityRole, Principal principal) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedRole", (Object)new Object[]{accessContext, securityRole, principal});
        }
        javax.security.auth.Subject subject = principal != null ? ((WSPrincipal)principal).getSubject() : null;
        String string = accessContext != null ? accessContext.getEnterpriseAppName() : null;
        boolean bl = accessContext != null ? WSAccessManager.checkIfAdminApp(string) : false;
        boolean bl2 = false;
        if (bl) {
            String[] stringArray = new String[]{securityRole.getRoleName()};
            bl2 = this.adminAuthorizer.isGrantedRole(stringArray, subject);
        } else {
            bl2 = this.isGrantedRole(accessContext, WSAccessManager.getAuthorizationTable(string), securityRole, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedRole", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    protected boolean isGrantedRole(AccessContext accessContext, AuthorizationTable authorizationTable, SecurityRole securityRole, javax.security.auth.Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedRole", (Object)new Object[]{accessContext, authorizationTable, securityRole, WSAccessManager.subjectToString(subject)});
        }
        boolean bl = false;
        if (this.pluggableAuthTable != null) {
            bl = this.pluggableAuthTable.isGrantedRole(accessContext, securityRole, subject);
        } else if (authorizationTable != null) {
            SecurityRole[] securityRoleArray = new SecurityRole[]{securityRole};
            if (this.isEveryoneGranted(accessContext, securityRoleArray)) {
                bl = true;
            } else if (this.isGrantedAnyRole(accessContext, securityRoleArray, subject)) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isEveryoneGranted(AccessContext accessContext, SecurityRole[] securityRoleArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Object[]{accessContext, securityRoleArray});
        }
        boolean bl = false;
        if (securityRoleArray == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty required roles list from web application DD");
            }
        } else if (this.pluggableAuthTable != null) {
            bl = this.pluggableAuthTable.isEveryoneGranted(accessContext, securityRoleArray);
        } else {
            AuthorizationTable authorizationTable = WSAccessManager.getAuthorizationTable(accessContext.getEnterpriseAppName());
            bl = this.isSpecialSubjectGrantedAnyRole(authorizationTable, securityRoleArray, (SpecialSubject)Constants.EVERYONE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean isServerId(String string) {
        return string != null && string.equalsIgnoreCase(this.serverId);
    }

    public boolean isGrantedAnyRole(AccessContext accessContext, SecurityRole[] securityRoleArray, javax.security.auth.Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Object[]{accessContext, securityRoleArray, WSAccessManager.subjectToString(subject)});
        }
        String string = accessContext != null ? accessContext.getEnterpriseAppName() : null;
        boolean bl = accessContext != null ? WSAccessManager.checkIfAdminApp(string) : false;
        boolean bl2 = false;
        if (securityRoleArray == PermissionRoleMap.EMPTY_REQUIRED_ROLES) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Empty required roles list from web application DD");
            }
        } else if (bl) {
            String[] stringArray = this.getNamesFromRoles(securityRoleArray);
            bl2 = this.adminAuthorizer.isGrantedRole(stringArray, subject);
        } else if (this.pluggableAuthTable != null) {
            bl2 = this.pluggableAuthTable.isGrantedAnyRole(accessContext, securityRoleArray, subject);
        } else {
            AuthorizationTable authorizationTable = WSAccessManager.getAuthorizationTable(string);
            bl2 = this.isGrantedAnyRole(authorizationTable, securityRoleArray, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    private boolean isGrantedAnyRole(AuthorizationTable authorizationTable, SecurityRole[] securityRoleArray, javax.security.auth.Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Object[]{authorizationTable, securityRoleArray, WSAccessManager.subjectToString(subject)});
        }
        boolean bl = false;
        javax.security.auth.Subject subject2 = this.getAuthenticatedSubject(subject);
        if (subject2 != null) {
            if (this.isSpecialSubjectGrantedAnyRole(authorizationTable, securityRoleArray, (SpecialSubject)Constants.ALL_AUTHENTICATED_USERS)) {
                bl = true;
            } else {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject2);
                String string = this.getAccessId(wSCredential);
                if (this.isServerId(string) && this.isSpecialSubjectGrantedAnyRole(authorizationTable, securityRoleArray, (SpecialSubject)Constants.SERVER)) {
                    bl = true;
                } else if (this.isGrantedAnyRole(authorizationTable, securityRoleArray, wSCredential)) {
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean isSpecialSubjectGrantedAnyRole(AuthorizationTable authorizationTable, SecurityRole[] securityRoleArray, SpecialSubject specialSubject) {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSpecialSubjectGrantedAnyRole", (Object)new Object[]{authorizationTable, securityRoleArray, specialSubject});
        }
        boolean bl = false;
        if (authorizationTable != null && (list = authorizationTable.getRolesForSubject((Subject)specialSubject)) != null) {
            for (int i = 0; i < securityRoleArray.length; ++i) {
                if (!list.contains(securityRoleArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSpecialSubjectGrantedAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGrantedAnyRole(AuthorizationTable authorizationTable, SecurityRole[] securityRoleArray, WSCredential wSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Object[]{authorizationTable, securityRoleArray, wSCredential});
        }
        boolean bl = false;
        if (authorizationTable != null) {
            String string = this.getAccessId(wSCredential);
            List list = null;
            User user = this.userSub;
            synchronized (user) {
                this.userSub.setAccessId(string);
                this.userSub.setName(string);
                list = authorizationTable.getRolesForSubject((Subject)this.userSub);
            }
            for (int i = 0; list != null && i < securityRoleArray.length; ++i) {
                if (!list.contains(securityRoleArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                String[] stringArray = this.getGroupIds(wSCredential);
                block7: for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    Group group = this.groupSub;
                    synchronized (group) {
                        this.groupSub.setAccessId(stringArray[i]);
                        this.groupSub.setName(stringArray[i]);
                        list = authorizationTable.getRolesForSubject((Subject)this.groupSub);
                    }
                    for (int j = 0; list != null && j < securityRoleArray.length; ++j) {
                        if (!list.contains(securityRoleArray[j])) continue;
                        bl = true;
                        continue block7;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    private javax.security.auth.Subject getAuthenticatedSubject(javax.security.auth.Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthenticatedSubject", (Object)WSAccessManager.subjectToString(subject));
        }
        javax.security.auth.Subject subject2 = null;
        final WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((javax.security.auth.Subject)subject);
        if (wSCredential == null || wSCredential.isUnauthenticated()) {
            subject2 = null;
        } else if (wSCredential.isBasicAuth()) {
            try {
                subject2 = (javax.security.auth.Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException {
                        return contextManager.login(wSCredential);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.core.WSAccessManager.getAuthenticatedSubject", (String)"805", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("authentication failed:" + privilegedActionException.getException()));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.getAuthenticatedSubject", (String)"810", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("authentication failed:" + exception));
                }
                subject2 = null;
            }
        } else {
            subject2 = subject;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAuthenticatedSubject", (Object)WSAccessManager.subjectToString(subject2));
        }
        return subject2;
    }

    private String[] getNamesFromRoles(SecurityRole[] securityRoleArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNamesFromRoles", (Object)securityRoleArray);
        }
        String[] stringArray = new String[securityRoleArray == null ? 0 : securityRoleArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = securityRoleArray[i].getRoleName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNamesFromRoles", (Object)stringArray);
        }
        return stringArray;
    }

    protected static synchronized void fillAccessIds() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fillAccessIds");
        }
        Collection collection = authzTableMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AuthorizationTable authorizationTable = (AuthorizationTable)iterator.next();
            WSAccessManager.fillMissingAccessIds(authorizationTable);
        }
        WSAccessManager.setAccessIdsFilled();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fillAccessIds");
        }
    }

    protected static void fillMissingAccessIds(AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fillMissingAccessIds", (Object)authorizationTable);
        }
        try {
            if (registry == null) {
                if (contextManager == null) {
                    return;
                }
                registry = contextManager.getRegistry(contextManager.getDefaultRealm());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", (String)"888");
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanage.get.reg", (Object)new Object[]{exception});
        }
        Iterator iterator = authorizationTable.getAuthorizations().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Object object;
            RoleAssignment roleAssignment = (RoleAssignment)iterator.next();
            EList eList = roleAssignment.getSpecialSubjects();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                object = (SpecialSubject)eList.get(i);
                string2 = object.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SpecialSubject " + string2));
                }
                if ((string = object.getAccessId()) != null && string.length() != 0) continue;
                object.setAccessId(string2);
            }
            Iterator iterator2 = roleAssignment.getUsers().iterator();
            while (iterator2.hasNext()) {
                object = (User)iterator2.next();
                string2 = object.getAccessId();
                if (string2 != null && isLDAPRegistry) {
                    string2 = RegistryUtil.removeDNSpace(string2, -1);
                }
                if (string2 == null || string2.length() == 0) {
                    try {
                        string2 = registry.getUniqueUserId(object.getName());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", (String)"937");
                    }
                }
                if (string2 != null && ignoreCase) {
                    string2 = string2.toLowerCase();
                }
                if (string2 != null && string2.length() > 0) {
                    object.setAccessId(string2);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("user accessId=" + string2));
            }
            object = roleAssignment.getGroups().iterator();
            while (object.hasNext()) {
                string2 = (Group)object.next();
                string = string2.getAccessId();
                if (string != null && isLDAPRegistry) {
                    string = RegistryUtil.removeDNSpace(string, -1);
                }
                if (string == null || string.length() == 0) {
                    try {
                        string = registry.getUniqueGroupId(string2.getName());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.fillMissingAccessIds", (String)"973");
                    }
                }
                if (string != null && ignoreCase) {
                    string = string.toLowerCase();
                }
                if (string != null && string.length() > 0) {
                    string2.setAccessId(string);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("group accessId=" + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fillMissingAccessIds");
        }
    }

    private String getAccessId(WSCredential wSCredential) {
        String string;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAccessId");
            }
            string = null;
            try {
                string = wSCredential.getAccessId();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.getAccessId", (String)"1012", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"getAccessId raised exception", (Object)exception);
            }
        }
        if (string != null && string.length() > 0 && ignoreCase) {
            string = string.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAccessId", (Object)string);
        }
        return string;
    }

    private String[] getGroupIds(WSCredential wSCredential) {
        String[] stringArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getGroupsIds", (Object)wSCredential);
            }
            stringArray = null;
            try {
                ArrayList arrayList = wSCredential.getGroupIds();
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.getGroupIds", (String)"1045", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"getAccessId raised exception", (Object)exception);
            }
        }
        if (ignoreCase) {
            int n = stringArray == null ? 0 : stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringArray[i].toLowerCase();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsIds", (Object)stringArray);
        }
        return stringArray;
    }

    private static String subjectToString(javax.security.auth.Subject subject) {
        String string = null;
        final javax.security.auth.Subject subject2 = subject;
        if (subject != null) {
            try {
                string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException {
                        return subject2.toString();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static {
        filledAccessIDs = false;
        contextManager = null;
        adminapps = null;
    }
}

