/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.init.J2EEInit;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.SecurityCookie;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.Identity;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.authorize.WSPolicyContextHandlerImpl;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.SecurityCookieImpl;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.ejb.BeanAccessContext;
import com.ibm.ws.security.ejb.BeanAccessManager;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.ws.security.ejb.BeanPermissionRoleMapTable;
import com.ibm.ws.security.ejb.EJBInitializer;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.ejb.EnterpriseBean;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

public abstract class SecurityCollaborator
implements com.ibm.websphere.csi.SecurityCollaborator,
EJBInitializer {
    private static TraceComponent tc = Tr.register((Class)SecurityCollaborator.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    protected static final String HOME = "Home";
    protected static final String BEAN = "Bean";
    protected static final String FIND = "find";
    protected static final String EJB_FIND = "ejbFind";
    protected static final String CREATE = "create";
    protected static final String EJB_CREATE = "ejbCreate";
    protected static final String REMOVE = "remove";
    protected static final String EJB_REMOVE = "ejbRemove";
    protected static final String GET_META_DATA = "getEJBMetaData";
    protected static final String EJB_GET_META_DATA = "ejbGetEJBMetaData";
    protected static ContextManager contextManager = ContextManagerFactory.getInstance();
    protected static boolean securityEnabled = false;
    private static Object _lockObject = new Object();
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int GROUPID = 2;
    protected static EJBJar ejbjar;
    protected static BeanPermissionRoleMapTable beanPermissionRoleMapTable;
    protected static AccessManager beanAccessManager;
    protected static RunAsMapTable runAsMapTbl;
    private static final WebSphereRuntimePermission runAsPerm;
    private static AuditHandlerImpl auditHandler;
    private static J2EEAuditEventFactory auditFactory;
    private static String providerName;
    private static final boolean providerSuccess = true;
    private static String[] jaccHandlerKeyArray;
    private static WSPolicyContextHandlerImpl wpch;
    protected Hashtable metadataMap = new Hashtable();

    public static RunAsMapTable getRunAsMapTable() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunAsMapTable");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)runAsPerm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunAsMapTable", (Object)new Boolean(runAsMapTbl == null));
        }
        return runAsMapTbl;
    }

    public static Subject getSubject(String string, String string2) throws LoginException, WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject");
        }
        Subject subject = null;
        try {
            subject = contextManager.login(contextManager.getDefaultRealm(), string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.getSubject", (String)"217");
            Tr.debug((TraceComponent)tc, (String)"getSubject() exception occurred: ", (Object)new Object[]{exception});
            subject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject");
        }
        return subject;
    }

    public SecurityCollaborator() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public static void initialize() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        securityEnabled = SecurityContext.isSecurityEnabled();
        J2EEInit.init();
        runAsMapTbl = new RunAsMapTable();
        beanPermissionRoleMapTable = new BeanPermissionRoleMapTable();
        beanAccessManager = new BeanAccessManager();
        AuditServiceImpl auditServiceImpl = (AuditServiceImpl)AuditServiceImpl.getAuditService();
        if (auditServiceImpl != null) {
            Class<?> clazz;
            auditHandler = (AuditHandlerImpl)auditServiceImpl.newAuditHandler("WAS.security", "WAS.security");
            if (auditHandler != null) {
                auditFactory = (J2EEAuditEventFactory)auditHandler.getAuditEventFactory("J2EE");
            }
            if (auditFactory != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                auditFactory = null;
            }
        }
        if (SecurityConfig.isJACCEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting the PolicyContextHandlers for JACC.");
            }
            jaccHandlerKeyArray = new String[]{"javax.security.auth.Subject.container", "javax.ejb.EnterpriseBean", "javax.ejb.arguments", "javax.xml.soap.SOAPMessage"};
            wpch = WSPolicyContextHandlerImpl.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public CollaboratorCookie installBean(EJBConfigData eJBConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"installBean");
        }
        String string = eJBConfigData.getJ2EEName().getApplication();
        String string2 = eJBConfigData.getJ2EEName().getModule();
        String string3 = eJBConfigData.getJ2EEName().getComponent();
        SecurityBeanCookie securityBeanCookie = new SecurityBeanCookie(string3, string, string2);
        securityBeanCookie.setEjbJar(eJBConfigData.getEJBJarDeploymentData());
        securityBeanCookie.setRoleRefList(securityBeanCookie.getBeanName(), eJBConfigData.getEJBJarDeploymentData());
        securityBeanCookie.setRunAsSettings(eJBConfigData.getDeploymentExtn());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"installBean");
        }
        return securityBeanCookie;
    }

    public void setRunAsMap(String string, ApplicationBinding applicationBinding) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRunAsMap");
        }
        RunAsMapTable.addRunAsMap(string, applicationBinding.getRunAsMap());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRunAsMap");
        }
    }

    public abstract CollaboratorCookie preInvoke(EJBKey var1, EJBMethodInfo var2, CollaboratorCookie var3) throws CSIException;

    public abstract CollaboratorCookie preInvoke(EJBKey var1, EJBMethodInfo var2, CollaboratorCookie var3, EnterpriseBean var4, Object[] var5) throws CSIException;

    protected Subject[] performAuthorization(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, Subject subject, Subject subject2, SecurityBeanCookie securityBeanCookie, EnterpriseBean enterpriseBean, Object[] objectArray) throws CSIException {
        Exception exception;
        boolean bl;
        Subject subject3;
        String string;
        String string2;
        boolean bl2;
        String string3;
        Subject subject4;
        block27: {
            Exception exception2;
            block26: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"performAuthorization");
                }
                subject4 = null;
                string3 = eJBMethodInfo.getHomeName();
                bl2 = eJBMethodInfo.isHome();
                string2 = securityBeanCookie.getAppName() + ":" + securityBeanCookie.getModuleName() + ":" + securityBeanCookie.getBeanName();
                String string4 = eJBMethodInfo.getMethodSignature();
                string = SecurityCollaborator.getMethodWithSignature(eJBMethodInfo.getMethodName(), string4);
                int n = eJBMethodInfo.getInterfaceType().getValue();
                if (auditHandler != null) {
                    auditHandler.setAppName(securityBeanCookie.getAppName());
                }
                string = string + ":" + n;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("methodInfo.getMethodName() : " + string));
                    Tr.debug((TraceComponent)tc, (String)("methodInfo.getHomeName() : " + string3));
                    Tr.debug((TraceComponent)tc, (String)("methodInfo.isHome(): " + bl2));
                    Tr.debug((TraceComponent)tc, (String)("methodInfo.getMethodSignature = " + eJBMethodInfo.getMethodSignature()));
                }
                exception2 = null;
                try {
                    subject4 = contextManager.getInvocationSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("invokedSubject is null: " + (subject4 == null)));
                        Tr.debug((TraceComponent)tc, (String)("receivedSubject is null: " + (subject2 == null)));
                    }
                }
                catch (Exception exception3) {
                    FFDCFilter.processException((Throwable)exception3, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"404", (Object)this);
                    exception2 = exception3;
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug((TraceComponent)tc, (String)"Invalid.credential.type");
                }
            }
            if (exception2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"performAuthorization", (Object)exception2);
                }
                String string5 = bl2 ? HOME : BEAN;
                throw new CSIAccessException(Constants.nls.getFormattedMessage("security.authz.failed.invalidcreds", new Object[]{string5, string3, string}, "Authorization.failed.while.invoking.({0}){1}.{2} - invalid.credentials"), (Throwable)exception2);
            }
            subject3 = subject4 == null ? subject2 : subject4;
            bl = false;
            exception = null;
            try {
                if (!this.internalUnprotected(string)) {
                    if (!SecurityConfig.isJACCEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Calling ejbCheckAuthorization");
                        }
                        this.ejbCheckAuthorization(string2, string, subject3, securityBeanCookie);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Calling ejbCheckAuthorization for JACC");
                        }
                        providerName = "JACC";
                        this.ejbCheckAuthorizationForJACC(string, subject3, securityBeanCookie, eJBMethodInfo, enterpriseBean, objectArray);
                    }
                }
                bl = true;
            }
            catch (Exception exception4) {
                bl = false;
                FFDCFilter.processException((Throwable)exception4, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"450", (Object)this);
                exception = exception4;
                if (!tc.isDebugEnabled()) break block27;
                Tr.debug((TraceComponent)tc, (String)"Authorization failed accessing EJB ", (Object)exception4);
            }
        }
        if (!bl) {
            String string6;
            String string7 = "???";
            String string8 = string6 = bl2 ? HOME : BEAN;
            if (subject3 != null) {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject3);
                try {
                    string7 = wSCredential.getRealmSecurityName();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"471", (Object)this);
                    throw new CSIAccessException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
                }
            }
            Tr.audit((TraceComponent)tc, (String)"security.authz.failed.foruser", (Object)new Object[]{string7, string6, string3, string, exception.getMessage()});
            if (auditFactory != null && auditFactory.isActive(1, 4)) {
                auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, string2, "EJB", string, providerName, true, subject2, "security.audit.authz.denied.audit", null);
            }
            throw new CSIAccessException(Constants.nls.getFormattedMessage("security.authz.failed.foruser", new Object[]{string7, string6, string3, string, exception.getMessage()}, "Authorization.failed.for.{0}.while.invoking.({1}){2}.{3}: {4}"));
        }
        Subject[] subjectArray = null;
        if (subject2 != null || subject4 != null) {
            subjectArray = new Subject[]{subject2, subject4};
        }
        if (tc.isDebugEnabled()) {
            if (null == subject2) {
                Tr.debug((TraceComponent)tc, (String)"NULL receivedCred");
            }
            if (null == subject4) {
                Tr.debug((TraceComponent)tc, (String)"NULL invokedCred");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performAuthorization");
        }
        if (auditFactory != null && auditFactory.isActive(1, 0)) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, string2, "EJB", string, providerName, true, subject2, "security.audit.authz.success.audit", null);
        }
        return subjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ejbCheckAuthorizationForJACC(String string, Subject subject, SecurityBeanCookie securityBeanCookie, EJBMethodInfo eJBMethodInfo, EnterpriseBean enterpriseBean, Object[] objectArray) throws Exception {
        block23: {
            String string2;
            String string3;
            block22: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"ejbCheckAuthorizationForJACC");
                }
                string3 = securityBeanCookie.getAppName();
                string2 = securityBeanCookie.getBeanName();
                if (!this.isAdminApp(string3)) break block22;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Calling default authorization for admin Application " + string3));
                }
                this.ejbCheckAuthorization(string2, string, subject, securityBeanCookie);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ejbCheckAuthorizationForJACC");
                }
                break block23;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bean instance = " + enterpriseBean));
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Tr.debug((TraceComponent)tc, (String)("methodParameter[" + i + "] = " + objectArray[i]));
                    }
                }
            }
            Object var9_10 = null;
            boolean bl = false;
            try {
                Object object;
                String string4;
                int n;
                String string5 = eJBMethodInfo.getInterfaceType().toString();
                String string6 = eJBMethodInfo.getMethodSignature();
                String string7 = securityBeanCookie.getModuleName();
                String string8 = eJBMethodInfo.getMethodName();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string6 != null && string6.length() > 0 && (n = string6.indexOf(":")) != -1 && (string4 = string6.substring(n + 1)) != null && string4.length() > 0) {
                    object = new StringTokenizer(string4, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        arrayList.add(((StringTokenizer)object).nextToken());
                    }
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("jaccBeanName: " + string2));
                    Tr.debug((TraceComponent)tc, (String)("jaccAppName: " + string3));
                    Tr.debug((TraceComponent)tc, (String)("jaccModuleName: " + string7));
                    Tr.debug((TraceComponent)tc, (String)("jaccMethodName: " + string8));
                    Tr.debug((TraceComponent)tc, (String)("jaccInterfaceName: " + string5));
                }
                string4 = new EJBMethodPermission(string2, string8, string5, stringArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("EJBMethodPermission = " + string4));
                }
                if ((object = new StringBuffer(WSAccessManager.getContextID(string3))) == null) {
                    throw new CSIAccessException("Cannot get the contextID for application: " + string3);
                }
                ((StringBuffer)object).append("/").append(string7);
                final String string9 = ((StringBuffer)object).toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contextID: " + string9));
                }
                final HashMap hashMap = new HashMap();
                final Subject subject2 = subject;
                final EnterpriseBean enterpriseBean2 = enterpriseBean;
                final Object[] objectArray2 = objectArray;
                Boolean bl2 = new Boolean(false);
                bl2 = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((EJBMethodPermission)string4){
                    private final /* synthetic */ EJBMethodPermission val$ejbPerm;
                    {
                        this.val$ejbPerm = eJBMethodPermission;
                    }

                    public Object run() throws PolicyContextException {
                        Principal[] principalArray;
                        PolicyContext.setContextID((String)string9);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers");
                        }
                        for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                            PolicyContext.registerHandler((String)jaccHandlerKeyArray[i], (PolicyContextHandler)wpch, (boolean)true);
                        }
                        hashMap.put(jaccHandlerKeyArray[0], subject2);
                        hashMap.put(jaccHandlerKeyArray[1], enterpriseBean2);
                        hashMap.put(jaccHandlerKeyArray[2], objectArray2);
                        ProtectionDomain protectionDomain = null;
                        if (subject2 != null && subject2.getPrincipals().size() > 0) {
                            principalArray = subject2.getPrincipals().toArray(new Principal[subject2.getPrincipals().size()]);
                            protectionDomain = new ProtectionDomain(SecurityConfig.getNullCodeSource(), null, null, principalArray);
                        } else {
                            protectionDomain = SecurityConfig.getNullProtectionDomain();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data");
                        }
                        PolicyContext.setHandlerData((Object)hashMap);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Calling JACC implies");
                        }
                        principalArray = new Boolean(Policy.getPolicy().implies(protectionDomain, (Permission)this.val$ejbPerm));
                        return principalArray;
                    }
                });
                bl = bl2;
                Object var26_27 = null;
            }
            catch (Throwable throwable) {
                Object var26_28 = null;
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() {
                            PolicyContext.setHandlerData(null);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"659", (Object)this);
                }
                throw throwable;
            }
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"659", (Object)this);
            }
            if (!bl) {
                Tr.debug((TraceComponent)tc, (String)"hasJaccAccess is false");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("ejbCheckAuthorizationForJACC is false for Bean: " + string2));
                }
                throw new AccessException("JACC Authorization failed for bean: " + string2);
            }
            Tr.debug((TraceComponent)tc, (String)"hasJaccAccess is true");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("ejbCheckAuthorizationForJACC is true for bean: " + string2));
            }
        }
    }

    protected boolean isUnprotected(String string) {
        return false;
    }

    protected String resolveHomeMethod(String string) {
        if (string.equals(CREATE)) {
            string = EJB_CREATE;
        } else if (string.equals(REMOVE)) {
            string = EJB_REMOVE;
        } else if (string.equals(GET_META_DATA)) {
            string = EJB_GET_META_DATA;
        }
        return string;
    }

    protected String resolveBeanMethod(String string) {
        if (string.equals(REMOVE)) {
            string = EJB_REMOVE;
        }
        return string;
    }

    private boolean internalUnprotected(String string) {
        boolean bl = false;
        if (string != null && string.startsWith("ejbTimeout(javax.ejb.Timer)")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ejbTimeout(javax.ejb.Timer) is excluded from authorization checking, EJB spec section 22.2.2.");
            }
            bl = true;
        }
        return bl;
    }

    public void postInvokeCommon(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, SecurityCookie securityCookie, CollaboratorCookie collaboratorCookie) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postInvoke");
        }
        if (securityCookie != null) {
            try {
                Subject[] subjectArray = ((SecurityCookieImpl)securityCookie).subjects;
                if (subjectArray != null) {
                    Subject subject = contextManager.getCallerSubject();
                    if (subject != null) {
                        subject = subjectArray[0];
                        contextManager.setCallerSubject(subject);
                    }
                    if (subjectArray.length > 1) {
                        contextManager.setInvocationSubject(subjectArray[1]);
                    }
                }
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.core.SecurityCollaborator.postInvokeCommon", (String)"797", (Object)this);
                throw new CSIAccessException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postInvoke");
        }
    }

    public Principal getCallerPrincipal(CollaboratorCookie collaboratorCookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCallerPrincipal", (Object)collaboratorCookie);
        }
        if (securityEnabled) {
            String string;
            block29: {
                String string2 = SecurityContext.getCallerName();
                string = null;
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    try {
                        Object object;
                        String string3 = null;
                        Subject subject = contextManager.getCallerSubject();
                        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                        if (wSCredential != null) {
                            try {
                                object = wSCredential;
                                string3 = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)object){
                                    private final /* synthetic */ WSCredential val$privCred;
                                    {
                                        this.val$privCred = wSCredential;
                                    }

                                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                        return this.val$privCred.get("com.ibm.wsspi.security.token.caller_principal_class");
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.SecurityCollaborator", (String)"853", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Exception getting CallerPrincipalClass : ", (Object)new Object[]{privilegedActionException.getException()});
                                }
                                string3 = null;
                            }
                        }
                        if (string3 == null || string3.equals("com.ibm.websphere.security.auth.WSPrincipal")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"requested principal class is null or defaulted");
                            }
                            string2 = SecurityContext.getCallerName();
                            boolean bl = false;
                            Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.FullyQualifiedUserName");
                            bl = bl2;
                            if (bl) {
                                String string4 = RealmSecurityName.getRealm((String)(string2 = SecurityContext.unqualifySecurityName((String)string2)));
                                if (string4 == null || string4.length() < 1) {
                                    string4 = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                                }
                                string = RealmSecurityName.getRealmSecurityName((String)string4, (String)string2);
                            } else {
                                string = SecurityContext.unqualifySecurityName((String)string2);
                            }
                        } else if (string3.equals("com.ibm.ws.security.zos.Principal")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"requested principal class is z/OS");
                            }
                            if ((object = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential")) != null) {
                                string = ((PlatformCredential)object).getUserId();
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("requested principal class is custom: " + string3));
                            }
                            if ((object = subject.getPrincipals(Class.forName(string3))) != null && object.size() > 0) {
                                string = ((Principal)object.iterator().next()).getName();
                            }
                        }
                        break block29;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"caught exception in getCallerPrincipal", (Object)exception);
                        }
                        break block29;
                    }
                }
                boolean bl = false;
                Boolean bl3 = (Boolean)SecurityConfig.getConfig().getValue("security.FullyQualifiedUserName");
                bl = bl3;
                if (bl) {
                    String string5 = RealmSecurityName.getRealm((String)(string2 = SecurityContext.unqualifySecurityName((String)string2)));
                    if (string5 == null || string5.length() < 1) {
                        string5 = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                    }
                    string = RealmSecurityName.getRealmSecurityName((String)string5, (String)string2);
                } else {
                    string = SecurityContext.unqualifySecurityName((String)string2);
                }
            }
            if (string != null) {
                if (!contextManager.getPlatformHelper().isZOS()) {
                    return new Identity(string);
                }
                return new Identity(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SecurityCollaborator  getCallerPrincipal");
        }
        if (!contextManager.getPlatformHelper().isZOS()) {
            return new Identity(ContextManagerFactory.getInstance().getUnauthenticatedString());
        }
        return new Identity("UNAUTHENTICATED");
    }

    public boolean isCallerInRole(String string) {
        throw new RuntimeException("not implemented");
    }

    public boolean isCallerInRole(CollaboratorCookie collaboratorCookie, String string) {
        throw new RuntimeException("old isCallerInRole called");
    }

    public boolean isCallerInRole(CollaboratorCookie collaboratorCookie, String string, Subject subject) {
        BeanPermissionRoleMap beanPermissionRoleMap;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCallerInRole");
        }
        boolean bl = false;
        SecurityBeanCookie securityBeanCookie = (SecurityBeanCookie)collaboratorCookie;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Calling getBeanPermissionRoleMap");
        }
        if ((string2 = (beanPermissionRoleMap = beanPermissionRoleMapTable.getBeanPermissionRoleMap(securityBeanCookie.getAppName() + ":" + securityBeanCookie.getModuleName())).getMappedRole(string, securityBeanCookie)) == null) {
            Tr.error((TraceComponent)tc, (String)"security.roleref.configerror", (Object)new Object[]{string, securityBeanCookie.getBeanName(), securityBeanCookie.getModuleName(), securityBeanCookie.getAppName()});
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("role-ref =" + string));
                Tr.debug((TraceComponent)tc, (String)(" role-link =" + string2));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling createSecurityRole");
            }
            SecurityRole securityRole = WCCMHelper.createSecurityRole(null, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("New-up BeanAccessContext with " + securityBeanCookie.getAppName() + " null, null"));
            }
            BeanAccessContext beanAccessContext = new BeanAccessContext(securityBeanCookie.getAppName(), null, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling beanAccessManager.isGrantedRole");
            }
            bl = beanAccessManager.isGrantedRole(beanAccessContext, securityRole, new WSPrincipal(subject));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCallerInRole = " + bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCallerInRole");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isCallerInRole(CollaboratorCookie collaboratorCookie, String string, EnterpriseBean enterpriseBean, Object[] objectArray) {
        boolean bl;
        block37: {
            StringBuffer stringBuffer;
            EJBRoleRefPermission eJBRoleRefPermission;
            String string2;
            Subject subject;
            block35: {
                block34: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Trying to get the callerSubject.");
                    }
                    subject = null;
                    try {
                        subject = contextManager.getCallerSubject();
                    }
                    catch (WSSecurityException wSSecurityException) {
                        FFDCFilter.processException((Throwable)wSSecurityException, (String)(this.getClass().getName() + ".isCallerInRole"), (String)"1049", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Failed to get Caller Subject " + (Object)((Object)wSSecurityException)));
                            Tr.debug((TraceComponent)tc, (String)"Try using unauthenticated subject");
                        }
                        try {
                            subject = SubjectHelper.createUnauthenticatedSubject();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".isCallerInRole"), (String)"1062", (Object)this);
                            if (!tc.isDebugEnabled()) break block34;
                            Tr.debug((TraceComponent)tc, (String)("Fail to get unauthenticated subject: " + exception));
                        }
                    }
                }
                SecurityBeanCookie securityBeanCookie = (SecurityBeanCookie)collaboratorCookie;
                if (!SecurityConfig.isJACCEnabled() || this.isAdminApp(securityBeanCookie.getAppName())) {
                    return this.isCallerInRole(collaboratorCookie, string, subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"isCallerInRoleForJACC");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bean instance = " + enterpriseBean));
                    if (objectArray != null) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            Tr.debug((TraceComponent)tc, (String)("methodParameter[" + i + "] = " + objectArray[i]));
                        }
                    }
                }
                boolean bl2 = false;
                bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling JACC provider for isCallerInRole check.");
                }
                String string3 = securityBeanCookie.getBeanName();
                String string4 = securityBeanCookie.getAppName();
                string2 = securityBeanCookie.getModuleName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("jaccBeanName: " + string3));
                    Tr.debug((TraceComponent)tc, (String)("jaccAppName: " + string4));
                    Tr.debug((TraceComponent)tc, (String)("jaccModuleName: " + string2));
                    Tr.debug((TraceComponent)tc, (String)("roleRefName: " + string));
                }
                eJBRoleRefPermission = new EJBRoleRefPermission(string3, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("EJBRoleRefPermission: " + eJBRoleRefPermission));
                }
                if ((stringBuffer = new StringBuffer(WSAccessManager.getContextID(string4))) != null) break block35;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cannot get the contextID for application: " + string4 + ". Returning false."));
                }
                boolean bl3 = false;
                Object var21_20 = null;
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() {
                            PolicyContext.setHandlerData(null);
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"1192", (Object)this);
                }
                return bl3;
            }
            stringBuffer.append("/").append(string2);
            final String string5 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("contextID: " + string5));
            }
            final Subject subject2 = subject;
            final EnterpriseBean enterpriseBean2 = enterpriseBean;
            final Object[] objectArray2 = objectArray;
            final HashMap hashMap = new HashMap();
            Boolean bl4 = new Boolean(false);
            bl4 = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    Principal[] principalArray;
                    PolicyContext.setContextID((String)string5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler((String)jaccHandlerKeyArray[i], (PolicyContextHandler)wpch, (boolean)true);
                    }
                    hashMap.put(jaccHandlerKeyArray[0], subject2);
                    hashMap.put(jaccHandlerKeyArray[1], enterpriseBean2);
                    hashMap.put(jaccHandlerKeyArray[2], objectArray2);
                    ProtectionDomain protectionDomain = null;
                    if (subject2 != null && subject2.getPrincipals().size() > 0) {
                        principalArray = subject2.getPrincipals().toArray(new Principal[subject2.getPrincipals().size()]);
                        protectionDomain = new ProtectionDomain(SecurityConfig.getNullCodeSource(), null, null, principalArray);
                    } else {
                        protectionDomain = SecurityConfig.getNullProtectionDomain();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData((Object)hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Calling JACC implies");
                    }
                    principalArray = new Boolean(Policy.getPolicy().implies(protectionDomain, (Permission)eJBRoleRefPermission));
                    return principalArray;
                }
            });
            bl = bl4;
            Object var21_21 = null;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"1192", (Object)this);
            }
            break block37;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.isCallerInRole", (String)"1178", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.iscallerinrole.error", (Object)new Object[]{string, exception});
                    Object var21_22 = null;
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception2));
                        }
                        FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"1192", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", (String)"1192", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"jaccCallerInRole is true");
            } else {
                Tr.debug((TraceComponent)tc, (String)"jaccCallerInRole is false");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCallerInRoleForJACC", (Object)String.valueOf(bl));
        }
        return bl;
    }

    public java.security.Identity getCallerIdentity() {
        String string;
        if (securityEnabled && (string = SecurityContext.getCallerName()) != null) {
            return new Identity(string);
        }
        throw new RuntimeException("no identity");
    }

    public boolean isCallerInRole(java.security.Identity identity) {
        throw new RuntimeException("not implemented");
    }

    protected void ejbCheckAuthorization(String string, String string2, Subject subject, SecurityBeanCookie securityBeanCookie) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ejbCheckAuthorization");
        }
        Subject subject2 = subject;
        boolean bl = false;
        String string3 = securityBeanCookie.getAppName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AppName: " + string3));
        }
        EJBJar eJBJar = securityBeanCookie.getEjbJar();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Calling getBeanPermissionRoleMap with:\n       String: " + string3 + ":" + securityBeanCookie.getModuleName()));
        }
        BeanPermissionRoleMap beanPermissionRoleMap = beanPermissionRoleMapTable.getBeanPermissionRoleMap(securityBeanCookie.getAppName() + ":" + securityBeanCookie.getModuleName());
        if (tc.isDebugEnabled()) {
            if (null == beanPermissionRoleMap) {
                Tr.debug((TraceComponent)tc, (String)"Created a NULL BeanPermissionRoleMap .... new-up a BeanAccessContext");
            } else {
                Tr.debug((TraceComponent)tc, (String)"Created a not NULL BeanPermissionRoleMap .... new-up a BeanAccessContext");
            }
        }
        BeanAccessContext beanAccessContext = new BeanAccessContext(string3, beanPermissionRoleMap, eJBJar);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling beanAccessManager.checkAccess<>");
            }
            beanAccessManager.checkAccess(beanAccessContext, string, string2, new WSPrincipal(subject2));
            bl = true;
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, (String)"com.ibm.ws.security.core.SecurityCollaborator.ejbCheckAuthorization", (String)"1271", (Object)this);
            throw accessException;
        }
        if (bl && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BeanName=" + string));
            Tr.debug((TraceComponent)tc, (String)("MethodName=" + string2));
            Tr.debug((TraceComponent)tc, (String)("AccessAllowed " + bl));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ejbCheckAuthorization");
        }
    }

    protected void setSubjects(Subject subject, Subject subject2) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSubjects");
        }
        Exception exception = null;
        try {
            contextManager.setInvocationSubject(subject2);
        }
        catch (Exception exception2) {
            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.core.SecurityCollaborator.setSubjects", (String)"1302", (Object)this);
            exception = exception2;
        }
        if (exception != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setSubjects", (Object)exception);
            }
            throw new CSIAccessException(Constants.nls.getString("security.invalid.creds", "Invalid credentials"));
        }
        try {
            contextManager.setCallerSubject(subject);
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.core.SecurityCollaborator.setSubjects", (String)"1320", (Object)this);
            throw new CSIAccessException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSubjects");
        }
    }

    protected boolean isSystemPrincipal(Subject subject) {
        throw new RuntimeException("not implemented");
    }

    protected boolean SetUnauthenticatedSubjectIfNeeded(Subject subject, Subject subject2) {
        boolean bl;
        block6: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"SetUnauthenticatedSubjectIfNeeded");
            }
            if (subject == null && subject2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Invoked and received Subject are null, setting it anonymous/unauthenticated.");
                }
                try {
                    contextManager.setInvocationSubject(SubjectHelper.createUnauthenticatedSubject());
                    bl = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityCollaborator.SetUnauthenticatedSubjectIfNeeded", (String)"1351", (Object)this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("contextManager.setInvocationSubject() threw exception when setting SecInvocationSubject to unauthenticated." + exception));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SetUnauthenticatedSubjectIfNeeded:" + bl));
        }
        return bl;
    }

    public static String getMethodWithSignature(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMethodWithSignature");
        }
        String string3 = string;
        int n = string2.indexOf(":");
        if (n == -1) {
            return string3;
        }
        String string4 = string2.substring(n + 1);
        if (string4 == null) {
            return string3;
        }
        int n2 = 0;
        while ((n = string4.indexOf(32)) != -1 || (n = string4.length()) > 0) {
            string3 = n2 == 0 ? string3 + "(" + string4.substring(0, n) : string3 + "," + string4.substring(0, n);
            if (n == string4.length()) {
                ++n2;
                break;
            }
            string4 = string4.substring(n + 1);
            ++n2;
        }
        if (n2 > 0) {
            string3 = string3 + ")";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMethodWithSignature");
        }
        return string3;
    }

    protected static final SecurityCookie getCookie(Subject[] subjectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookie()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookie()");
        }
        return new SecurityCookieImpl(subjectArray);
    }

    protected static final SecurityCookie getCookie(Subject[] subjectArray, Object object, boolean bl) {
        return new SecurityCookieImpl(subjectArray, object, bl);
    }

    private boolean isAdminApp(String string) {
        return WSAccessManager.checkIfAdminApp(string);
    }

    static {
        runAsPerm = new WebSphereRuntimePermission("wssecurity.getRunAsMap");
        auditHandler = null;
        auditFactory = null;
        providerName = "WebSphere";
    }
}

