/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.SSLSecurityLevel;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.jaaslogin.JAASModuleControlFlag;
import com.ibm.websphere.models.config.jaaslogin.JaasloginFactory;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocolKind;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.QualityOfProtection;
import com.ibm.websphere.models.config.orb.securityprotocol.SecureAssociationService;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityProtocolConfig;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityprotocolFactory;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityprotocolPackage;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportQOP;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.CertificateMapMode;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.LDAPDirectoryType;
import com.ibm.websphere.models.config.security.LDAPSearchFilter;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SWAMAuthentication;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityFactory;
import com.ibm.websphere.models.config.security.SecurityPackage;
import com.ibm.websphere.models.config.security.SingleSignon;
import com.ibm.websphere.models.config.security.TAInterceptor;
import com.ibm.websphere.models.config.security.TrustAssociation;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.ws.security.core.AbstractConfigBuilder;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class SampleSecurityConfigBuilder
extends AbstractConfigBuilder {
    protected SecurityFactory securityFactory;
    protected PropertiesFactory propertiesFactory;
    protected SslFactory sslFactory;
    protected IpcFactory ipcFactory;
    protected JaasloginFactory lf;
    protected SecurityprotocolFactory secProFactory;

    public EList buildRootElements() {
        BasicEList basicEList = new BasicEList();
        System.out.println("buildRootElements");
        basicEList.add((Object)this.buildSampleSecurity());
        return basicEList;
    }

    public Security buildSampleSecurity() {
        System.out.println("buildSampleSecurity");
        Security security = this.securityFactory.createSecurity();
        security.setEnabled(false);
        security.setUseLocalSecurityServer(true);
        security.setUseDomainQualifiedUserNames(false);
        security.setIssuePermissionWarning(true);
        security.setCacheTimeout(600);
        security.setActiveProtocol(IIOPSecurityProtocolKind.BOTH_LITERAL);
        security.setEnforceJava2Security(false);
        SWAMAuthentication sWAMAuthentication = this.securityFactory.createSWAMAuthentication();
        sWAMAuthentication.setOID("No OID for this mechanism");
        sWAMAuthentication.setAuthConfig("system.SWAM");
        sWAMAuthentication.setSimpleAuthConfig("system.SWAM");
        sWAMAuthentication.setAuthValidationConfig("system.SWAM");
        sWAMAuthentication.setAuthContextImplClass("com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContext");
        security.getAuthMechanisms().add((Object)sWAMAuthentication);
        LTPA lTPA = this.securityFactory.createLTPA();
        lTPA.setOID("oid:1.3.18.0.2.30.2");
        lTPA.setAuthConfig("system.LTPA");
        lTPA.setSimpleAuthConfig("system.LTPA");
        lTPA.setAuthValidationConfig("system.LTPA");
        lTPA.setAuthContextImplClass("com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl");
        security.getAuthMechanisms().add((Object)sWAMAuthentication);
        TrustAssociation trustAssociation = this.securityFactory.createTrustAssociation();
        TAInterceptor tAInterceptor = this.securityFactory.createTAInterceptor();
        tAInterceptor.setInterceptorClassName("com.ibm.ws.security.web.WebSealTrustAssociationInterceptor");
        trustAssociation.getInterceptors().add((Object)tAInterceptor);
        trustAssociation.setEnabled(false);
        SingleSignon singleSignon = this.securityFactory.createSingleSignon();
        singleSignon.setRequiresSSL(false);
        singleSignon.setEnabled(true);
        singleSignon.setDomainName("");
        lTPA.setTrustAssociation(trustAssociation);
        lTPA.setPassword("");
        lTPA.setTimeout(120L);
        lTPA.setSingleSignon(singleSignon);
        security.getAuthMechanisms().add((Object)lTPA);
        security.setActiveAuthMechanism((AuthMechanism)sWAMAuthentication);
        System.out.println("added setActiveAuthMechanism");
        LocalOSUserRegistry localOSUserRegistry = this.securityFactory.createLocalOSUserRegistry();
        localOSUserRegistry.setServerId("");
        localOSUserRegistry.setServerPassword("");
        localOSUserRegistry.setRealm("");
        Resource resource = localOSUserRegistry.eResource();
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).setID((EObject)localOSUserRegistry, "LocalOSUserRegistry");
        }
        security.getUserRegistries().add((Object)localOSUserRegistry);
        CustomUserRegistry customUserRegistry = this.securityFactory.createCustomUserRegistry();
        customUserRegistry.setCustomRegistryClassName("com.ibm.websphere.security.FileRegistrySample");
        security.getUserRegistries().add((Object)customUserRegistry);
        LDAPUserRegistry lDAPUserRegistry = this.securityFactory.createLDAPUserRegistry();
        SecureSocketLayer secureSocketLayer = this.sslFactory.createSecureSocketLayer();
        secureSocketLayer.setKeyFileName("${USER_INSTALL_ROOT}/etc/DummyServerKeyFile.jks");
        secureSocketLayer.setTrustFileName("${USER_INSTALL_ROOT}/etc/DummyServerTrustFile.jks");
        secureSocketLayer.setTrustFilePassword("WebAS");
        secureSocketLayer.setKeyFilePassword("WebAS");
        secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.JKS_LITERAL);
        secureSocketLayer.setTrustFileFormat(KeyFileFormatKind.JKS_LITERAL);
        secureSocketLayer.setClientAuthentication(false);
        secureSocketLayer.setSecurityLevel(SSLSecurityLevel.HIGH_LITERAL);
        secureSocketLayer.setEnableCryptoHardwareSupport(false);
        Property property = this.propertiesFactory.createProperty();
        Property property2 = this.propertiesFactory.createProperty();
        property.setName("com.ibm.ssl.protocol");
        property.setValue("SSLv3");
        property2.setName("com.ibm.ssl.contextProvider");
        property2.setValue("IBMJSSE");
        resource = secureSocketLayer.eResource();
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).setID((EObject)secureSocketLayer, "DefaultSSLSettings");
        }
        secureSocketLayer.getProperties().add((Object)property);
        secureSocketLayer.getProperties().add((Object)property2);
        CryptoHardwareToken cryptoHardwareToken = this.sslFactory.createCryptoHardwareToken();
        cryptoHardwareToken.setTokenType("");
        cryptoHardwareToken.setLibraryFile("");
        cryptoHardwareToken.setPassword("");
        secureSocketLayer.setCryptoHardware(cryptoHardwareToken);
        SSLConfig sSLConfig = this.securityFactory.createSSLConfig();
        sSLConfig.setSetting(secureSocketLayer);
        sSLConfig.setAlias("DefaultSSLSettings");
        security.setDefaultSSLSettings(sSLConfig);
        security.getRepertoire().add((Object)sSLConfig);
        LDAPSearchFilter lDAPSearchFilter = this.securityFactory.createLDAPSearchFilter();
        lDAPSearchFilter.setGroupFilter("(&(cn=%v)(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)))");
        lDAPSearchFilter.setUserFilter("(&(uid=%v)(objectclass=inetOrgPerson))");
        lDAPSearchFilter.setUserIdMap("inetOrgPerson:uid");
        lDAPSearchFilter.setGroupIdMap("*:cn");
        lDAPSearchFilter.setGroupMemberIdMap("groupOfNames:member;groupOfUniqueNames:uniqueMember");
        lDAPSearchFilter.setCertificateMapMode(CertificateMapMode.EXACT_DN_LITERAL);
        lDAPSearchFilter.setCertificateFilter("");
        lDAPUserRegistry.setSslEnabled(false);
        lDAPUserRegistry.setBaseDN("");
        lDAPUserRegistry.setBindDN("");
        lDAPUserRegistry.setBindPassword("");
        lDAPUserRegistry.setType(LDAPDirectoryType.SECUREWAY_LITERAL);
        lDAPUserRegistry.setSearchFilter(lDAPSearchFilter);
        lDAPUserRegistry.setSslConfig(sSLConfig.getAlias());
        lDAPUserRegistry.setServerId("");
        lDAPUserRegistry.setServerPassword("");
        lDAPUserRegistry.setIgnoreCase(false);
        lDAPUserRegistry.setSearchTimeout(120L);
        lDAPUserRegistry.setReuseConnection(true);
        EndPoint endPoint = this.ipcFactory.createEndPoint();
        endPoint.setHost("");
        endPoint.setPort(389);
        lDAPUserRegistry.getHosts().add((Object)endPoint);
        lDAPUserRegistry.setRealm("");
        security.getUserRegistries().add((Object)lDAPUserRegistry);
        security.setActiveUserRegistry((UserRegistry)localOSUserRegistry);
        System.out.println("added setActiveUserRegistry");
        JAASConfiguration jAASConfiguration = this.lf.createJAASConfiguration();
        JAASConfigurationEntry jAASConfigurationEntry = this.lf.createJAASConfigurationEntry();
        JAASLoginModule jAASLoginModule = this.lf.createJAASLoginModule();
        Property property3 = this.propertiesFactory.createProperty();
        property3.setName("delegate");
        property3.setValue("com.ibm.ws.security.common.auth.module.WSClientLoginModuleImpl");
        jAASLoginModule.getOptions().add((Object)property3);
        jAASLoginModule.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        jAASConfigurationEntry.setAlias("ClientContainer");
        jAASConfigurationEntry.getLoginModules().add((Object)jAASLoginModule);
        jAASConfiguration.getEntries().add((Object)jAASConfigurationEntry);
        JAASConfigurationEntry jAASConfigurationEntry2 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule jAASLoginModule2 = this.lf.createJAASLoginModule();
        Property property4 = this.propertiesFactory.createProperty();
        property4.setName("delegate");
        property4.setValue("com.ibm.ws.security.common.auth.module.WSLoginModuleImpl");
        jAASLoginModule2.getOptions().add((Object)property4);
        jAASLoginModule2.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule2.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        jAASConfigurationEntry2.setAlias("WSLogin");
        jAASConfigurationEntry2.getLoginModules().add((Object)jAASLoginModule2);
        jAASConfiguration.getEntries().add((Object)jAASConfigurationEntry2);
        JAASConfigurationEntry jAASConfigurationEntry3 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule jAASLoginModule3 = this.lf.createJAASLoginModule();
        Property property5 = this.propertiesFactory.createProperty();
        property5.setName("delegate");
        property5.setValue("com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule");
        jAASLoginModule3.getOptions().add((Object)property5);
        jAASLoginModule3.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule3.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        jAASConfigurationEntry3.setAlias("DefaultPrincipalMapping");
        jAASConfigurationEntry3.getLoginModules().add((Object)jAASLoginModule3);
        jAASConfiguration.getEntries().add((Object)jAASConfigurationEntry3);
        security.setApplicationLoginConfig(jAASConfiguration);
        System.out.println("added security.setApplicationLoginConfig()");
        JAASConfiguration jAASConfiguration2 = this.lf.createJAASConfiguration();
        JAASConfigurationEntry jAASConfigurationEntry4 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule jAASLoginModule4 = this.lf.createJAASLoginModule();
        Property property6 = this.propertiesFactory.createProperty();
        property6.setName("delegate");
        property6.setValue("com.ibm.ws.security.server.lm.swamLoginModule");
        jAASLoginModule4.getOptions().add((Object)property6);
        jAASLoginModule4.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule4.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        jAASConfigurationEntry4.setAlias("SWAM");
        jAASConfigurationEntry4.getLoginModules().add((Object)jAASLoginModule4);
        jAASConfiguration2.getEntries().add((Object)jAASConfigurationEntry4);
        JAASConfigurationEntry jAASConfigurationEntry5 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule jAASLoginModule5 = this.lf.createJAASLoginModule();
        Property property7 = this.propertiesFactory.createProperty();
        property7.setName("delegate");
        property7.setValue("com.ibm.ws.security.server.lm.ltpaLoginModule");
        jAASLoginModule5.getOptions().add((Object)property7);
        jAASLoginModule5.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule5.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        jAASConfigurationEntry5.setAlias("LTPA");
        jAASConfigurationEntry5.getLoginModules().add((Object)jAASLoginModule5);
        jAASConfiguration2.getEntries().add((Object)jAASConfigurationEntry5);
        JAASConfigurationEntry jAASConfigurationEntry6 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule jAASLoginModule6 = this.lf.createJAASLoginModule();
        Property property8 = this.propertiesFactory.createProperty();
        property8.setName("delegate");
        property8.setValue("com.ibm.ws.security.web.PreAuthenLoginModule");
        jAASLoginModule6.getOptions().add((Object)property8);
        jAASLoginModule6.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule6.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        JAASLoginModule jAASLoginModule7 = this.lf.createJAASLoginModule();
        Property property9 = this.propertiesFactory.createProperty();
        property9.setName("delegate");
        property9.setValue("com.ibm.ws.security.web.AuthenLoginModule");
        jAASLoginModule7.getOptions().add((Object)property9);
        jAASLoginModule7.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        jAASLoginModule7.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        jAASConfigurationEntry6.setAlias("SLTPA");
        jAASConfigurationEntry6.getLoginModules().add((Object)jAASLoginModule6);
        jAASConfigurationEntry6.getLoginModules().add((Object)jAASLoginModule7);
        jAASConfiguration2.getEntries().add((Object)jAASConfigurationEntry6);
        security.setSystemLoginConfig(jAASConfiguration2);
        System.out.println("added security.setSystemLoginConfig()");
        IIOPSecurityProtocol iIOPSecurityProtocol = this.secProFactory.createIIOPSecurityProtocol();
        CommonSecureInterop commonSecureInterop = this.secProFactory.createCommonSecureInterop();
        resource = commonSecureInterop.eResource();
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).setID((EObject)commonSecureInterop, "CSIv2 Inbound Configuration");
        }
        security.getUserRegistries().add((Object)localOSUserRegistry);
        commonSecureInterop.setStateful(true);
        IdentityAssertionLayer identityAssertionLayer = this.secProFactory.createIdentityAssertionLayer();
        IdentityAssertionQOP identityAssertionQOP = this.secProFactory.createIdentityAssertionQOP();
        identityAssertionQOP.setEnable(false);
        identityAssertionLayer.setSupportedQOP((QualityOfProtection)identityAssertionQOP);
        commonSecureInterop.getLayers().add((Object)identityAssertionLayer);
        MessageLayer messageLayer = this.secProFactory.createMessageLayer();
        MessageQOP messageQOP = this.secProFactory.createMessageQOP();
        messageQOP.setEstablishTrustInClient(true);
        messageLayer.setSupportedQOP((QualityOfProtection)messageQOP);
        MessageQOP messageQOP2 = this.secProFactory.createMessageQOP();
        messageQOP2.setEstablishTrustInClient(false);
        messageLayer.setRequiredQOP((QualityOfProtection)messageQOP2);
        commonSecureInterop.getLayers().add((Object)messageLayer);
        TransportLayer transportLayer = this.secProFactory.createTransportLayer();
        TransportQOP transportQOP = this.secProFactory.createTransportQOP();
        transportQOP.setEnableProtection(false);
        transportQOP.setEstablishTrustInClient(true);
        transportQOP.setIntegrity(true);
        transportQOP.setConfidentiality(true);
        transportLayer.setSupportedQOP((QualityOfProtection)transportQOP);
        TransportQOP transportQOP2 = this.secProFactory.createTransportQOP();
        transportQOP2.setEnableProtection(false);
        transportQOP2.setEstablishTrustInClient(false);
        transportQOP2.setIntegrity(true);
        transportQOP2.setConfidentiality(false);
        transportLayer.setRequiredQOP((QualityOfProtection)transportQOP2);
        IIOPTransport iIOPTransport = this.secProFactory.createIIOPTransport();
        SSLConfig sSLConfig2 = sSLConfig;
        iIOPTransport.setSslConfig(sSLConfig2.getAlias());
        transportLayer.setServerAuthentication(iIOPTransport);
        commonSecureInterop.getLayers().add((Object)transportLayer);
        iIOPSecurityProtocol.setClaims((SecurityProtocolConfig)commonSecureInterop);
        CommonSecureInterop commonSecureInterop2 = this.secProFactory.createCommonSecureInterop();
        resource = commonSecureInterop2.eResource();
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).setID((EObject)commonSecureInterop2, "CSIv2 Outbound Configuration");
        }
        security.getUserRegistries().add((Object)localOSUserRegistry);
        commonSecureInterop2.setStateful(true);
        commonSecureInterop2.setSessionGCInterval(300000);
        commonSecureInterop2.setSessionGCIdleTime(900000);
        IdentityAssertionLayer identityAssertionLayer2 = this.secProFactory.createIdentityAssertionLayer();
        IdentityAssertionQOP identityAssertionQOP2 = this.secProFactory.createIdentityAssertionQOP();
        identityAssertionQOP2.setEnable(false);
        identityAssertionLayer2.setSupportedQOP((QualityOfProtection)identityAssertionQOP2);
        IdentityAssertionQOP identityAssertionQOP3 = this.secProFactory.createIdentityAssertionQOP();
        identityAssertionQOP3.setEnable(false);
        identityAssertionLayer2.setRequiredQOP((QualityOfProtection)identityAssertionQOP3);
        commonSecureInterop2.getLayers().add((Object)identityAssertionLayer2);
        MessageLayer messageLayer2 = this.secProFactory.createMessageLayer();
        messageLayer2.setAuthenticationLayerRetryCount(3);
        MessageQOP messageQOP3 = this.secProFactory.createMessageQOP();
        messageQOP3.setEstablishTrustInClient(true);
        messageLayer2.setSupportedQOP((QualityOfProtection)messageQOP3);
        MessageQOP messageQOP4 = this.secProFactory.createMessageQOP();
        messageQOP4.setEstablishTrustInClient(false);
        messageLayer2.setRequiredQOP((QualityOfProtection)messageQOP4);
        commonSecureInterop2.getLayers().add((Object)messageLayer2);
        TransportLayer transportLayer2 = this.secProFactory.createTransportLayer();
        TransportQOP transportQOP3 = this.secProFactory.createTransportQOP();
        transportQOP3.setEnableProtection(true);
        transportQOP3.setEstablishTrustInClient(false);
        transportQOP3.setIntegrity(true);
        transportQOP3.setConfidentiality(true);
        transportLayer2.setSupportedQOP((QualityOfProtection)transportQOP3);
        TransportQOP transportQOP4 = this.secProFactory.createTransportQOP();
        transportQOP4.setEnableProtection(false);
        transportQOP4.setEstablishTrustInClient(false);
        transportQOP4.setIntegrity(true);
        transportQOP4.setConfidentiality(false);
        transportLayer2.setRequiredQOP((QualityOfProtection)transportQOP4);
        IIOPTransport iIOPTransport2 = this.secProFactory.createIIOPTransport();
        SSLConfig sSLConfig3 = sSLConfig;
        iIOPTransport2.setSslConfig(sSLConfig3.getAlias());
        transportLayer2.setServerAuthentication(iIOPTransport2);
        commonSecureInterop2.getLayers().add((Object)transportLayer2);
        iIOPSecurityProtocol.setPerforms((SecurityProtocolConfig)commonSecureInterop2);
        security.setCSI(iIOPSecurityProtocol);
        System.out.println("Generated CSIv2");
        IIOPSecurityProtocol iIOPSecurityProtocol2 = this.secProFactory.createIIOPSecurityProtocol();
        SecureAssociationService secureAssociationService = this.secProFactory.createSecureAssociationService();
        TransportLayer transportLayer3 = this.secProFactory.createTransportLayer();
        TransportQOP transportQOP5 = this.secProFactory.createTransportQOP();
        transportQOP5.setEnableProtection(true);
        transportQOP5.setIntegrity(true);
        transportQOP5.setConfidentiality(true);
        transportLayer3.setSupportedQOP((QualityOfProtection)transportQOP5);
        IIOPTransport iIOPTransport3 = this.secProFactory.createIIOPTransport();
        SSLConfig sSLConfig4 = sSLConfig;
        iIOPTransport3.setSslConfig(sSLConfig4.getAlias());
        transportLayer3.setServerAuthentication(iIOPTransport3);
        secureAssociationService.getLayers().add((Object)transportLayer3);
        iIOPSecurityProtocol2.setClaims((SecurityProtocolConfig)secureAssociationService);
        SecureAssociationService secureAssociationService2 = this.secProFactory.createSecureAssociationService();
        TransportLayer transportLayer4 = this.secProFactory.createTransportLayer();
        TransportQOP transportQOP6 = this.secProFactory.createTransportQOP();
        transportQOP6.setEnableProtection(true);
        transportQOP6.setIntegrity(false);
        transportQOP6.setConfidentiality(false);
        transportLayer4.setSupportedQOP((QualityOfProtection)transportQOP6);
        IIOPTransport iIOPTransport4 = this.secProFactory.createIIOPTransport();
        SSLConfig sSLConfig5 = sSLConfig;
        iIOPTransport4.setSslConfig(sSLConfig5.getAlias());
        transportLayer4.setServerAuthentication(iIOPTransport4);
        secureAssociationService2.getLayers().add((Object)transportLayer4);
        iIOPSecurityProtocol2.setPerforms((SecurityProtocolConfig)secureAssociationService2);
        security.setIBM(iIOPSecurityProtocol2);
        System.out.println("Generated SAS");
        return security;
    }

    public String getDocumentName() {
        return "security.xml";
    }

    public void initializeFactories() {
        super.initializeFactories();
        SecurityPackage securityPackage = (SecurityPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi");
        this.securityFactory = securityPackage.getSecurityFactory();
        PropertiesPackage propertiesPackage = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propertiesFactory = propertiesPackage.getPropertiesFactory();
        IpcPackage ipcPackage = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcPackage.getIpcFactory();
        SslPackage sslPackage = (SslPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.ssl.xmi");
        this.sslFactory = sslPackage.getSslFactory();
        this.lf = (JaasloginFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/jaaslogin.xmi").getEFactoryInstance();
        SecurityprotocolPackage securityprotocolPackage = (SecurityprotocolPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi");
        this.secProFactory = securityprotocolPackage.getSecurityprotocolFactory();
    }

    public static void main(String[] stringArray) {
        SampleSecurityConfigBuilder sampleSecurityConfigBuilder = new SampleSecurityConfigBuilder();
        sampleSecurityConfigBuilder.write();
    }
}

