/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.SAFRoleMapperFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;

public class SAFAuthorizationTableImpl
implements AuthorizationTable {
    private static final TraceComponent tc = Tr.register((Class)SAFAuthorizationTableImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    public static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    public static final int EJBROLE_TRUE = 1;
    public static final int EJBROLE_FALSE = 0;
    public static final int EJBROLE_INACTIVE = -1;
    private static boolean _roleClassInactive = false;
    private SAFRoleMapper _roleMapper = null;
    private boolean _suppressMessages = false;
    private int _logOption = 0;

    public SAFAuthorizationTableImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this._roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();
        Properties properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties");
        String string = properties.getProperty("com.ibm.security.SAF.Authz.Log.Option");
        String string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.security.SAF.EJBROLE.Audit.Messages.Suppress");
        this._suppressMessages = new Boolean(string2);
        if (string != null && string.length() > 0) {
            if (string.equalsIgnoreCase("NONE")) {
                this._logOption = 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Log Option is NONE.");
                }
            } else if (string.equalsIgnoreCase("ASIS")) {
                this._logOption = 2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Log Option is ASIS.");
                }
            } else if (string.equalsIgnoreCase("NOFAIL")) {
                this._logOption = 3;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Log Option is NOFAIL.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Following DEFAULT log option path.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean isEveryoneGranted(HashMap hashMap, String[] stringArray) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Object[]{hashMap, stringArray});
        }
        boolean bl = SAFAuthorizationTableImpl.isRoleClassInactive();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedRole(HashMap hashMap, String string, Principal principal) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedRole", (Object)new Object[]{hashMap, string, principal});
        }
        String[] stringArray = new String[]{string};
        boolean bl = this.isGrantedAnyRole(hashMap, stringArray, principal);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedAnyRole(HashMap hashMap, String[] stringArray, Principal principal) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Object[]{hashMap, stringArray, principal});
        }
        boolean bl = false;
        PlatformCredential platformCredential = null;
        try {
            final Subject subject = (Subject)hashMap.get(SUBJECT_KEY);
            platformCredential = (PlatformCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                    if (wSCredential != null) {
                        return wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.SAFAuthorizationTableImpl", (String)"249", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting PlatformCredential", (Object)privilegedActionException.getException());
            }
            throw new SecurityProviderException("Unable to acquire PlatformCredential", privilegedActionException.getException());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"PlatformCredential", (Object)platformCredential);
        }
        if (platformCredential != null) {
            bl = this.isSAFPrincipalInAnyRole(hashMap, stringArray, platformCredential);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean isSAFPrincipalInAnyRole(HashMap hashMap, String[] stringArray, PlatformCredential platformCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSAFPrincipalInAnyRole", (Object)new Object[]{hashMap, stringArray, platformCredential});
        }
        boolean bl = false;
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Target role is required");
        }
        String string = (String)hashMap.get("APPLICATION_NAME");
        boolean bl2 = "admin-authz".equals(string);
        String[] stringArray2 = this.getProfilesFromRoles(hashMap, stringArray);
        boolean bl3 = bl2 && this._logOption == 0 || this._suppressMessages;
        int n = this.checkProfiles(stringArray2, stringArray2.length, platformCredential, bl3, this._logOption);
        switch (n) {
            case -1: {
                SAFAuthorizationTableImpl.setRoleClassInactive();
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSAFPrincipalInAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected String[] getProfilesFromRoles(HashMap hashMap, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProfilesFromRoles", (Object)new Object[]{hashMap, stringArray});
        }
        String[] stringArray2 = new String[stringArray.length];
        String string = (String)hashMap.get("APPLICATION_NAME");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this._roleMapper.getProfileFromRole(string, stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProfilesFromRoles", (Object)stringArray2);
        }
        return stringArray2;
    }

    private native int checkProfiles(String[] var1, int var2, PlatformCredential var3, boolean var4, int var5);

    private static synchronized void setRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markServiceDisabled");
        }
        if (!_roleClassInactive) {
            Tr.audit((TraceComponent)tc, (String)"BBOJ0015");
            _roleClassInactive = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markServiceDisabled");
        }
    }

    private static boolean isRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isRoleClassInactive");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isRoleClassInactive", (Object)new Boolean(_roleClassInactive));
        }
        return _roleClassInactive;
    }
}

