/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.SecurityCookie;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSLocalzOSExtensionImpl;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityCookieImpl;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.delegation.DelegationFactory;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.security.util.SyncToOSThreadHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EnterpriseBean;
import javax.security.auth.Subject;

public class EJSSecurityCollaborator
extends SecurityCollaborator {
    private static final TraceComponent tc = Tr.register((Class)EJSSecurityCollaborator.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final String[] UNPROTECTED = new String[]{"RemoteSRP", "RemoteSRPHome", "SrdSrvltCtxHome", "SessionBMP", "UPManager", "UP_ReadOnly", "UP_ReadWrite"};
    protected Delegation delegationPolicy;
    private final SyncToOSThreadHelper syncHelper;
    private final WSLocalzOSExtensionImpl localSecurity;
    private final boolean isZOS;
    private static EJSSecurityCollaborator securityCollaboratorInstance;

    public static EJSSecurityCollaborator getInstance() {
        return securityCollaboratorInstance;
    }

    public EJSSecurityCollaborator() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.delegationPolicy = DelegationFactory.getDelegation();
        this.isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        this.syncHelper = this.isZOS ? new SyncToOSThreadHelper() : null;
        this.localSecurity = this.isZOS ? (WSLocalzOSExtensionImpl)WSLoginLocalOSExtensionFactory.getInstance() : null;
        securityCollaboratorInstance = this;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public CollaboratorCookie preInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie) throws CSIException {
        throw new CSIException("old preInvoke called");
    }

    public CollaboratorCookie preInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie, EnterpriseBean enterpriseBean, Object[] objectArray) throws CSIException {
        SyncToOSThreadHelper syncToOSThreadHelper;
        Object object;
        if (!securityEnabled) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preInvoke", (Object)new Object[]{eJBKey, eJBMethodInfo, collaboratorCookie, enterpriseBean, objectArray});
        }
        Subject subject = null;
        Subject subject2 = null;
        Subject subject3 = null;
        try {
            subject = contextManager.getCallerSubject();
            subject2 = contextManager.getInvocationSubject();
            subject3 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws WSSecurityException {
                    return SecurityCollaborator.contextManager.getServerSubject();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.EJSSecurityCollaborator.preInvoke", (String)"170", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error getting subjects", (Object)exception);
            }
            throw new CSIAccessException(exception.getMessage(), (Throwable)exception);
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.core.EJSSecurityCollaborator.preInvoke", (String)"176", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error getting subjects", (Object)((Object)wSSecurityException));
            }
            throw new CSIAccessException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
        }
        Subject[] subjectArray = new Subject[3];
        subjectArray[0] = subject != null ? subject : null;
        subjectArray[1] = subject2;
        this.SetUnauthenticatedSubjectIfNeeded(subject2, subject);
        Subject[] subjectArray2 = null;
        subjectArray2 = this.performAuthorization(eJBKey, eJBMethodInfo, subject3, subject, (SecurityBeanCookie)collaboratorCookie, enterpriseBean, objectArray);
        if (subjectArray2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"performAuthorization returned non null retSubjects");
            }
            subject = subjectArray2[1] != null ? subjectArray2[1] : subjectArray2[0];
        }
        Subject subject4 = subject;
        String string = eJBMethodInfo.getHomeName();
        final EJBKey eJBKey2 = eJBKey;
        final EJBMethodInfo eJBMethodInfo2 = eJBMethodInfo;
        final CollaboratorCookie collaboratorCookie2 = collaboratorCookie;
        final Subject subject5 = subject3;
        final Subject subject6 = subject;
        if (!this.isUnprotected(((SecurityBeanCookie)collaboratorCookie).getBeanName())) {
            try {
                subject4 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws CSIException {
                        return EJSSecurityCollaborator.this.delegationPolicy.delegate(eJBKey2, eJBMethodInfo2, subject5, subject6, (SecurityBeanCookie)collaboratorCookie2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                CSIException cSIException = (CSIException)privilegedActionException.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error getting delegatedSubject");
                }
                if (cSIException instanceof CSIAccessException) {
                    throw (CSIAccessException)cSIException;
                }
                throw new CSIAccessException(cSIException.getMessage());
            }
        }
        this.setSubjects(subject, subject4);
        boolean bl = false;
        boolean bl2 = false;
        if (this.isZOS) {
            object = eJBMethodInfo.getEJBComponentMetaData();
            bl = object.isApplicationSyncToOSThreadEnabled();
            bl2 = this.localSecurity.isThreadLocalApplicationSyncEnabled();
        }
        object = null;
        if (bl) {
            try {
                syncToOSThreadHelper = this.syncHelper;
                final Subject subject7 = subject4;
                object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return syncToOSThreadHelper.setAppSyncToThread(subject7);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Thread identity synchronization error", (Object)privilegedActionException);
                }
                throw new CSIException(privilegedActionException.getMessage(), (Throwable)privilegedActionException);
            }
        }
        if (bl2) {
            try {
                syncToOSThreadHelper = ServerIdentityHelper.getServerIdentityHelper();
                object = syncToOSThreadHelper.push();
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Thread identity synchronization error", (Object)exception);
                }
                throw new CSIException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (this.isZOS) {
            this.localSecurity.setThreadLocalApplicationSyncEnabled(bl);
        }
        syncToOSThreadHelper = (CollaboratorCookie)EJSSecurityCollaborator.getCookie(subjectArray, object, bl2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preInvoke", (Object)syncToOSThreadHelper);
        }
        return syncToOSThreadHelper;
    }

    protected boolean isUnprotected(String string) {
        for (int i = 0; i < UNPROTECTED.length; ++i) {
            if (!UNPROTECTED[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    protected String resolveHomeMethod(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolveHomeMethod", (Object)string);
        }
        if (string.startsWith("find")) {
            StringBuffer stringBuffer = new StringBuffer(3 + string.length());
            stringBuffer.append("ejb").append(string);
            stringBuffer.setCharAt(3, 'F');
            string = stringBuffer.toString();
        } else {
            string = super.resolveHomeMethod(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolveHomeMethod", (Object)string);
        }
        return string;
    }

    public void postInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie, CollaboratorCookie collaboratorCookie2) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postInvoke", (Object)new Object[]{eJBKey, eJBMethodInfo, collaboratorCookie, collaboratorCookie2});
        }
        super.postInvokeCommon(eJBKey, eJBMethodInfo, (SecurityCookie)collaboratorCookie, collaboratorCookie2);
        if (this.isZOS) {
            SecurityCookieImpl securityCookieImpl = (SecurityCookieImpl)collaboratorCookie;
            Object object = ((SecurityCookieImpl)collaboratorCookie).syncToThreadToken;
            if (object != null) {
                try {
                    final SyncToOSThreadHelper syncToOSThreadHelper = this.syncHelper;
                    final Object object2 = object;
                    object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            syncToOSThreadHelper.restoreAppSyncToThread(object2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unable to restore thread identity", (Object)privilegedActionException);
                    }
                    throw new CSIException(privilegedActionException.getMessage(), (Throwable)privilegedActionException);
                }
            }
            this.localSecurity.setThreadLocalApplicationSyncEnabled(securityCookieImpl.appSyncToOSThread);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postInvoke");
        }
    }

    public CollaboratorCookie beanInstalled(EJBConfigData eJBConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beanInstalled", (Object)eJBConfigData);
        }
        CollaboratorCookie collaboratorCookie = this.installBean(eJBConfigData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beanInstalled", (Object)collaboratorCookie);
        }
        return collaboratorCookie;
    }

    public void beanUninstalled(CollaboratorCookie collaboratorCookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beanUninstalled", (Object)collaboratorCookie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beanUninstalled");
        }
    }
}

