/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.env.EnvFactory;
import com.ibm.ejs.models.base.resources.env.EnvPackage;
import com.ibm.ejs.models.base.resources.j2c.J2cFactory;
import com.ibm.ejs.models.base.resources.j2c.J2cPackage;
import com.ibm.ejs.models.base.resources.jdbc.JdbcFactory;
import com.ibm.ejs.models.base.resources.jdbc.JdbcPackage;
import com.ibm.ejs.models.base.resources.jms.JmsFactory;
import com.ibm.ejs.models.base.resources.jms.JmsPackage;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.InternalmessagingFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.InternalmessagingPackage;
import com.ibm.ejs.models.base.resources.jms.mqseries.MqseriesFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MqseriesPackage;
import com.ibm.ejs.models.base.resources.mail.MailFactory;
import com.ibm.ejs.models.base.resources.mail.MailPackage;
import com.ibm.ejs.models.base.resources.url.UrlFactory;
import com.ibm.ejs.models.base.resources.url.UrlPackage;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class AbstractConfigBuilder {
    public static final String APP_INSTALL_ROOT = "c:/g021122/installedApps";
    public static final String INSTALLABLE_APPS_ROOT = "c:/g021122/installableApps";
    public static final String DEFAULT_CONFIG_ROOT = "/wccm50";
    public static final String DEFAULT_CONTACT = "{Your Contact Info}";
    public static final String CELL_EXTENSION = ".ws-cell";
    public static final String NODE_EXTENSION = ".ws-node";
    public static final String PROCESS_EXTENSION = ".ws-proc";
    public static final String APP_EXTENSION = ".ws-app";
    public static final String CELL_MANAGER_TYPE = "CellManager";
    public static final String NODE_AGENT_TYPE = "NodeAgent";
    public static final String MANAGED_SERVER_TYPE = "ManagedServer";
    protected boolean emitTimestamp = true;
    protected ResourcesFactory resourceFactory;
    protected J2cFactory j2cFactory;
    protected JmsFactory jmsFactory;
    protected MqseriesFactory mqSeriesFactory;
    protected InternalmessagingFactory internalMessagingFactory;
    protected JdbcFactory jdbcFactory;
    protected MailFactory mailFactory;
    protected EnvFactory envFactory;
    protected UrlFactory urlFactory;
    protected static ResourceSet context;
    protected String configRoot;
    protected boolean multiExtent = false;

    public AbstractConfigBuilder() {
        this.initializeFactories();
    }

    public abstract EList buildRootElements();

    public void setConfigRepositoryRoot(String string) {
        this.configRoot = string;
    }

    public String getConfigRepositoryRoot() {
        if (this.configRoot == null || this.configRoot.equals("")) {
            return DEFAULT_CONFIG_ROOT;
        }
        return this.configRoot;
    }

    public String getContactInfo() {
        return DEFAULT_CONTACT;
    }

    protected ResourceSet getContext() {
        if (context == null) {
            context = new WASResourceSetImpl();
            URIConverterImpl uRIConverterImpl = new URIConverterImpl();
            URI uRI = URI.createURI((String)this.getConfigRepositoryRoot());
            context.setURIConverter((URIConverter)uRIConverterImpl);
        }
        return context;
    }

    public abstract String getDocumentName();

    public ResourceSet getResourceSet() {
        return this.getContext();
    }

    public void initializeFactories() {
        ArchiveInit.init();
        CommonarchiveFactory commonarchiveFactory = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore")).getCommonarchiveFactory();
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
        this.resourceFactory = resourcesPackage.getResourcesFactory();
        J2cPackage j2cPackage = (J2cPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi");
        this.j2cFactory = j2cPackage.getJ2cFactory();
        JmsPackage jmsPackage = (JmsPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi");
        this.jmsFactory = jmsPackage.getJmsFactory();
        InternalmessagingPackage internalmessagingPackage = (InternalmessagingPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.internalmessaging.xmi");
        this.internalMessagingFactory = internalmessagingPackage.getInternalmessagingFactory();
        MqseriesPackage mqseriesPackage = (MqseriesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi");
        this.mqSeriesFactory = mqseriesPackage.getMqseriesFactory();
        JdbcPackage jdbcPackage = (JdbcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jdbc.xmi");
        this.jdbcFactory = jdbcPackage.getJdbcFactory();
        MailPackage mailPackage = (MailPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.mail.xmi");
        this.mailFactory = mailPackage.getMailFactory();
        EnvPackage envPackage = (EnvPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.env.xmi");
        this.envFactory = envPackage.getEnvFactory();
        UrlPackage urlPackage = (UrlPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.url.xmi");
        this.urlFactory = urlPackage.getUrlFactory();
    }

    protected Resource makeResource(String string, EList eList) {
        ResourceSet resourceSet = this.getContext();
        Resource resource = resourceSet.createResource(URI.createURI((String)string));
        resource.getContents().addAll((Collection)eList);
        return resource;
    }

    public void trace(String string) {
        System.out.println(string);
    }

    public void write() {
        this.write(this.buildRootElements(), this.getConfigRepositoryRoot() + "/" + this.getDocumentName());
    }

    public void write(EList eList, String string) {
        XMIResource xMIResource = (XMIResource)this.makeResource(string, eList);
        try {
            xMIResource.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.AbstractConfigBuilder.write", (String)"206", (Object)this);
            exception.printStackTrace();
        }
    }

    public void write(EObject eObject, String string) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        arrayList.add(eObject);
        this.write(arrayList, string);
    }

    public void write(Collection collection, String string) {
        BasicEList basicEList = new BasicEList();
        basicEList.addAll(collection);
        XMIResource xMIResource = (XMIResource)this.makeResource(this.getDocumentName(), (EList)basicEList);
        try {
            xMIResource.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.AbstractConfigBuilder.write", (String)"226", (Object)this);
            exception.printStackTrace();
        }
    }
}

