/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.models.base.bindings.applicationbnd.AllAuthenticatedUsers;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Everyone;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.Server;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.ExcludeList;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.ejb.MethodPermission;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.SecurityRoleRef;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveWrappedException;
import com.ibm.etools.webapplication.AuthConstraint;
import com.ibm.etools.webapplication.HTTPMethodTypeEnum;
import com.ibm.etools.webapplication.SecurityConstraint;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.UserDataConstraint;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.authorize.URLMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.security.authorization.RoleConfiguration;
import com.ibm.wsspi.security.authorization.RoleConfigurationException;
import com.ibm.wsspi.security.authorization.RoleConfigurationFactory;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AppInstallNotify {
    private static TraceComponent tc = Tr.register((Class)AppInstallNotify.class, null, (String)"com.ibm.ejs.resources.security");
    private static PolicyConfigurationFactory pcf = null;
    private static AppInstallNotify appNotify = null;
    private static String FACTORY_NAME = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static String FACTORY_CLASS_NAME = "com.ibm.ws.security.provider.WSPolicyConfigurationFactoryImpl";
    private static HashMap pcConfigsMap = null;
    private static final int EXTENSION_PATTERN = 0;
    private static final int PATHPREFIX_PATTERN = 1;
    private static final int EXACT_PATTERN = 2;
    private static final int DEFAULT_PATTERN = 3;
    private static String cellName = null;
    private static String policyCfgFactoryImplClassName = null;
    private static RoleConfigurationFactory rcf = null;
    private static AuthorizationProvider authzProvider = null;
    private static Policy jPolicy = null;

    private AppInstallNotify() {
        this.initialize();
    }

    public static AppInstallNotify getInstance() {
        if (appNotify == null) {
            appNotify = new AppInstallNotify();
        }
        return appNotify;
    }

    private void initialize() {
        pcConfigsMap = new HashMap();
    }

    public void appInstalled(EARFile eARFile, String string) throws Exception {
    }

    public void appInstall(EARFile eARFile, String string, String string2, boolean bl) throws Exception {
        EJBModuleRef eJBModuleRef;
        Object object;
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appInstalled", (Object)new Object[]{eARFile, string, string2});
        }
        if (eARFile == null) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.earfile.error", (Object)new Object[]{string});
            throw new Exception("The earFile is null");
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.appname.error");
            throw new Exception("The appName is null");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"appInstall in local mode");
            }
            this.getLocalPolicy();
            this.getPCF(bl);
            this.getRCF(bl);
        }
        if ((list = eARFile.getEJBModuleRefs()) != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                eJBModuleRef = (EJBModuleRef)object.next();
                this.addEJBPermissions(eJBModuleRef, string, string2, bl);
            }
        }
        if ((object = eARFile.getWebModuleRefs()) != null && object.size() > 0) {
            eJBModuleRef = object.iterator();
            while (eJBModuleRef.hasNext()) {
                WebModuleRef webModuleRef = (WebModuleRef)eJBModuleRef.next();
                this.addWebPermissions(webModuleRef, string, string2, bl);
            }
        }
        this.addAuthorizationTable(eARFile, string, string2, bl);
        if (jPolicy == null) {
            jPolicy = !bl ? Policy.getPolicy() : this.getLocalPolicy();
        }
        if (jPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Refreshing the policy ");
            }
            jPolicy.refresh();
        }
        Tr.audit((TraceComponent)tc, (String)"security.jacc.secpolicy.propagated", (Object)new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appInstalled");
        }
    }

    public void addAuthorizationTable(EARFile eARFile, String string, String string2, boolean bl) throws RoleConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAuthorizationTable");
        }
        if (rcf == null) {
            rcf = this.getRCF(bl);
        }
        if (rcf == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addAuthorizationTable: no roleconfiguration");
            }
            return;
        }
        RoleConfiguration roleConfiguration = null;
        if (rcf != null) {
            try {
                roleConfiguration = rcf.getRoleConfiguration(string2, true);
            }
            catch (RoleConfigurationException roleConfigurationException) {
                FFDCFilter.processException((Throwable)roleConfigurationException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.addAuthorizationTable", (String)"223", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.jacc.tools.rcf", (Object)new Object[]{string2, roleConfigurationException});
                roleConfiguration = null;
                throw roleConfigurationException;
            }
        }
        if (roleConfiguration != null) {
            ApplicationBinding applicationBinding = eARFile.getBindings();
            AuthorizationTable authorizationTable = null;
            if (applicationBinding != null) {
                authorizationTable = applicationBinding.getAuthorizationTable();
            }
            EList eList = null;
            if (authorizationTable != null) {
                eList = authorizationTable.getAuthorizations();
            }
            Iterator iterator = null;
            if (eList != null) {
                iterator = eList.iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    EList eList2;
                    EList eList3;
                    RoleAssignment roleAssignment = (RoleAssignment)iterator.next();
                    String string3 = roleAssignment.getRole().getRoleName();
                    EList eList4 = roleAssignment.getUsers();
                    if (eList4 != null) {
                        roleConfiguration.addUsersToRole(string3, (List)eList4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("added users: " + eList4.toString() + " to role: " + string3));
                        }
                    }
                    if ((eList3 = roleAssignment.getGroups()) != null) {
                        roleConfiguration.addGroupsToRole(string3, (List)eList3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("added groups: " + eList3.toString() + " to role: " + string3));
                        }
                    }
                    if ((eList2 = roleAssignment.getSpecialSubjects()) == null) continue;
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        SpecialSubject specialSubject = (SpecialSubject)iterator2.next();
                        if (specialSubject instanceof Everyone) {
                            roleConfiguration.addEveryoneToRole(string3);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("added Everyone to role: " + string3));
                            continue;
                        }
                        if (specialSubject instanceof AllAuthenticatedUsers) {
                            roleConfiguration.addAuthenticatedUsersToRole(string3);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("added AllAuthenticatedUsers to role: " + string3));
                            continue;
                        }
                        if (!(specialSubject instanceof Server) || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("added Server not supported for role: " + string3));
                    }
                }
            }
            roleConfiguration.commit();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Propagated RoleConfiguration information for Application: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAuthorizationTable");
        }
    }

    public void appUninstalled(String string, String string2) throws Exception {
    }

    public void appUninstall(ApplicationDeployment applicationDeployment, String string, String string2, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appUninstalled", (Object)new Object[]{applicationDeployment, string, string2});
        }
        if (applicationDeployment == null) {
            throw new Exception("The deployment.xml in the application is null");
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.appname.error");
            throw new Exception("The appName is null");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"appInstall in local mode");
            }
            this.getLocalPolicy();
            this.getPCF(bl);
            this.getRCF(bl);
        }
        try {
            EList eList = applicationDeployment.getModules();
            if (eList != null && eList.size() > 0) {
                for (int i = 0; i < eList.size(); ++i) {
                    ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
                    String string3 = moduleDeployment.getUri();
                    this.deleteModule(string3, string, string2, bl);
                }
            }
            this.deleteAuthorizationTable(string, string2, bl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authorize.AppInstallNotify.appUninstalled", (String)"333", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.uninstall", (Object)new Object[]{string, exception});
            throw exception;
        }
        if (jPolicy == null) {
            jPolicy = !bl ? Policy.getPolicy() : this.getLocalPolicy();
        }
        if (jPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Refreshing the policy ");
            }
            jPolicy.refresh();
        }
        Tr.audit((TraceComponent)tc, (String)"security.jacc.secpolicy.removed", (Object)new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appUninstalled");
        }
    }

    public void deleteAuthorizationTable(String string, String string2, boolean bl) throws ClassNotFoundException, PolicyContextException, ArchiveWrappedException, RoleConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteAuthorizationTable");
        }
        if (rcf == null) {
            rcf = this.getRCF(bl);
        }
        if (rcf == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteAuthorizationTable: no roleconfiguration");
            }
            return;
        }
        if (rcf != null) {
            RoleConfiguration roleConfiguration = null;
            try {
                roleConfiguration = rcf.getRoleConfiguration(string2, true);
            }
            catch (RoleConfigurationException roleConfigurationException) {
                FFDCFilter.processException((Throwable)roleConfigurationException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.appUninstalled", (String)"354", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.jacc.tools.rcf", (Object)new Object[]{string2, roleConfigurationException});
                roleConfiguration = null;
                throw roleConfigurationException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RoleConfiguration to be deleted is: " + roleConfiguration));
            }
            if (roleConfiguration != null) {
                roleConfiguration.delete();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Deleted role configuration for contextID: " + string2));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteAuthorizationTable");
        }
    }

    public void addEJBPermissions(EJBModuleRef eJBModuleRef, String string, String string2, boolean bl) throws Exception {
        this.addEJBPermissions(eJBModuleRef, string, string2, bl, null);
    }

    public void addEJBPermissions(EJBModuleRef eJBModuleRef, String string, String string2, boolean bl, PolicyConfiguration policyConfiguration) throws Exception {
        Object object;
        int n;
        String string3;
        EnterpriseBean enterpriseBean;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addEJBPermissions", (Object)new Object[]{eJBModuleRef.getUri(), string});
        }
        PolicyConfiguration policyConfiguration2 = null;
        EJBJar eJBJar = null;
        AssemblyDescriptor assemblyDescriptor = null;
        EList eList = null;
        EList eList2 = null;
        EList eList3 = null;
        EList eList4 = null;
        ExcludeList excludeList = null;
        Permissions permissions = new Permissions();
        Permissions permissions2 = new Permissions();
        Permissions permissions3 = new Permissions();
        eJBJar = eJBModuleRef.getEJBJar();
        if (eJBJar != null) {
            eList3 = eJBJar.getEnterpriseBeans();
            assemblyDescriptor = eJBJar.getAssemblyDescriptor();
        }
        if (assemblyDescriptor != null) {
            eList = assemblyDescriptor.getMethodPermissions();
            excludeList = assemblyDescriptor.getExcludeList();
        }
        String string4 = eJBModuleRef.getUri();
        String string5 = this.getModuleContextID(string2, string4);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf == null) {
                throw new PolicyContextException("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            policyConfiguration2 = pcf.getPolicyConfiguration(string5, true);
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.addEJBPermissions", (String)"420", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf", (Object)new Object[]{string5, policyContextException});
            pcf = null;
            policyConfiguration2 = null;
            throw policyContextException;
        }
        if (policyConfiguration2 == null) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf.null", (Object)new Object[]{string5});
            throw new PolicyContextException("The PolicyConfiguration object is null");
        }
        if (eList3 != null && eList3.size() > 0) {
            for (n2 = 0; n2 < eList3.size(); ++n2) {
                enterpriseBean = (EnterpriseBean)eList3.get(n2);
                string3 = enterpriseBean.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bean Name processed is " + enterpriseBean.getName()));
                }
                if ((eList4 = enterpriseBean.getSecurityRoleRefs()) == null) continue;
                for (n = 0; n < eList4.size(); ++n) {
                    object = (SecurityRoleRef)eList4.get(n);
                    String string6 = object.getName();
                    String string7 = object.getLink();
                    EJBRoleRefPermission eJBRoleRefPermission = new EJBRoleRefPermission(string3, string6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding the following EJBRoleRefPermission (roleName, refLink): ", (Object)new Object[]{string6, string7});
                    }
                    policyConfiguration2.addToRole(string7, (Permission)eJBRoleRefPermission);
                }
            }
        }
        if (eList != null && eList.size() > 0) {
            for (n2 = 0; n2 < eList.size(); ++n2) {
                enterpriseBean = (MethodPermission)eList.get(n2);
                string3 = enterpriseBean.getMethodElements();
                if (enterpriseBean.isUnchecked()) {
                    permissions2 = this.getEJBPermCollection((EList)string3);
                    if (permissions2 == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding the following Unchecked permissions: ", (Object)new Object[]{permissions2});
                    }
                    policyConfiguration2.addToUncheckedPolicy((PermissionCollection)permissions2);
                    continue;
                }
                eList2 = enterpriseBean.getRoles();
                if (eList2 == null || eList2.size() <= 0 || (permissions = this.getEJBPermCollection((EList)string3)) == null) continue;
                for (n = 0; n < eList2.size(); ++n) {
                    object = ((SecurityRole)eList2.get(n)).getRoleName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding the following Role Permissions (roleName, EJBRolePermissions): ", (Object)new Object[]{object, permissions});
                    }
                    policyConfiguration2.addToRole((String)object, (PermissionCollection)permissions);
                }
            }
        }
        EList eList5 = null;
        if (excludeList != null && (permissions3 = this.getEJBPermCollection(eList5 = excludeList.getMethodElements())) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding the following Excluded Permissions: ", (Object)new Object[]{permissions3});
            }
            policyConfiguration2.addToExcludedPolicy((PermissionCollection)permissions3);
        }
        this.linkConfiguration(string, policyConfiguration2, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Committing the EJB PolicyConfiguration ");
        }
        policyConfiguration2.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addEJBPermissions");
        }
    }

    private PolicyConfigurationFactory getPCF(boolean bl) {
        if (pcf == null) {
            try {
                if (System.getProperty(FACTORY_NAME) == null) {
                    policyCfgFactoryImplClassName = !bl ? SecurityConfig.getPolicyConfigurationFactoryClassName() : this.getLocalPCFName();
                    if (policyCfgFactoryImplClassName != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The policy configuration factory name is:" + policyCfgFactoryImplClassName));
                        }
                        System.setProperty(FACTORY_NAME, policyCfgFactoryImplClassName);
                        pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                    }
                } else {
                    pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.initialize", (String)"541", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", (Object)new Object[]{classNotFoundException});
                }
                pcf = null;
            }
            catch (PolicyContextException policyContextException) {
                FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.initialize", (String)"545", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", (Object)new Object[]{policyContextException});
                }
                pcf = null;
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException((Throwable)workSpaceException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.initialize", (String)"567", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", (Object)new Object[]{workSpaceException});
                }
                pcf = null;
            }
        }
        return pcf;
    }

    private RoleConfigurationFactory getRCF(boolean bl) {
        if (rcf == null) {
            String string = null;
            try {
                string = !bl ? SecurityConfig.getRoleConfigurationFactoryClassName() : this.getLocalRCFName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"rcfClassName: ", (Object)string);
                }
                if (string != null && string.length() > 0) {
                    rcf = (RoleConfigurationFactory)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authorize.AppInstallNotify.initialize", (String)"563", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception during the initialization of the roleConfigurationImplClass:", (Object)new Object[]{string, exception});
                }
                rcf = null;
            }
        }
        return rcf;
    }

    public void addWebPermissions(WebModuleRef webModuleRef, String string, String string2, boolean bl) throws Exception {
        this.addWebPermissions(webModuleRef, string, string2, bl, null);
    }

    public void addWebPermissions(WebModuleRef webModuleRef, String string, String string2, boolean bl, PolicyConfiguration policyConfiguration) throws Exception {
        Object object;
        Object object2;
        ArrayList<String> arrayList;
        Object object3;
        Object object4;
        String[] stringArray;
        Object object5;
        EList eList;
        String[] stringArray2;
        Object object6;
        Object object7;
        String string3;
        Object object8;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addWebPermissions", (Object)new Object[]{webModuleRef.getUri(), string});
        }
        WebApp webApp = null;
        EList eList2 = null;
        EList eList3 = null;
        UserDataConstraint userDataConstraint = null;
        EList eList4 = null;
        EList eList5 = null;
        EList eList6 = null;
        EList eList7 = null;
        PolicyConfiguration policyConfiguration2 = null;
        webApp = webModuleRef.getWebApp();
        if (webApp != null) {
            eList2 = webApp.getConstraints();
            eList5 = webApp.getServlets();
            eList7 = webApp.getSecurityRoles();
        }
        String string4 = webModuleRef.getUri();
        String string5 = this.getModuleContextID(string2, string4);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf == null) {
                throw new PolicyContextException("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            policyConfiguration2 = pcf.getPolicyConfiguration(string5, true);
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.addWebPermissions", (String)"607", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf", (Object)new Object[]{string5, policyContextException});
            pcf = null;
            policyConfiguration2 = null;
            throw policyContextException;
        }
        if (policyConfiguration2 == null) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf.null", (Object)new Object[]{string5});
            throw new PolicyContextException("The PolicyConfiguration object is null");
        }
        Permissions permissions = new Permissions();
        Permissions permissions2 = new Permissions();
        Permissions permissions3 = new Permissions();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (eList5 != null) {
            for (int i = 0; i < eList5.size(); ++i) {
                object8 = (Servlet)eList5.get(i);
                string3 = object8.getServletName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Servlet Name is: " + string3));
                }
                if ((eList6 = object8.getSecurityRoleRefs()) != null) {
                    for (int j = 0; j < eList6.size(); ++j) {
                        object7 = (SecurityRoleRef)eList6.get(j);
                        object6 = object7.getName();
                        stringArray2 = object7.getLink();
                        eList = new WebRoleRefPermission(string3, (String)object6);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding the following WebRoleRefPermission (roleLink, WebRoleRefPermission) for RoleLink: ", (Object)new Object[]{stringArray2});
                        }
                        policyConfiguration2.addToRole((String)stringArray2, (Permission)eList);
                        arrayList2.add(object6);
                    }
                }
                if (eList7 == null) continue;
                Iterator iterator = eList7.iterator();
                while (iterator.hasNext()) {
                    object7 = ((SecurityRole)iterator.next()).getRoleName();
                    if (arrayList2.contains(object7)) continue;
                    object6 = new WebRoleRefPermission(string3, (String)object7);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding the following WebRoleRefPermission (roleLink , WebRoleRefPermission): ", (Object)new Object[]{object7, object6});
                    }
                    policyConfiguration2.addToRole((String)object7, (Permission)object6);
                }
            }
        }
        if (eList7 != null) {
            Iterator iterator = eList7.iterator();
            while (iterator.hasNext()) {
                object8 = ((SecurityRole)iterator.next()).getRoleName();
                string3 = new WebRoleRefPermission("", (String)object8);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding the following WebRoleRefPermission with empty string (roleName , WebRoleRefPermission): ", (Object)new Object[]{object8, string3});
                }
                policyConfiguration2.addToRole((String)object8, (Permission)((Object)string3));
            }
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("/", new URLMap("/"));
        if (eList2 != null) {
            object8 = eList2.iterator();
            while (object8.hasNext()) {
                boolean bl2;
                string3 = (SecurityConstraint)object8.next();
                if (string3 == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SecurityConstraint: ", (Object)new Object[]{string3});
                }
                AuthConstraint authConstraint = string3.getAuthConstraint();
                eList3 = null;
                if (authConstraint != null) {
                    eList3 = authConstraint.getRoles();
                }
                userDataConstraint = string3.getUserDataConstraint();
                object7 = null;
                if (userDataConstraint != null && (bl2 = userDataConstraint.isSetTransportGuarantee())) {
                    object7 = userDataConstraint.getTransportGuarantee().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("transport is set: " + (String)object7));
                    }
                }
                eList4 = string3.getWebResourceCollections();
                object6 = eList4.iterator();
                while (object6.hasNext()) {
                    stringArray2 = (String[])object6.next();
                    eList = stringArray2.getUrlPattern();
                    if (eList == null) continue;
                    object5 = eList.iterator();
                    while (object5.hasNext()) {
                        String string6;
                        stringArray = (String)object5.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("url being processed is: " + (String)stringArray));
                        }
                        if ((object4 = (URLMap)hashMap.get(stringArray)) == null) {
                            object4 = new URLMap((String)stringArray);
                            object3 = hashMap.keySet().iterator();
                            block15: while (object3.hasNext()) {
                                arrayList = (String)object3.next();
                                int n = this.urlType((String)((Object)arrayList));
                                switch (this.urlType((String)stringArray)) {
                                    case 0: {
                                        if (n == 1 || n == 2 && this.urlPatternMatch((String)stringArray, (String)((Object)arrayList))) {
                                            ((URLMap)object4).appendURLPattern((String)((Object)arrayList));
                                            continue block15;
                                        }
                                        if (n != 3) continue block15;
                                        ((URLMap)hashMap.get(arrayList)).appendURLPattern((String)stringArray);
                                        continue block15;
                                    }
                                    case 1: {
                                        if ((n == 1 || n == 2) && this.urlPatternMatch((String)stringArray, (String)((Object)arrayList))) {
                                            ((URLMap)object4).appendURLPattern((String)((Object)arrayList));
                                            continue block15;
                                        }
                                        if (n == 1 && this.urlPatternMatch((String)((Object)arrayList), (String)stringArray)) {
                                            ((URLMap)hashMap.get(arrayList)).appendURLPattern((String)stringArray);
                                            continue block15;
                                        }
                                        if (n != 0 && n != 3) continue block15;
                                        ((URLMap)hashMap.get(arrayList)).appendURLPattern((String)stringArray);
                                        continue block15;
                                    }
                                    case 2: {
                                        if ((n == 0 || n == 1) && this.urlPatternMatch((String)((Object)arrayList), (String)stringArray)) {
                                            ((URLMap)hashMap.get(arrayList)).appendURLPattern((String)stringArray);
                                            continue block15;
                                        }
                                        if (n != 3) continue block15;
                                        ((URLMap)hashMap.get(arrayList)).appendURLPattern((String)stringArray);
                                        continue block15;
                                    }
                                    case 3: {
                                        if (n == 3) continue block15;
                                        ((URLMap)object4).appendURLPattern((String)((Object)arrayList));
                                        continue block15;
                                    }
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("full urlPattern is : " + ((URLMap)object4).getURLPattern()));
                            }
                            hashMap.put(stringArray, object4);
                        }
                        object3 = stringArray2.getHttpMethod();
                        arrayList = new ArrayList();
                        if (object3 != null && object3.size() > 0) {
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                object = (HTTPMethodTypeEnum)object2.next();
                                string6 = object.getName();
                                arrayList.add(string6);
                            }
                        } else {
                            object2 = ((URLMap)object4).getAllMethods();
                            arrayList = new ArrayList<String>(Arrays.asList(object2));
                        }
                        if (authConstraint != null && (eList3 == null || eList3.size() < 1)) {
                            ((URLMap)object4).setExcludedSet(arrayList);
                        } else if (authConstraint == null) {
                            ((URLMap)object4).setUncheckedSet(arrayList);
                        } else if (eList3 != null && eList3 != null) {
                            object2 = eList3.iterator();
                            while (object2.hasNext()) {
                                object = (String)object2.next();
                                if (((String)object).equals("*")) {
                                    string6 = webApp.getSecurityRoles();
                                    if (string6 == null) continue;
                                    Iterator iterator = string6.iterator();
                                    while (iterator.hasNext()) {
                                        String string7 = ((SecurityRole)iterator.next()).getRoleName();
                                        ((URLMap)object4).setRoleMap(string7, arrayList);
                                    }
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Setting role map for role = " + (String)object));
                                }
                                ((URLMap)object4).setRoleMap((String)object, arrayList);
                            }
                        }
                        if (object7 == null) continue;
                        ((URLMap)object4).setUserDataMap((String)object7, arrayList);
                    }
                }
            }
        }
        object8 = hashMap.keySet().iterator();
        boolean bl3 = false;
        while (object8.hasNext()) {
            String string8 = (String)object8.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("url is: " + string8));
            }
            if (this.unqualified(string8, (String)(object6 = ((URLMap)(object7 = (URLMap)hashMap.get(string8))).getURLPattern()))) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("url: " + string8 + " is unqualified"));
                continue;
            }
            stringArray2 = ((URLMap)object7).getExcludedArray();
            if (stringArray2 != null) {
                permissions3.add((Permission)new WebResourcePermission((String)object6, stringArray2));
                permissions3.add((Permission)new WebUserDataPermission((String)object6, stringArray2, null));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"excluded list is null");
            }
            eList = ((URLMap)object7).getUncheckedArray();
            if (eList != null) {
                permissions2.add((Permission)new WebResourcePermission((String)object6, (String[])eList));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unchecked list is null");
            }
            object5 = ((URLMap)object7).getUserDataArray();
            if (object5 != null) {
                permissions2.add((Permission)new WebUserDataPermission((String)object6, (String[])object5, "CONFIDENTIAL"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"methodarray for user data is null");
            }
            stringArray = ((URLMap)object7).getUnchkDataConstraintArray();
            if (stringArray != null) {
                permissions2.add((Permission)new WebUserDataPermission((String)object6, stringArray, "NONE"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"methodarray for unchecked user data is null");
            }
            object4 = ((URLMap)object7).getRoleMap();
            object3 = ((HashMap)object4).keySet().iterator();
            while (object3.hasNext()) {
                arrayList = (String)object3.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("role is " + arrayList));
                }
                if ((object2 = (ArrayList)((HashMap)object4).get(arrayList)) != null && ((ArrayList)object2).size() > 0) {
                    object = new WebResourcePermission((String)object6, ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]));
                    policyConfiguration2.addToRole(arrayList, (Permission)object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added the role: " + arrayList + " to the permission " + object));
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"methodarray for role is null");
            }
        }
        policyConfiguration2.addToExcludedPolicy((PermissionCollection)permissions3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added the following ExcludedPerms:" + permissions3));
        }
        policyConfiguration2.addToUncheckedPolicy((PermissionCollection)permissions2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added the following UncheckedPerms:" + permissions2));
        }
        this.linkConfiguration(string, policyConfiguration2, policyConfiguration);
        policyConfiguration2.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addWebPermissions");
        }
    }

    public void linkConfiguration(String string, PolicyConfiguration policyConfiguration, PolicyConfiguration policyConfiguration2) throws PolicyContextException {
        if (policyConfiguration2 == null) {
            if (pcConfigsMap.containsKey(string)) {
                PolicyConfiguration policyConfiguration3 = (PolicyConfiguration)pcConfigsMap.get(string);
                policyConfiguration.linkConfiguration(policyConfiguration3);
            } else {
                pcConfigsMap.put(string, policyConfiguration);
            }
        } else {
            policyConfiguration.linkConfiguration(policyConfiguration2);
        }
    }

    public PolicyConfiguration getPolicyConfiguration(String string, String string2, String string3, boolean bl, boolean bl2) {
        PolicyConfiguration policyConfiguration = null;
        String string4 = this.getModuleContextID(string3, string);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf != null) {
                policyConfiguration = pcf.getPolicyConfiguration(string4, bl2);
            }
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.getPolicyConfiguration", (String)"983", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf", (Object)new Object[]{string4, policyContextException});
            pcf = null;
            policyConfiguration = null;
        }
        return policyConfiguration;
    }

    public void deleteModule(ModuleRef moduleRef, String string, String string2, boolean bl) throws Exception {
        String string3 = moduleRef.getUri();
        this.deleteModule(string3, string, string2, bl);
    }

    public void deleteModule(String string, String string2, String string3, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteModule", (Object)new Object[]{string, string2, string3});
        }
        PolicyConfiguration policyConfiguration = null;
        String string4 = this.getModuleContextID(string3, string);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf == null) {
                throw new Exception("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            policyConfiguration = pcf.getPolicyConfiguration(string4, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.addWebPermissions", (String)"930", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf", (Object)new Object[]{string4, classNotFoundException});
            pcf = null;
            policyConfiguration = null;
            throw new Exception("Failed to get the PolicyConfiguration object", classNotFoundException);
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, (String)"com.ibm.ws.security.authorize.AppInstallNotify.addWebPermissions", (String)"936", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf", (Object)new Object[]{string4, policyContextException});
            pcf = null;
            policyConfiguration = null;
            throw new Exception("Failed to get the PolicyConfiguration object", policyContextException);
        }
        if (policyConfiguration == null) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.pcf.null", (Object)new Object[]{string4});
            throw new Exception("The PolicyConfiguration object is null");
        }
        policyConfiguration.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteModule");
        }
    }

    private Permissions getEJBPermCollection(EList eList) {
        Permissions permissions = new Permissions();
        if (eList != null && eList.size() > 0) {
            for (int i = 0; i < eList.size(); ++i) {
                Object object;
                MethodElement methodElement = (MethodElement)eList.get(i);
                String string = methodElement.getEnterpriseBean().getName();
                String string2 = methodElement.getName();
                int n = methodElement.getType().getValue();
                String string3 = methodElement.getType().getName();
                if (string2.equals("*")) {
                    string2 = null;
                }
                if (string3 != null && string3.equals("Unspecified")) {
                    string3 = null;
                }
                String[] stringArray = null;
                if (methodElement.hasMethodParams() && (object = methodElement.getMethodParams()) != null) {
                    stringArray = object.toArray(new String[object.size()]);
                }
                if (tc.isDebugEnabled()) {
                    object = new StringBuffer("addingEJBPermCollection: ejbName = ");
                    ((StringBuffer)object).append(string).append(", methodName = ").append(string2).append(", methodInfName = ").append(string3).append(", paramArray = ").append(stringArray);
                    Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
                }
                object = new EJBMethodPermission(string, string2, string3, stringArray);
                permissions.add((Permission)object);
            }
        } else {
            permissions = null;
        }
        return permissions;
    }

    private int urlType(String string) {
        String string2 = string.toString();
        if (string2.startsWith("*.")) {
            return 0;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            return 1;
        }
        if (string2.equals("/")) {
            return 3;
        }
        return 2;
    }

    private boolean urlPatternMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string.equals("/*")) {
            return true;
        }
        if (string.startsWith("/") && string.endsWith("/*")) {
            String string3 = string.substring(0, string.length() - 2);
            int n = string3.length();
            if (string2.startsWith(string3) && (string2.length() == n || string2.charAt(n + 1) == '/')) {
                return true;
            }
        }
        if (string.startsWith("*.") && string2.endsWith(string.substring(1))) {
            return true;
        }
        return string.equals("/");
    }

    private boolean unqualified(String string, String string2) {
        boolean bl = false;
        if (string2.indexOf(":") != -1) {
            int n = string2.indexOf(":");
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1), ":");
            while (stringTokenizer.hasMoreTokens()) {
                if (!this.urlPatternMatch(stringTokenizer.nextToken(), string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String getModuleContextID(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("/").append(string2);
            string3 = stringBuffer.toString();
        } else {
            string3 = string2;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthorizationProvider getAuthorizationProvider() throws WorkSpaceException {
        block16: {
            WorkSpace workSpace;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"getAuthorizationProvider");
                }
                workSpace = null;
                Resource resource = null;
                try {
                    block15: {
                        try {
                            RepositoryContext repositoryContext;
                            String string = "" + System.currentTimeMillis();
                            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
                            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
                            URI uRI = URI.createURI((String)"security.xml");
                            Collection collection = workSpace.findContext(repositoryContextType);
                            Security security = null;
                            Iterator iterator = collection.iterator();
                            if (iterator.hasNext()) {
                                repositoryContext = (RepositoryContext)iterator.next();
                                resource = repositoryContext.getResourceSet().createResource(uRI);
                                HashMap hashMap = new HashMap();
                                resource.load(hashMap);
                                security = (Security)resource.getContents().get(0);
                            }
                            repositoryContext = null;
                            if (security != null) {
                                repositoryContext = security.getAuthConfig();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("authorization config in local mode is: " + repositoryContext));
                            }
                            if (repositoryContext != null) {
                                authzProvider = (AuthorizationProvider)repositoryContext.getAuthorizationProviders().get(0);
                            }
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug((TraceComponent)tc, (String)("authorization provider in local mode is: " + authzProvider));
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authorize.AppInstallNotify.getLocalPCFName", (String)"1211", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.jacc.tools.authzprovider.error", (Object)new Object[]{exception});
                            Object var12_13 = null;
                            if (resource != null) {
                                resource.unload();
                                resource = null;
                            }
                            if (workSpace != null) {
                                String string = workSpace.getUserName();
                                WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
                            }
                            break block16;
                        }
                    }
                    Object var12_12 = null;
                    if (resource == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (resource != null) {
                        resource.unload();
                        resource = null;
                    }
                    if (workSpace != null) {
                        String string = workSpace.getUserName();
                        WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
                    }
                    throw throwable;
                }
                resource.unload();
                resource = null;
            }
            if (workSpace != null) {
                String string = workSpace.getUserName();
                WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthorizationProvider");
        }
        return authzProvider;
    }

    private String getLocalPCFName() throws WorkSpaceException {
        String string = null;
        if (authzProvider == null) {
            authzProvider = this.getAuthorizationProvider();
        }
        if (authzProvider != null) {
            string = authzProvider.getPolicyConfigurationFactoryImplClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("PolicyConfigurationFactory in localMode is: " + string));
        }
        return string;
    }

    private String getLocalRCFName() throws WorkSpaceException {
        String string = null;
        if (authzProvider == null) {
            authzProvider = this.getAuthorizationProvider();
        }
        if (authzProvider != null) {
            string = authzProvider.getRoleConfigurationFactoryImplClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RoleConfigurationFactory in localMode is: " + string));
        }
        return string;
    }

    private Policy getLocalPolicy() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalPolicy");
        }
        if (jPolicy == null) {
            String string = System.getProperty("javax.security.jacc.policy.provider");
            if (string == null) {
                if (authzProvider == null) {
                    authzProvider = this.getAuthorizationProvider();
                }
                if (authzProvider != null) {
                    string = authzProvider.getJ2eePolicyImplClassName();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("PolicyName in local mode is: " + string));
                }
            }
            if (string != null) {
                Policy.setPolicy((Policy)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance());
                jPolicy = Policy.getPolicy();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalPolicy");
        }
        return jPolicy;
    }
}

