/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.wsspi.security.auth.callback.WSManagedConnectionFactoryCallback;
import com.ibm.wsspi.security.auth.callback.WSMappingPropertiesCallback;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSPrincipalMappingLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register((Class)WSPrincipalMappingLoginModule.class, null, (String)"com.ibm.ejs.resources.security");
    private Subject wspm_subject;
    private CallbackHandler wspm_callbackHandler;
    private Map wspm_sharedState;
    private Map wspm_options;
    private boolean wspm_debug = false;
    private boolean wspm_succeeded = false;
    private boolean wspm_commitSucceeded = false;
    private WSPrincipalImpl wspm_principal = null;
    private PasswordCredential wspm_passwordCredential = null;
    private Map wspm_properties;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("getPasswordCredential");
    private static boolean isFineGrained = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize()");
        }
        this.wspm_subject = subject;
        this.wspm_callbackHandler = callbackHandler;
        this.wspm_sharedState = map;
        this.wspm_options = map2;
        this.wspm_debug = "true".equalsIgnoreCase((String)this.wspm_options.get("debug"));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize()");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        if (this.wspm_commitSucceeded) {
            this.logout();
        }
        this.wspm_succeeded = false;
        Callback[] callbackArray = new Callback[]{new WSManagedConnectionFactoryCallback("Target ManagedConnectionFactory: "), new WSMappingPropertiesCallback("Mapping Properties (HashMap): ")};
        try {
            this.wspm_callbackHandler.handle(callbackArray);
            String string = null;
            String string2 = null;
            String string3 = null;
            this.wspm_properties = ((WSMappingPropertiesCallback)callbackArray[1]).getProperties();
            if (this.wspm_properties == null) {
                Tr.warning((TraceComponent)tc, (String)"security.j2c.missingParameter", (Object)new Object[]{"properties HashMap"});
            } else {
                string3 = (String)this.wspm_properties.get("com.ibm.mapping.authDataAlias");
                if (string3 == null) {
                    Tr.warning((TraceComponent)tc, (String)"security.j2c.missingParameter", (Object)new Object[]{"alias"});
                } else {
                    string3 = string3.trim();
                }
            }
            if (string3 != null) {
                Properties properties;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (!isFineGrained) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                            Tr.debug((TraceComponent)tc, (String)("Expecting : " + perm.toString()));
                        }
                        securityManager.checkPermission((Permission)perm);
                    } else {
                        properties = new WebSphereRuntimePermission("getPasswordCredential." + string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check (Fine Grained) ...");
                            Tr.debug((TraceComponent)tc, (String)("Expecting : " + properties.toString()));
                        }
                        securityManager.checkPermission((Permission)((Object)properties));
                    }
                }
                if ((properties = SecurityConfig.getConfig().getAuthData(string3)) != null) {
                    string = properties.getProperty("username");
                    String string4 = properties.getProperty("password");
                    String string5 = PasswordUtil.passwordDecode((String)string4);
                    String string6 = string2 = string5 == null ? string4 : string5;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)((string5 == null ? "Original" : "Decoded") + " version of the password is used"));
                    }
                    ManagedConnectionFactory managedConnectionFactory = ((WSManagedConnectionFactoryCallback)callbackArray[0]).getManagedConnectionFacotry();
                    this.wspm_passwordCredential = new PasswordCredential(string, string2.toCharArray());
                    this.wspm_passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
                    WSCredential wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
                    String string7 = null;
                    if (wSCredential != null && !wSCredential.isUnauthenticated()) {
                        string7 = wSCredential.getSecurityName();
                    }
                    this.wspm_principal = new WSPrincipalImpl(string7);
                    this.wspm_succeeded = true;
                }
            }
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", (String)"128", (Object)this);
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication " + "information from the user");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", (String)"135", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"security.j2c.unexpectedIOException", (Object)new Object[]{iOException});
            throw new LoginException("Error: " + iOException.toString());
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", (String)"164", (Object)this);
            throw new LoginException("Error: " + wSSecurityException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return this.wspm_succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        if (!this.wspm_succeeded) {
            return this.wspm_succeeded;
        }
        if (this.wspm_principal != null) {
            Set<Principal> set = this.wspm_subject.getPrincipals();
            if (!set.contains(this.wspm_principal)) {
                set.add((Principal)this.wspm_principal);
            }
            if (!this.wspm_subject.getPrivateCredentials().contains(this.wspm_passwordCredential)) {
                this.wspm_subject.getPrivateCredentials().add(this.wspm_passwordCredential);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        this.wspm_commitSucceeded = true;
        return this.wspm_commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (!this.wspm_succeeded) {
            return false;
        }
        if (!this.wspm_commitSucceeded) {
            this.wspm_succeeded = false;
            this.wspm_principal = null;
            this.wspm_passwordCredential = null;
        } else {
            this.logout();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return this.wspm_succeeded;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        Set<Principal> set = this.wspm_subject.getPrincipals();
        set.remove(this.wspm_principal);
        this.wspm_subject.getPrivateCredentials().remove(this.wspm_passwordCredential);
        this.wspm_principal = null;
        this.wspm_passwordCredential = null;
        this.wspm_succeeded = false;
        this.wspm_commitSucceeded = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    static {
        Boolean bl = Boolean.TRUE;
        try {
            bl = (Boolean)SecurityConfig.getConfig().getValue("security.enforceFineGrainedJCASecurity");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl != null) {
            isFineGrained = bl;
        }
        if (tc.isDebugEnabled()) {
            if (isFineGrained) {
                Tr.debug((TraceComponent)tc, (String)"Enforce Fine Grained Java 2 Security Permission Check");
            } else {
                Tr.debug((TraceComponent)tc, (String)"Enforce Java 2 Security Permission Check");
            }
        }
    }
}

