/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.zOSContextManagerImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.ContextManagerPlatformInterface;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public final class WSLocalzOSExtensionImpl
implements WSLoginLocalOSExtension {
    private static final TraceComponent tc = Tr.register((Class)WSLocalzOSExtensionImpl.class, (String)"Security", null);
    private ContextManagerPlatformInterface _contextManager = null;
    private boolean _isSyncEnabled = false;
    private boolean _isAppSyncEnabled = false;
    private boolean _serverSecurityEnabled = false;
    private ComponentMetaDataAccessorImpl _cmda = null;

    public WSLocalzOSExtensionImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this._contextManager = (ContextManagerPlatformInterface)ContextManagerFactory.getInstance();
        this._isSyncEnabled = ((zOSContextManagerImpl)this._contextManager).isSynctoThreadEnabled();
        this._isAppSyncEnabled = ((zOSContextManagerImpl)this._contextManager).isApplicationSyncToOSThreadEnabled();
        this._serverSecurityEnabled = this._contextManager.isServerSecurityEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public Subject getLocalOSInvocationSubject() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalOSInvocationSubject");
        }
        Subject subject = null;
        if (this._serverSecurityEnabled) {
            try {
                subject = this._contextManager.getInvocationSubject();
                if (subject == null) {
                    subject = this._contextManager.getCallerSubject();
                }
            }
            catch (WSSecurityException wSSecurityException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception acquring invocation subject", (Object)((Object)wSSecurityException));
                }
                IllegalStateException illegalStateException = new IllegalStateException(wSSecurityException.getMessage());
                illegalStateException.initCause(wSSecurityException);
                throw illegalStateException;
            }
        }
        if (subject == null) {
            subject = this.getLocalOSOwnSubject();
        } else {
            try {
                subject = this.extractJ2CSubject(subject);
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException("Failure using input subject");
                illegalStateException.initCause(exception);
                Tr.event((TraceComponent)tc, (String)"Failure using input subject", (Object)illegalStateException);
                throw illegalStateException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalOSInvocationSubject", (Object)subject);
        }
        return subject;
    }

    private Subject extractJ2CSubject(Subject subject) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractJ2CSubject", (Object)subject);
        }
        Subject subject2 = null;
        if (subject != null) {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            if (wSCredential == null) {
                throw new IllegalArgumentException("Subject did not contain a WSCredential");
            }
            PlatformCredential platformCredential = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
            if (platformCredential == null) {
                PlatformCredentialManager platformCredentialManager = PlatformCredentialManager.instance();
                platformCredential = platformCredentialManager.createDefaultCredential();
            }
            try {
                subject2 = platformCredential.getJ2CSubject();
            }
            catch (RemoteException remoteException) {
                throw new CredentialDestroyedException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractJ2CSubject", subject2);
        }
        return subject2;
    }

    public synchronized Subject getLocalOSOwnSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalOSOwnSubject");
        }
        Subject subject = this._contextManager.getLocalOSServerSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalOSOwnSubject", (Object)subject);
        }
        return subject;
    }

    public Object setLocalOSThreadID(Subject subject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLocalOSThreadID", (Object)subject);
        }
        Object object = this.setLocalOSThreadID(subject, this._isSyncEnabled || this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLocalOSThreadID", (Object)object);
        }
        return object;
    }

    public Object setAppLocalOSThreadID(Subject subject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAppLocalOSThreadID", (Object)subject);
        }
        Object object = this.setLocalOSThreadID(subject, this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAppLocalOSThreadID", (Object)object);
        }
        return object;
    }

    private Object setLocalOSThreadID(Subject subject, boolean bl) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setlocalOSThreadID", (Object)new Object[]{subject, new Boolean(bl)});
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject is null");
        }
        PlatformCredential platformCredential = (PlatformCredential)((zOSContextManagerImpl)this._contextManager).getThreadCredential();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"currentCred", (Object)platformCredential);
        }
        if (platformCredential == null) {
            throw new IllegalStateException("Current thread PlatformCredential is null");
        }
        if (bl) {
            PlatformCredential platformCredential2 = this.getPlatformCredentialFromSubject(subject);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"targetCred", (Object)platformCredential2);
            }
            if (platformCredential2 != null && !platformCredential2.equals(platformCredential)) {
                try {
                    PlatformCredentialManager.instance().setOSThreadSecurityEnvironment(platformCredential2);
                }
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception from setOSThreadSecurityEnvironment", (Object)exception);
                    throw new IllegalStateException("Unexpected exception from setOSThreadSecurityEnvironment");
                }
                ((zOSContextManagerImpl)this._contextManager).setThreadCredential(platformCredential2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLocalOSThreadID", (Object)platformCredential);
        }
        return platformCredential;
    }

    public void restoreLocalOSThreadID(Object object) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreLocalOSThreadID", (Object)object);
        }
        this.restoreLocalOSThreadID(object, this._isSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreLocalOSThreadID");
        }
    }

    public void restoreAppLocalOSThreadID(Object object) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreAppLocalOSThreadID", (Object)object);
        }
        this.restoreLocalOSThreadID(object, this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreAppLocalOSThreadID");
        }
    }

    public void restoreLocalOSThreadID(Object object, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreLocalOSThreadID", (Object)new Object[]{object, new Boolean(bl)});
        }
        if (bl) {
            if (object == null) {
                throw new NullPointerException("null credential is not valid");
            }
            if (!(object instanceof PlatformCredential)) {
                throw new IllegalArgumentException("Credential is not a PlatformCredential");
            }
            PlatformCredential platformCredential = (PlatformCredential)object;
            PlatformCredential platformCredential2 = (PlatformCredential)((zOSContextManagerImpl)this._contextManager).getThreadCredential();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"currentCred", (Object)platformCredential2);
            }
            if (platformCredential2 == null) {
                throw new IllegalStateException("Current thread PlatformCredential is null");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"targetCred", (Object)platformCredential);
            }
            if (!platformCredential.equals(platformCredential2)) {
                try {
                    PlatformCredentialManager.instance().setOSThreadSecurityEnvironment(platformCredential);
                }
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception from setOSThreadSecurityEnvironment", (Object)exception);
                    throw new IllegalStateException("Unexpected exception from setOSThreadSecurityEnvironment");
                }
                ((zOSContextManagerImpl)this._contextManager).setThreadCredential(platformCredential);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreLocalOSThreadID");
        }
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCredential;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getPlatformCredentialFromSubject", (Object)subject);
            }
            platformCredential = null;
            Iterator iterator = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (iterator.hasNext()) {
                platformCredential = (PlatformCredential)iterator.next();
            }
            if (platformCredential == null) {
                WSCredential wSCredential = null;
                Iterator iterator2 = subject.getPublicCredentials(WSCredential.class).iterator();
                if (iterator2.hasNext()) {
                    wSCredential = (WSCredential)iterator2.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSCredential", (Object)wSCredential);
                }
                if (wSCredential != null) {
                    try {
                        platformCredential = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug((TraceComponent)tc, (String)"Unexpected exception acquiring platform cred", (Object)exception);
                    }
                }
            }
        }
        if (platformCredential == null) {
            platformCredential = PlatformCredentialManager.instance().createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPlatformCredentialFromSubject", (Object)platformCredential);
        }
        return platformCredential;
    }

    public boolean isSyncToThreadEnabled() {
        return this._isSyncEnabled;
    }

    public boolean isApplicationSyncToOSThreadEnabled() {
        return this._isAppSyncEnabled;
    }

    public boolean isThreadLocalApplicationSyncEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isThreadLocalApplicationSyncEnabled");
        }
        boolean bl = this._contextManager.isThreadLocalApplicationSyncEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isThreadLocalApplicationSyncEnabled", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setThreadLocalApplicationSyncEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setThreadLocalApplicationSyncEnabled", (Object)new Boolean(bl));
        }
        this._contextManager.setThreadLocalApplicationSyncEnabled(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setThreadLocalApplicationSyncEnabled");
        }
    }

    public boolean getAppSyncEnabledFromComponentMetaData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppSyncEnabledFromComponentMetaData");
        }
        boolean bl = false;
        if (this._isAppSyncEnabled) {
            ComponentMetaData componentMetaData = this.getMetaDataAccessor().getComponentMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"current meta data", (Object)componentMetaData);
            }
            if (componentMetaData != null) {
                if (componentMetaData instanceof EJBComponentMetaData) {
                    EJBComponentMetaData eJBComponentMetaData = (EJBComponentMetaData)componentMetaData;
                    bl = eJBComponentMetaData.isApplicationSyncToOSThreadEnabled();
                } else if (componentMetaData instanceof WebComponentMetaData) {
                    WebComponentMetaData webComponentMetaData = (WebComponentMetaData)componentMetaData;
                    WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)webComponentMetaData.getModuleMetaData();
                    bl = webModuleMetaDataImpl.getWebAppConfig().isSyncToThreadEnabled();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppSyncEnabledFromComponentMetaData", (Object)new Boolean(bl));
        }
        return bl;
    }

    private ComponentMetaDataAccessorImpl getMetaDataAccessor() {
        if (this._cmda == null) {
            this._cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        }
        return this._cmda;
    }

    public String toString() {
        return super.toString() + ";_syncEnabled=" + this._isSyncEnabled + ",_appSyncEnabled=" + this._isAppSyncEnabled;
    }
}

