/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.security.core.SecurityConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class AuditLogger {
    private static final TraceComponent tc = Tr.register((Class)AuditLogger.class, null, (String)"com.ibm.ejs.resources.security");
    public static String fileName = null;
    public static WrappingFileOutputStream wfos = null;
    public static TraceLogger traceLogger = null;
    private static boolean logInited = false;
    private static String osName = null;

    public static WsHandler createAuditLogger() {
        int n = -1;
        if (!logInited) {
            try {
                StringTokenizer stringTokenizer;
                int n2;
                String string;
                String string2 = (String)SecurityConfig.getConfig().getValue("cellname");
                if (string2 == null) {
                    traceLogger = null;
                    return traceLogger;
                }
                String string3 = null;
                String string4 = null;
                String string5 = SecurityConfig.getConfig().toString();
                int n3 = string5.indexOf("maxArchives=");
                if (n3 != -1) {
                    string = string5.substring(n3);
                    n2 = string.indexOf(",");
                    string = string.substring(0, n2);
                    stringTokenizer = new StringTokenizer(string, "=");
                    string = stringTokenizer.nextToken();
                    string4 = string = stringTokenizer.nextToken();
                }
                if ((n3 = string5.indexOf("maxFileSize=")) != -1) {
                    string = string5.substring(n3);
                    n2 = string.indexOf(",");
                    string = string.substring(0, n2);
                    stringTokenizer = new StringTokenizer(string, "=");
                    string = stringTokenizer.nextToken();
                    string3 = string = stringTokenizer.nextToken();
                }
                string = RasHelper.getServerName();
                osName = System.getProperty("os.name");
                if (osName == null) {
                    Tr.info((TraceComponent)tc, (String)"osName was null");
                } else {
                    n = string.lastIndexOf("\\");
                    fileName = n != -1 ? AuditLogger.getDirectoryName() + File.separator + string.substring(n + 1) + File.separator + "AuditLog.log" : AuditLogger.getDirectoryName() + File.separator + string + File.separator + "AuditLog.log";
                }
                wfos = string3 != null && string4 != null ? new WrappingFileOutputStream(fileName, Integer.parseInt(string4), (long)Integer.parseInt(string3)) : new WrappingFileOutputStream(fileName, 10, 0x1400000L);
                logInited = true;
                traceLogger = new TraceLogger((OutputStream)wfos, true);
                wfos.addRolloverListener((LogRolloverListener)traceLogger);
                traceLogger.logRolled();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\n\nThe AuditLog is used for the Security Auditing Tech Preview for WAS V6.0 only.  Refer to the Tech Preview notes for information.\n\n");
                wfos.write(stringBuffer.toString().getBytes());
                return traceLogger;
            }
            catch (RasException rasException) {
                System.out.println("Exception = " + rasException.toString());
                rasException.printStackTrace();
                return null;
            }
            catch (IOException iOException) {
                System.out.println("Exception = " + iOException.toString());
                iOException.printStackTrace();
                return null;
            }
        }
        return traceLogger;
    }

    public static void closeAuditLogger(WsHandler wsHandler) {
        if (wfos == null) {
            return;
        }
        try {
            wfos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        wfos = null;
        if (wsHandler == null) {
            return;
        }
        Tr.removeWsHandler((WsHandler)wsHandler);
    }

    public static void writeBytes(byte[] byArray) {
        try {
            if (wfos == null) {
                Tr.error((TraceComponent)tc, (String)"Error: Audit Log not created");
                return;
            }
            if (byArray == null) {
                Tr.error((TraceComponent)tc, (String)"Error: no bytes to write");
                return;
            }
            wfos.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getDirectoryName() {
        String string = System.getProperty("user.install.root");
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"Error: Could not find WebSphere install root");
            return null;
        }
        if (osName.indexOf("Windows") != -1) {
            string = string.concat("\\logs");
            return string;
        }
        string = string.concat("/logs");
        return string;
    }
}

