/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractSqlParseTreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Expression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ExpressionList;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableExpression
extends AbstractSqlParseTreeNode
implements Expression {
    private static final long serialVersionUID = -8654712096632054051L;
    public static final String AS = " AS ";
    public static final String OPEN = "(";
    public static final String CLOSE = ")";
    public static final String C = "C";
    private String fName;
    private ExpressionList fColumnNames;
    private FullOrSubSelect fFullSelect;

    public TableExpression(String string) {
        this.name(string);
    }

    public TableExpression(String string, FullOrSubSelect fullOrSubSelect) {
        this.name(string);
        this.fullSelect(fullOrSubSelect);
    }

    public void name(String string) {
        this.fName = string;
    }

    public String name() {
        return this.fName;
    }

    public ExpressionList columnNames() {
        if (this.fColumnNames == null) {
            this.fColumnNames = new ExpressionList();
        }
        return this.fColumnNames;
    }

    public boolean hasColumns() {
        return this.fColumnNames != null && !this.fColumnNames.isEmpty();
    }

    public void addColumnName(String string) {
        this.columnNames().add(new SqlIdentifier(string));
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.name());
        if (!this.isOracle() && this.hasColumns()) {
            this.columnNames().evaluateOn(stringBuffer);
        }
        if (this.hasSelect()) {
            stringBuffer.append(AS).append(OPEN);
            this.fullSelect().evaluateOn(stringBuffer);
            stringBuffer.append(CLOSE);
        }
    }

    public void fullSelect(FullOrSubSelect fullOrSubSelect) {
        this.fFullSelect = fullOrSubSelect;
    }

    public FullOrSubSelect fullSelect() {
        return this.fFullSelect;
    }

    public boolean hasSelect() {
        return this.fFullSelect != null;
    }

    public void createNColumns(int n) {
        for (int i = 1; i <= n; ++i) {
            this.addColumnName(this.createName(i));
        }
    }

    public void addColumnsFromProjectionClause() {
        if (!this.hasSelect() || this.isOracle()) {
            return;
        }
        this.createNColumns(this.fullSelect().selectClause().getResultSetElements().size());
    }

    public String createName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(C).append(n);
        return stringBuffer.toString();
    }

    public List toResultSetElements() {
        ArrayList<ColumnName> arrayList = new ArrayList<ColumnName>();
        Iterator iterator = this.columnNames().iterator();
        while (iterator.hasNext()) {
            arrayList.add(new ColumnName((SqlIdentifier)iterator.next()));
        }
        return arrayList;
    }

    public void gatherVariablesInOrderOn(List list) {
        this.fullSelect().gatherVariablesInOrderOn(list);
    }
}

