/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractSqlParseTreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Expression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlIdentifier;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AbstractLiteral
extends AbstractSqlParseTreeNode
implements Expression {
    private static final long serialVersionUID = 6571521391626509578L;
    protected Object literalValue;

    public AbstractLiteral() {
    }

    public AbstractLiteral(Object object) {
        this.value(object);
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isString()) {
            stringBuffer.append("'");
            stringBuffer.append(this.value());
            stringBuffer.append("'");
            return;
        }
        if (this.isInteger()) {
            stringBuffer.append(((Number)this.value()).intValue());
            return;
        }
        if (this.isFloat()) {
            stringBuffer.append(((Number)this.value()).floatValue());
            return;
        }
        if (this.isDouble()) {
            stringBuffer.append(((Number)this.value()).doubleValue());
            return;
        }
        if (this.isBoolean()) {
            stringBuffer.append((Boolean)this.value());
            return;
        }
        if (this.isChar()) {
            stringBuffer.append("'");
            stringBuffer.append(((Character)this.value()).charValue());
            stringBuffer.append("'");
            return;
        }
        stringBuffer.append(this.value());
    }

    public boolean isBoolean() {
        return this.value() instanceof Boolean;
    }

    public boolean isByte() {
        return this.value() instanceof Byte;
    }

    public boolean isChar() {
        return this.value() instanceof Character;
    }

    public boolean isDouble() {
        return this.isNumeric() && this.value() instanceof Double;
    }

    public boolean isFloat() {
        return this.isNumeric() && (this.value() instanceof Float || this.value() instanceof BigDecimal);
    }

    public boolean isInteger() {
        return this.isNumeric() && (this.value() instanceof Integer || this.value() instanceof Short || this.value() instanceof Long || this.value() instanceof BigInteger);
    }

    public boolean isNull() {
        return this.literalValue == null;
    }

    public boolean isNumeric() {
        return this.value() instanceof Number;
    }

    public boolean isString() {
        if (this.isNull()) {
            return false;
        }
        return this.literalValue instanceof String;
    }

    public boolean isSqlIdentifier() {
        return this.literalValue instanceof SqlIdentifier;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        if (this.value() == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.value());
        }
    }

    public Object value() {
        return this.literalValue;
    }

    public void value(Object object) {
        this.literalValue = object;
    }
}

