/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.OrderedSet;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.OrderBy;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.InLinedSelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class WithoutRootSelectBuilder
extends SelectBuilder {
    public WithoutRootSelectBuilder(Metadata metadata, RDBSchema rDBSchema) throws QueryEngineException {
        this.setMetadata(metadata);
        this.setSchema(rDBSchema);
        this.initialize();
    }

    public QueryResultDescriptor createResultDescriptor() {
        OrderedSet orderedSet = new OrderedSet();
        orderedSet.addAll((Collection)this.rootTable().getPrimaryKey().getMembers());
        List list = this.orderByColumnsForRoot();
        if (list != null) {
            orderedSet.addAll((Collection)list);
        }
        return new QueryResultDescriptor(orderedSet, this.getSchema().getNonRootTables(), this.getSchema().root());
    }

    public SelectStatementCreator newSelectStatementCreator() {
        InLinedSelectStatementCreator inLinedSelectStatementCreator = new InLinedSelectStatementCreator();
        inLinedSelectStatementCreator.cteTables(this.getSchema().getTables());
        return inLinedSelectStatementCreator;
    }

    public List orderByColumns() {
        EList eList = this.getMetadata().getOrderBys();
        if (eList.isEmpty()) {
            return null;
        }
        Iterator iterator = eList.iterator();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        while (iterator.hasNext()) {
            OrderBy orderBy = (OrderBy)iterator.next();
            arrayList.add(new Association(this.getSchema().findColumn(orderBy.getColumn()), new Boolean(orderBy.isAscending())));
        }
        return arrayList;
    }

    public List orderByColumnsForRoot() {
        EList eList = this.getMetadata().getOrderBys();
        if (eList.isEmpty()) {
            return null;
        }
        Iterator iterator = eList.iterator();
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        while (iterator.hasNext()) {
            OrderBy orderBy = (OrderBy)iterator.next();
            if (!orderBy.getColumn().getTable().equals(this.rootTable().getWDOTable())) continue;
            arrayList.add(this.getSchema().findColumn(orderBy.getColumn()));
        }
        return arrayList;
    }
}

