/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.Array;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryInputDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryPlan;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QuerySubplan;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.SQLReference;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class QueryBuilder {
    public static final String READ = "read";
    public static final String DELECT = "delete";
    public static final String UPDATE = "update";
    public static final String CREATE = "create";
    private SqlStatement fStatement;
    private QueryResultDescriptor fResultDescriptor;
    private QueryInputDescriptor fInputDescriptor;

    public abstract SqlStatement defaultStatement() throws QueryEngineException;

    public void evaluatQueryOn(StringBuffer stringBuffer, List list, List list2) throws QueryEngineException {
        this.statement().evaluateOn(stringBuffer);
    }

    public List getColumns(SQLReference sQLReference) {
        Iterator iterator = sQLReference.getMembers().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public void initialize() throws QueryEngineException {
        this.statement();
        this.createInputDescriptor();
    }

    public void createInputDescriptor() throws QueryEngineException {
        this.inputDescriptor(new QueryInputDescriptor(this.statement()));
    }

    public QueryInputDescriptor inputDescriptor() {
        return this.fInputDescriptor;
    }

    public void inputDescriptor(QueryInputDescriptor queryInputDescriptor) {
        this.fInputDescriptor = queryInputDescriptor;
    }

    public boolean isDeleteQuery() {
        return false;
    }

    public boolean isInitialized() {
        return this.fStatement != null;
    }

    public boolean isInsertQuery() {
        return false;
    }

    public boolean isSQLJ() {
        return QueryEngineInfo.isSQLJ();
    }

    public boolean isMSSqlServer() {
        return QueryEngineInfo.isSQLServer();
    }

    public boolean isOracle() {
        return QueryEngineInfo.isOracle();
    }

    public boolean isDB2() {
        return QueryEngineInfo.isDB2();
    }

    public boolean isOverqualified() {
        return false;
    }

    public boolean isReadQuery() {
        return false;
    }

    public boolean isSingleTable() throws QueryEngineException {
        return this.statement().isSingleTable();
    }

    public boolean isSelectInto() throws QueryEngineException {
        return false;
    }

    public boolean isUpdateQuery() {
        return false;
    }

    public boolean isUsingColumnNames() {
        return QueryEngineInfo.singleton().useColumnNames();
    }

    public boolean isVerifyQuery() {
        return false;
    }

    public boolean isWriteQuery() {
        return false;
    }

    public String nativeQuery(List list, List list2) throws QueryEngineException {
        StringBuffer stringBuffer = new StringBuffer();
        this.queryOn(stringBuffer, list, list2);
        return stringBuffer.toString();
    }

    public Array newArray(Object[] objectArray) {
        return new Array(objectArray);
    }

    public PredicateWithVariables newSearchCondition() {
        return new PredicateWithVariables();
    }

    public List outputShape() {
        if (this.resultDescriptor() == null) {
            return new ArrayList();
        }
        return this.resultDescriptor().fields();
    }

    public List inputShape() {
        if (this.inputDescriptor() == null) {
            return new ArrayList();
        }
        return this.inputDescriptor().fields();
    }

    public List parmColumns() throws QueryEngineException {
        return this.parmColumnsAllowCopies(true);
    }

    public abstract List parmColumnsAllowCopies(boolean var1) throws QueryEngineException;

    public List predicateColumns() {
        return new ArrayList();
    }

    public String predicateColumnString() {
        return new String();
    }

    public String query() throws QueryEngineException {
        StringBuffer stringBuffer = new StringBuffer();
        this.queryOn(stringBuffer);
        return stringBuffer.toString();
    }

    public String query(List list) throws QueryEngineException {
        StringBuffer stringBuffer = new StringBuffer();
        this.queryOn(stringBuffer, list);
        return stringBuffer.toString();
    }

    public void queryOn(StringBuffer stringBuffer) throws QueryEngineException {
        this.statement().evaluateOn(stringBuffer);
    }

    public void queryOn(StringBuffer stringBuffer, List list) throws QueryEngineException {
        this.statement().evaluateOn(stringBuffer, list);
    }

    public void queryOn(StringBuffer stringBuffer, List list, List list2) throws QueryEngineException {
        this.queryOn(stringBuffer, new ListWrapper(list).concatenate(list2));
    }

    public boolean references(RDBTable rDBTable) throws QueryEngineException {
        return false;
    }

    public void reset() {
    }

    public QueryResultDescriptor resultDescriptor() {
        return this.fResultDescriptor;
    }

    public void resultDescriptor(QueryResultDescriptor queryResultDescriptor) {
        this.fResultDescriptor = queryResultDescriptor;
    }

    public SqlStatement statement() throws QueryEngineException {
        if (this.fStatement == null) {
            this.fStatement = this.defaultStatement();
        }
        return this.fStatement;
    }

    public void statement(SqlStatement sqlStatement) {
        this.fStatement = sqlStatement;
    }

    public List tables() throws QueryEngineException {
        if (this.isInitialized()) {
            return this.statement().tables();
        }
        return new ArrayList();
    }

    public boolean hasForUpdateClause() throws QueryEngineException {
        return false;
    }

    public QueryPlan createPlan() throws QueryEngineException {
        return new QueryPlan(this.createSubplan());
    }

    public QuerySubplan createSubplan() throws QueryEngineException {
        QuerySubplan querySubplan = new QuerySubplan(this.query(), this.queryType());
        querySubplan.setInput(this.inputDescriptor());
        querySubplan.setOutput(this.resultDescriptor());
        return querySubplan;
    }

    public abstract String queryType();

    public boolean isDB2390() {
        return QueryEngineInfo.isDB2() && QueryEngineInfo.isOS390();
    }
}

