/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.websphere.sdo.mediator.jdbc.metadata.Filter;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SubSelectCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableExpression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CTESelectStatementCreator
extends SelectStatementCreator {
    public static final String ROOT_CTE_NAME = "CTE";
    private List fTables;
    private Map fCteNames;
    private int fIndex = 0;
    private List fFilterArguments;

    public List cteTables() {
        return this.fTables;
    }

    public void cteTables(List list) {
        this.fTables = list;
    }

    public Map cteNames() {
        if (this.fCteNames == null) {
            this.fCteNames = new HashMap();
        }
        return this.fCteNames;
    }

    public SelectStatement build() throws QueryEngineException {
        super.build();
        if (this.cteTables().size() == 1) {
            return this.statement();
        }
        this.buildCTEs();
        this.replaceTablesWithCTEs();
        return this.statement();
    }

    public void buildCTEs() {
        Iterator iterator = this.tablesWithFilters().iterator();
        while (iterator.hasNext()) {
            RDBTable rDBTable = (RDBTable)iterator.next();
            SubSelect subSelect = this.buildSingleSelect(rDBTable);
            TableExpression tableExpression = new TableExpression(this.nextCTEName(), subSelect);
            this.statement().addTableExpression(tableExpression);
            this.cteNames().put(rDBTable, tableExpression);
        }
    }

    public String nextCTEName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ROOT_CTE_NAME).append(++this.fIndex);
        return stringBuffer.toString();
    }

    public SubSelect buildSingleSelect(RDBTable rDBTable) {
        SubSelectCreator subSelectCreator = new SubSelectCreator(rDBTable.getColumns());
        subSelectCreator.setSingle();
        subSelectCreator.buildSingleSelect();
        Filter filter = rDBTable.getWDOTable().getFilter();
        if (filter != null) {
            subSelectCreator.statement().addNativeFilter(filter.getPredicate());
            this.filterArguments().addAll(filter.getFilterArguments());
        }
        return subSelectCreator.statement();
    }

    public List filterArguments() {
        if (this.fFilterArguments == null) {
            this.fFilterArguments = new ArrayList();
        }
        return this.fFilterArguments;
    }

    public void replaceTablesWithCTEs() {
        TableExpression tableExpression;
        Iterator iterator = this.statement().select().tableNames().iterator();
        while (iterator.hasNext()) {
            TableName tableName = (TableName)iterator.next();
            tableExpression = (TableExpression)this.cteNames().get(tableName.table());
            if (tableExpression == null) continue;
            tableName.cteName(tableExpression.name());
        }
        iterator = this.statement().select().gatherColumns().iterator();
        while (iterator.hasNext()) {
            ColumnName columnName = (ColumnName)iterator.next();
            tableExpression = (TableExpression)this.cteNames().get(columnName.table());
            if (tableExpression == null) continue;
            columnName.invariantTableAlias(tableExpression.name());
        }
    }

    public List tablesWithFilters() {
        ArrayList<RDBTable> arrayList = new ArrayList<RDBTable>();
        Iterator iterator = this.cteTables().iterator();
        while (iterator.hasNext()) {
            RDBTable rDBTable = (RDBTable)iterator.next();
            if (rDBTable.getWDOTable().getFilter() == null) continue;
            arrayList.add(rDBTable);
        }
        return arrayList;
    }
}

