/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.ResultSetInfo;
import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Key;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.impl.RelationshipImpl;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.PagedGraphInfo;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.GraphBuilderMetadata;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.ResultSetRow;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.TableData;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.TableRegistry;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import commonj.sdo.DataObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResultSetProcessor {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$sdo$mediator$jdbc$graphbuilder$impl$ResultSetProcessor == null ? (class$com$ibm$ws$sdo$mediator$jdbc$graphbuilder$impl$ResultSetProcessor = ResultSetProcessor.class$("com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.ResultSetProcessor")) : class$com$ibm$ws$sdo$mediator$jdbc$graphbuilder$impl$ResultSetProcessor), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private DataObject dataGraph;
    private Metadata metadata;
    private TableRegistry registry;
    static /* synthetic */ Class class$com$ibm$ws$sdo$mediator$jdbc$graphbuilder$impl$ResultSetProcessor;

    public ResultSetProcessor(Metadata metadata, DataObject dataObject) {
        this.metadata = metadata;
        this.dataGraph = dataObject;
        this.registry = new TableRegistry();
    }

    public void process(ResultSet resultSet, ResultSetInfo resultSetInfo, PagedGraphInfo pagedGraphInfo, QueryResultDescriptor queryResultDescriptor, int n, boolean bl) throws SQLException, InvalidMetadataException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"process");
        }
        if (resultSet == null) {
            return;
        }
        boolean bl2 = pagedGraphInfo != null;
        GraphBuilderMetadata graphBuilderMetadata = null;
        graphBuilderMetadata = queryResultDescriptor == null ? new GraphBuilderMetadata(this.metadata, resultSet, resultSetInfo, this.getSchema()) : new GraphBuilderMetadata(queryResultDescriptor, bl2, this.getSchema());
        for (int i = 0; resultSet.next() && i < n; ++i) {
            ResultSetRow resultSetRow = new ResultSetRow(resultSet, graphBuilderMetadata);
            this.processRelationships(resultSetRow, bl, graphBuilderMetadata);
            if (!bl2) continue;
            this.processPageInfo(pagedGraphInfo, i, resultSet);
        }
        resultSet.getStatement().close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"process");
        }
    }

    protected void processPageInfo(PagedGraphInfo pagedGraphInfo, int n, ResultSet resultSet) throws SQLException {
        if (n == 0) {
            pagedGraphInfo.setFirstIndex(resultSet.getInt(1));
        } else {
            pagedGraphInfo.setLastIndex(resultSet.getInt(1));
        }
    }

    private void processRelationships(ResultSetRow resultSetRow, boolean bl, GraphBuilderMetadata graphBuilderMetadata) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processRelationships");
        }
        if ((eList = this.metadata.getRelationships()).size() == 0) {
            this.getSingleTable(resultSetRow, this.metadata.getRootTable(), graphBuilderMetadata);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processRelationships");
            }
            return;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            RelationshipImpl relationshipImpl = (RelationshipImpl)iterator.next();
            Iterator iterator2 = this.getTableDataObjects(resultSetRow, relationshipImpl.getParentPrimaryKey(), bl, graphBuilderMetadata).iterator();
            List list = this.getTableDataObjects(resultSetRow, relationshipImpl.getChildPrimaryKey(), bl, graphBuilderMetadata);
            while (iterator2.hasNext()) {
                DataObject dataObject = (DataObject)iterator2.next();
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    DataObject dataObject2 = (DataObject)iterator3.next();
                    if (!this.checkRelationship(relationshipImpl, dataObject, dataObject2)) continue;
                    if (relationshipImpl.isToMany()) {
                        List list2 = (List)dataObject.get(relationshipImpl.getName());
                        list2.add(dataObject2);
                        continue;
                    }
                    dataObject.set(relationshipImpl.getName(), (Object)dataObject2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processRelationships");
        }
    }

    private boolean checkRelationship(RelationshipImpl relationshipImpl, DataObject dataObject, DataObject dataObject2) {
        if (dataObject == null || dataObject2 == null) {
            return false;
        }
        Iterator iterator = relationshipImpl.getParentKey().getColumns().iterator();
        Iterator iterator2 = relationshipImpl.getChildKey().getColumns().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object object;
            Column column = (Column)iterator.next();
            Column column2 = (Column)iterator2.next();
            Object object2 = dataObject.get(column.getPropertyName());
            if (object2.equals(object = dataObject2.get(column2.getPropertyName()))) continue;
            return false;
        }
        return true;
    }

    private void getSingleTable(ResultSetRow resultSetRow, Table table, GraphBuilderMetadata graphBuilderMetadata) {
        TableData tableData = resultSetRow.getTable(table.getName());
        EObject eObject = this.createAndAddDataObject(tableData);
        for (int i = 0; i < tableData.getSize(); ++i) {
            if (tableData.getColumn(i) == null) continue;
            EStructuralFeature eStructuralFeature = graphBuilderMetadata.getFeature(tableData.getName(), i);
            eObject.eSet(eStructuralFeature, tableData.getColumn(i));
        }
    }

    private DataObject getTable(ResultSetRow resultSetRow, Key key, boolean bl, GraphBuilderMetadata graphBuilderMetadata) {
        EObject eObject;
        Table table;
        TableData tableData;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTable");
        }
        if ((tableData = resultSetRow.getTable((table = key.getTable()).getPropertyName())) == null || !tableData.hasValidPrimaryKey()) {
            return null;
        }
        ArrayList arrayList = tableData.getPrimaryKey();
        if (arrayList == null) {
            return null;
        }
        boolean bl2 = false;
        if (bl && table.getMetadata().getRootTable().equals(table)) {
            bl2 = true;
        }
        if ((eObject = this.registry.get(tableData.getName(), arrayList)) == null && !bl2) {
            eObject = this.createAndAddDataObject(tableData);
            for (int i = 0; i < tableData.getSize(); ++i) {
                if (tableData.getColumn(i) == null) continue;
                EStructuralFeature eStructuralFeature = graphBuilderMetadata.getFeature(tableData.getName(), i);
                eObject.eSet(eStructuralFeature, tableData.getColumn(i));
            }
            this.registry.put(table.getPropertyName(), arrayList, eObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTable");
        }
        return (DataObject)eObject;
    }

    private EObject createAndAddDataObject(TableData tableData) {
        EObject eObject = (EObject)this.dataGraph;
        EReference eReference = tableData.getReference();
        EDataObject eDataObject = SDOUtil.create((EClass)eReference.getEReferenceType());
        ((InternalEList)eObject.eGet((EStructuralFeature)eReference)).addUnique((Object)eDataObject);
        return eDataObject;
    }

    private EClass getSchema() {
        return ((EDataObject)this.dataGraph).eClass();
    }

    private List getTableDataObjects(ResultSetRow resultSetRow, Key key, boolean bl, GraphBuilderMetadata graphBuilderMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTableDataObjects");
        }
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        Table table = key.getTable();
        List list = resultSetRow.getTableByName(table.getPropertyName());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TableData tableData = (TableData)iterator.next();
                DataObject dataObject = this.findTableDataObject(tableData, table, bl, graphBuilderMetadata);
                if (dataObject == null) continue;
                arrayList.add(dataObject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTableDataObjects");
        }
        return arrayList;
    }

    private DataObject findTableDataObject(TableData tableData, Table table, boolean bl, GraphBuilderMetadata graphBuilderMetadata) {
        EObject eObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findTableDataObject");
        }
        if (tableData == null || !tableData.hasValidPrimaryKey()) {
            return null;
        }
        ArrayList arrayList = tableData.getPrimaryKey();
        if (arrayList == null) {
            return null;
        }
        boolean bl2 = false;
        if (bl && table.getMetadata().getRootTable().equals(table)) {
            bl2 = true;
        }
        if ((eObject = this.registry.get(tableData.getName(), arrayList)) == null && !bl2) {
            eObject = this.createAndAddDataObject(tableData);
            for (int i = 0; i < tableData.getSize(); ++i) {
                if (tableData.getColumn(i) == null) continue;
                EStructuralFeature eStructuralFeature = graphBuilderMetadata.getFeature(tableData.getName(), i);
                eObject.eSet(eStructuralFeature, tableData.getColumn(i));
            }
            this.registry.put(table.getPropertyName(), arrayList, eObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findTableDataObject");
        }
        return (DataObject)eObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

