/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Relationship;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.impl.MetadataImpl;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.impl.RelationshipImpl;
import com.ibm.ws.sdo.mediator.jdbc.Create;
import com.ibm.ws.sdo.mediator.jdbc.DataObjectWrapper;
import com.ibm.ws.sdo.mediator.jdbc.Delete;
import com.ibm.ws.sdo.mediator.jdbc.GraphChange;
import com.ibm.ws.sdo.mediator.jdbc.Update;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;
import org.eclipse.emf.ecore.sdo.impl.EChangeSummaryImpl;

public class GraphChanges {
    private List updates;
    private ArrayList inserts;
    private ArrayList deletes;
    private QueryEngine queryEngine;
    private Metadata metadata;
    private EChangeSummaryImpl changeSummary;
    private boolean sortUpdates = true;

    public GraphChanges(Metadata metadata, QueryEngine queryEngine, ChangeSummary changeSummary, boolean bl) throws JDBCMediatorException {
        this.sortUpdates = bl;
        this.metadata = metadata;
        this.queryEngine = queryEngine;
        this.changeSummary = (EChangeSummaryImpl)changeSummary;
        this.updates = new ArrayList();
        this.inserts = new ArrayList();
        this.deletes = new ArrayList();
        this.initialize();
    }

    private void initialize() throws JDBCMediatorException {
        if (this.changeSummary.isLogging()) {
            this.changeSummary.summarize();
        }
        DataObject dataObject = this.changeSummary.getDataGraph().getRootObject();
        Iterator iterator = this.changeSummary.getChangedDataObjects().iterator();
        while (iterator.hasNext()) {
            DataObject dataObject2 = (DataObject)iterator.next();
            if (dataObject2.equals(dataObject)) continue;
            this.createChange(dataObject2);
        }
    }

    public void createChange(DataObject dataObject) throws JDBCMediatorException {
        if (this.changeSummary.isCreated(dataObject)) {
            if (!this.changeSummary.isDeleted(dataObject)) {
                this.inserts.add(dataObject);
            }
        } else if (this.changeSummary.isDeleted(dataObject)) {
            this.deletes.add(dataObject);
        } else if (this.isPersistenceChange(dataObject)) {
            this.bumpCollisionField(dataObject);
            this.updates.add(new Update(this.metadata, this.queryEngine, dataObject));
        }
    }

    private void doInserts() throws JDBCMediatorException {
        if (this.sortUpdates) {
            this.sortInserts();
        }
        Iterator iterator = this.inserts.iterator();
        while (iterator.hasNext()) {
            Create create = new Create(this.metadata, this.queryEngine, (DataObject)iterator.next());
            ((GraphChange)create).applyChange();
        }
    }

    private void doUpdates() throws DBException {
        Iterator iterator = this.updates.iterator();
        while (iterator.hasNext()) {
            GraphChange graphChange = (GraphChange)iterator.next();
            graphChange.applyChange();
        }
    }

    private void doDeletes() throws JDBCMediatorException {
        if (this.sortUpdates) {
            this.sortDeletes();
        }
        Iterator iterator = this.deletes.iterator();
        while (iterator.hasNext()) {
            Delete delete = new Delete(this.metadata, this.queryEngine, (DataObject)iterator.next());
            ((GraphChange)delete).applyChange();
        }
    }

    private void collapseUpdates() {
        DataObjectWrapper dataObjectWrapper;
        DataObject dataObject;
        if (this.deletes.size() == 0 || this.inserts.size() == 0) {
            return;
        }
        HashMap<ArrayList, DataObject> hashMap = new HashMap<ArrayList, DataObject>();
        Iterator iterator = this.deletes.iterator();
        while (iterator.hasNext()) {
            dataObject = (DataObject)iterator.next();
            dataObjectWrapper = new DataObjectWrapper(this.metadata, dataObject);
            hashMap.put(dataObjectWrapper.getPrimaryKeyValue(), dataObject);
        }
        iterator = ((List)this.inserts.clone()).iterator();
        while (iterator.hasNext()) {
            dataObject = (DataObject)iterator.next();
            dataObjectWrapper = new DataObjectWrapper(this.metadata, dataObject);
            DataObject dataObject2 = (DataObject)hashMap.remove(dataObjectWrapper.getPrimaryKeyValue());
            if (dataObject2 == null) continue;
            this.deletes.remove(dataObject2);
            this.inserts.remove(dataObject);
            if (dataObjectWrapper.hasCollisionColumn()) {
                String string = dataObjectWrapper.getCollisionColumn().getPropertyName();
                DataObjectWrapper dataObjectWrapper2 = new DataObjectWrapper(this.metadata, dataObject2);
                dataObject.setInt(string, dataObjectWrapper2.getCollisionColumnValue() + 1);
            }
            this.updates.add(new Update(this.metadata, this.queryEngine, dataObject));
        }
    }

    public void applyChanges() throws JDBCMediatorException {
        if (this.sortUpdates) {
            this.collapseUpdates();
        }
        this.doInserts();
        this.doUpdates();
        this.doDeletes();
        if (this.changeSummary.isLogging()) {
            this.changeSummary.endLogging();
        }
        this.changeSummary.beginLogging();
    }

    private void sortInserts() throws JDBCMediatorException {
        ArrayList arrayList = new ArrayList();
        while (this.inserts.size() > 0) {
            arrayList.addAll(this.removeCreateTree((DataObject)this.inserts.get(0)));
        }
        this.inserts = arrayList;
    }

    private ArrayList removeCreateTreeList(List list) throws JDBCMediatorException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            arrayList.addAll(this.removeCreateTree(dataObject));
        }
        return arrayList;
    }

    private ArrayList removeCreateTree(DataObject dataObject) throws JDBCMediatorException {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        if (dataObject != null && this.inserts.contains(dataObject)) {
            this.inserts.remove(dataObject);
            EObject eObject = (EObject)dataObject;
            Iterator iterator = eObject.eClass().getEAllReferences().iterator();
            while (iterator.hasNext()) {
                EReference eReference = (EReference)iterator.next();
                Relationship relationship = ((MetadataImpl)this.metadata).getRelationship(eReference);
                if (relationship == null || this.isParent(relationship, eReference.getName())) continue;
                if (eReference.getUpperBound() == -1) {
                    arrayList.addAll(this.removeCreateTreeList(dataObject.getList(eReference.getName())));
                    continue;
                }
                arrayList.addAll(this.removeCreateTree((DataObject)dataObject.get(eReference.getName())));
            }
            arrayList.add(eObject);
        }
        return arrayList;
    }

    private void sortDeletes() throws JDBCMediatorException {
        ArrayList arrayList = new ArrayList();
        while (this.deletes.size() > 0) {
            arrayList.addAll(this.sortDeleteTree((DataObject)this.deletes.get(0)));
        }
        this.deletes = arrayList;
    }

    private ArrayList sortDeleteTreeList(List list) throws JDBCMediatorException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            arrayList.addAll(this.sortDeleteTree(dataObject));
        }
        return arrayList;
    }

    private List sortDeleteTree(DataObject dataObject) throws JDBCMediatorException {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        if (dataObject != null && this.deletes.contains(dataObject)) {
            this.deletes.remove(dataObject);
            List list = this.changeSummary.getOldValues(dataObject);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EReference eReference;
                RelationshipImpl relationshipImpl;
                EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)iterator.next();
                if (eChangeSummarySetting.getFeature() instanceof EAttribute || (relationshipImpl = (RelationshipImpl)((MetadataImpl)this.metadata).getRelationship(eReference = (EReference)eChangeSummarySetting.getFeature())) == null || !this.isParent(relationshipImpl, eReference.getName())) continue;
                if (relationshipImpl.isToMany()) {
                    arrayList.addAll(this.sortDeleteTreeList((List)eChangeSummarySetting.getValue()));
                    continue;
                }
                arrayList.addAll(this.sortDeleteTree((DataObject)eChangeSummarySetting.getValue()));
            }
            arrayList.add(dataObject);
        }
        return arrayList;
    }

    private boolean isPersistenceChange(DataObject dataObject) throws JDBCMediatorException {
        return !this.isAllParentRefChanges(dataObject);
    }

    private boolean isAllParentRefChanges(DataObject dataObject) throws JDBCMediatorException {
        Iterator iterator = this.changeSummary.getOldValues(dataObject).iterator();
        while (iterator.hasNext()) {
            EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)iterator.next();
            if (eChangeSummarySetting.getFeature() instanceof EAttribute) {
                return false;
            }
            EReference eReference = (EReference)eChangeSummarySetting.getFeature();
            RelationshipImpl relationshipImpl = (RelationshipImpl)((MetadataImpl)this.metadata).getRelationship(eReference);
            if (!relationshipImpl.isToMany() || !this.isChild(relationshipImpl, eReference.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isParent(Relationship relationship, String string) throws JDBCMediatorException {
        if (relationship.getName().equals(string)) {
            return true;
        }
        if (relationship.getOppositeName().equals(string)) {
            return false;
        }
        throw new JDBCMediatorException("No match on relationship name" + string);
    }

    private boolean isChild(Relationship relationship, String string) throws JDBCMediatorException {
        return !this.isParent(relationship, string);
    }

    private void bumpCollisionField(DataObject dataObject) {
        DataObjectWrapper dataObjectWrapper = new DataObjectWrapper(this.metadata, dataObject);
        Column column = dataObjectWrapper.getCollisionColumn();
        if (column != null) {
            int n = dataObject.getInt(column.getPropertyName()) + 1;
            dataObject.setInt(column.getPropertyName(), n);
        }
    }
}

