/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResult;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;

public abstract class GraphChange {
    protected Metadata metadata;
    protected QueryEngine queryEngine;
    protected DataObject dataObject;
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$sdo$mediator$jdbc$GraphChange == null ? (class$com$ibm$ws$sdo$mediator$jdbc$GraphChange = GraphChange.class$("com.ibm.ws.sdo.mediator.jdbc.GraphChange")) : class$com$ibm$ws$sdo$mediator$jdbc$GraphChange), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    static /* synthetic */ Class class$com$ibm$ws$sdo$mediator$jdbc$GraphChange;

    public GraphChange(Metadata metadata, QueryEngine queryEngine, DataObject dataObject) {
        this.metadata = metadata;
        this.queryEngine = queryEngine;
        this.dataObject = dataObject;
    }

    protected void checkException(QueryResult queryResult, String string) throws DBException {
        if (queryResult.hasException()) {
            QueryEngineException queryEngineException = queryResult.getException();
            Tr.debug((TraceComponent)tc, (String)"Query Engine Exception: {0}", (Object)queryEngineException);
            throw new DBException("Exception in QueryEngine " + string, queryEngineException);
        }
    }

    public abstract void applyChange() throws DBException;

    public abstract boolean isInsert();

    public abstract boolean isUpdate();

    public abstract boolean isDelete();

    public DataObject originalCopyFor(DataObject dataObject) {
        DataObject dataObject2 = this.makeCopy(dataObject);
        this.restoreAttributeValues(dataObject2, dataObject);
        return dataObject2;
    }

    protected DataObject makeCopy(DataObject dataObject) {
        EObject eObject = (EObject)dataObject;
        EFactory eFactory = eObject.eClass().getEPackage().getEFactoryInstance();
        EObject eObject2 = eFactory.create(eObject.eClass());
        Iterator iterator = eObject.eClass().getEAllStructuralFeatures().iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            eObject2.eSet(eStructuralFeature, eObject.eGet(eStructuralFeature));
        }
        return (DataObject)eObject2;
    }

    protected void restoreAttributeValues(DataObject dataObject, DataObject dataObject2) {
        ChangeSummary changeSummary = dataObject2.getDataGraph().getChangeSummary();
        List list = changeSummary.getOldValues(dataObject2);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)iterator.next();
            if (!(eChangeSummarySetting.getFeature() instanceof EAttribute)) continue;
            ((EObject)dataObject).eSet(eChangeSummarySetting.getFeature(), eChangeSummarySetting.getValue());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

