/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.websphere.sdo.mediator.CountingPager;
import com.ibm.websphere.sdo.mediator.JDBCMediator;
import com.ibm.websphere.sdo.mediator.exception.MediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.ws.sdo.mediator.jdbc.MediatorImpl;
import commonj.sdo.DataObject;
import java.util.Map;

public class GenericPagerImpl
implements CountingPager {
    private static final long serialVersionUID = -2924495946081344807L;
    private int pageSize;
    private int pageNumber;
    private Map arguments;
    private int totalPages;

    public GenericPagerImpl(int n, Map map) {
        this.pageSize = n;
        this.arguments = map;
        this.totalPages = -1;
    }

    public GenericPagerImpl(int n) {
        this(n, null);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public DataObject next(JDBCMediator jDBCMediator) throws JDBCMediatorException {
        if (this.isLastPage(jDBCMediator)) {
            throw new JDBCMediatorException("Cannot move past the last page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
        mediatorImpl.setPageSize(this.pageSize);
        int n = this.pageNumber * this.pageSize;
        DataObject dataObject = mediatorImpl.nextGenericPage(n, this.arguments);
        ++this.pageNumber;
        return dataObject;
    }

    public DataObject previous(JDBCMediator jDBCMediator) throws JDBCMediatorException {
        if (this.pageNumber <= 1) {
            throw new JDBCMediatorException("Cannot move prior to the first page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
        mediatorImpl.setPageSize(this.pageSize);
        DataObject dataObject = mediatorImpl.previousGenericPage(this.pageNumber - 1, this.arguments);
        --this.pageNumber;
        return dataObject;
    }

    public DataObject page(int n, JDBCMediator jDBCMediator) throws MediatorException {
        if (n < 1) {
            throw new JDBCMediatorException("Cannot move prior to the first page");
        }
        if (n > this.lastPageNumber(jDBCMediator)) {
            throw new JDBCMediatorException("Cannot move past the last page");
        }
        MediatorImpl mediatorImpl = (MediatorImpl)jDBCMediator;
        mediatorImpl.setPageSize(this.pageSize);
        DataObject dataObject = mediatorImpl.genericPage(n - 1, this.arguments);
        this.pageNumber = n;
        return dataObject;
    }

    public int pageCount(JDBCMediator jDBCMediator) throws MediatorException {
        return this.totalPages(jDBCMediator);
    }

    public boolean isFirstPage(JDBCMediator jDBCMediator) throws MediatorException {
        return this.pageNumber == 1;
    }

    public boolean isLastPage(JDBCMediator jDBCMediator) throws JDBCMediatorException {
        return this.pageNumber == this.lastPageNumber(jDBCMediator);
    }

    private int lastPageNumber(JDBCMediator jDBCMediator) throws DBException {
        return this.totalPages(jDBCMediator);
    }

    private int totalPages(JDBCMediator jDBCMediator) throws DBException {
        if (this.totalPages == -1) {
            long l = ((MediatorImpl)jDBCMediator).rowCount(this.arguments);
            this.totalPages = (int)Math.ceil((float)l / (float)this.pageSize);
        }
        return this.totalPages;
    }
}

