/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ClassShortName;

public final class VapSemaphore {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int count = 0;

    public VapSemaphore() {
        this.count = 0;
    }

    public VapSemaphore(int n) {
        this.count = n;
    }

    public boolean hasWaiters() {
        return this.count < 0;
    }

    public boolean isZero() {
        return this.count == 0;
    }

    public static VapSemaphore mutex() {
        return new VapSemaphore(1);
    }

    public void notifyAllWaiters() {
        this.notifyAll();
    }

    public synchronized void notifySemaphore() {
        ++this.count;
        if (this.count <= 0) {
            this.notify();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        stringBuffer.append(this.count);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public synchronized void waitSemaphore() {
        --this.count;
        if (this.count < 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

