/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.LookupTableAssociationEnumerator;
import com.ibm.ObjectQuery.crud.util.LookupTableEnumerator;
import com.ibm.ObjectQuery.crud.util.LookupTableKeyEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StLookupTable
extends StCollection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int elementCount;
    private Object[] keyArray;
    private Object[] valueArray;

    public StLookupTable() {
        this.initialize(StLookupTable.minimumSize());
    }

    public StLookupTable(int n) {
        this.initialize(n + Math.max(n, StLookupTable.minimumSize()));
    }

    public StLookupTable(EqualityRelation equalityRelation) {
        super(equalityRelation);
    }

    public StLookupTable(HashFunction hashFunction) {
        this.hashFunction(hashFunction);
    }

    public StLookupTable(HashFunction hashFunction, EqualityRelation equalityRelation) {
        super(hashFunction, equalityRelation);
    }

    private void aboutToAdd(int n) {
        if (n * 2 > this.keyArray.length) {
            this.rehash(n * 2);
        }
    }

    public boolean add(Association association) {
        this.put(association.first(), association.second());
        return true;
    }

    public boolean add(Object object) {
        return this.add((Association)object);
    }

    public Enumeration associationElements() {
        return new LookupTableAssociationEnumerator(this);
    }

    private Object atUnique(Object object, Object object2) {
        int n;
        int n2;
        int n3 = this.keyArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            if (this.keyArray[n2] != null) continue;
            this.keyArray[n2] = object;
            this.valueArray[n2] = object2;
            ++this.elementCount;
            if (this.elementCount > n3 / 2) {
                this.expand();
            }
            return object2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            if (this.keyArray[n2] != null) continue;
            this.keyArray[n2] = object;
            this.valueArray[n2] = object2;
            ++this.elementCount;
            if (this.elementCount > n3 / 2) {
                this.expand();
            }
            return object2;
        }
        return this.expand().atUnique(object, object2);
    }

    public void clear() {
        for (int i = 0; i < this.keyArray.length; ++i) {
            this.keyArray[i] = null;
            this.valueArray[i] = null;
        }
        this.elementCount = 0;
    }

    public Enumeration elements() {
        return new LookupTableEnumerator(this);
    }

    private StLookupTable expand() {
        return this.rehash(this.keyArray.length + this.keyArray.length);
    }

    public Object get(Object object) {
        Object object2;
        int n;
        int n2;
        int n3 = this.keyArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            object2 = this.keyArray[n2];
            if (object2 == null) {
                return null;
            }
            if (!this.eq(object2, object)) continue;
            return this.valueArray[n2];
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            object2 = this.keyArray[n2];
            if (object2 == null) {
                return null;
            }
            if (!this.eq(object2, object)) continue;
            return this.valueArray[n2];
        }
        return null;
    }

    public Object[] getKeyArray() {
        return this.keyArray;
    }

    public Object[] getValueArray() {
        return this.valueArray;
    }

    private int hashIndex(Object object) {
        return this.hashIndex(object, this.keyArray.length);
    }

    private int hashIndex(Object object, int n) {
        return (this.hashFunction().hashValue(object) & Integer.MAX_VALUE) % n;
    }

    public boolean includes(Object object) {
        for (int i = 0; i < this.keyArray.length; ++i) {
            if (this.keyArray[i] == null || !this.valueEq(this.valueArray[i], object)) continue;
            return true;
        }
        return false;
    }

    public boolean includesKey(char c) {
        return this.includesKey(new Character(c));
    }

    public boolean includesKey(int n) {
        return this.includesKey(new Integer(n));
    }

    public boolean includesKey(Object object) {
        Object object2;
        int n;
        int n2;
        int n3 = this.keyArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            object2 = this.keyArray[n2];
            if (object2 == null) {
                return false;
            }
            if (!this.eq(object2, object)) continue;
            return true;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            object2 = this.keyArray[n2];
            if (object2 == null) {
                return false;
            }
            if (!this.eq(object2, object)) continue;
            return true;
        }
        return false;
    }

    public boolean includesKey(boolean bl) {
        return this.includesKey(new Boolean(bl));
    }

    public void initialize(int n) {
        super.initialize(n);
        this.elementCount = 0;
        this.keyArray = new Object[n];
        this.valueArray = new Object[n];
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new LookupTableEnumerator(this);
    }

    public Object keyAtValue(Object object) {
        for (int i = 0; i < this.keyArray.length; ++i) {
            if (this.keyArray[i] == null || !this.valueEq(this.valueArray[i], object)) continue;
            return this.keyArray[i];
        }
        return null;
    }

    public Enumeration keyElements() {
        return new LookupTableKeyEnumerator(this);
    }

    public StSet keys() {
        StSet stSet = new StSet(this.size());
        for (int i = 0; i < this.keyArray.length; ++i) {
            if (this.keyArray[i] == null) continue;
            stSet.add(this.keyArray[i]);
        }
        return stSet;
    }

    public boolean notEmpty() {
        return this.elementCount != 0;
    }

    private void primRemoveAllKeys(Iterator iterator) {
        int n = this.keyArray.length;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n2 = this.hashIndex(e);
            boolean bl = false;
            while (!bl) {
                Object object;
                if (n2 >= n) {
                    n2 = 0;
                }
                if ((object = this.keyArray[n2]) == null) {
                    bl = true;
                    continue;
                }
                if (object == this || !this.eq(object, e)) continue;
                this.rehashTo(n2);
                --this.elementCount;
                bl = true;
            }
        }
    }

    public Object put(char[] cArray, Object object) {
        return this.put((Object)new String(cArray), object);
    }

    public Object put(int n, int n2) {
        return this.put((Object)new Integer(n), (Object)new Integer(n2));
    }

    public Object put(int n, Object object) {
        return this.put((Object)new Integer(n), object);
    }

    public Object put(Object object, char c) {
        return this.put(object, (Object)new Character(c));
    }

    public Object put(Object object, int n) {
        return this.put(object, (Object)new Integer(n));
    }

    public Object put(Object object, Object object2) {
        Object object3;
        int n;
        int n2;
        int n3 = this.keyArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            object3 = this.keyArray[n2];
            if (object3 == null) {
                this.keyArray[n2] = object;
                this.valueArray[n2] = object2;
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(object3, object)) continue;
            this.valueArray[n2] = object2;
            return object2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            object3 = this.keyArray[n2];
            if (object3 == null) {
                this.keyArray[n2] = object;
                this.valueArray[n2] = object2;
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(object3, object)) continue;
            this.valueArray[n2] = object2;
            return object2;
        }
        return this.expand().put(object, object2);
    }

    public Object put(Object object, boolean bl) {
        return this.put(object, (Object)new Boolean(bl));
    }

    public Object put(boolean bl, Object object) {
        return this.put((Object)new Boolean(bl), object);
    }

    public Object putIfAbsent(Object object, Object object2) {
        Object object3;
        int n;
        int n2;
        int n3 = this.keyArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            object3 = this.keyArray[n2];
            if (object3 == null) {
                this.keyArray[n2] = object;
                this.valueArray[n2] = object2;
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(object3, object)) continue;
            return object2;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            object3 = this.keyArray[n2];
            if (object3 == null) {
                this.keyArray[n2] = object;
                this.valueArray[n2] = object2;
                ++this.elementCount;
                if (this.elementCount > n3 / 2) {
                    this.expand();
                }
                return object2;
            }
            if (!this.eq(object3, object)) continue;
            return object2;
        }
        return this.expand().put(object, object2);
    }

    public StLookupTable rehash() {
        return this.rehash(this.keyArray.length);
    }

    private StLookupTable rehash(int n) {
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        if (this.elementCount > 0) {
            for (int i = 0; i < this.keyArray.length; ++i) {
                Object object = this.keyArray[i];
                if (object == null) continue;
                int n2 = this.hashIndex(object, n);
                if (n2 > n - 1) {
                    n2 = 0;
                }
                while (objectArray[n2] != null) {
                    if (++n2 <= n - 1) continue;
                    n2 = 0;
                }
                objectArray[n2] = object;
                objectArray2[n2] = this.valueArray[i];
            }
        }
        this.keyArray = objectArray;
        this.valueArray = objectArray2;
        return this;
    }

    private void rehashTo(int n) {
        int n2 = n;
        int n3 = n;
        int n4 = this.keyArray.length;
        if (++n2 > n4) {
            n2 = 0;
        }
        Object object = this.keyArray[n2];
        while (object != null) {
            int n5 = this.hashIndex(object);
            if (!(n2 >= n3 ? n5 > n3 && n5 <= n2 : n5 > n3 || n5 <= n2)) {
                this.keyArray[n3] = object;
                this.valueArray[n3] = this.valueArray[n2];
                n3 = n2;
            }
            if (++n2 > n4) {
                n2 = 0;
            }
            object = this.keyArray[n2];
        }
        this.keyArray[n3] = null;
        this.valueArray[n3] = null;
    }

    public boolean remove(Object object) {
        throw new RuntimeException("Objects are removed from Dictionaries based on their keys!");
    }

    public void removeAllKeys(Object[] objectArray) {
        this.primRemoveAllKeys(new ArrayIterator(objectArray));
    }

    public void removeAllKeys(List list) {
        this.primRemoveAllKeys(list.iterator());
    }

    public Object removeKey(char c) {
        return this.removeKey(new Character(c));
    }

    public Object removeKey(int n) {
        return this.removeKey(new Integer(n));
    }

    public Object removeKey(Object object) {
        Object object2;
        int n;
        int n2;
        int n3 = this.keyArray.length;
        for (n2 = n = this.hashIndex(object); n2 < n3; ++n2) {
            object2 = this.keyArray[n2];
            if (object2 == null) {
                return null;
            }
            if (!this.eq(object2, object)) continue;
            Object object3 = this.valueArray[n2];
            this.rehashTo(n2);
            --this.elementCount;
            return object3;
        }
        for (n2 = 0; n2 < n - 1; ++n2) {
            object2 = this.keyArray[n2];
            if (object2 == null) {
                return null;
            }
            if (!this.eq(object2, object)) continue;
            Object object4 = this.valueArray[n2];
            this.rehashTo(n2);
            --this.elementCount;
            return object4;
        }
        return null;
    }

    public Object removeKey(boolean bl) {
        return this.removeKey(new Boolean(bl));
    }

    public int size() {
        return this.elementCount;
    }

    public void toStringForLargeOn(StringBuffer stringBuffer) {
        int n = this.size() - 1;
        int n2 = 0;
        Enumeration enumeration = this.associationElements();
        stringBuffer.append("{");
        while (enumeration.hasMoreElements()) {
            ((Association)enumeration.nextElement()).assocToStringOn(stringBuffer);
            if (n2++ >= 30) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
        stringBuffer.append("......etc......");
        stringBuffer.append(this.getNewLine());
        while (enumeration.hasMoreElements()) {
            ((Association)enumeration.nextElement()).assocToStringOn(stringBuffer);
            if (n2++ >= n) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
    }

    public void toStringForSmallOn(StringBuffer stringBuffer) {
        int n = this.size() - 1;
        int n2 = 0;
        Enumeration enumeration = this.associationElements();
        stringBuffer.append("{");
        while (enumeration.hasMoreElements()) {
            ((Association)enumeration.nextElement()).assocToStringOn(stringBuffer);
            if (n2++ >= n) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
    }

    public boolean valueEq(Object object, Object object2) {
        return object.equals(object2);
    }

    public Vector values() {
        Vector<Object> vector = new Vector<Object>(this.size());
        for (int i = 0; i < this.keyArray.length; ++i) {
            if (this.keyArray[i] == null) continue;
            vector.addElement(this.valueArray[i]);
        }
        return vector;
    }
}

