/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.GenericEqualityRelation;
import com.ibm.ObjectQuery.crud.util.GenericHashFunction;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.IteratorWithIndex;
import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class StCollection
implements Collection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private EqualityRelation fEqualityRelation;
    private HashFunction fHashFunction;

    public StCollection() {
        this.initialize(StCollection.minimumSize());
    }

    public StCollection(EqualityRelation equalityRelation) {
        this.equalityRelation(equalityRelation);
        this.initialize(StCollection.minimumSize());
    }

    public StCollection(HashFunction hashFunction) {
        this.hashFunction(hashFunction);
        this.initialize(StCollection.minimumSize());
    }

    public StCollection(HashFunction hashFunction, EqualityRelation equalityRelation) {
        this.equalityRelation(equalityRelation);
        this.hashFunction(hashFunction);
        this.initialize(StCollection.minimumSize());
    }

    public abstract boolean add(Object var1);

    public boolean addAll(Object[] objectArray) {
        return this.basicAddAll(new ArrayIterator(objectArray));
    }

    public boolean addAll(Collection collection) {
        return this.basicAddAll(collection.iterator());
    }

    public Object any() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Enumeration enumeration = this.elements();
        return enumeration.nextElement();
    }

    public Object[] asArray() {
        Object[] objectArray = new Object[this.size()];
        this.toArray(objectArray);
        return objectArray;
    }

    public List asList() {
        ArrayList arrayList = new ArrayList(this.size());
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public StSet asSet() {
        StSet stSet = new StSet(this.size());
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stSet.add(enumeration.nextElement());
        }
        return stSet;
    }

    public Vector asVector() {
        Vector vector = new Vector(this.size());
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public boolean basicAddAll(Iterator iterator) {
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.add(iterator.next());
        }
        return bl;
    }

    public boolean contains(Object object) {
        return this.includes(object);
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public EqualityRelation defaultEqualityRelation() {
        return new GenericEqualityRelation();
    }

    public HashFunction defaultHashFunction() {
        return new GenericHashFunction();
    }

    public abstract Enumeration elements();

    public boolean eq(Object object, Object object2) {
        return this.equalityRelation().equals(object, object2);
    }

    public EqualityRelation equalityRelation() {
        return this.fEqualityRelation;
    }

    public void equalityRelation(EqualityRelation equalityRelation) {
        this.fEqualityRelation = equalityRelation;
    }

    public Object first() {
        return this.any();
    }

    public String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public HashFunction hashFunction() {
        return this.fHashFunction;
    }

    public void hashFunction(HashFunction hashFunction) {
        this.fHashFunction = hashFunction;
    }

    public abstract boolean includes(Object var1);

    public void initialize(int n) {
        this.hashFunction(this.defaultHashFunction());
        this.equalityRelation(this.defaultEqualityRelation());
    }

    public abstract boolean isEmpty();

    public static int minimumSize() {
        return 11;
    }

    public abstract boolean remove(Object var1);

    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.remove(iterator.next());
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        return true;
    }

    public abstract int size();

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.toArray(objectArray);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Iterator iterator = this.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    public List toList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        if (this.size() - 1 < 100) {
            this.toStringForSmallOn(stringBuffer);
        } else {
            this.toStringForLargeOn(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void toStringForLargeOn(StringBuffer stringBuffer) {
        IteratorWithIndex iteratorWithIndex = new IteratorWithIndex(this.iterator(), this.size());
        stringBuffer.append("{");
        while (iteratorWithIndex.hasNext()) {
            stringBuffer.append(iteratorWithIndex.next());
            if (iteratorWithIndex.isLast()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("......etc......");
        iteratorWithIndex.skip(this.size() - 29);
        while (iteratorWithIndex.hasNext()) {
            stringBuffer.append(iteratorWithIndex.next());
            if (iteratorWithIndex.isLast()) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
    }

    public void toStringForSmallOn(StringBuffer stringBuffer) {
        int n = this.size() - 1;
        boolean bl = false;
        IteratorWithIndex iteratorWithIndex = new IteratorWithIndex(this.iterator(), this.size());
        stringBuffer.append("{");
        while (iteratorWithIndex.hasNext()) {
            stringBuffer.append(iteratorWithIndex.next());
            if (iteratorWithIndex.isLast()) continue;
            stringBuffer.append(this.getNewLine());
        }
        stringBuffer.append("}");
    }
}

