/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.Printable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class OutputDevice
implements Printable {
    private StringBuffer stringBuffer = null;
    private PrintWriter printWriter = null;
    private PrintStream printStream = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";

    public OutputDevice() {
        this(System.out);
    }

    public OutputDevice(FileOutputStream fileOutputStream) {
        this(new PrintWriter(fileOutputStream));
    }

    public OutputDevice(PrintStream printStream) {
        this(new PrintWriter(printStream, true));
        this.setPrintStream(printStream);
    }

    public OutputDevice(PrintWriter printWriter) {
        this.setPrintWriter(printWriter);
    }

    public OutputDevice(StringBuffer stringBuffer) {
        this.setStringBuffer(stringBuffer);
    }

    public void close() {
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().close();
        }
    }

    public void flush() {
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().flush();
        }
    }

    private String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public StringBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    private boolean isUsingPrintWriter() {
        return this.printWriter != null;
    }

    private boolean isUsingStringBuffer() {
        return this.stringBuffer != null;
    }

    public boolean isUsingSystemOut() {
        return this.getPrintStream() != null && this.getPrintStream() == System.out;
    }

    public void newLine() {
        this.print(this.getNewLine());
    }

    public void print(char[] cArray) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(cArray);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(cArray);
        }
    }

    public void print(char c) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(c);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(c);
        }
    }

    public void print(double d) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(d);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(d);
        }
    }

    public void print(float f) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(f);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(f);
        }
    }

    public void print(int n) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(n);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(n);
        }
    }

    public void print(long l) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(l);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(l);
        }
    }

    public void print(Object object) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(object);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(object);
        }
    }

    public void print(boolean bl) {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(bl);
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().print(bl);
        }
    }

    public void println() {
        if (this.isUsingStringBuffer()) {
            this.getStringBuffer().append(this.getNewLine());
            return;
        }
        if (this.isUsingPrintWriter()) {
            this.getPrintWriter().println();
        }
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int n) {
        this.print(n);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setStringBuffer(StringBuffer stringBuffer) {
        this.stringBuffer = stringBuffer;
    }
}

