/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ObjectQuery.crud.util.ClassName;
import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.GenericNameFunction;
import com.ibm.ObjectQuery.crud.util.InclusionFunction;
import com.ibm.ObjectQuery.crud.util.ListSorter;
import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.NameFunction;
import com.ibm.ObjectQuery.crud.util.NamedCollectionOrderRelation;
import com.ibm.ObjectQuery.crud.util.OrderRelation;
import com.ibm.ObjectQuery.crud.util.StDictionary;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TwoValuedFunction;
import com.ibm.ObjectQuery.crud.util.TwoValuedIntFunction;
import com.ibm.ObjectQuery.crud.util.VoidFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamedCollection
implements Collection {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String nameString;
    private List collectionValue;
    private NameFunction nameFunctionObj;
    private OrderRelation orderRelationObj;

    public NamedCollection() {
    }

    public NamedCollection(NameFunction nameFunction) {
        this.nameFunction(nameFunction);
    }

    public NamedCollection(NameFunction nameFunction, OrderRelation orderRelation) {
        this.nameFunction(nameFunction);
        this.orderRelation(orderRelation);
    }

    public NamedCollection(OrderRelation orderRelation) {
        this.orderRelation(orderRelation);
    }

    public NamedCollection(String string) {
        this.name(string);
    }

    public NamedCollection(String string, NameFunction nameFunction) {
        this.name(string);
        this.nameFunction(nameFunction);
    }

    public boolean add(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return this.collection().add(object);
        }
        this.collection().set(n, object);
        return true;
    }

    public boolean addAll(Object[] objectArray) {
        return this.basicAddAll(new ArrayIterator(objectArray));
    }

    public boolean addAll(Collection collection) {
        return this.basicAddAll(collection.iterator());
    }

    public boolean addIfAbsent(Object object) {
        if (!this.includes(object)) {
            this.collection().add(object);
            return true;
        }
        return false;
    }

    public Object any() {
        return this.first();
    }

    public void apply(VoidFunction voidFunction) {
        this.getWrapper().apply(voidFunction);
    }

    public void applyWith(NamedCollection namedCollection, TwoValuedFunction twoValuedFunction) {
        this.getWrapper().applyWith(namedCollection.collection(), twoValuedFunction);
    }

    public void applyWith(List list, TwoValuedFunction twoValuedFunction) {
        this.getWrapper().applyWith(list, twoValuedFunction);
    }

    public void applyWithIndex(TwoValuedIntFunction twoValuedIntFunction) {
        this.getWrapper().applyWithIndex(twoValuedIntFunction);
    }

    public boolean basicAddAll(Iterator iterator) {
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        this.collectionValue = null;
    }

    public List collect(Function function) {
        return this.getWrapper().collect(function);
    }

    public List collection() {
        if (this.collectionValue == null) {
            this.collectionValue = new ArrayList();
        }
        return this.collectionValue;
    }

    public boolean conform(BooleanFunction booleanFunction) {
        return this.getWrapper().conform(booleanFunction);
    }

    public boolean contains(Object object) {
        return this.includes(object);
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public NameFunction defaultNameFunction() {
        return new GenericNameFunction();
    }

    public OrderRelation defaultOrderRelation() {
        return new NamedCollectionOrderRelation();
    }

    public Object detect(BooleanFunction booleanFunction) {
        return this.getWrapper().detect(booleanFunction);
    }

    public Object first() {
        if (this.collection().size() == 0) {
            throw new RuntimeException("index out of bounds");
        }
        return this.collection().get(0);
    }

    public ListWrapper getWrapper() {
        return new ListWrapper(this.collection());
    }

    public boolean hasName() {
        return this.nameString != null;
    }

    public boolean hasNameFunction() {
        return this.nameFunctionObj != null;
    }

    public boolean includes(Object object) {
        if (object == null) {
            return false;
        }
        return this.includesName(this.nameFor(object));
    }

    public boolean includesName(Object object) {
        if (object == null) {
            return false;
        }
        return this.includesName(this.nameFor(object));
    }

    public boolean includesName(String string) {
        return this.named(string) != null;
    }

    public boolean includesObject(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != object) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Object object) {
        return this.indexOfName(this.nameFor(object));
    }

    private int indexOfName(String string) {
        for (int i = 0; i < this.size(); ++i) {
            if (!string.equals(this.nameFor(this.collection().get(i)))) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.collection().isEmpty();
    }

    public Iterator iterator() {
        return this.collection().iterator();
    }

    public Object last() {
        int n = this.collection().size();
        if (n == 0) {
            throw new RuntimeException("index out of bounds");
        }
        return this.collection().get(n);
    }

    public String name() {
        if (this.nameString == null) {
            return "";
        }
        return this.nameString;
    }

    public void name(String string) {
        this.nameString = string;
    }

    public Object named(String string) {
        for (int i = 0; i < this.size(); ++i) {
            Object e = this.collection().get(i);
            if (!string.equals(this.nameFor(e))) continue;
            return e;
        }
        return null;
    }

    public String nameFor(Object object) {
        return this.nameFunction().nameof(object);
    }

    public NameFunction nameFunction() {
        if (this.nameFunctionObj == null) {
            this.nameFunctionObj = this.defaultNameFunction();
        }
        return this.nameFunctionObj;
    }

    public void nameFunction(NameFunction nameFunction) {
        this.nameFunctionObj = nameFunction;
    }

    public Iterator nameIterator() {
        return this.collection().iterator();
    }

    public List names() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.nameFor(iterator.next()));
        }
        return arrayList;
    }

    public OrderRelation orderRelation() {
        if (this.orderRelationObj == null) {
            this.orderRelationObj = this.defaultOrderRelation();
        }
        return this.orderRelationObj;
    }

    public void orderRelation(OrderRelation orderRelation) {
        this.orderRelationObj = orderRelation;
    }

    public List reject(InclusionFunction inclusionFunction) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (inclusionFunction.value(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public boolean remove(Object object) {
        return this.removeNamed(this.nameFor(object));
    }

    public boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.remove(iterator.next());
        }
        return bl;
    }

    public boolean removeNamed(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.collection().remove(n);
        return true;
    }

    public boolean removeNamed(String string) {
        int n = this.indexOfName(string);
        if (n == -1) {
            return false;
        }
        this.collection().remove(n);
        return true;
    }

    public boolean retainAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            bl = bl && this.remove(e);
        }
        return bl;
    }

    public List select(BooleanFunction booleanFunction) {
        return this.getWrapper().select(booleanFunction);
    }

    public int size() {
        return this.collection().size();
    }

    public void sort() {
        ListSorter listSorter = new ListSorter(this.orderRelation());
        listSorter.heapSort(this.collection());
    }

    public Object[] toArray() {
        return this.getWrapper().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getWrapper().toArray(objectArray);
    }

    public Map toHashMap() {
        Iterator iterator = this.iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashMap.put(this.nameFor(e), e);
        }
        return hashMap;
    }

    public List toList() {
        Iterator iterator = this.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public StDictionary toStDictionary() {
        Iterator iterator = this.iterator();
        StDictionary stDictionary = new StDictionary();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stDictionary.put((Object)this.nameFor(e), e);
        }
        return stDictionary;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasName()) {
            stringBuffer.append(this.name());
        } else {
            stringBuffer.append(ClassName.name(this));
        }
        this.detailOn(stringBuffer);
        return stringBuffer.toString();
    }

    public void detailOn(StringBuffer stringBuffer) {
        Iterator iterator = this.collection().iterator();
        stringBuffer.append("[");
        while (iterator.hasNext()) {
            stringBuffer.append(this.nameFor(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
    }

    public StSet toStSet() {
        Iterator iterator = this.iterator();
        StSet stSet = new StSet();
        while (iterator.hasNext()) {
            stSet.add(iterator.next());
        }
        return stSet;
    }
}

