/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.AccumulatingFunction;
import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.MultiIterator;
import com.ibm.ObjectQuery.crud.util.ObjectCollectionWrapper;
import com.ibm.ObjectQuery.crud.util.PairwiseIterator;
import com.ibm.ObjectQuery.crud.util.ReverseArrayEnumerator;
import com.ibm.ObjectQuery.crud.util.ShouldNotImplement;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TwoValuedFunction;
import com.ibm.ObjectQuery.crud.util.TwoValuedIntFunction;
import com.ibm.ObjectQuery.crud.util.UnderConstruction;
import com.ibm.ObjectQuery.crud.util.VoidFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class Array
extends ObjectCollectionWrapper
implements List {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Object[] fValue;

    public Array() {
    }

    public Array(Object[] objectArray) {
        this.value(objectArray);
    }

    public Array(int n) {
        this.value(new Object[n]);
    }

    public Array(Object object) {
        this.value(Array.array(object));
    }

    public Array(Object object, Object object2) {
        this.value(Array.array(object, object2));
    }

    public Array(Object object, Object object2, Object object3) {
        this.value(Array.array(object, object2, object3));
    }

    public Array(Object object, Object object2, Object object3, Object object4) {
        this.value(Array.array(object, object2, object3, object4));
    }

    public Object accumulate(AccumulatingFunction accumulatingFunction, Object object) {
        return this.accumulate(new ArrayIterator(this.value()), accumulatingFunction, object);
    }

    public void add(int n, Object object) {
        if (n >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.value().length);
        }
        this.value()[n] = object;
    }

    public boolean add(Object object) {
        throw new ShouldNotImplement();
    }

    public boolean addAll(int n, Collection collection) {
        throw new ShouldNotImplement();
    }

    public boolean addAll(Object object) {
        throw new ShouldNotImplement();
    }

    public boolean addAll(Collection collection) {
        throw new ShouldNotImplement();
    }

    public void apply(VoidFunction voidFunction) {
        super.apply(new ArrayIterator(this.value()), voidFunction);
    }

    public void applyWith(Object[] objectArray, TwoValuedFunction twoValuedFunction) {
        super.applyWith(new ArrayIterator(this.value()), new ArrayIterator(objectArray), twoValuedFunction);
    }

    public void applyWithIndex(TwoValuedIntFunction twoValuedIntFunction) {
        super.applyWithIndex(new ArrayIterator(this.value()), twoValuedIntFunction);
    }

    public static Object[] array(int n) {
        return new Object[n];
    }

    public static Object[] array(Object object) {
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public static Object[] array(Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return objectArray;
    }

    public static Object[] array(Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2};
        objectArray[2] = object3;
        return objectArray;
    }

    public static Object[] array(Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2};
        objectArray[2] = object3;
        objectArray[3] = object4;
        return objectArray;
    }

    public Object at(int n) {
        if (n >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.value().length);
        }
        try {
            return this.value()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.value()[i] = null;
        }
    }

    public Object[] collect(Function function) {
        Object[] objectArray = new Object[this.value().length];
        for (int i = 0; i < this.value().length; ++i) {
            objectArray[i] = function.value(this.value()[i]);
        }
        return objectArray;
    }

    public void commaSpaceInBetweenOn(StringBuffer stringBuffer) {
        super.inBetweenOn(new ArrayIterator(this.value()), null, ", ", stringBuffer);
    }

    public Object[] concatenate(Object[] objectArray) {
        int n;
        Object[] objectArray2 = new Object[this.value().length + objectArray.length];
        for (n = 0; n < this.value().length - 1; ++n) {
            objectArray2[n] = this.value()[n];
        }
        for (n = this.value().length + 1; n < this.value().length + objectArray.length - 1; ++n) {
            objectArray2[n] = objectArray[n];
        }
        return objectArray2;
    }

    public boolean conform(BooleanFunction booleanFunction) {
        return super.conform(new ArrayIterator(this.value()), booleanFunction);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] copy() {
        return this.copy(0);
    }

    public Object[] copy(int n) {
        return this.copy(n, this.size() - 1);
    }

    public Object[] copy(int n, int n2) {
        Object[] objectArray = Array.array(this.size());
        if (n > n2 || n < 0 || n2 < 0) {
            return objectArray;
        }
        int n3 = Math.max(n2, this.size() - 1);
        for (int i = n; i <= n3; ++i) {
            objectArray[i] = this.at(i);
        }
        return objectArray;
    }

    public void copyInto(Object[] objectArray) {
        int n = this.value().length;
        while (n-- > 0) {
            objectArray[n] = this.value()[n];
        }
    }

    public Object detect(BooleanFunction booleanFunction) {
        return super.detect(new ArrayIterator(this.value()), booleanFunction);
    }

    public Iterator dual(Object[] objectArray) {
        return new MultiIterator(this.value(), objectArray);
    }

    public boolean eq(Object[] objectArray) {
        if (this.value() == objectArray) {
            return true;
        }
        if (this.value().length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < this.value().length; ++i) {
            if (this.value()[i].equals(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Array)) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((Array)object).iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public Object first() {
        return this.value()[0];
    }

    public Object get(int n) {
        return this.at(n);
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size(); ++i) {
            n = 31 * n + (this.value()[i] == null ? 0 : this.value()[i].hashCode());
        }
        return n;
    }

    public void inBetweenOn(Function function, String string, StringBuffer stringBuffer) {
        super.inBetweenOn(new ArrayIterator(this.value()), function, string, stringBuffer);
    }

    public void inBetweenOn(String string, StringBuffer stringBuffer) {
        this.inBetweenOn(new ArrayIterator(this.value()), null, string, stringBuffer);
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        for (int i = n; i < this.value().length; ++i) {
            if (!object.equals(this.value()[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.conform(new BooleanFunction(){

            public boolean value(Object object) {
                return object == null;
            }
        });
    }

    public Iterator iterator() {
        return new ArrayIterator(this.value());
    }

    public Object last() {
        return this.value()[this.value().length - 1];
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.value()[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!object.equals(this.value()[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        throw new UnderConstruction();
    }

    public ListIterator listIterator(int n) {
        throw new UnderConstruction();
    }

    public Iterator pairwise() {
        return new PairwiseIterator(this.value());
    }

    public void put(Object object, int n) {
        this.set(object, n);
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size());
        }
    }

    public Object remove(int n) {
        if (n >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.value().length);
        }
        Object object = this.value()[n];
        return object;
    }

    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!object.equals(this.value()[i])) continue;
            this.value()[i] = null;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && this.remove(iterator.next());
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!collection.contains(this.value()[i])) continue;
            this.value()[i] = null;
            bl = true;
        }
        return bl;
    }

    public Object[] reverse() {
        int n = this.value().length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[n - (i + 1)] = this.value()[i];
        }
        return objectArray;
    }

    public Enumeration reverseEnumerator() {
        return new ReverseArrayEnumerator(this.value());
    }

    public Object[] select(BooleanFunction booleanFunction) {
        Object[] objectArray = new Object[this.value().length];
        int n = 0;
        for (int i = 0; i < this.value().length; ++i) {
            if (!booleanFunction.value(this.value()[i])) continue;
            objectArray[n++] = this.value()[i];
        }
        Object[] objectArray2 = new Object[n + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public Object set(int n, Object object) {
        this.rangeCheck(n);
        this.value()[n] = object;
        return object;
    }

    public void set(Object object, int n) {
        if (n >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.value().length);
        }
        this.value()[n] = object;
    }

    public void setAll(Object object) {
        this.applyWithIndex(new TwoValuedIntFunction(){

            public Object value(Object object, int n) {
                Array.this.set(object, n);
                return object;
            }
        });
    }

    public int size() {
        return this.value().length;
    }

    public void spaceInBetweenOn(StringBuffer stringBuffer) {
        super.inBetweenOn(new ArrayIterator(this.value()), null, " ", stringBuffer);
    }

    public List subList(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.value()[i]);
        }
        return arrayList;
    }

    public Object[] toArray() {
        return this.copy();
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])java.lang.reflect.Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.value()[i];
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public List toList() {
        int n = this.value().length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.value()[i]);
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append(" {");
        this.commaSpaceInBetweenOn(stringBuffer);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public StSet toStSet() {
        StSet stSet = new StSet();
        ArrayIterator arrayIterator = new ArrayIterator(this.value());
        while (arrayIterator.hasNext()) {
            stSet.add(arrayIterator.next());
        }
        return stSet;
    }

    public Vector toVector() {
        int n = this.value().length;
        Vector<Object> vector = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.value()[i]);
        }
        return vector;
    }

    public Object[] value() {
        if (this.fValue == null) {
            this.fValue = new Object[0];
        }
        return this.fValue;
    }

    public void value(Object[] objectArray) {
        this.fValue = objectArray;
    }
}

