/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ObjectQuery.crud.util.BreadthFirstTreeIterator;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.PostOrderTreeIterator;
import com.ibm.ObjectQuery.crud.util.PreOrderTreeIterator;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ObjectQuery.crud.util.Treelike;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class AbstractTreeNode
implements Treelike,
Serializable,
Cloneable {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public void addChild(Treelike treelike) {
        this.basicAddChild(treelike);
    }

    public String asFullTreeString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printFullTreeOn(stringBuffer);
        return stringBuffer.toString();
    }

    public List asList() {
        return this.collectIntoList(this.iterator());
    }

    public String asTreeString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printTreeOn(stringBuffer);
        return stringBuffer.toString();
    }

    public Vector asVector() {
        return this.collectIntoVector(this.iterator());
    }

    public void basicAddChild(Treelike treelike) {
        this.children().add(treelike);
    }

    public void basicAddChildren(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.basicAddChild((TreeNode)enumeration.nextElement());
        }
    }

    public Iterator breadthFirstIterator() {
        return new BreadthFirstTreeIterator(this);
    }

    public abstract List children();

    public abstract void children(List var1);

    public Iterator childrenIterator() {
        return this.children().iterator();
    }

    public List collect(Function function) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(function.value(iterator.next()));
        }
        return arrayList;
    }

    public List collectInto(Iterator iterator, List list) {
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public List collectIntoList(Iterator iterator) {
        return this.collectInto(iterator, new ArrayList());
    }

    public Vector collectIntoVector(Iterator iterator) {
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public boolean conform(BooleanFunction booleanFunction) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (booleanFunction.value(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public List decendants() {
        Iterator iterator = this.iterator();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            if (treeNode == this) continue;
            arrayList.add(treeNode);
        }
        return arrayList;
    }

    private String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public boolean hasChildren() {
        return !this.children().isEmpty();
    }

    public boolean isBranch() {
        if (this.isLeaf()) {
            return false;
        }
        return this.children().size() > 1;
    }

    public boolean isCyclicReference(TreeNode treeNode) {
        if (this == treeNode) {
            return true;
        }
        Iterator iterator = this.children().iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode2 = (TreeNode)iterator.next();
            if (treeNode2 == treeNode) {
                return true;
            }
            if (!treeNode2.isCyclicReference(treeNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public Iterator iterator() {
        return this.preOrderIterator();
    }

    public int leafCount() {
        if (this.isLeaf()) {
            return 1;
        }
        int n = 0;
        Iterator iterator = this.childrenIterator();
        while (iterator.hasNext()) {
            n += ((AbstractTreeNode)iterator.next()).leafCount();
        }
        return n;
    }

    public List leaves() {
        Iterator iterator = this.iterator();
        ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>();
        while (iterator.hasNext()) {
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)iterator.next();
            if (!abstractTreeNode.isLeaf()) continue;
            arrayList.add(abstractTreeNode);
        }
        return arrayList;
    }

    public int maxPrint() {
        return 1000;
    }

    public char nestingIndicator() {
        return '.';
    }

    public Iterator postOrderIterator() {
        return new PostOrderTreeIterator(this);
    }

    public Iterator preOrderIterator() {
        return new PreOrderTreeIterator(this);
    }

    public void printChildrenOn(StringBuffer stringBuffer) {
        Iterator iterator = this.childrenIterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > this.maxPrint()) {
                this.printEtcOn(stringBuffer);
                return;
            }
            stringBuffer.append(this.getNewLine());
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)iterator.next();
            abstractTreeNode.printTreeOn(stringBuffer);
            stringBuffer.append(" ");
        }
    }

    public void printDetailOn(StringBuffer stringBuffer) {
    }

    public void printEtcOn(StringBuffer stringBuffer) {
        stringBuffer.append("...etc...");
    }

    public void printFullTreeOn(StringBuffer stringBuffer) {
        this.printFullTreeOn(stringBuffer, new StSet());
    }

    public void printFullTreeOn(StringBuffer stringBuffer, StSet stSet) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            this.printTreeNodeOn((AbstractTreeNode)iterator.next(), stringBuffer, stSet);
        }
    }

    public void printOn(StringBuffer stringBuffer) {
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        this.printDetailOn(stringBuffer);
        stringBuffer.append(")");
    }

    public void printPartialTreeOn(StringBuffer stringBuffer) {
        this.printPartialTreeOn(stringBuffer, new StSet());
    }

    public void printPartialTreeOn(StringBuffer stringBuffer, StSet stSet) {
        int n = stringBuffer.length() + this.maxPrint();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > n) {
                this.printEtcOn(stringBuffer);
                return;
            }
            this.printTreeNodeOn((AbstractTreeNode)iterator.next(), stringBuffer, stSet);
        }
    }

    public void printPrefixOn(StringBuffer stringBuffer) {
    }

    public void printRecursionMessageOn(StringBuffer stringBuffer) {
        stringBuffer.append("... recursive reference to ");
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append(" ...");
    }

    public void printSuffixOn(StringBuffer stringBuffer) {
    }

    public void printTreeNodeOn(AbstractTreeNode abstractTreeNode, StringBuffer stringBuffer, StSet stSet) {
        if (this.recursiveAccessCheck(stSet)) {
            this.printRecursionMessageOn(stringBuffer);
            return;
        }
        stringBuffer.append(this.getNewLine());
        abstractTreeNode.printPrefixOn(stringBuffer);
        abstractTreeNode.printOn(stringBuffer);
        abstractTreeNode.printSuffixOn(stringBuffer);
        this.recursiveAccessClear(stSet);
    }

    public void printTreeNodeOn(TreeNode treeNode, StringBuffer stringBuffer, StSet stSet) {
        if (this.recursiveAccessCheck(stSet)) {
            this.printRecursionMessageOn(stringBuffer);
            return;
        }
        stringBuffer.append(this.getNewLine());
        treeNode.printPrefixOn(stringBuffer);
        treeNode.printOn(stringBuffer);
        treeNode.printSuffixOn(stringBuffer);
        this.recursiveAccessClear(stSet);
    }

    public void printTreeOn(StringBuffer stringBuffer) {
        this.printTreeOn(stringBuffer, new StSet());
    }

    public void printTreeOn(StringBuffer stringBuffer, StSet stSet) {
        if (this.recursiveAccessCheck(stSet)) {
            this.printRecursionMessageOn(stringBuffer);
            return;
        }
        this.printPrefixOn(stringBuffer);
        this.printOn(stringBuffer);
        this.printChildrenOn(stringBuffer);
        this.printSuffixOn(stringBuffer);
        this.recursiveAccessClear(stSet);
    }

    public boolean recursiveAccessCheck(StSet stSet) {
        return stSet.includes(this);
    }

    public AbstractTreeNode recursiveAccessClear(StSet stSet) {
        stSet.remove(this);
        return this;
    }

    public Treelike removeChild(Treelike treelike) {
        this.children().remove(treelike);
        return treelike;
    }

    public List select(BooleanFunction booleanFunction) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!booleanFunction.value(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printOn(stringBuffer);
        return stringBuffer.toString();
    }
}

