/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallIntegerUtils {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final int SIGN_CODING_TWOS_COMPLEMENT = 0;
    public static final int SIGN_CODING_ONES_COMPLEMENT = 1;
    public static final int SIGN_CODING_SIGN_MAGNITUDE = 2;
    public static final int SIGN_CODING_UNSIGNED_BINARY = 3;
    public static final int SIGN_CODING_UNSIGNED_DECIMAL = 4;

    public static void marshallOneByteIntegerIntoBuffer(byte by, byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byArray[n] = by;
    }

    public static void marshallOneByteUnsignedIntegerIntoBuffer(short s, byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToByte(s);
        byArray[n] = byArray2[1];
    }

    public static void marshallTwoByteIntegerIntoBuffer(short s, byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToByte(s);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallTwoByteUnsignedIntegerIntoBuffer(int n, byte[] byArray, int n2, boolean bl, int n3) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToByte(n);
        byte[] byArray3 = new byte[]{byArray2[2], byArray2[3]};
        byArray2 = byArray3;
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n2, 2);
    }

    public static void marshallFourByteIntegerIntoBuffer(int n, byte[] byArray, int n2, boolean bl, int n3) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToByte(n);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
    }

    public static void marshallFourByteUnsignedIntegerIntoBuffer(long l, byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToByte(l);
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray2, 4, byArray3, 0, byArray3.length);
        byArray2 = byArray3;
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallEightByteIntegerIntoBuffer(long l, byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToByte(l);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallEightByteUnsignedIntegerIntoBuffer(BigInteger bigInteger, byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = bigInteger.toByteArray();
        int n3 = byArray2.length;
        byte[] byArray3 = null;
        if (n3 == 8) {
            byArray3 = byArray2;
        } else {
            byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 8 - n3, n3);
        }
        if (!bl) {
            ConversionUtils.endianSwap(byArray3);
        }
        System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
    }

    public static void marshallSixteenByteIntegerIntoBuffer(BigInteger bigInteger, byte[] byArray, int n, boolean bl, boolean bl2, int n2) throws IllegalArgumentException {
        byte[] byArray2 = bigInteger.toByteArray();
        int n3 = byArray2.length;
        if (n3 > 16) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT16NUM_OUTOF_RANGE", bigInteger.toString()));
        }
        byte[] byArray3 = null;
        if (n3 == 16) {
            byArray3 = byArray2;
        } else {
            byArray3 = new byte[16];
            System.arraycopy(byArray2, 0, byArray3, 16 - n3, n3);
            if (bl && bigInteger.signum() == -1) {
                for (int i = 0; i < 16 - n3; ++i) {
                    byArray3[i] = -1;
                }
            }
        }
        if (!bl2) {
            ConversionUtils.endianSwap(byArray3);
        }
        System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
    }

    public static void marshallOneByteIntegerIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        if (bl) {
            MarshallIntegerUtils.marshallOneByteIntegerIntoBuffer(bigDecimal.byteValue(), byArray, n, n2);
        } else {
            MarshallIntegerUtils.marshallOneByteUnsignedIntegerIntoBuffer(bigDecimal.shortValue(), byArray, n, n2);
        }
    }

    public static void marshallTwoByteIntegerIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, boolean bl, boolean bl2, int n2, int n3) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        if (bl) {
            MarshallIntegerUtils.marshallTwoByteIntegerIntoBuffer(bigDecimal.shortValue(), byArray, n, bl2, n2);
        } else {
            MarshallIntegerUtils.marshallTwoByteUnsignedIntegerIntoBuffer(bigDecimal.intValue(), byArray, n, bl2, n2);
        }
    }

    public static void marshallFourByteIntegerIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, boolean bl, boolean bl2, int n2, int n3) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        if (bl) {
            MarshallIntegerUtils.marshallFourByteIntegerIntoBuffer(bigDecimal.intValue(), byArray, n, bl2, n2);
        } else {
            MarshallIntegerUtils.marshallFourByteUnsignedIntegerIntoBuffer(bigDecimal.longValue(), byArray, n, bl2, n2);
        }
    }

    public static void marshallEightByteIntegerIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, boolean bl, boolean bl2, int n2, int n3) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        if (bl) {
            MarshallIntegerUtils.marshallEightByteIntegerIntoBuffer(bigDecimal.longValue(), byArray, n, bl2, n2);
        } else {
            MarshallIntegerUtils.marshallEightByteUnsignedIntegerIntoBuffer(bigDecimal.toBigInteger(), byArray, n, bl2, n2);
        }
    }

    public static void marshallSixteenByteIntegerIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, boolean bl, boolean bl2, int n2, int n3) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        MarshallIntegerUtils.marshallSixteenByteIntegerIntoBuffer(bigDecimal.toBigInteger(), byArray, n, bl, bl2, n2);
    }

    public static byte unmarshallOneByteIntegerFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byte by = byArray[n];
        return by;
    }

    public static short unmarshallOneByteUnsignedIntegerFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        short s = byArray[n];
        s = (short)(s & 0xFF);
        return s;
    }

    public static short unmarshallTwoByteIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        short s = ConversionUtils.convertFromByteToShort(byArray2);
        return s;
    }

    public static int unmarshallTwoByteUnsignedIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        int n3 = ConversionUtils.convertFromByteToShort(byArray2);
        return n3 &= 0xFFFF;
    }

    public static int unmarshallFourByteIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        int n3 = ConversionUtils.convertFromByteToInt(byArray2);
        return n3;
    }

    public static long unmarshallFourByteUnsignedIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        long l = ConversionUtils.convertFromByteToInt(byArray2);
        return l &= 0xFFFFFFFFL;
    }

    public static long unmarshallEightByteIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        long l = ConversionUtils.convertFromByteToLong(byArray2);
        return l;
    }

    public static BigInteger unmarshallEightByteUnsignedIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 8, byArray2.length);
        BigInteger bigInteger = new BigInteger(byArray3);
        return bigInteger;
    }

    public static BigInteger unmarshallSixteenByteIntegerFromBuffer(byte[] byArray, int n, boolean bl, int n2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return bigInteger;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] byArray, int n, int n2, boolean bl, boolean bl2, int n3, int n4) throws IllegalArgumentException {
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 1: {
                if (bl) {
                    byte by = MarshallIntegerUtils.unmarshallOneByteIntegerFromBuffer(byArray, n, n3);
                    bigDecimal = new BigDecimal(Byte.toString(by));
                    break;
                }
                short s = MarshallIntegerUtils.unmarshallOneByteUnsignedIntegerFromBuffer(byArray, n, n3);
                bigDecimal = new BigDecimal(Short.toString(s));
                break;
            }
            case 2: {
                if (bl) {
                    short s = MarshallIntegerUtils.unmarshallTwoByteIntegerFromBuffer(byArray, n, bl2, n3);
                    bigDecimal = new BigDecimal(Short.toString(s));
                    break;
                }
                int n5 = MarshallIntegerUtils.unmarshallTwoByteUnsignedIntegerFromBuffer(byArray, n, bl2, n3);
                bigDecimal = new BigDecimal(Integer.toString(n5));
                break;
            }
            case 4: {
                if (bl) {
                    int n6 = MarshallIntegerUtils.unmarshallFourByteIntegerFromBuffer(byArray, n, bl2, n3);
                    bigDecimal = new BigDecimal(Integer.toString(n6));
                    break;
                }
                long l = MarshallIntegerUtils.unmarshallFourByteUnsignedIntegerFromBuffer(byArray, n, bl2, n3);
                bigDecimal = new BigDecimal(Long.toString(l));
                break;
            }
            case 8: {
                if (bl) {
                    long l = MarshallIntegerUtils.unmarshallEightByteIntegerFromBuffer(byArray, n, bl2, n3);
                    bigDecimal = new BigDecimal(Long.toString(l));
                    break;
                }
                BigInteger bigInteger = MarshallIntegerUtils.unmarshallEightByteUnsignedIntegerFromBuffer(byArray, n, bl2, n3);
                bigDecimal = new BigDecimal(bigInteger);
                break;
            }
            case 16: {
                BigInteger bigInteger = MarshallIntegerUtils.unmarshallSixteenByteIntegerFromBuffer(byArray, n, bl2, n3);
                bigDecimal = new BigDecimal(bigInteger);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_INT_SIZE_NOT_VALID", Integer.toString(n2)));
            }
        }
        bigDecimal = bigDecimal.movePointLeft(n4);
        return bigDecimal;
    }
}

