/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.marshall.util.bidi.BidiFlag;
import com.ibm.etools.marshall.util.bidi.BidiFlagSet;
import com.ibm.etools.marshall.util.bidi.BidiText;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.wsif.format.WSIFFormatHandler;

public class ConversionUtils {
    private static String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-B75>> (C) Copyright IBM Corp. 2001,2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;
    private static final byte PACKED_DEC_POSOR = 12;
    private static final byte PACKED_DEC_NEGOR = 13;
    private static final byte PACKED_DEC_NOSIGN = 15;
    private static final byte EBCDIC_EXTDEC_POSOR = -64;
    private static final byte EBCDIC_EXTDEC_NEGOR = -48;
    private static final byte EBCDIC_ZERO_PAD = -16;
    private static final byte EBCDIC_PLUS = 78;
    private static final byte EBCDIC_MINUS = 96;
    private static final byte ASCII_EXTDEC_POSOR = 48;
    private static final byte ASCII_EXTDEC_NEGOR = 112;
    private static final byte ASCII_ZERO_PAD = 48;
    private static final byte ASCII_PLUS = 43;
    private static final byte ASCII_MINUS = 45;
    private static final byte EBCDIC_CUST_EXTDEC_POSOR = 64;
    private static final byte EBCDIC_CUST_EXTDEC_NEGOR = 73;
    private static final byte EBCDIC_CUST_ZERO_PAD = 48;
    private static final byte EBCDIC_CUST_PLUS = 43;
    private static final byte EBCDIC_CUST_MINUS = 45;
    private static final byte[] EBCDIC_CUST_POS_TABLE = new byte[]{123, 65, 66, 67, 68, 69, 70, 71, 72, 73};
    private static final byte[] EBCDIC_CUST_NEG_TABLE = new byte[]{125, 74, 75, 76, 77, 78, 79, 80, 81, 82};
    private static final byte[] EBCDIC_CUST_POS_SIGNS = new byte[]{-64, -63, -62, -61, -60, -59, -58, -57, -56, -55};
    private static final byte[] EBCDIC_CUST_NEG_SIGNS = new byte[]{-48, -47, -46, -45, -44, -43, -42, -41, -40, -39};
    private static final byte BYTE_SIGN_MASK = -128;

    public static char convertFromByteToChar(byte[] byArray) {
        return (char)ConversionUtils.convertFromByteToShort(byArray);
    }

    public static double convertFromByteToDouble(byte[] byArray) {
        long l = ConversionUtils.convertFromByteToLong(byArray);
        return Double.longBitsToDouble(l);
    }

    public static float convertFromByteToFloat(byte[] byArray) {
        int n = ConversionUtils.convertFromByteToInt(byArray);
        return Float.intBitsToFloat(n);
    }

    public static int convertFromByteToInt(byte[] byArray) {
        int n = byArray[0] << 24 >>> 0 | byArray[1] << 24 >>> 8 | byArray[2] << 24 >>> 16 | byArray[3] << 24 >>> 24;
        return n;
    }

    public static long convertFromByteToLong(byte[] byArray) {
        long l = (long)byArray[0] << 56 & 0xFF00000000000000L | (long)byArray[1] << 48 & 0xFF000000000000L | (long)byArray[2] << 40 & 0xFF0000000000L | (long)byArray[3] << 32 & 0xFF00000000L | (long)byArray[4] << 24 & 0xFF000000L | (long)byArray[5] << 16 & 0xFF0000L | (long)byArray[6] << 8 & 0xFF00L | (long)byArray[7] & 0xFFL;
        return l;
    }

    public static short convertFromByteToShort(byte[] byArray) {
        int n = byArray[0] << 24 >>> 16 | byArray[1] << 24 >>> 24;
        return (short)n;
    }

    public static byte[] convertToByte(char c) {
        byte[] byArray = new byte[]{(byte)(((short)c & 0xFF00) >>> 8), (byte)((short)c & 0xFF)};
        return byArray;
    }

    public static byte[] convertToByte(double d) {
        Double d2 = new Double(d);
        long l = Double.doubleToLongBits(d);
        byte[] byArray = ConversionUtils.convertToByte(l);
        return byArray;
    }

    public static byte[] convertToByte(float f) {
        Float f2 = new Float(f);
        int n = Float.floatToIntBits(f);
        byte[] byArray = ConversionUtils.convertToByte(n);
        return byArray;
    }

    public static byte[] convertToByte(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >>> 24), (byte)((n & 0xFF0000) >>> 16), (byte)((n & 0xFF00) >>> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] convertToByte(long l) {
        byte[] byArray = new byte[]{(byte)((l & 0xFF00000000000000L) >>> 56), (byte)((l & 0xFF000000000000L) >>> 48), (byte)((l & 0xFF0000000000L) >>> 40), (byte)((l & 0xFF00000000L) >>> 32), (byte)((l & 0xFF000000L) >>> 24), (byte)((l & 0xFF0000L) >>> 16), (byte)((l & 0xFF00L) >>> 8), (byte)(l & 0xFFL)};
        return byArray;
    }

    public static byte[] convertToByte(short s) {
        byte[] byArray = new byte[]{(byte)((s & 0xFF00) >>> 8), (byte)(s & 0xFF)};
        return byArray;
    }

    public static long doubleToS390LongBits(double d) throws IOException {
        long l;
        boolean bl;
        long l2 = Double.doubleToLongBits(d);
        boolean bl2 = bl = (l2 & Long.MIN_VALUE) == 0L;
        if ((l2 & Long.MAX_VALUE) == 0L) {
            return l2;
        }
        long l3 = l2 & 0x7FF0000000000000L;
        l3 >>>= 52;
        long l4 = l2 & 0xFFFFFFFFFFFFFL;
        long l5 = Math.abs(l3 -= 1022L) % 4L;
        long l6 = l = Math.abs(l3) / 4L;
        if (l3 > 0L && l5 != 0L) {
            ++l6;
        }
        if (l3 < 0L) {
            l6 = -l6;
        }
        l6 += 64L;
        long l7 = l4;
        l7 = l3 > -1022L ? (l7 |= 0x10000000000000L) : (l7 <<= 1);
        l7 <<= 3;
        if (l5 > 0L) {
            if (l3 > 0L) {
                int n = (int)(4L - l5);
                l7 >>>= n;
            } else {
                if (l3 == -1022L && (l7 & 0xF0000000000000L) == 0L) {
                    l7 <<= 4;
                    --l6;
                }
                l7 >>>= (int)l5;
            }
        }
        if (l3 == -1022L) {
            while (l7 != 0L && (l7 & 0xF0000000000000L) == 0L) {
                l7 <<= 4;
                --l6;
            }
        }
        if (l6 > 127L) {
            throw new IOException(MarshallResource.instance().getString("MARSHRT_FPNUM_OUTOF_RANGE", Double.toString(d)));
        }
        if (l6 < 0L) {
            return 0L;
        }
        long l8 = 0L;
        long l9 = l6 & 0x7FL;
        l8 = l9 << 56;
        if (!bl) {
            l8 |= Long.MIN_VALUE;
        }
        return l8 |= l7;
    }

    public static void endianSwap(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; n < i; ++n, --i) {
            byte by = byArray[n];
            byArray[n] = byArray[i];
            byArray[i] = by;
        }
    }

    public static int evaluateFormula(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FORMULA_NULL"));
        }
        int n = Integer.parseInt(string);
        return n;
    }

    public static int evaluateFormula(String string, HashMap hashMap, WSIFFormatHandler wSIFFormatHandler) throws IllegalArgumentException {
        int n;
        if (string == null) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FORMULA_NULL"));
        }
        int n2 = 0;
        int n3 = string.indexOf("(");
        if (n3 == -1) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n2;
        }
        String string2 = string.substring(0, n3);
        if (string2.equalsIgnoreCase("val")) {
            String string3 = (String)hashMap.get(string);
            if (string3 == null) {
                return 0;
            }
            try {
                Number number = (Number)wSIFFormatHandler.getElement(string3, 0);
                n2 = number == null ? Integer.parseInt(string3) : number.intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n2;
        }
        if (string2.equalsIgnoreCase("neg")) {
            string = string.substring(n3 + 1, string.length() - 1);
            n2 = -1 * ConversionUtils.evaluateFormula(string, hashMap, wSIFFormatHandler);
            return n2;
        }
        string = string.substring(n3 + 1, string.length() - 1);
        char[] cArray = string.toCharArray();
        int n4 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == '(') {
                ++n4;
                continue;
            }
            if (cArray[n] == ')') {
                --n4;
                continue;
            }
            if (cArray[n] == ',' && n4 == 0) break;
        }
        String string4 = "0";
        String string5 = "0";
        string4 = string.substring(0, n);
        string5 = string.substring(n + 1);
        if (string2.equalsIgnoreCase("add")) {
            n2 = ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler) + ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler);
        } else if (string2.equalsIgnoreCase("mpy")) {
            n2 = ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler) * ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler);
        } else if (string2.equalsIgnoreCase("sub")) {
            n2 = ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler) - ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler);
        } else if (string2.equalsIgnoreCase("div")) {
            n2 = ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler) / ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler);
        } else if (string2.equalsIgnoreCase("max")) {
            n2 = Math.max(ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler), ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler));
        } else if (string2.equalsIgnoreCase("min")) {
            n2 = Math.min(ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler), ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler));
        } else if (string2.equalsIgnoreCase("mod")) {
            n2 = ConversionUtils.evaluateFormula(string4, hashMap, wSIFFormatHandler) % ConversionUtils.evaluateFormula(string5, hashMap, wSIFFormatHandler);
        }
        return n2;
    }

    public static void fillBytes(byte by, byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 > 0) {
            int n3 = 1;
            byArray[n] = by;
            while (n3 * 2 <= n2) {
                System.arraycopy(byArray, n, byArray, n + n3, n3);
                n3 *= 2;
            }
            System.arraycopy(byArray, n, byArray, n + n3, n2 - n3);
        }
    }

    public static int floatToS390IntBits(float f) throws IOException {
        int n;
        int n2;
        boolean bl;
        int n3 = Float.floatToIntBits(f);
        boolean bl2 = bl = (n3 & Integer.MIN_VALUE) == 0;
        if ((n3 & Integer.MAX_VALUE) == 0) {
            return n3;
        }
        int n4 = n3 & 0x7F800000;
        n4 >>>= 23;
        int n5 = n3 & 0x7FFFFF;
        if ((n4 -= 126) > -126) {
            n5 |= 0x800000;
        }
        int n6 = Math.abs(n4) % 4;
        int n7 = n2 = Math.abs(n4) / 4;
        if (n4 > 0 && n6 != 0) {
            ++n7;
        }
        if (n4 < 0) {
            n7 = -n7;
        }
        n7 += 64;
        int n8 = n5;
        if (n6 > 0) {
            if (n4 > 0) {
                n = 4 - n6;
                n8 >>>= n;
            } else {
                if (n4 == -126 && (n8 & 0xF00000) == 0) {
                    n8 <<= 4;
                    --n7;
                }
                n = n6;
                n8 >>>= n;
            }
        }
        if (n4 == -126) {
            n8 <<= 1;
            while (n8 != 0 && (n8 & 0xF00000) == 0) {
                n8 <<= 4;
                --n7;
            }
        }
        n = 0;
        int n9 = n7 & 0x7F;
        n = n9 << 24;
        if (!bl) {
            n |= Integer.MIN_VALUE;
        }
        return n |= n8;
    }

    public static float intS390BitsToFloat(int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = (n & Integer.MIN_VALUE) == 0;
        if ((n & Integer.MAX_VALUE) == 0) {
            if (bl) {
                return 0.0f;
            }
            return -0.0f;
        }
        int n2 = n & 0xFFFFFF;
        int n3 = n & 0x7F000000;
        n3 >>= 24;
        int n4 = (n3 -= 64) * 4;
        int n5 = n2;
        if (n4 <= -126) {
            n5 >>= 1;
            while (n4 < -126) {
                ++n4;
                n5 >>= 1;
            }
        }
        while (n5 != 0 && (n5 & 0x800000) == 0 && n4 > -126) {
            n5 <<= 1;
            --n4;
        }
        if (n4 < -149) {
            return 0.0f;
        }
        if (n4 > 128) {
            if (bl) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int n6 = 0;
        if (!bl) {
            n6 |= Integer.MIN_VALUE;
        }
        n4 += 126;
        n6 |= (n4 <<= 23);
        return Float.intBitsToFloat(n6 |= (n5 &= 0x7FFFFF));
    }

    public static double longS390BitsToDouble(long l) throws IOException {
        boolean bl;
        boolean bl2 = bl = (l & Long.MIN_VALUE) == 0L;
        if ((l & Long.MAX_VALUE) == 0L) {
            if (bl) {
                return 0.0;
            }
            return -0.0;
        }
        long l2 = l & 0xFFFFFFFFFFFFFFL;
        long l3 = l & 0x7F00000000000000L;
        l3 >>= 56;
        long l4 = (l3 -= 64L) * 4L;
        long l5 = l2;
        l5 >>= 3;
        if (l4 <= -1022L) {
            l5 >>= 1;
            while (l4 < -1022L) {
                ++l4;
                l5 >>= 1;
            }
        }
        while (l5 != 0L && (l5 & 0x10000000000000L) == 0L && l4 > -1022L) {
            l5 <<= 1;
            --l4;
        }
        if (l4 < -1045L) {
            return 0.0;
        }
        if (l4 > 1024L) {
            if (bl) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        long l6 = 0L;
        if (!bl) {
            l6 |= Long.MIN_VALUE;
        }
        l4 += 1022L;
        l6 |= (l4 <<= 52);
        return Double.longBitsToDouble(l6 |= (l5 &= 0xFFFFFFFFFFFFFL));
    }

    public static BigDecimal convertPackedDecimalToBigDecimal(byte[] byArray) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length - 1;
        stringBuffer.append(Character.forDigit(byArray[n] >>> 4 & 0xF, 16));
        --n;
        while (n >= 0) {
            stringBuffer.append(Character.forDigit(byArray[n] & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[n] >>> 4 & 0xF, 16));
            --n;
        }
        if ((byArray[byArray.length - 1] & 0xF) == 13) {
            stringBuffer.append("-");
        }
        stringBuffer = stringBuffer.reverse();
        BigDecimal bigDecimal = new BigDecimal(stringBuffer.toString());
        return bigDecimal;
    }

    public static long convertPackedDecimalToBinary(byte[] byArray) throws IllegalArgumentException {
        long l = 0L;
        long l2 = 1L;
        boolean bl = true;
        for (int i = byArray.length - 1; i >= 0; --i) {
            byte by = byArray[i];
            int n = by & 0xF;
            int n2 = by >>> 4 & 0xF;
            if (i == byArray.length - 1) {
                switch (n) {
                    case 12: {
                        bl = true;
                        break;
                    }
                    case 13: {
                        bl = false;
                        break;
                    }
                    case 15: {
                        bl = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_PACKDEC_SIGN_NOT_VALID", Integer.toString(n)));
                    }
                }
                n = n2;
                n2 = 0;
            }
            if (n > 9 || n2 > 9) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_PDNUM_OUTOF_RANGE", Integer.toString(by)));
            }
            int n3 = n + 10 * n2;
            l += l2 * (long)n3;
            if (i == byArray.length - 1) {
                l2 *= 10L;
                continue;
            }
            l2 *= 100L;
        }
        if (!bl) {
            l = -l;
        }
        return l;
    }

    public static byte[] convertToPackedDecimal(char[] cArray, int n, boolean bl) {
        byte[] byArray = new byte[n];
        int n2 = n - 1;
        int n3 = cArray.length - 1;
        int n4 = 0;
        byte by = (byte)Character.digit(cArray[n3], 16);
        by = bl ? (cArray[0] == '-' ? (byte)(by << 4 | 0xD) : (byte)(by << 4 | 0xC)) : (byte)(by << 4 | 0xF);
        if (cArray[0] == '-' || cArray[0] == '+') {
            n4 = 1;
        }
        byArray[n2] = by;
        --n3;
        for (int i = --n2; i >= 0 && n3 >= n4; --n3, --i) {
            int n5 = Character.digit(cArray[n3], 16);
            int n6 = 0;
            if (--n3 >= n4) {
                n6 = Character.digit(cArray[n3], 16);
            }
            byArray[i] = (byte)(n5 | n6 << 4);
        }
        return byArray;
    }

    public static byte[] convertToPackedDecimal(long l, int n, boolean bl) {
        boolean bl2;
        byte[] byArray = new byte[n];
        boolean bl3 = bl2 = l >= 0L;
        if (!bl && !bl2) {
            l = -l;
        }
        int n2 = (int)Math.abs(l % 10L);
        l /= 10L;
        byte by = bl ? (bl2 ? (byte)(n2 << 4 | 0xC) : (byte)(n2 << 4 | 0xD)) : (byte)(n2 << 4 | 0xF);
        byArray[n - 1] = by;
        for (int i = n - 2; i >= 0 && l != 0L; l /= 10L, --i) {
            int n3 = (int)Math.abs(l % 10L);
            int n4 = (int)Math.abs((l /= 10L) % 10L);
            byArray[i] = (byte)(n3 | n4 << 4);
        }
        return byArray;
    }

    private static byte[] getPosTable(String string) {
        byte[] byArray = EBCDIC_CUST_POS_TABLE;
        if (string == null) {
            return byArray;
        }
        try {
            String string2 = new String(EBCDIC_CUST_POS_SIGNS, string);
            byArray = string2.getBytes("8859_1");
        }
        catch (Exception exception) {
            byArray = EBCDIC_CUST_POS_TABLE;
        }
        return byArray;
    }

    private static byte[] getNegTable(String string) {
        byte[] byArray = EBCDIC_CUST_NEG_TABLE;
        if (string == null) {
            return byArray;
        }
        try {
            String string2 = new String(EBCDIC_CUST_NEG_SIGNS, string);
            byArray = string2.getBytes("8859_1");
        }
        catch (Exception exception) {
            byArray = EBCDIC_CUST_NEG_TABLE;
        }
        return byArray;
    }

    public static BigDecimal convertExternalDecimalToBigDecimal(byte[] byArray, boolean bl, int n, int n2) throws IllegalArgumentException {
        return ConversionUtils.convertExternalDecimalToBigDecimal(byArray, bl, n, n2, null);
    }

    public static BigDecimal convertExternalDecimalToBigDecimal(byte[] byArray, boolean bl, int n, int n2, String string) throws IllegalArgumentException {
        int n3;
        byte by;
        byte by2;
        int n4;
        long l = 1L;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        switch (n2) {
            case 0: {
                n4 = -64;
                by2 = -48;
                by = 96;
                break;
            }
            case 1: {
                byArray2 = ConversionUtils.getPosTable(string);
                byArray3 = ConversionUtils.getNegTable(string);
                n4 = 48;
                by2 = 112;
                by = 45;
                break;
            }
            case 2: {
                n4 = 48;
                by2 = 112;
                by = 45;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_NOT_VALID", Integer.toString(n2)));
            }
        }
        int n5 = byArray.length - 1;
        int n6 = 0;
        if (bl) {
            block5 : switch (n) {
                case 0: {
                    if (n2 != 1) {
                        if ((byte)(byArray[0] & 0xF0) != by2) break;
                        bl2 = false;
                        break;
                    }
                    for (n3 = 0; n3 < byArray3.length; ++n3) {
                        if (byArray[0] == byArray2[n3]) {
                            byArray[0] = (byte)(n3 & 0xF | n4);
                            break block5;
                        }
                        if (byArray[0] != byArray3[n3]) continue;
                        byArray[0] = (byte)(n3 & 0xF | by2);
                        bl2 = false;
                        break block5;
                    }
                    break;
                }
                case 2: {
                    if (byArray[0] == by) {
                        bl2 = false;
                    }
                    n6 = 1;
                    break;
                }
                case 1: {
                    if (n2 != 1) {
                        if ((byte)(byArray[byArray.length - 1] & 0xF0) != by2) break;
                        bl2 = false;
                        break;
                    }
                    for (n3 = 0; n3 < byArray3.length; ++n3) {
                        if (byArray[byArray.length - 1] == byArray2[n3]) {
                            byArray[byArray.length - 1] = (byte)(n3 & 0xF | n4);
                            break block5;
                        }
                        if (byArray[byArray.length - 1] != byArray3[n3]) continue;
                        byArray[byArray.length - 1] = (byte)(n3 & 0xF | by2);
                        bl2 = false;
                        break block5;
                    }
                    break;
                }
                case 3: {
                    if (byArray[byArray.length - 1] == by) {
                        bl2 = false;
                    }
                    n5 = byArray.length - 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_FMT_NOT_VALID", Integer.toString(n)));
                }
            }
        }
        for (n3 = n5; n3 >= n6; --n3) {
            stringBuffer.append(Character.forDigit(byArray[n3] & 0xF, 16));
        }
        if (!bl2) {
            stringBuffer.append("-");
        }
        stringBuffer = stringBuffer.reverse();
        BigDecimal bigDecimal = new BigDecimal(stringBuffer.toString());
        return bigDecimal;
    }

    public static long convertExternalDecimalToBinary(byte[] byArray, boolean bl, int n, int n2) throws IllegalArgumentException {
        return ConversionUtils.convertExternalDecimalToBinary(byArray, bl, n, n2, null);
    }

    public static long convertExternalDecimalToBinary(byte[] byArray, boolean bl, int n, int n2, String string) throws IllegalArgumentException {
        int n3;
        byte by;
        byte by2;
        int n4;
        long l = 0L;
        long l2 = 1L;
        boolean bl2 = true;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        switch (n2) {
            case 0: {
                n4 = -64;
                by2 = -48;
                by = 96;
                break;
            }
            case 1: {
                byArray2 = ConversionUtils.getPosTable(string);
                byArray3 = ConversionUtils.getNegTable(string);
                n4 = 48;
                by2 = 112;
                by = 45;
                break;
            }
            case 2: {
                n4 = 48;
                by2 = 112;
                by = 45;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_NOT_VALID", Integer.toString(n2)));
            }
        }
        int n5 = byArray.length - 1;
        int n6 = 0;
        if (bl) {
            block5 : switch (n) {
                case 0: {
                    if (n2 != 1) {
                        if ((byte)(byArray[0] & 0xF0) != by2) break;
                        bl2 = false;
                        break;
                    }
                    for (n3 = 0; n3 < byArray3.length; ++n3) {
                        if (byArray[0] == byArray2[n3]) {
                            byArray[0] = (byte)(n3 & 0xF | n4);
                            break block5;
                        }
                        if (byArray[0] != byArray3[n3]) continue;
                        byArray[0] = (byte)(n3 & 0xF | by2);
                        bl2 = false;
                        break block5;
                    }
                    break;
                }
                case 2: {
                    if (byArray[0] == by) {
                        bl2 = false;
                    }
                    n6 = 1;
                    break;
                }
                case 1: {
                    if (n2 != 1) {
                        if ((byte)(byArray[byArray.length - 1] & 0xF0) != by2) break;
                        bl2 = false;
                        break;
                    }
                    for (n3 = 0; n3 < byArray3.length; ++n3) {
                        if (byArray[byArray.length - 1] == byArray2[n3]) {
                            byArray[byArray.length - 1] = (byte)(n3 & 0xF | n4);
                            break block5;
                        }
                        if (byArray[byArray.length - 1] != byArray3[n3]) continue;
                        byArray[byArray.length - 1] = (byte)(n3 & 0xF | by2);
                        bl2 = false;
                        break block5;
                    }
                    break;
                }
                case 3: {
                    if (byArray[byArray.length - 1] == by) {
                        bl2 = false;
                    }
                    n5 = byArray.length - 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_FMT_NOT_VALID", Integer.toString(n)));
                }
            }
        }
        for (n3 = n5; n3 >= n6; --n3) {
            int n7 = byArray[n3] & 0xF;
            l += l2 * (long)n7;
            l2 *= 10L;
        }
        if (!bl2) {
            l = -l;
        }
        return l;
    }

    public static byte[] convertToExternalDecimal(char[] cArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        return ConversionUtils.convertToExternalDecimal(cArray, n, bl, n2, n3, null);
    }

    public static byte[] convertToExternalDecimal(char[] cArray, int n, boolean bl, int n2, int n3, String string) throws IllegalArgumentException {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        byte[] byArray = new byte[n];
        boolean bl2 = true;
        int n10 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (cArray[0] == '-') {
            bl2 = false;
        }
        if (cArray[0] == '-' || cArray[0] == '+') {
            ++n10;
        }
        switch (n3) {
            case 0: {
                n9 = -16;
                n8 = -64;
                n7 = -48;
                n6 = 78;
                n5 = 96;
                break;
            }
            case 1: {
                byArray2 = ConversionUtils.getPosTable(string);
                byArray3 = ConversionUtils.getNegTable(string);
                n9 = 48;
                n8 = 64;
                n7 = 73;
                n6 = 43;
                n5 = 45;
                break;
            }
            case 2: {
                n9 = 48;
                n8 = 48;
                n7 = 112;
                n6 = 43;
                n5 = 45;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_NOT_VALID", Integer.toString(n3)));
            }
        }
        int n11 = n - 1;
        int n12 = cArray.length - 1;
        if (bl && n2 == 3) {
            n11 = n - 2;
        }
        while (n11 >= 0 && n12 >= n10) {
            n4 = Character.digit(cArray[n12], 16);
            byArray[n11] = (byte)(n4 | n9);
            --n11;
            --n12;
        }
        if (n11 >= 0) {
            for (n4 = n11; n4 >= 0; --n4) {
                byArray[n4] = n9;
            }
        }
        if (bl) {
            switch (n2) {
                case 0: {
                    if (n3 != 1) {
                        if (bl2) {
                            byArray[0] = (byte)(byArray[0] & 0xF | n8);
                            break;
                        }
                        byArray[0] = (byte)(byArray[0] & 0xF | n7);
                        break;
                    }
                    n4 = byArray[0] & 0xF;
                    if (bl2) {
                        byArray[0] = byArray2[n4];
                        break;
                    }
                    byArray[0] = byArray3[n4];
                    break;
                }
                case 2: {
                    if (bl2) {
                        byArray[0] = n6;
                        break;
                    }
                    byArray[0] = n5;
                    break;
                }
                case 1: {
                    if (n3 != 1) {
                        if (bl2) {
                            byArray[n - 1] = (byte)(byArray[n - 1] & 0xF | n8);
                            break;
                        }
                        byArray[n - 1] = (byte)(byArray[n - 1] & 0xF | n7);
                        break;
                    }
                    n4 = byArray[n - 1] & 0xF;
                    if (bl2) {
                        byArray[n - 1] = byArray2[n4];
                        break;
                    }
                    byArray[n - 1] = byArray3[n4];
                    break;
                }
                case 3: {
                    if (bl2) {
                        byArray[n - 1] = n6;
                        break;
                    }
                    byArray[n - 1] = n5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_FMT_NOT_VALID", Integer.toString(n2)));
                }
            }
        }
        return byArray;
    }

    public static byte[] convertToExternalDecimal(long l, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        return ConversionUtils.convertToExternalDecimal(l, n, bl, n2, n3, null);
    }

    public static byte[] convertToExternalDecimal(long l, int n, boolean bl, int n2, int n3, String string) throws IllegalArgumentException {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        byte[] byArray = new byte[n];
        boolean bl2 = true;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (l < 0L) {
            bl2 = false;
            if (!bl) {
                l = -l;
            }
        }
        switch (n3) {
            case 0: {
                n9 = -16;
                n8 = -64;
                n7 = -48;
                n6 = 78;
                n5 = 96;
                break;
            }
            case 1: {
                byArray2 = ConversionUtils.getPosTable(string);
                byArray3 = ConversionUtils.getNegTable(string);
                n9 = 48;
                n8 = 64;
                n7 = 73;
                n6 = 43;
                n5 = 45;
                break;
            }
            case 2: {
                n9 = 48;
                n8 = 48;
                n7 = 112;
                n6 = 43;
                n5 = 45;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_NOT_VALID", Integer.toString(n3)));
            }
        }
        int n10 = n - 1;
        if (bl && n2 == 3) {
            n10 = n - 2;
        }
        while (n10 >= 0 && l != 0L) {
            n4 = (int)Math.abs(l % 10L);
            l /= 10L;
            byArray[n10] = (byte)(n4 | n9);
            --n10;
        }
        if (n10 >= 0) {
            for (n4 = n10; n4 >= 0; --n4) {
                byArray[n4] = n9;
            }
        }
        if (bl) {
            switch (n2) {
                case 0: {
                    if (n3 != 1) {
                        if (bl2) {
                            byArray[0] = (byte)(byArray[0] & 0xF | n8);
                            break;
                        }
                        byArray[0] = (byte)(byArray[0] & 0xF | n7);
                        break;
                    }
                    n4 = byArray[0] & 0xF;
                    if (bl2) {
                        byArray[0] = byArray2[n4];
                        break;
                    }
                    byArray[0] = byArray3[n4];
                    break;
                }
                case 2: {
                    if (bl2) {
                        byArray[0] = n6;
                        break;
                    }
                    byArray[0] = n5;
                    break;
                }
                case 1: {
                    if (n3 != 1) {
                        if (bl2) {
                            byArray[n - 1] = (byte)(byArray[n - 1] & 0xF | n8);
                            break;
                        }
                        byArray[n - 1] = (byte)(byArray[n - 1] & 0xF | n7);
                        break;
                    }
                    n4 = byArray[n - 1] & 0xF;
                    if (bl2) {
                        byArray[n - 1] = byArray2[n4];
                        break;
                    }
                    byArray[n - 1] = byArray3[n4];
                    break;
                }
                case 3: {
                    if (bl2) {
                        byArray[n - 1] = n6;
                        break;
                    }
                    byArray[n - 1] = n5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_EXTDEC_SIGN_FMT_NOT_VALID", Integer.toString(n2)));
                }
            }
        }
        return byArray;
    }

    public static String transformBidiTextMarshall(String string, BidiFlag bidiFlag, BidiFlag bidiFlag2, BidiFlag bidiFlag3, BidiFlag bidiFlag4, BidiFlag bidiFlag5) throws IllegalArgumentException {
        BidiFlagSet bidiFlagSet = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
        BidiText bidiText = new BidiText(bidiFlagSet, string);
        BidiFlagSet bidiFlagSet2 = new BidiFlagSet(bidiFlag, bidiFlag2, bidiFlag3, bidiFlag4, bidiFlag5);
        BidiText bidiText2 = bidiText.transform(bidiFlagSet2);
        return bidiText2.toString();
    }

    public static String transformBidiTextUnmarshall(String string, BidiFlag bidiFlag, BidiFlag bidiFlag2, BidiFlag bidiFlag3, BidiFlag bidiFlag4, BidiFlag bidiFlag5) throws IllegalArgumentException {
        BidiFlagSet bidiFlagSet = new BidiFlagSet(bidiFlag, bidiFlag2, bidiFlag3, bidiFlag4, bidiFlag5);
        BidiText bidiText = new BidiText(bidiFlagSet, string);
        BidiFlagSet bidiFlagSet2 = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
        BidiText bidiText2 = bidiText.transform(bidiFlagSet2);
        return bidiText2.toString();
    }

    public static void dumpBytes(StringBuffer stringBuffer, byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        int n2 = n;
        char[] cArray = new char[16];
        while (n2 % 16 != 0) {
            ++n2;
        }
        stringBuffer.append("Buffer Size: " + n + " bytes");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (byArray == null) {
            return;
        }
        int n3 = 0;
        for (int i = 1; i <= n2; ++i) {
            int n4;
            if (i > n) {
                stringBuffer.append(Integer.toHexString(0));
                stringBuffer.append(Integer.toHexString(0));
                cArray[n3] = '\u0000';
            } else {
                n4 = (byArray[i - 1] & 0xF0) >> 4;
                int n5 = byArray[i - 1] & 0xF;
                stringBuffer.append(Integer.toHexString(n4));
                stringBuffer.append(Integer.toHexString(n5));
                cArray[n3] = (char)byArray[i - 1];
            }
            if (i % 4 == 0) {
                stringBuffer.append(" ");
            }
            if (i % 16 == 0) {
                stringBuffer.append(" |");
                for (n4 = 0; n4 < 16; ++n4) {
                    if (Character.isIdentifierIgnorable(cArray[n4])) {
                        stringBuffer.append(".");
                        continue;
                    }
                    stringBuffer.append(cArray[n4]);
                }
                stringBuffer.append("|");
                stringBuffer.append("\n");
                n3 = 0;
                continue;
            }
            ++n3;
        }
        stringBuffer.append("\n");
    }

    public static String convertIEEEExtendedIntelToString(byte[] byArray) {
        boolean bl = true;
        if ((byArray[0] & 0xFFFFFF80) != 0) {
            bl = false;
        }
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, 0, byArray2, 0, 2);
        byArray2[0] = (byte)(byArray2[0] & 0x7F);
        short s = ConversionUtils.convertFromByteToShort(byArray2);
        short s2 = -16382;
        if (s != 0) {
            s2 = (short)(s - 16383);
        }
        byte[] byArray3 = new byte[9];
        System.arraycopy(byArray, 2, byArray3, 1, 8);
        BigInteger bigInteger = new BigInteger(byArray3);
        if (s != 0) {
            if (s == Short.MAX_VALUE) {
                if (!bigInteger.equals(BigInteger.ZERO)) {
                    return "NaN";
                }
                if (bl) {
                    return "Infinity";
                }
                return "-Infinity";
            }
        } else if (bigInteger.equals(BigInteger.ZERO)) {
            if (bl) {
                return "0";
            }
            return "-0";
        }
        int n = bigInteger.getLowestSetBit();
        int n2 = 63;
        if (s == 0) {
            s2 = (short)(s2 - (n2 -= n));
        } else {
            if (n != 0) {
                n2 -= --n;
                bigInteger = bigInteger.shiftRight(n);
            }
            s2 = (short)(s2 - n2);
        }
        String string = ConversionUtils.getFractionAsString(bl, s2, bigInteger, 2, 20);
        return string;
    }

    public static byte[] convertBigDecimalToIEEEExtendedIntel(BigDecimal bigDecimal) {
        byte[] byArray = new byte[10];
        if (bigDecimal.signum() == 0) {
            return byArray;
        }
        boolean bl = true;
        if (bigDecimal.signum() == -1) {
            bl = false;
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
        bigDecimal = bigDecimal.abs();
        BigInteger[] bigIntegerArray = ConversionUtils.getBase2FractionAndExponent(bigDecimal, 63, true);
        BigInteger bigInteger = bigIntegerArray[0];
        short s = 16383;
        short s2 = bigIntegerArray[1].shortValue();
        int n = s - Math.abs(s2);
        if (n < 0) {
            bigInteger = bigInteger.setBit(63);
            bigInteger = bigInteger.shiftRight(Math.abs(n) + 1);
            bigInteger = bigInteger.clearBit(63);
            s = 0;
        } else {
            s = (short)(s + s2);
            bigInteger = bigInteger.setBit(63);
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 8) {
            byte[] byArray3 = new byte[8];
            int n2 = byArray2.length - 8;
            System.arraycopy(byArray2, n2, byArray3, 0, 8);
            byArray2 = byArray3;
        }
        int n3 = 2;
        if (n < 0) {
            n3 = 10 - byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n3, Math.min(byArray2.length, 8));
        byte[] byArray4 = ConversionUtils.convertToByte(s);
        byArray[0] = (byte)(byArray4[0] | byArray[0]);
        byArray[1] = byArray4[1];
        return byArray;
    }

    public static String convertIEEEExtendedOS390ToString(byte[] byArray) {
        boolean bl = true;
        if ((byArray[0] & 0xFFFFFF80) != 0) {
            bl = false;
        }
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, 0, byArray2, 0, 2);
        byArray2[0] = (byte)(byArray2[0] & 0x7F);
        short s = ConversionUtils.convertFromByteToShort(byArray2);
        short s2 = -16382;
        if (s != 0) {
            s2 = (short)(s - 16383);
        }
        byte[] byArray3 = new byte[15];
        System.arraycopy(byArray, 2, byArray3, 1, 14);
        BigInteger bigInteger = new BigInteger(byArray3);
        if (s != 0) {
            if (s == Short.MAX_VALUE) {
                if (!bigInteger.equals(BigInteger.ZERO)) {
                    return "NaN";
                }
                if (bl) {
                    return "Infinity";
                }
                return "-Infinity";
            }
            byArray3[0] = (byte)(byArray3[0] | 1);
            bigInteger = new BigInteger(byArray3);
        } else if (bigInteger.equals(BigInteger.ZERO)) {
            if (bl) {
                return "0";
            }
            return "-0";
        }
        int n = bigInteger.getLowestSetBit();
        int n2 = 112;
        if (s == 0) {
            s2 = (short)(s2 - (n2 -= n));
        } else {
            if (n != 0) {
                n2 = 112 - --n;
                bigInteger = bigInteger.shiftRight(n);
            }
            s2 = (short)(s2 - n2);
        }
        String string = ConversionUtils.getFractionAsString(bl, s2, bigInteger, 2, 34);
        return string;
    }

    public static byte[] convertBigDecimalToIEEEExtendedOS390(BigDecimal bigDecimal) {
        byte[] byArray = new byte[16];
        if (bigDecimal.signum() == 0) {
            return byArray;
        }
        boolean bl = true;
        if (bigDecimal.signum() == -1) {
            bl = false;
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
        bigDecimal = bigDecimal.abs();
        BigInteger[] bigIntegerArray = ConversionUtils.getBase2FractionAndExponent(bigDecimal, 112, true);
        BigInteger bigInteger = bigIntegerArray[0];
        short s = 16383;
        short s2 = bigIntegerArray[1].shortValue();
        int n = s - Math.abs(s2);
        if (n < 0) {
            bigInteger = bigInteger.setBit(112);
            bigInteger = bigInteger.shiftRight(Math.abs(n) + 1);
            s = 0;
        } else {
            s = (short)(s + s2);
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 14) {
            byte[] byArray3 = new byte[14];
            int n2 = byArray2.length - 14;
            System.arraycopy(byArray2, n2, byArray3, 0, 14);
            byArray2 = byArray3;
        }
        int n3 = 2;
        if (n < 0) {
            n3 = 16 - byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n3, Math.min(byArray2.length, 14));
        byte[] byArray4 = ConversionUtils.convertToByte(s);
        byArray[0] = (byte)(byArray4[0] | byArray[0]);
        byArray[1] = byArray4[1];
        return byArray;
    }

    public static String convertIEEEExtendedAIXToString(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        System.arraycopy(byArray, 8, byArray3, 0, 8);
        double d = ConversionUtils.convertFromByteToDouble(byArray2);
        double d2 = ConversionUtils.convertFromByteToDouble(byArray3);
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
        String string = bigDecimal3.toString();
        return string;
    }

    public static byte[] convertBigDecimalToIEEEExtendedAIX(BigDecimal bigDecimal) {
        byte[] byArray = new byte[16];
        if (bigDecimal.signum() == 0) {
            return byArray;
        }
        double d = bigDecimal.doubleValue();
        if (d == Double.POSITIVE_INFINITY) {
            d = Double.MAX_VALUE;
        } else if (d == Double.NEGATIVE_INFINITY) {
            d = -1.7976931348623157E308;
        }
        byte[] byArray2 = ConversionUtils.convertToByte(d);
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        if (bigDecimal3.signum() != 0) {
            d = bigDecimal3.doubleValue();
            byArray2 = ConversionUtils.convertToByte(d);
            System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
        }
        return byArray;
    }

    private static String getFractionAsString(boolean bl, short s, BigInteger bigInteger, int n, int n2) {
        String string;
        BigInteger bigInteger2 = new BigInteger(Integer.toString(n));
        bigInteger2 = bigInteger2.pow(Math.abs(s));
        if (s < 0) {
            BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
            StringBuffer stringBuffer = new StringBuffer();
            if (bigInteger3.equals(BigInteger.ZERO)) {
                stringBuffer.append("0");
            } else {
                stringBuffer.append(bigInteger3.toString());
            }
            int n3 = stringBuffer.length();
            BigInteger bigInteger4 = bigInteger.remainder(bigInteger2);
            if (!bigInteger4.equals(BigInteger.ZERO)) {
                stringBuffer.append(".");
            }
            BigInteger bigInteger5 = new BigInteger("10");
            boolean bl2 = false;
            while (!bigInteger4.equals(BigInteger.ZERO) && n3 <= n2) {
                bigInteger4 = bigInteger4.multiply(bigInteger5);
                BigInteger bigInteger6 = n3 != n2 ? bigInteger4.divide(bigInteger2) : new BigDecimal(bigInteger4).divide(new BigDecimal(bigInteger2), 4).toBigInteger();
                stringBuffer.append(bigInteger6.toString());
                if (!bl2) {
                    if (!bigInteger6.equals(BigInteger.ZERO)) {
                        bl2 = true;
                    }
                } else {
                    ++n3;
                }
                bigInteger4 = bigInteger4.remainder(bigInteger2);
            }
            string = stringBuffer.toString();
        } else {
            BigInteger bigInteger7 = bigInteger.multiply(bigInteger2);
            string = bigInteger7.toString();
        }
        if (!bl) {
            string = "-" + string;
        }
        return string;
    }

    private static BigInteger[] getBase2FractionAndExponent(BigDecimal bigDecimal, int n, boolean bl) {
        int n2;
        BigInteger bigInteger = bigDecimal.toBigInteger();
        bigDecimal = bigDecimal.subtract(new BigDecimal(bigInteger));
        BigInteger bigInteger2 = BigInteger.ZERO;
        int n3 = 0;
        if (bigDecimal.signum() != 0) {
            BigDecimal bigDecimal2 = new BigDecimal("2");
            BigDecimal bigDecimal3 = new BigDecimal("1");
            boolean bl2 = false;
            int n4 = 0;
            while (n4 <= n && bigDecimal.signum() != 0) {
                bigDecimal = bigDecimal.multiply(bigDecimal2);
                --n3;
                bigInteger2 = bigInteger2.shiftLeft(1);
                if (bigDecimal.toBigInteger().compareTo(BigInteger.ONE) == 0) {
                    bl2 = true;
                    bigInteger2 = bigInteger2.setBit(0);
                    bigDecimal = bigDecimal.subtract(bigDecimal3);
                }
                if (!bl2) continue;
                if (n4 == n && bigDecimal.compareTo(new BigDecimal("0.5")) >= 0) {
                    bigInteger2 = bigInteger2.add(BigInteger.ONE);
                }
                ++n4;
            }
        }
        if (n3 != 0) {
            bigInteger = bigInteger.shiftRight(n3);
            bigInteger = bigInteger.or(bigInteger2);
        }
        int n5 = bigInteger.bitLength();
        n3 += n5;
        if (n5 > n) {
            n2 = n5 - n;
            if (bl) {
                --n2;
            }
            bigInteger = bigInteger.shiftRight(n2);
        } else {
            n2 = n - n5;
            if (bl) {
                ++n2;
            }
            bigInteger = bigInteger.shiftLeft(n2);
        }
        if (bl) {
            bigInteger = bigInteger.clearBit(bigInteger.bitLength() - 1);
            --n3;
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger, new BigInteger(Integer.toString(n3))};
        return bigIntegerArray;
    }

    public static String convertIEEEDoubleToString(byte[] byArray) {
        boolean bl = true;
        if ((byArray[0] & 0xFFFFFF80) != 0) {
            bl = false;
        }
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, 0, byArray2, 0, 2);
        byArray2[0] = (byte)(byArray2[0] & 0x7F);
        byArray2[1] = (byte)(byArray2[1] & 0xFFFFFFF0);
        short s = ConversionUtils.convertFromByteToShort(byArray2);
        s = (short)(s >> 4);
        short s2 = -1022;
        if (s != 0) {
            s2 = (short)(s - 1023);
        }
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 0, byArray3, 0, 8);
        byArray3[0] = 0;
        byArray3[1] = (byte)(byArray3[1] & 0xF);
        BigInteger bigInteger = new BigInteger(byArray3);
        if (s != 0) {
            if (s == 2047) {
                if (!bigInteger.equals(BigInteger.ZERO)) {
                    return "NaN";
                }
                if (bl) {
                    return "Infinity";
                }
                return "-Infinity";
            }
            byArray3[1] = (byte)(byArray3[1] | 0x10);
            bigInteger = new BigInteger(byArray3);
        } else if (bigInteger.equals(BigInteger.ZERO)) {
            if (bl) {
                return "0";
            }
            return "-0";
        }
        int n = bigInteger.getLowestSetBit();
        int n2 = 52;
        if (s == 0) {
            s2 = (short)(s2 - (n2 -= n));
        } else {
            if (n != 0) {
                n2 -= --n;
                bigInteger = bigInteger.shiftRight(n);
            }
            s2 = (short)(s2 - n2);
        }
        String string = ConversionUtils.getFractionAsString(bl, s2, bigInteger, 2, 16);
        return string;
    }

    public static byte[] convertBigDecimalToDouble(BigDecimal bigDecimal) {
        byte[] byArray = new byte[8];
        if (bigDecimal.signum() == 0) {
            return byArray;
        }
        boolean bl = true;
        if (bigDecimal.signum() == -1) {
            bl = false;
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
        bigDecimal = bigDecimal.abs();
        BigInteger[] bigIntegerArray = ConversionUtils.getBase2FractionAndExponent(bigDecimal, 52, true);
        BigInteger bigInteger = bigIntegerArray[0];
        short s = 1023;
        short s2 = bigIntegerArray[1].shortValue();
        int n = s - Math.abs(s2);
        if (n < 0) {
            bigInteger = bigInteger.setBit(52);
            bigInteger = bigInteger.shiftRight(Math.abs(n) + 1);
            s = 0;
        } else {
            s = (short)(s + s2);
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 7) {
            byte[] byArray3 = new byte[7];
            int n2 = byArray2.length - 7;
            System.arraycopy(byArray2, n2, byArray3, 0, 7);
            byArray2 = byArray3;
        }
        int n3 = 1;
        if (n < 0) {
            n3 = 8 - byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n3, Math.min(byArray2.length, 7));
        s = (short)(s << 4);
        byte[] byArray4 = ConversionUtils.convertToByte(s);
        byArray[0] = (byte)(byArray4[0] | byArray[0]);
        byArray[1] = (byte)(byArray4[1] | byArray[1]);
        return byArray;
    }

    public static String convertIBM390HexExtendedToString(byte[] byArray) {
        boolean bl = true;
        if ((byArray[0] & 0xFFFFFF80) != 0) {
            bl = false;
        }
        byte by = byArray[0];
        by = (byte)(by & 0x7F);
        byte by2 = (byte)(by - 64);
        byte[] byArray2 = new byte[15];
        System.arraycopy(byArray, 1, byArray2, 1, 7);
        System.arraycopy(byArray, 9, byArray2, 8, 7);
        BigInteger bigInteger = new BigInteger(byArray2);
        if (by != 0) {
            if (by == 127) {
                if (!bigInteger.equals(BigInteger.ZERO)) {
                    return "NaN";
                }
                if (bl) {
                    return "Infinity";
                }
                return "-Infinity";
            }
        } else if (bigInteger.equals(BigInteger.ZERO)) {
            if (bl) {
                return "0";
            }
            return "-0";
        }
        int n = bigInteger.getLowestSetBit();
        int n2 = 112;
        if (by == 0) {
            n2 -= n;
            while (n2 % 4 != 0) {
                --n2;
                bigInteger = bigInteger.shiftLeft(1);
            }
            by2 = (byte)(by2 - n2 / 4);
        } else {
            if (n != 0) {
                --n;
                while (n % 4 != 0) {
                    --n;
                }
                n2 -= n;
                bigInteger = bigInteger.shiftRight(n);
            }
            by2 = (byte)(by2 - n2 / 4);
        }
        String string = ConversionUtils.getFractionAsString(bl, by2, bigInteger, 16, 34);
        return string;
    }

    public static byte[] convertBigDecimalToIBM390HexExtended(BigDecimal bigDecimal) {
        int n;
        byte[] byArray = new byte[16];
        if (bigDecimal.signum() == 0) {
            return byArray;
        }
        boolean bl = true;
        if (bigDecimal.signum() == -1) {
            bl = false;
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
        bigDecimal = bigDecimal.abs();
        BigInteger[] bigIntegerArray = ConversionUtils.getBase2FractionAndExponent(bigDecimal, 112, false);
        BigInteger bigInteger = bigIntegerArray[0];
        short s = bigIntegerArray[1].shortValue();
        while (s % 4 != 0) {
            bigInteger = bigInteger.shiftRight(1);
            s = (short)(s + 1);
        }
        int n2 = 64;
        short s2 = (short)(s / 4);
        int n3 = n2 - Math.abs(s2);
        if (n3 < 0) {
            bigInteger = bigInteger.shiftRight(Math.abs(n3 * 4));
            n2 = 0;
        } else {
            n2 = (short)(n2 + s2);
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 14) {
            byte[] byArray3 = new byte[14];
            n = byArray2.length - 14;
            System.arraycopy(byArray2, n, byArray3, 0, 14);
            byArray2 = byArray3;
        }
        boolean bl2 = true;
        if (n3 < 0) {
            byte[] byArray4 = new byte[14];
            int n4 = 14 - byArray2.length;
            System.arraycopy(byArray2, 0, byArray4, n4, byArray2.length);
            byArray2 = byArray4;
        }
        System.arraycopy(byArray2, 0, byArray, 1, 7);
        System.arraycopy(byArray2, 7, byArray, 9, 7);
        n = (byte)n2;
        byArray[0] = (byte)(n | byArray[0]);
        return byArray;
    }

    public static String convertIBM390HexDoubleToString(byte[] byArray) {
        boolean bl = true;
        if ((byArray[0] & 0xFFFFFF80) != 0) {
            bl = false;
        }
        byte by = byArray[0];
        by = (byte)(by & 0x7F);
        byte by2 = (byte)(by - 64);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 1, byArray2, 1, 7);
        BigInteger bigInteger = new BigInteger(byArray2);
        if (by != 0) {
            if (by == 127) {
                if (!bigInteger.equals(BigInteger.ZERO)) {
                    return "NaN";
                }
                if (bl) {
                    return "Infinity";
                }
                return "-Infinity";
            }
        } else if (bigInteger.equals(BigInteger.ZERO)) {
            if (bl) {
                return "0";
            }
            return "-0";
        }
        int n = bigInteger.getLowestSetBit();
        int n2 = 56;
        if (by == 0) {
            n2 -= n;
            while (n2 % 4 != 0) {
                --n2;
                bigInteger = bigInteger.shiftLeft(1);
            }
            by2 = (byte)(by2 - n2 / 4);
        } else {
            if (n != 0) {
                --n;
                while (n % 4 != 0) {
                    --n;
                }
                n2 = 56 - n;
                bigInteger = bigInteger.shiftRight(n);
            }
            by2 = (byte)(by2 - n2 / 4);
        }
        String string = ConversionUtils.getFractionAsString(bl, by2, bigInteger, 16, 17);
        return string;
    }

    public static byte[] convertBigDecimalToIBM390HexDouble(BigDecimal bigDecimal) {
        int n;
        byte[] byArray = new byte[8];
        if (bigDecimal.signum() == 0) {
            return byArray;
        }
        boolean bl = true;
        if (bigDecimal.signum() == -1) {
            bl = false;
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
        bigDecimal = bigDecimal.abs();
        BigInteger[] bigIntegerArray = ConversionUtils.getBase2FractionAndExponent(bigDecimal, 56, false);
        BigInteger bigInteger = bigIntegerArray[0];
        short s = bigIntegerArray[1].shortValue();
        while (s % 4 != 0) {
            bigInteger = bigInteger.shiftRight(1);
            s = (short)(s + 1);
        }
        int n2 = 64;
        short s2 = (short)(s / 4);
        int n3 = n2 - Math.abs(s2);
        if (n3 < 0) {
            bigInteger = bigInteger.shiftRight(Math.abs(n3 * 4));
            n2 = 0;
        } else {
            n2 = (short)(n2 + s2);
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 7) {
            byte[] byArray3 = new byte[7];
            n = byArray2.length - 7;
            System.arraycopy(byArray2, n, byArray3, 0, 7);
            byArray2 = byArray3;
        }
        int n4 = 1;
        if (n3 < 0) {
            n4 = 8 - byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n4, Math.min(byArray2.length, 7));
        n = (byte)n2;
        byArray[0] = (byte)(n | byArray[0]);
        return byArray;
    }
}

