/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util.html;

import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Element;

public class Text
extends Element {
    protected String text;
    protected boolean newline;
    protected int headerLevel;

    public Text() {
    }

    public Text(String string) {
        this.text = string;
    }

    public Text(String string, boolean bl) {
        this.text = string;
        this.newline = bl;
    }

    public Text(String string, int n) {
        this.text = string;
        this.headerLevel = n;
    }

    protected String toHtmlString() {
        String string = this.text;
        if (this.headerLevel != 0) {
            string = "<h" + this.headerLevel + ">" + this.text + "</h" + this.headerLevel + ">";
        }
        if (this.newline) {
            string = string + "<br>";
        }
        return string.length() == 0 ? string : this.beautify(string);
    }

    protected String toTextString() {
        String string = this.text;
        if (this.headerLevel != 0) {
            if (this.headerLevel == 1) {
                string = string + Document.lineSeparator;
                string = string + Document.pad(this.text.length(), '-');
            } else {
                string = "*** " + this.text + " ***";
            }
            string = string + Document.lineSeparator;
        }
        if (this.newline) {
            string = string + Document.lineSeparator;
        }
        return string;
    }
}

