/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.findroots.NullHandler;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Cp1047;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.DumpReader;
import com.ibm.jvm.svcdump.Function;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.Page;
import com.ibm.jvm.svcdump.Ras;
import com.ibm.jvm.svcdump.StatHandler;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Row;
import com.ibm.jvm.util.html.Table;
import com.ibm.jvm.zseries.Engine;
import com.ibm.jvm.zseries.Instruction;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Dump
extends DvDump {
    DumpReader dumpReader;
    AddressSpace[] spaces;
    AddressSpace[] validSpaces;
    static final int HEADERSIZE = 64;
    static final int BLOCKSIZE = 4160;
    static final int DR1 = -992349888;
    static final int DR2 = -992349632;
    boolean old;
    public static boolean verbose = false;
    public static boolean debug = false;
    static boolean printArgs = false;
    static boolean analyzeHeap = false;
    static boolean printAllocCache = false;
    static boolean printExceptionObject = false;
    static boolean disassemble = false;
    static int disassembleAddress;
    static int disassembleLength;
    static boolean dumpstorage;
    static int dumpstorageAddress;
    static int dumpstorageLength;
    static boolean dumpclasses;
    static boolean dumpnative;
    static boolean tcbsummary;
    static boolean verifysubpools;
    static boolean verifyheap;
    static boolean printdosed;
    static boolean heapstats;
    static boolean printroots;
    static boolean printversion;
    static boolean printtitle;
    static boolean printtime;
    static boolean dumpverbosegc;
    static int dumpclass;
    static int dumpobject;
    static boolean dumpproperties;
    static boolean dumpapars;
    static boolean dumpmdata;
    static int mdata;
    static boolean systrace;
    static boolean hpitrace;
    static boolean search;
    static int searchvalue;
    static int defaultJvm;
    static String dvDumpName;
    Document doc;
    Ras ras;
    int defaultAsid;
    AddressSpace defaultSpace;
    static boolean fromJFormat;
    boolean svcdump;
    int samplecaa;
    static int arrayLength;
    static int arrayCount;
    static int objectCount;
    static int reg;
    static int caa;
    static /* synthetic */ Class class$com$ibm$jvm$svcdump$Dump;

    public Dump() throws Exception {
        this(dvDumpName);
    }

    public String getSuffix() {
        String string = "sov";
        return string;
    }

    public static Boolean isSupportedSource(String string) {
        DvUtils.writetoTrace(" svcdump:isSupportedSource entry with " + string);
        dvDumpName = string;
        Boolean bl = new Boolean(Dump.validFile(new File(string)));
        if (bl.booleanValue()) {
            DvUtils.writetoTrace(" Dump recognised as svc dump");
        } else {
            DvUtils.writetoTrace(" Dump not recognised as svc dump");
        }
        DvUtils.writetoTrace(" svcdump:isSupportedSource exit ");
        return bl;
    }

    public DvAddressSpace[] getAddressSpaces() {
        return this.addressSpaces();
    }

    public DvAddressSpace getCurrentAddressSpace() {
        throw new Error("unimplemented method");
    }

    public int getArchitecture() {
        return 5;
    }

    public int getSystemType() {
        return 4;
    }

    public int getSubSystemType() {
        return 11;
    }

    public int getProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorSubType() {
        throw new Error("unimplemented method");
    }

    public int getCurrentProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorCount() {
        throw new Error("unimplemented method");
    }

    public byte[] getCTypedefs() {
        this.getRas();
        if (this.ras == null) {
            return null;
        }
        return this.ras.getCTypedefs();
    }

    public DvRas getRas() {
        if (this.ras == null) {
            AddressSpace addressSpace = this.getRasAddressSpace();
            if (addressSpace == null || addressSpace.jvmRasAddress == 0) {
                if (verbose) {
                    System.out.println("Warning: ras address is zero!");
                }
                return null;
            }
            if (verbose) {
                System.out.println("getRas");
            }
            try {
                int n;
                int n2 = addressSpace.readInt(addressSpace.jvmRasAddress);
                if (n2 != 1247169874) {
                    throw new Error("Unexpected jvm ras eyecatcher: " + Dump.hex(n2));
                }
                int n3 = addressSpace.readInt(addressSpace.jvmRasAddress + 24);
                if (n3 == 0) {
                    System.out.println("Bad jvm_ras_t:");
                    for (n = 0; n < 13; ++n) {
                        System.out.println(Dump.hex(addressSpace.readInt(addressSpace.jvmRasAddress + n * 4)));
                    }
                }
                Dump.Assert(n3 != 0);
                n = addressSpace.readInt(addressSpace.jvmRasAddress + 28);
                Dump.Assert(n < 65536);
                if (verbose) {
                    System.out.println("Creating Ras");
                }
                this.ras = new Ras(addressSpace, (long)n3, (long)n);
            }
            catch (Exception exception) {
                throw new Error("problem: " + exception);
            }
        }
        return this.ras;
    }

    boolean validBlock(int n) {
        if (n == -992349632) {
            this.old = false;
        } else if (n == -992349888) {
            this.old = true;
        } else {
            return false;
        }
        return true;
    }

    static boolean validFile(File file) {
        try {
            DumpReader dumpReader = new DumpReader(file);
            dumpReader.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static int maxBlocks(File file) {
        return (int)file.length() / 4160;
    }

    void scanFile() throws Exception {
        AddressSpace addressSpace = null;
        try {
            byte[] byArray = new byte[4160];
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (true) {
                this.dumpReader.read(byArray);
                int n2 = Dump.getInt(byArray, 0);
                if (!this.validBlock(n2)) {
                    throw new Error("No DR2 found at record " + n + " instead found " + Dump.hex(n2));
                }
                int n3 = Dump.getInt(byArray, 3);
                int n4 = Dump.getInt(byArray, this.old ? 5 : 6);
                addressSpace = this.getAddressSpace(n3);
                addressSpace.add(n4, n);
                if (addressSpace.jvmRasAddress == 0) {
                    for (int i = 0; i < 1040; ++i) {
                        int n5 = Dump.getInt(byArray, i);
                        if (!bl) {
                            if (n5 != 1247169874) continue;
                            bl = true;
                            if (!verbose) continue;
                            System.out.println("found ras eyecatcher 1 in block " + n + " offset " + i);
                            continue;
                        }
                        if (!bl2) {
                            if (n5 == 1095958528) {
                                bl2 = true;
                                if (!verbose) continue;
                                System.out.println("found ras eyecatcher 2");
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        if (!bl3) {
                            if (n5 == -1437226411) {
                                bl3 = true;
                                if (!verbose) continue;
                                System.out.println("found ras eyecatcher 3");
                                continue;
                            }
                            bl2 = false;
                            bl = false;
                            continue;
                        }
                        if (n5 == -1437226411) {
                            if (verbose) {
                                System.out.println("found ras eyecatcher 4");
                            }
                            addressSpace.setJvmRasAddress(n4 + ((i << 2) - 64 - 12));
                        }
                        bl3 = false;
                        bl2 = false;
                        bl = false;
                    }
                }
                ++n;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public Dump(String string) throws Exception {
        block17: {
            int n;
            Closeable closeable;
            Object object;
            this.spaces = new AddressSpace[0];
            this.doc = new Document();
            this.defaultAsid = -1;
            this.svcdump = true;
            this.samplecaa = 0;
            if (!SvcdumpProperties.getBooleanProperty("svcdump.registered", false)) {
                System.err.println("Hi, thanks for downloading the latest version of svcdump.jar/jformat. Please");
                System.err.println("could you do me a big favour and drop me a line to let me know that you are");
                System.err.println("using this software. In return I will add your email address to a mailing list");
                System.err.println("to keep you informed of future developments. It would also be useful to know");
                System.err.println("how many people are using this for when it comes to funding additional work.");
                System.err.println("All you have to do is send an email to dgriff@hursley.ibm.com with the subject");
                System.err.println("\"svcdump.jar user\".");
                System.err.println("");
                System.err.println("Thanks!");
                System.err.println("");
                System.err.println("Dave");
                try {
                    SvcdumpProperties.setProperty("svcdump.registered", "true");
                }
                catch (Exception exception) {
                    System.err.println("");
                    System.err.println("Whoops, a problem occurred when trying to write to the .svcdumprc file in");
                    System.err.println("your home directory: " + exception);
                    System.err.println("To stop this message appearing again, please either create a .svcdumprc file");
                    System.err.println("in your home directory containing the line \"svcdump.registered=true\", or");
                    System.err.println("set the system property \"-Dsvcdump.registered=true\" when running.");
                }
            }
            this.doc.setPlainText(!SvcdumpProperties.getBooleanProperty("svcdump.output.html", false));
            this.dumpReader = new DumpReader(string);
            try {
                object = new FileInputStream(string + ".cache");
                closeable = new ObjectInputStream((InputStream)object);
                this.spaces = (AddressSpace[])((ObjectInputStream)closeable).readObject();
                ((ObjectInputStream)closeable).close();
            }
            catch (Exception exception) {
                closeable = new FileOutputStream(string + ".cache");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)closeable);
                this.scanFile();
                objectOutputStream.writeObject(this.spaces);
                objectOutputStream.close();
            }
            object = null;
            if (debug) {
                this.doc.println("finished scanning dump");
            }
            for (n = 0; n < this.spaces.length; ++n) {
                this.spaces[n].dump = this;
                this.spaces[n].sort();
            }
            for (n = 0; n < this.spaces.length; ++n) {
                object = this.spaces[n];
                try {
                    int n2 = ((AddressSpace)object).readInt(548L);
                    if (debug) {
                        this.doc.println("asid = " + object + ", psaaold = " + Dump.hex(n2));
                    }
                    try {
                        int n3 = ((AddressSpace)object).readInt(n2 + 108);
                        if (((AddressSpace)object).id != 1) continue;
                        if (debug) {
                            this.doc.println("ascb = " + Dump.hex(n3));
                        }
                        AddressSpace.ascbasxb = n3;
                        AddressSpace.root = object;
                    }
                    catch (Exception exception) {
                        if (!debug) continue;
                        this.doc.println("inner failed for " + ((AddressSpace)object).hexId() + " psaaold " + Dump.hex(n2) + " psaanew " + Dump.hex(((AddressSpace)object).readInt(544L)));
                    }
                    continue;
                }
                catch (Exception exception) {
                    if (!debug) continue;
                    this.doc.println("outer failed for " + ((AddressSpace)object).hexId() + ": " + exception);
                }
            }
            this.defaultAsid = SvcdumpProperties.getIntProperty("svcdump.default.asid", -1, 16);
            defaultJvm = SvcdumpProperties.getIntProperty("svcdump.default.jvm", -1);
            try {
                byte[] byArray = this.getCTypedefs();
                if (byArray != null) {
                    new CTypeFile(byArray);
                }
            }
            catch (Throwable throwable) {
                if (!debug) break block17;
                System.out.println("Warning, problem getting typedefs!");
                throwable.printStackTrace(System.out);
            }
        }
    }

    static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    void seek(int n) throws IOException {
        this.dumpReader.seek(n);
    }

    AddressSpace getAddressSpace(int n) {
        AddressSpace addressSpace;
        for (int i = 0; i < this.spaces.length; ++i) {
            addressSpace = this.spaces[i];
            if (addressSpace.id != n) continue;
            return addressSpace;
        }
        AddressSpace[] addressSpaceArray = new AddressSpace[this.spaces.length + 1];
        System.arraycopy(this.spaces, 0, addressSpaceArray, 0, this.spaces.length);
        addressSpaceArray[this.spaces.length] = addressSpace = new AddressSpace(this, n);
        this.spaces = addressSpaceArray;
        return addressSpace;
    }

    public int[] readBlock() throws IOException {
        int[] nArray = new int[1024];
        byte[] byArray = new byte[4160];
        this.dumpReader.read(byArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Dump.getInt(byArray, i + 16);
        }
        return nArray;
    }

    static String hex(int n, int n2) {
        String string = Integer.toHexString(n);
        for (int i = string.length(); i < n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static String hex(int n) {
        return Dump.hex(n, 8);
    }

    static byte fix(int n) {
        int n2 = n & 0xFF;
        if (n2 < 64 || n2 > 64 && n2 < 75 || n2 > 80 && n2 < 90 || n2 > 97 && n2 < 106 || n2 > 111 && n2 < 121 || n2 > 169 && n2 < 188 || n2 > 249) {
            n2 = 64;
        }
        byte by = (byte)n2;
        return by;
    }

    public static String ebcdic(int n) {
        byte[] byArray = new byte[]{Dump.fix(n >> 24), Dump.fix(n >> 16), Dump.fix(n >> 8), Dump.fix(n >> 0)};
        return Dump.getEbcdicString(byArray);
    }

    public final boolean isEbcdic(short s) {
        return (s = (short)(s | 0x40)) >= 193 && s <= 201 || s >= 209 && s <= 217 || s >= 162 && s <= 169 || s >= 240 && s <= 249;
    }

    public final boolean isEbcdic(int n) {
        short s = (short)(n & 0xFF);
        short s2 = (short)(n >> 8 & 0xFF);
        short s3 = (short)(n >> 16 & 0xFF);
        short s4 = (short)(n >> 24 & 0xFF);
        return this.isEbcdic(s) && this.isEbcdic(s2) && this.isEbcdic(s3) && this.isEbcdic(s4);
    }

    public AddressSpace[] addressSpaces() {
        if (this.validSpaces != null) {
            return this.validSpaces;
        }
        Vector<AddressSpace> vector = new Vector<AddressSpace>();
        for (int i = 0; i < this.spaces.length; ++i) {
            AddressSpace addressSpace = this.spaces[i];
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray == null) continue;
            vector.add(addressSpace);
        }
        this.validSpaces = vector.toArray(new AddressSpace[1]);
        Arrays.sort(this.validSpaces, new Comparator(){

            public int compare(Object object, Object object2) {
                AddressSpace addressSpace = (AddressSpace)object;
                AddressSpace addressSpace2 = (AddressSpace)object2;
                return addressSpace2.tcbs().length - addressSpace.tcbs().length;
            }
        });
        return this.validSpaces;
    }

    public void processTrace(AddressSpace addressSpace) throws Exception {
        if (debug) {
            this.doc.println("found trace in asid 0x" + addressSpace.hexId());
        }
        int n = addressSpace.addresses.get(0);
        int n2 = addressSpace.readUnsignedShort(n + 28);
        int n3 = addressSpace.readInt(n + 32);
        long l = n3 >> 16;
        long l2 = l <<= 48;
        AddressSpace addressSpace2 = null;
        for (int i = 0; i < n2; ++i) {
            if (debug) {
                this.doc.println("*** processor " + i + " trace table ***");
            }
            int n4 = n + 56 + i * 8;
            int n5 = addressSpace.readUnsignedShort(n4);
            int n6 = addressSpace.readInt(n4 + 4);
            int n7 = 0;
            for (int j = 0; j < n5; ++j) {
                int n8 = addressSpace.readUnsignedShort(n6 + j * 40 + 8);
                if (debug) {
                    this.doc.println("*** doing buffer section " + j + " flags " + Dump.hex(n8));
                }
                int n9 = addressSpace.readInt(n6 + j * 40);
                int n10 = addressSpace.readInt(n6 + j * 40 + 4);
                int n11 = 0;
                block27: for (int k = n9; k < n9 + n10; k += n11) {
                    int n12;
                    int n13 = addressSpace.readUnsignedByte(k);
                    if (n13 < 112) {
                        switch (n13) {
                            case 33: {
                                n11 = 8;
                                break;
                            }
                            case 50: {
                                n11 = 12;
                                break;
                            }
                            case 49: {
                                n11 = 8;
                                break;
                            }
                            case 16: {
                                n11 = 4;
                                break;
                            }
                            default: {
                                if (n13 != 0 && debug) {
                                    this.doc.println("!!! unknown id " + Dump.hex(n13));
                                }
                                n11 = 4;
                                break;
                            }
                        }
                        continue;
                    }
                    if (n13 >= 128) {
                        n12 = addressSpace.readInt(k);
                        n11 = 4;
                        if (addressSpace2 == null) continue;
                        if (debug) {
                            this.doc.println("found branch " + Dump.hex(n12) + " in asid " + addressSpace2.hexId());
                        }
                        addressSpace2.addTraceEntry(0, null, n12, n7, ++l2);
                        continue;
                    }
                    n12 = addressSpace.readUnsignedShort(k + 10);
                    n7 = addressSpace.readInt(k + 12);
                    int n14 = addressSpace.readUnsignedShort(k + 18);
                    int n15 = addressSpace.readInt(k + 28);
                    n11 = 16 + (n13 & 0xF) * 4;
                    String string = "unknown";
                    switch (n12) {
                        case 1: {
                            string = "SSCH";
                            n15 = addressSpace.readInt(k + 24);
                            break;
                        }
                        case 3: {
                            string = "EXT";
                            break;
                        }
                        case 5: {
                            string = "SVC";
                            n15 = addressSpace.readInt(k + 24);
                            break;
                        }
                        case 7: {
                            string = "PGM";
                            n15 = addressSpace.readInt(k + 40);
                            break;
                        }
                        case 11: {
                            string = "I/O";
                            break;
                        }
                        case 15: {
                            string = "DSP";
                            break;
                        }
                        case 25: {
                            string = "SUSP";
                            n15 = addressSpace.readInt(k + 20);
                            break;
                        }
                        case 127: {
                            string = "USR";
                            n15 = addressSpace.readInt(k + 24);
                            break;
                        }
                        case 259: {
                            string = "EMS";
                            break;
                        }
                        case 261: {
                            string = "SVCR";
                            n15 = addressSpace.readInt(k + 24);
                            break;
                        }
                        case 271: {
                            string = "SRB";
                            n15 = addressSpace.readInt(k + 24);
                            break;
                        }
                        case 517: {
                            string = "SSRV";
                            n15 = addressSpace.readInt(k + 20);
                            break;
                        }
                        case 527: {
                            string = "SSRB";
                            break;
                        }
                        case 771: {
                            string = "CALL";
                            break;
                        }
                        case 1025: {
                            string = "RSCH";
                            n15 = addressSpace.readInt(k + 24);
                            break;
                        }
                        case 1027: {
                            string = "CLKC";
                            break;
                        }
                        case 3855: {
                            string = "WAIT";
                            n15 = addressSpace.readInt(k + 20);
                            continue block27;
                        }
                        default: {
                            if (debug) {
                                this.doc.println("unknown type " + Dump.hex(n12) + " id " + Dump.hex(n13));
                            }
                            string = "UNKNOWN";
                            n15 = n12;
                            continue block27;
                        }
                    }
                    if (debug) {
                        // empty if block
                    }
                    if (n15 != 0 && (n15 & 1) == 1 && debug) {
                        this.doc.println("found dodgy " + string + ", tcb = " + Dump.hex(n7) + " asid = " + Dump.hex(n14) + " psw = " + Dump.hex(n15));
                    }
                    if (addressSpace2 == null || addressSpace2.id != n14) {
                        int n16;
                        for (n16 = 0; n16 < this.spaces.length; ++n16) {
                            AddressSpace addressSpace3 = this.spaces[n16];
                            if (addressSpace3.id != n14) continue;
                            addressSpace2 = addressSpace3;
                            break;
                        }
                        if (n16 == this.spaces.length) {
                            addressSpace2 = null;
                            if (!debug) continue;
                            this.doc.println("Warning: could not locate asid " + Dump.hex(n14));
                            continue;
                        }
                    }
                    long l3 = 0L;
                    for (int i2 = 0; i2 < 6; ++i2) {
                        l3 <<= 8;
                        l3 |= (long)addressSpace.readUnsignedByte(k + 2 + i2);
                    }
                    addressSpace2.addTraceEntry(n12, string, n15, n7, l3 |= l);
                    l2 = l3;
                }
            }
        }
    }

    private void printTrace(Function[] functionArray) {
        Table table = new Table(new String[]{"Count", "Function"});
        for (int i = 0; i < functionArray.length; ++i) {
            Function function = functionArray[i];
            table.addRow(new String[]{"" + function.entryCount, function.name});
        }
        this.doc.addElement(table);
    }

    static final int arrayLength(int n, int n2) {
        int n3 = n >> 3;
        int n4 = 1 << (n3 & 3);
        n4 *= n2;
        return n4 += 8;
    }

    static void usage() {
        Document document = new Document();
        document.setPlainText(true);
        document.println("");
        document.println("Usage: java com.ibm.jvm.svcdump.Dump [options] <filename>");
        document.println("");
        Table table = new Table("Option", "Description");
        table.addRow("-debug", "print internal debugging info");
        table.addRow("-verbose", "print extra info");
        table.addRow("-heap", "print a table showing which classes have the most objects allocated");
        table.addRow("-cache", "print alloc cache");
        table.addRow("-exception", "print old exception objects");
        table.addRow("-dis <addr> <n>", "disassemble <n> instructions starting at <addr> (hex)");
        table.addRow("-dump <addr> <n>", "dump <n> words of storage starting at <addr> (hex)");
        table.addRow("-dumpapars", "print the apars installed");
        table.addRow("-dumpclasses", "print info about all classes");
        table.addRow("-dumpclass <addr>", "print info about class at given address");
        table.addRow("-dumpobject <addr>", "print info about object at given address");
        table.addRow("-dumpmdata <addr>", "print info about mdata at given address");
        table.addRow("-dumpprops", "print the system properties");
        table.addRow("-dumpnative", "dump all the native methods");
        table.addRow("-dumpverbosegc", "dump the verbosegc");
        table.addRow("-heapstats", "print stats about heap usage");
        table.addRow("-tcbsummary", "print a summary of what the tcbs are doing");
        table.addRow("-systrace", "print the system trace");
        table.addRow("-hpitrace", "print the hpi trace");
        table.addRow("-caa <addr>", "specify the caa to use when disassembling");
        table.addRow("-r<n>", "include saved register <n> in stack trace");
        table.addRow("-args", "print first four function arguments");
        table.addRow("-verifysubpools", "verify subpools");
        table.addRow("-verifyheap", "verify heap");
        table.addRow("-printdosed", "print pinned and dosed objects");
        table.addRow("-printroots", "print GC roots");
        table.addRow("-version", "print the version and exit");
        table.addRow("-fullversion", "print the version of the jvm in the dump and exit");
        table.addRow("-title", "print title of the dump and exit");
        table.addRow("-time", "print time of the dump and exit");
        document.addElement(table);
        document.println("");
        document.println("Visit http://w3.hursley.ibm.com/~dgriff for more info");
        document.println("");
        if (Dump.isFromJFormat()) {
            document.setPlainText(true);
        }
        document.close();
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        if (stringArray.length == 0) {
            Dump.usage();
        }
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (string.equals("-debug")) {
                    debug = true;
                    verbose = true;
                    continue;
                }
                if (string.equals("-xxxhelp")) {
                    int n;
                    object = (class$com$ibm$jvm$svcdump$Dump == null ? Dump.class$("com.ibm.jvm.svcdump.Dump") : class$com$ibm$jvm$svcdump$Dump).getResourceAsStream("help.html");
                    while ((n = ((InputStream)object).read()) != -1) {
                        System.out.print((char)n);
                    }
                    System.exit(0);
                    continue;
                }
                if (string.equals("-dumpapars")) {
                    dumpapars = true;
                    continue;
                }
                if (string.equals("-dumpprops")) {
                    dumpproperties = true;
                    continue;
                }
                if (string.equals("-dumpmdata")) {
                    dumpmdata = true;
                    mdata = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    ++i;
                    continue;
                }
                if (string.equals("-search")) {
                    search = true;
                    searchvalue = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    ++i;
                    continue;
                }
                if (string.equals("-systrace")) {
                    systrace = true;
                    continue;
                }
                if (string.equals("-hpitrace")) {
                    hpitrace = true;
                    continue;
                }
                if (string.equals("-version")) {
                    try {
                        object = (class$com$ibm$jvm$svcdump$Dump == null ? Dump.class$("com.ibm.jvm.svcdump.Dump") : class$com$ibm$jvm$svcdump$Dump).getResource("Dump.class");
                        URLConnection uRLConnection = ((URL)object).openConnection();
                        Date date = new Date(uRLConnection.getLastModified());
                        System.out.println("");
                        System.out.println("You are using");
                        System.out.println("");
                        System.out.println("" + object);
                        System.out.println("");
                        System.out.println("which was last modified on");
                        System.out.println("");
                        System.out.println("" + date);
                        System.out.println("");
                    }
                    catch (Exception exception) {
                        System.out.println("Unexpected exception: " + exception);
                    }
                    System.exit(0);
                    continue;
                }
                if (string.equals("-dumpverbosegc")) {
                    dumpverbosegc = true;
                    continue;
                }
                if (string.equals("-time")) {
                    printtime = true;
                    continue;
                }
                if (string.equals("-title")) {
                    printtitle = true;
                    continue;
                }
                if (string.equals("-fullversion")) {
                    printversion = true;
                    continue;
                }
                if (string.equals("-verifysubpools")) {
                    verifysubpools = true;
                    continue;
                }
                if (string.equals("-verifyheap")) {
                    verifyheap = true;
                    continue;
                }
                if (string.equals("-printdosed")) {
                    printdosed = true;
                    continue;
                }
                if (string.equals("-heapstats")) {
                    heapstats = true;
                    continue;
                }
                if (string.equals("-printroots")) {
                    printroots = true;
                    continue;
                }
                if (string.equals("-dumpclasses")) {
                    dumpclasses = true;
                    continue;
                }
                if (string.equals("-dumpnative")) {
                    dumpnative = true;
                    continue;
                }
                if (string.equals("-tcbsummary")) {
                    tcbsummary = true;
                    continue;
                }
                if (string.equals("-dumpclass")) {
                    dumpclass = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    ++i;
                    continue;
                }
                if (string.equals("-dumpobject")) {
                    dumpobject = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    ++i;
                    continue;
                }
                if (string.equals("-heap")) {
                    analyzeHeap = true;
                    continue;
                }
                if (string.equals("-cache")) {
                    printAllocCache = true;
                    continue;
                }
                if (string.equals("-exception")) {
                    printExceptionObject = true;
                    continue;
                }
                if (string.equals("-args")) {
                    printArgs = true;
                    continue;
                }
                if (string.startsWith("-r")) {
                    reg = Integer.parseInt(string.substring(2));
                    continue;
                }
                if (string.equals("-dis")) {
                    disassemble = true;
                    disassembleAddress = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    disassembleLength = SvcdumpProperties.parseInt(stringArray[i + 2]);
                    i += 2;
                    continue;
                }
                if (string.equals("-dump")) {
                    dumpstorage = true;
                    dumpstorageAddress = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    dumpstorageLength = SvcdumpProperties.parseInt(stringArray[i + 2]);
                    i += 2;
                    continue;
                }
                if (string.equals("-caa")) {
                    caa = SvcdumpProperties.parseInt(stringArray[i + 1], 16);
                    ++i;
                    continue;
                }
                Dump.usage();
                continue;
            }
            string2 = string;
        }
        Dump dump = null;
        if (heapstats && stringArray.length == 1) {
            string = null;
            try {
                object = new File(".");
                String[] stringArray2 = ((File)object).list();
                for (int i = 0; i < stringArray2.length; ++i) {
                    boolean bl = false;
                    string = stringArray2[i];
                    if (Dump.validFile(new File(string))) {
                        System.out.println("Processing " + string);
                        try {
                            dump = new Dump(string);
                            dump.heapstats();
                            dump.doStuff();
                        }
                        catch (Throwable throwable) {
                            System.out.println("Problem opening dump " + string + ": " + throwable);
                            throwable.printStackTrace();
                        }
                    }
                    if (!bl) continue;
                    System.out.println("Zipping " + string);
                    try {
                        Runtime.getRuntime().exec("sh ./zipper " + string).waitFor();
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Unexpected exception zipping " + string + ": " + exception);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Problem opening dump " + string + ": " + exception);
                return;
            }
            return;
        }
        try {
            dump = new Dump(string2);
        }
        catch (Exception exception) {
            System.out.println("Problem opening dump " + string2 + ": " + exception);
            return;
        }
        if (disassemble) {
            dump.disassemble();
        } else if (dumpstorage) {
            dump.dumpstorage();
        } else if (tcbsummary) {
            dump.tcbsummary();
        } else if (dumpnative) {
            dump.dumpnative();
        } else if (dumpclasses) {
            dump.dumpclasses();
        } else if (verifysubpools) {
            dump.verifysubpools();
        } else if (verifyheap) {
            dump.verifyheap();
        } else if (printdosed) {
            dump.printdosed();
        } else if (heapstats) {
            dump.heapstats();
        } else if (printroots) {
            dump.printroots();
        } else if (printtime) {
            dump.printtime();
        } else if (printtitle) {
            dump.printtitle();
        } else if (printversion) {
            dump.printversion();
        } else if (dumpverbosegc) {
            dump.dumpverbosegc();
        } else if (dumpclass != 0) {
            dump.dumpclass(dumpclass);
        } else if (dumpobject != 0) {
            dump.dumpobject(dumpobject);
        } else if (dumpapars) {
            dump.dumpapars();
        } else if (dumpproperties) {
            dump.dumpproperties();
        } else if (dumpmdata) {
            dump.dumpmdata(mdata);
        } else if (systrace) {
            dump.systrace();
        } else if (hpitrace) {
            dump.hpitrace();
        } else if (search) {
            dump.search();
        } else {
            dump.doStuff();
        }
        dump.flush();
    }

    void flush() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.close();
    }

    public AddressSpace getDefaultAddressSpace() {
        int n;
        int n2;
        if (this.defaultSpace != null) {
            return this.defaultSpace;
        }
        if (this.defaultAsid != -1) {
            for (n2 = 0; n2 < this.spaces.length; ++n2) {
                if (this.spaces[n2].id != this.defaultAsid) continue;
                this.defaultSpace = this.spaces[n2];
                return this.spaces[n2];
            }
            System.out.println("Warning: could not find default asid " + Dump.hex(this.defaultAsid));
        }
        n2 = 0;
        for (n = 0; n < this.spaces.length; ++n) {
            if (!this.spaces[n].isJava()) continue;
            ++n2;
            this.defaultSpace = this.spaces[n];
            if (!debug) continue;
            System.out.println("found java asid " + this.spaces[n]);
        }
        if (n2 == 0) {
            throw new Error("Could not find a Java address space!");
        }
        if (n2 > 1) {
            System.out.println("Warning: more than one java address space found:");
            for (n = 0; n < this.spaces.length; ++n) {
                if (!this.spaces[n].isJava()) continue;
                System.out.println("    asid = " + this.spaces[n]);
            }
            System.out.println("You can use the svcdump.default.asid property to specify");
            System.out.println("which one you want to use (or use the jformat set asid command).");
            System.out.println("Using " + this.defaultSpace + " as default");
            System.out.println("See http://w3.hursley.ibm.com/~dgriff/ for more details");
            System.out.println("");
        }
        return this.defaultSpace;
    }

    AddressSpace getRasAddressSpace() {
        for (int i = 0; i < this.spaces.length; ++i) {
            if (this.spaces[i].jvmRasAddress == 0) continue;
            return this.spaces[i];
        }
        return null;
    }

    public Jvm getDefaultJvm() {
        Jvm[] jvmArray = this.getDefaultAddressSpace().jvms();
        if (jvmArray.length == 1) {
            return jvmArray[0];
        }
        if (defaultJvm == -1) {
            if (heapstats) {
                return jvmArray[0];
            }
            System.err.println("More than one Jvm found in asid " + this.getDefaultAddressSpace());
            System.err.println("please use the system property -Dsvcdump.default.jvm to choose one from the following list:");
            for (int i = 0; i < jvmArray.length; ++i) {
                System.err.println("    " + i + "    " + jvmArray[i]);
            }
            System.exit(1);
        }
        if (defaultJvm > jvmArray.length) {
            System.err.println("The number " + defaultJvm + " is out of range. Needs to be from 0 to " + (jvmArray.length - 1));
            System.exit(1);
        }
        return jvmArray[defaultJvm];
    }

    public void disassemble() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        System.out.println("Disassembly starting at 0x" + Dump.hex(disassembleAddress));
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        Engine engine = new Engine(addressSpace);
        if (caa == 0) {
            Instruction[] instructionArray = engine.disassemble(this.doc, disassembleAddress, disassembleLength);
        } else {
            Instruction[] instructionArray = engine.disassemble(this.doc, disassembleAddress, disassembleLength, caa);
        }
    }

    public void dumpapars() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        System.out.println("");
        System.out.println("This is the dump of the APARS in the default asid " + addressSpace);
        System.out.println("It is produced by scanning the dump for strings that look");
        System.out.println("like \"UWnnnnn.BPXINLPA\". Obviously this is not ideal so if");
        System.out.println("you know a better way please drop me a line!");
        System.out.println("");
        String[] stringArray = new String[]{"UW95333", "UW95334", "UW95335", "UW95336"};
        boolean bl = false;
        int n = 0;
        while (true) {
            try {
                n = addressSpace.search(n, -1026037815);
                if (n == -1) break;
                int n2 = addressSpace.readInt(n - 8);
                int n3 = addressSpace.readInt(n + 4);
                if (n3 == -707536959 && (n2 & 0xFFFF0000) == -454688768) {
                    byte[] byArray = new byte[7];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = addressSpace.readByte(n - 8 + i);
                    }
                    String string = Dump.getEbcdicString(byArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        bl = true;
                    }
                    System.out.println("    " + string);
                }
            }
            catch (Exception exception) {
                throw new Error("Unexpected exception: " + exception);
            }
            n += 4;
        }
        System.out.println("");
        if (!bl) {
            System.out.println("Warning! APAR OW54362 not found. This can cause pthread_quiesce failures.");
            System.out.println("");
        }
    }

    public void dumpstorage() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println("Storage dump starting at 0x" + Dump.hex(dumpstorageAddress));
        AddressSpace addressSpace = this.getDefaultAddressSpace();
        if (dumpstorageLength == 0) {
            this.doc.println(addressSpace.readString(dumpstorageAddress));
        } else {
            for (int i = 0; i < dumpstorageLength; ++i) {
                int n = dumpstorageAddress + (i << 2);
                this.doc.println("0x" + Dump.hex(n) + ": 0x" + Dump.hex(addressSpace.readInt(n)));
            }
        }
    }

    public void dumpclasses() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of all classes in asid " + jvm.space.hexId());
        try {
            jvm.dumpClasses(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void verifysubpools() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Verifying subpools in asid " + jvm.space.hexId());
        try {
            jvm.verifysubpools();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void verifyheap() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Verifying heap in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            jvm.verifyheap();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void printdosed() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Print dosed/pinned in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            jvm.printdosed();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void heapstats() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Print heap stats in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            int n;
            StatHandler statHandler = new StatHandler(jvm.space);
            jvm.handler = statHandler;
            jvm.analyze131Heap();
            System.out.println("objects = " + statHandler.objects);
            System.out.println("classes = " + statHandler.classes);
            System.out.println("objectarrays = " + statHandler.objectarrays);
            System.out.println("primarrays = " + statHandler.primarrays);
            System.out.println("strings = " + statHandler.strings);
            System.out.println("smallid = " + statHandler.smallid);
            System.out.println("mediumid = " + statHandler.mediumid);
            System.out.println("largeid = " + statHandler.largeid);
            System.out.println("smallrefs = " + statHandler.smallrefs);
            System.out.println("mediumrefs = " + statHandler.mediumrefs);
            System.out.println("largerefs = " + statHandler.largerefs);
            System.out.println("smallsize = " + statHandler.smallsize);
            System.out.println("mediumsize = " + statHandler.mediumsize);
            System.out.println("largesize = " + statHandler.largesize);
            for (n = 0; n < statHandler.refcounts.length; ++n) {
                System.out.println("refs[" + n + "] = " + statHandler.refcounts[n]);
            }
            System.out.println("cachehits = " + statHandler.cachehits);
            System.out.println("cachemisses = " + statHandler.cachemisses);
            System.out.println("fithits = " + statHandler.fithits);
            System.out.println("fitmisses = " + statHandler.fitmisses);
            System.out.println("oldsize = " + statHandler.oldsize);
            System.out.println("newsize = " + statHandler.newsize);
            System.out.println("hashed = " + statHandler.hashed);
            StatHandler.totalobjects += statHandler.objects;
            StatHandler.totalclasses += statHandler.classes;
            StatHandler.totalobjectarrays += statHandler.objectarrays;
            StatHandler.totalprimarrays += statHandler.primarrays;
            StatHandler.totalstrings += statHandler.strings;
            StatHandler.totalsmallid += statHandler.smallid;
            StatHandler.totalmediumid += statHandler.mediumid;
            StatHandler.totallargeid += statHandler.largeid;
            StatHandler.totalsmallrefs += statHandler.smallrefs;
            StatHandler.totalmediumrefs += statHandler.mediumrefs;
            StatHandler.totallargerefs += statHandler.largerefs;
            StatHandler.totalsmallsize += statHandler.smallsize;
            StatHandler.totalmediumsize += statHandler.mediumsize;
            StatHandler.totallargesize += statHandler.largesize;
            for (n = 0; n < statHandler.refcounts.length; ++n) {
                int n2 = n;
                StatHandler.totalrefcounts[n2] = StatHandler.totalrefcounts[n2] + statHandler.refcounts[n];
            }
            StatHandler.totalcachehits += statHandler.cachehits;
            StatHandler.totalcachemisses += statHandler.cachemisses;
            StatHandler.totalfithits += statHandler.fithits;
            StatHandler.totalfitmisses += statHandler.fitmisses;
            StatHandler.totaloldsize += statHandler.oldsize;
            StatHandler.totalnewsize += statHandler.newsize;
            StatHandler.totalhashed += statHandler.hashed;
            System.out.println("");
            System.out.println("total objects = " + StatHandler.totalobjects);
            System.out.println("total classes = " + StatHandler.totalclasses);
            System.out.println("total objectarrays = " + StatHandler.totalobjectarrays);
            System.out.println("total primarrays = " + StatHandler.totalprimarrays);
            System.out.println("total strings = " + StatHandler.totalstrings);
            System.out.println("total smallid = " + StatHandler.totalsmallid);
            System.out.println("total mediumid = " + StatHandler.totalmediumid);
            System.out.println("total largeid = " + StatHandler.totallargeid);
            System.out.println("total smallrefs = " + StatHandler.totalsmallrefs);
            System.out.println("total mediumrefs = " + StatHandler.totalmediumrefs);
            System.out.println("total largerefs = " + StatHandler.totallargerefs);
            System.out.println("total smallsize = " + StatHandler.totalsmallsize);
            System.out.println("total mediumsize = " + StatHandler.totalmediumsize);
            System.out.println("total largesize = " + StatHandler.totallargesize);
            for (n = 0; n < StatHandler.totalrefcounts.length; ++n) {
                System.out.println("total refs[" + n + "] = " + StatHandler.totalrefcounts[n]);
            }
            System.out.println("total cachehits = " + StatHandler.totalcachehits);
            System.out.println("total cachemisses = " + StatHandler.totalcachemisses);
            System.out.println("total fithits = " + StatHandler.totalfithits);
            System.out.println("total fitmisses = " + StatHandler.totalfitmisses);
            System.out.println("total oldsize = " + StatHandler.totaloldsize);
            System.out.println("total newsize = " + StatHandler.totalnewsize);
            System.out.println("total hashed = " + StatHandler.totalhashed);
            jvm.handler = null;
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void printroots() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Print GC roots in asid " + jvm.space.hexId() + " jvmp " + jvm);
        try {
            jvm.printroots();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void printtitle() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println(this.dumpReader.title);
    }

    public void printtime() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        this.doc.println(this.dumpReader.time);
    }

    public void printversion() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.printversion();
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void dumpverbosegc() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpverbosegc(this.doc);
        }
        catch (Exception exception) {
            System.out.println("Unexpected error");
            exception.printStackTrace();
        }
    }

    public void dumpnative() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of all native methods in asid " + jvm.space.hexId());
        try {
            jvm.dumpNative(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void tcbsummary() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        for (int i = 0; i < this.spaces.length; ++i) {
            Tcb tcb;
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            AddressSpace addressSpace = this.spaces[i];
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray == null || tcbArray.length == 0) continue;
            this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
            this.doc.println("");
            for (int j = 0; j < tcbArray.length; ++j) {
                object2 = tcbArray[j];
                if (!((Tcb)object2).isKnownType()) continue;
                boolean bl = false;
                Object object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object = (ArrayList)object3.next();
                    tcb = (Tcb)((ArrayList)object).get(0);
                    if (!((Tcb)object2).stackEquals(tcb)) continue;
                    ((ArrayList)object).add(object2);
                    bl = true;
                    break;
                }
                if (bl) continue;
                object3 = new ArrayList();
                ((ArrayList)object3).add(object2);
                arrayList.add(object3);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object2 = (ArrayList)iterator.next();
                Tcb tcb2 = (Tcb)((ArrayList)object2).get(0);
                this.doc.println("The following tcbs had this traceback:");
                int n = 0;
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    tcb = (Tcb)object.next();
                    this.doc.print(tcb + "   ");
                    if (!object.hasNext() || ++n <= 7) continue;
                    this.doc.println("");
                    n = 0;
                }
                this.doc.println("");
                this.doc.println("");
                for (object = tcb2.topDsa; object != null; object = ((Dsa)object).previous()) {
                    this.doc.println("    " + ((Dsa)object).function());
                }
                this.doc.println("");
            }
        }
    }

    public void dumpclass(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            HeapClass heapClass = jvm.getClass(n);
            if (heapClass == null) {
                System.out.println("Could not find class: 0x" + Dump.hex(n));
                return;
            }
            jvm.dumpClass(this.doc, heapClass, false);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpobject(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpObject(this.doc, n);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpproperties() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        System.out.println("Dump of system properties in asid " + jvm.space.hexId());
        try {
            jvm.dumpProperties(this.doc, new NullHandler());
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void hpitrace() throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            AddressSpace addressSpace = this.getDefaultAddressSpace();
            Enumeration enumeration = addressSpace.getPages();
            while (enumeration.hasMoreElements()) {
                Page page = (Page)enumeration.nextElement();
                int[] nArray = page.getIntArray();
                for (int i = 0; i < nArray.length; ++i) {
                    int n;
                    int n2;
                    int n3;
                    String string;
                    if (nArray[i] != 0x2A2A2A4A || !(string = addressSpace.readString(n3 = page.getAddress() + (i << 2))).equals("***JAVA_TRACE_TABLE****") || !(string = addressSpace.readString(n3 + 24)).equals("S390JAVA")) continue;
                    int n4 = addressSpace.readInt(n3 + 32);
                    int n5 = addressSpace.readInt(n3 + 44);
                    int n6 = addressSpace.readInt(n3 + 48);
                    int n7 = addressSpace.readInt(n3 + 52);
                    int n8 = n2 = n7 + n4;
                    int n9 = addressSpace.getId();
                    System.out.println("found hpi trace, offset = " + Dump.hex(n4) + " table start = " + Dump.hex(n7) + " table end = " + Dump.hex(n6) + " table size = " + Dump.hex(n5) + " asid = " + Dump.hex(n9));
                    boolean bl = false;
                    while (true) {
                        try {
                            if (addressSpace.readInt(n8 + 20) == n9 && (n = addressSpace.readInt(n8)) >= 32 && n < 100) {
                                bl = true;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            n8 = n7 - 4;
                        }
                        if ((n8 += 4) == n2) break;
                        if (n8 < n6) continue;
                        n8 = n7;
                    }
                    if (!bl) {
                        System.out.println("could not find a valid record!");
                        return;
                    }
                    n = 1;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
                    int n10 = 0;
                    int n11 = n8;
                    while (n10 < n5 && !(n8 >= n2 ? n11 >= n2 && n11 < n8 : n11 >= n2)) {
                        int n12 = addressSpace.readInt(n11);
                        if (n11 + n12 >= n6) {
                            n11 += n12 - n5;
                            n10 += n12;
                            System.out.println("skipping last record");
                            continue;
                        }
                        int n13 = addressSpace.readInt(n11 + 4);
                        long l = addressSpace.readInt(n11 + 8);
                        long l2 = addressSpace.readInt(n11 + 12);
                        Date date = AddressSpace.mvsClockToDate(l << 32 | l2 & 0xFFFFFFFFL);
                        if (n != 0) {
                            System.out.println("Trace begins at " + date);
                            n = 0;
                        }
                        String string2 = simpleDateFormat.format(date);
                        String string3 = n13 == 0 ? "No format string" : addressSpace.readString(n13);
                        int n14 = addressSpace.readInt(n11 + 16);
                        int n15 = addressSpace.readInt(n11 + 24);
                        System.out.print(string2 + " tcb " + Dump.hex(n14) + " " + string3 + " ");
                        for (int j = 0; j < n15; ++j) {
                            int n16 = addressSpace.readInt(n11 + 32 + (j << 2));
                            System.out.print(Dump.hex(n16) + " ");
                        }
                        System.out.println("");
                        n11 += n12;
                        n10 += n12;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void dumpmdata(int n) throws Exception {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        Jvm jvm = this.getDefaultJvm();
        try {
            jvm.dumpMdata(this.doc, n);
        }
        catch (Exception exception) {
            System.out.println("bad heap in asid " + jvm.space.hexId());
            exception.printStackTrace();
        }
    }

    public void systrace() throws Exception {
        AddressSpace addressSpace;
        int n;
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        for (n = 0; n < this.spaces.length; ++n) {
            block8: {
                addressSpace = this.spaces[n];
                if (!addressSpace.isTrace()) continue;
                try {
                    this.processTrace(addressSpace);
                }
                catch (Exception exception) {
                    if (!debug) break block8;
                    this.doc.println("problem processing trace!");
                }
            }
            if (!debug) continue;
            this.doc.println("finished processing trace");
        }
        for (n = 0; n < this.spaces.length; ++n) {
            addressSpace = this.spaces[n];
            try {
                if (n > 0) {
                    this.doc.println("");
                }
                addressSpace.printFullTrace(this.doc);
                continue;
            }
            catch (Exception exception) {
                if (!debug) continue;
                this.doc.println("problem processing trace!");
            }
        }
    }

    public void search() throws Exception {
        System.out.println("searching for " + Dump.hex(searchvalue) + "...");
        for (int i = 0; i < this.spaces.length; ++i) {
            AddressSpace addressSpace = this.spaces[i];
            int n = 0;
            while ((n = addressSpace.search(n, searchvalue)) != -1) {
                System.out.println("found at " + Dump.hex(n) + " in asid " + addressSpace);
                n += 4;
            }
        }
    }

    public void doStuff() {
        Object[] objectArray;
        AddressSpace addressSpace;
        int n;
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        if (debug) {
            this.doc.println("finished scan of dump");
        }
        try {
            this.doc.print("Dump title: ");
            this.printtitle();
            this.doc.print("Time of dump: ");
            this.printtime();
        }
        catch (Exception exception) {
            this.doc.println("Error processing dump title/time: " + exception);
        }
        for (n = 0; n < this.spaces.length; ++n) {
            block42: {
                addressSpace = this.spaces[n];
                if (!addressSpace.isTrace()) continue;
                try {
                    this.processTrace(addressSpace);
                }
                catch (Exception exception) {
                    if (!debug) break block42;
                    this.doc.println("problem processing trace!");
                }
            }
            if (!debug) continue;
            this.doc.println("finished processing trace");
        }
        for (n = 0; n < this.spaces.length; ++n) {
            addressSpace = this.spaces[n];
            if (!addressSpace.isJava() || (objectArray = addressSpace.jvms()) == null || objectArray.length <= 0) continue;
            System.out.print("Jvm fullversion: ");
            try {
                ((Jvm)objectArray[0]).printversion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("");
            break;
        }
        if (debug) {
            this.doc.println("finished creating Dump instance");
        }
        for (n = 0; n < this.spaces.length; ++n) {
            int n2;
            Object object;
            Object object2;
            int n3;
            addressSpace = this.spaces[n];
            if (verbose) {
                this.doc.println("processing asid " + addressSpace.hexId());
            }
            if ((objectArray = addressSpace.tcbs()) == null || objectArray.length == 0) continue;
            this.doc.println("found " + objectArray.length + " TCBs in asid 0x" + addressSpace.hexId());
            this.doc.println("");
            this.samplecaa = 0;
            boolean bl = false;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                object2 = objectArray[n3];
                if (object2.isKnownType()) {
                    this.printTCBStack((Tcb)object2, bl, addressSpace);
                    Function[] functionArray = object2.traceFunctions();
                    if (functionArray == null) continue;
                    this.doc.println("found trace table:");
                    this.doc.println("");
                    this.printTrace(functionArray);
                    this.doc.println("");
                    continue;
                }
                this.doc.println("TCB of unknown type " + object2.hexId() + " caa " + Dump.hex(object2.caa()));
                bl = true;
            }
            this.doc.println("");
            for (n3 = 0; addressSpace.jvms() != null && n3 < addressSpace.jvms().length; ++n3) {
                addressSpace.jvms()[n3].checkTidChain(this.doc);
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                object2 = objectArray[n3];
                if (object2.tid() == 0) continue;
                boolean bl2 = false;
                object = object2.jvm;
                if (object == null) continue;
                try {
                    n2 = ((Jvm)object).rootTid;
                    while (n2 != 0) {
                        if (object2.tid() == n2) {
                            if (verbose) {
                                this.doc.println("found " + Dump.hex(n2) + " in tid chain");
                            }
                            bl2 = true;
                            if (!object2.isKnownType()) {
                                this.doc.println("*** Warning! tcb " + object2.hexId() + " with tid " + Dump.hex(object2.tid()) + " is unknown TCB type but known by Java");
                                object2.printJavaStack(this.doc);
                            }
                            break;
                        }
                        n2 = addressSpace.readInt(n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl2) continue;
                this.doc.println("*** Warning! tid " + Dump.hex(object2.tid()) + " not found in tid chain, jvm " + object);
            }
            Function[] functionArray = addressSpace.traceFunctions();
            if (functionArray != null && functionArray.length != 0) {
                this.doc.println("trace table for asid " + addressSpace.hexId() + ":");
                this.doc.println("");
                this.printTrace(functionArray);
                this.doc.println("");
            }
            if (this.samplecaa != 0) {
                try {
                    String string;
                    int n4;
                    int n5;
                    int n6 = addressSpace.readInt(this.samplecaa + 752);
                    int n7 = addressSpace.readInt(n6 + 88);
                    this.doc.printHeader("environment variables:");
                    this.doc.println("");
                    object = new Table(new String[]{"key", "value"});
                    n2 = 0;
                    while ((n2 = addressSpace.readInt(n7)) != 0) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        while ((n5 = addressSpace.readUnsignedByte(n2++)) != 0) {
                            byteArrayOutputStream.write(n5);
                        }
                        String string2 = Dump.getEbcdicString(byteArrayOutputStream.toByteArray());
                        n4 = string2.indexOf(61);
                        if (n4 >= 0) {
                            String string3 = string2.substring(0, n4);
                            string = string2.substring(n4 + 1);
                            ((Table)object).addRow(new String[]{string3, string});
                        }
                        n7 += 4;
                    }
                    this.doc.addElement((Element)object);
                    this.doc.println("");
                    this.doc.printHeader("loaded dlls:");
                    this.doc.println("");
                    object = new Table(new String[]{"name", "wsa"});
                    n2 = addressSpace.readInt(n6 + 1096);
                    while (n2 != 0) {
                        int n8 = addressSpace.readUnsignedShort(n2 + 60);
                        n5 = addressSpace.readInt(n2 + 64);
                        int n9 = addressSpace.readInt(n2 + 20);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        for (int i = 0; i < n8; ++i) {
                            int n10 = addressSpace.readUnsignedByte(n5++);
                            byteArrayOutputStream.write(n10);
                        }
                        string = Dump.getEbcdicString(byteArrayOutputStream.toByteArray());
                        ((Table)object).addRow(new String[]{string, Dump.hex(n9)});
                        n2 = addressSpace.readInt(n2);
                    }
                    this.doc.addElement((Element)object);
                    this.doc.println("");
                    this.doc.printHeader("le runtime options:");
                    this.doc.println("");
                    object = new Table(new String[]{"option", "suboption", "value"});
                    n2 = addressSpace.readInt(n6 + 16);
                    int n11 = n2 + addressSpace.readInt(n2 + 240);
                    n5 = addressSpace.readUnsignedByte(n11 + 4);
                    if ((n5 & 0x80) != 0) {
                        int n12 = addressSpace.readUnsignedByte(n11 + 5);
                        ((Table)object).addRow("STORAGE", "heap_alloc_value", Dump.hex(n12, 2));
                    } else {
                        ((Table)object).addRow("STORAGE", "heap_alloc_value", "NONE");
                    }
                    if ((n5 & 0x40) != 0) {
                        int n13 = addressSpace.readUnsignedByte(n11 + 6);
                        ((Table)object).addRow("STORAGE", "heap_free_value", Dump.hex(n13, 2));
                    } else {
                        ((Table)object).addRow("STORAGE", "heap_free_value", "NONE");
                    }
                    if ((n5 & 0x20) != 0) {
                        int n14 = addressSpace.readUnsignedByte(n11 + 7);
                        ((Table)object).addRow("STORAGE", "dsa_alloc_value", Dump.hex(n14, 2));
                    } else {
                        ((Table)object).addRow("STORAGE", "dsa_alloc_value", "NONE");
                    }
                    int n15 = n2 + addressSpace.readInt(n2 + 232);
                    n4 = addressSpace.readInt(n15 + 4);
                    ((Table)object).addRow("STACK", "init_size", "" + n4);
                    int n16 = addressSpace.readInt(n15 + 8);
                    ((Table)object).addRow("STACK", "incr_size", "" + n16);
                    n5 = addressSpace.readUnsignedByte(n15 + 12);
                    ((Table)object).addRow("STACK", "location", (n5 & 0x80) == 0 ? "ANYWHERE" : "BELOW");
                    ((Table)object).addRow("STACK", "disposition", (n5 & 0x40) == 0 ? "KEEP" : "FREE");
                    this.doc.addElement((Element)object);
                }
                catch (Exception exception) {
                    this.doc.println("problem processing sample caa: " + exception);
                }
            } else {
                this.doc.println("no sample caa!");
            }
            object2 = addressSpace.jvms();
            if (object2 == null) continue;
            for (int i = 0; i < ((Jvm[])object2).length; ++i) {
                object = object2[i];
                if (!analyzeHeap) continue;
                try {
                    ((Jvm)object).analyzeHeap(this.doc, new NullHandler());
                    continue;
                }
                catch (Exception exception) {
                    this.doc.println("bad heap in asid " + addressSpace.hexId());
                    exception.printStackTrace();
                }
            }
        }
    }

    public Jvm[] jvms() {
        Vector<Jvm> vector = new Vector<Jvm>();
        for (int i = 0; i < this.spaces.length; ++i) {
            int n;
            AddressSpace addressSpace = this.spaces[i];
            Tcb[] tcbArray = addressSpace.tcbs();
            for (n = 0; n < tcbArray.length; ++n) {
                Tcb tcb = tcbArray[n];
                if (!tcb.isKnownType()) continue;
                for (Dsa dsa = tcb.topDsa; dsa != null; dsa = dsa.previous()) {
                    dsa.function();
                }
            }
            if (addressSpace.jvms() == null) continue;
            for (n = 0; n < addressSpace.jvms().length; ++n) {
                vector.addElement(addressSpace.jvms()[n]);
            }
        }
        return vector.toArray(new Jvm[0]);
    }

    public static String getEbcdicString(byte[] byArray) {
        return Cp1047.getString(byArray);
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public void printStacks() {
        if (Dump.isFromJFormat()) {
            this.doc.setPlainText(true);
        }
        if (debug) {
            this.doc.println("finished scan of dump");
        }
        for (int i = 0; i < this.spaces.length; ++i) {
            Tcb[] tcbArray;
            AddressSpace addressSpace = this.spaces[i];
            if (verbose) {
                this.doc.println("processing asid " + addressSpace.hexId());
            }
            if ((tcbArray = addressSpace.tcbs()) == null || tcbArray.length == 0) continue;
            this.doc.println("found " + tcbArray.length + " TCBs in asid 0x" + addressSpace.hexId());
            this.doc.println("");
            this.samplecaa = 0;
            boolean bl = false;
            for (int j = 0; j < tcbArray.length; ++j) {
                Tcb tcb = tcbArray[j];
                if (tcb.isKnownType()) {
                    this.printTCBStack(tcb, bl, addressSpace);
                    continue;
                }
                this.doc.println("TCB of unknown type " + tcb.hexId() + " caa " + Dump.hex(tcb.caa()));
                bl = true;
            }
            this.doc.println("");
        }
    }

    private void printTCBStack(Tcb tcb, boolean bl, AddressSpace addressSpace) {
        Object object;
        Object object2;
        Table table;
        int[] nArray;
        if (bl) {
            this.doc.println("");
            bl = false;
        }
        this.doc.print("TCB " + tcb.hexId() + " tid " + Dump.hex(tcb.tid()));
        if (tcb.tid_threadself() != -1L) {
            this.doc.print(" pthread id " + Long.toHexString(tcb.tid_threadself()));
        }
        if (tcb.threadIndex() != 0) {
            this.doc.print(" tindex " + Dump.hex(tcb.threadIndex()));
        }
        if (tcb.tid_type() != -1) {
            this.doc.print(" tid type 0x" + Dump.hex(tcb.tid_type()));
        }
        if (tcb.tid_state() != -1) {
            this.doc.print(" tid state 0x" + Dump.hex(tcb.tid_state()));
        }
        if (tcb.tid_singled() != -1) {
            this.doc.print(" tid singled 0x" + Dump.hex(tcb.tid_singled()));
        }
        if (tcb.jvm != null) {
            this.doc.print(" jvmp " + Dump.hex(tcb.jvm.jvmp));
            this.doc.print(" ee " + Dump.hex(tcb.ee()));
        }
        this.doc.print(tcb.caa() == 0 ? "" : " caa " + Dump.hex(tcb.caa()));
        this.doc.print(" (" + tcb.type() + ")");
        this.doc.println("");
        if (tcb.caa() != 0 && !tcb.dodgy && this.samplecaa == 0) {
            this.samplecaa = tcb.caa();
        }
        if ((nArray = tcb.failingRegisters()) != null) {
            this.doc.println("Registers at point of failure:");
            table = new Table();
            table.setBorder(0);
            table.addRow(new String[]{"r0:", Dump.hex(nArray[0]), "r1:", Dump.hex(nArray[1]), "r2:", Dump.hex(nArray[2]), "r3:", Dump.hex(nArray[3])});
            table.addRow(new String[]{"r4:", Dump.hex(nArray[4]), "r5:", Dump.hex(nArray[5]), "r6:", Dump.hex(nArray[6]), "r7:", Dump.hex(nArray[7])});
            table.addRow(new String[]{"r8:", Dump.hex(nArray[8]), "r9:", Dump.hex(nArray[9]), "r10:", Dump.hex(nArray[10]), "r11:", Dump.hex(nArray[11])});
            table.addRow(new String[]{"r12:", Dump.hex(nArray[12]), "r13:", Dump.hex(nArray[13]), "r14:", Dump.hex(nArray[14]), "r15:", Dump.hex(nArray[15])});
            table.addRow(new String[]{"psw:", Dump.hex(nArray[16]), "", Dump.hex(nArray[17])});
            this.doc.addElement(table);
            this.doc.println("");
        }
        table = new Table();
        table.suppressEmptyColumns(true);
        table.addHeaderCell("Dsa");
        table.addHeaderCell("Entry");
        table.addHeaderCell("Offset");
        if (reg != -1) {
            object2 = reg < 10 ? "r" + reg + " " : "r" + reg;
            table.addHeaderCell((String)object2);
        }
        table.addHeaderCell("Function");
        if (tcb.isJava() && !tcb.usesXplink()) {
            table.addHeaderCell("Method");
        }
        table.addHeaderCell("Module");
        for (object2 = tcb.topDsa; object2 != null; object2 = ((Dsa)object2).previous()) {
            object = new Row();
            ((Row)object).addCell(Dump.hex(((Dsa)object2).address));
            ((Row)object).addCell(Dump.hex(((Dsa)object2).entryPoint()));
            ((Row)object).addCell(Dump.hex(((Dsa)object2).offset()));
            if (reg != -1) {
                ((Row)object).addCell(Dump.hex(((Dsa)object2).reg(reg)));
            }
            ((Row)object).addCell(((Dsa)object2).function());
            if (tcb.isJava() && !tcb.usesXplink()) {
                ((Row)object).addCell(((Dsa)object2).method());
            }
            ((Row)object).addCell(((Dsa)object2).program());
            table.addRow((Row)object);
        }
        this.doc.addElement(table);
        if (tcb.isJava()) {
            tcb.printJavaStack(this.doc);
        }
        if (tcb.hasPendingException() || printExceptionObject) {
            tcb.printException(this.doc);
        }
        if (tcb.currentSignal() != -1) {
            this.doc.println("");
            this.doc.println("Found pending signal: " + tcb.currentSignal());
        }
        if (printAllocCache && tcb.tid() != 0) {
            tcb.printAllocCache(this.doc);
        }
        if (tcb.tid() != 0 && tcb.jvm != null) {
            int n = 0;
            object = tcb.jvm;
            try {
                int n2 = tcb.tid();
                while (n2 != 0) {
                    if (++n > 10000) {
                        System.out.println("Warning! loop found in tid chain!");
                        n = 0;
                        break;
                    }
                    n2 = addressSpace.readInt(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n > ((Jvm)object).longestTidChain) {
                ((Jvm)object).longestTidChain = n;
                ((Jvm)object).rootTid = tcb.tid();
            }
        }
        this.doc.println("");
    }

    protected static boolean isFromJFormat() {
        return fromJFormat;
    }

    public void setFromJFormat(boolean bl) {
        fromJFormat = bl;
    }

    public static void setDisassemble(boolean bl) {
        disassemble = bl;
    }

    public static void setDisassembleAddress(int n) {
        disassembleAddress = n;
    }

    public static void setDisassembleLength(int n) {
        disassembleLength = n;
    }

    public static void setDumpstorage(boolean bl) {
        dumpstorage = bl;
    }

    public static void setDumpstorageAddress(int n) {
        dumpstorageAddress = n;
    }

    public static void setDumpstorageLength(int n) {
        dumpstorageLength = n;
    }

    public static void setDumpclasses(boolean bl) {
        dumpclasses = bl;
    }

    public static void setDumpclass(int n) {
        dumpclass = n;
    }

    public static void setSystrace(boolean bl) {
        systrace = bl;
    }

    public static void setDumpmdata(boolean bl) {
        dumpmdata = bl;
    }

    public static void setAnalyzeHeap(boolean bl) {
        analyzeHeap = bl;
    }

    public static void setReg(int n) {
        reg = n;
    }

    public boolean isSvcdump() {
        return this.svcdump;
    }

    public AddressSpace[] getSpaces() {
        return this.spaces;
    }

    static {
        dumpstorage = false;
        dumpclasses = false;
        dumpnative = false;
        tcbsummary = false;
        verifysubpools = false;
        verifyheap = false;
        printdosed = false;
        heapstats = false;
        printroots = false;
        printversion = false;
        printtitle = false;
        printtime = false;
        dumpverbosegc = false;
        dumpclass = 0;
        dumpobject = 0;
        dumpproperties = false;
        dumpapars = false;
        dumpmdata = false;
        mdata = 0;
        systrace = false;
        hpitrace = false;
        search = false;
        defaultJvm = -1;
        fromJFormat = false;
        arrayLength = 0;
        arrayCount = 0;
        objectCount = 0;
        reg = -1;
    }
}

