/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Heapdump;
import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.VertexClass;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.util.html.Table;
import java.util.Arrays;
import java.util.Comparator;

public class Print
extends PrintBase {
    Document doc = new Document(true);
    Table table = new Table(new String[]{"Type", "Address", "Size", "Class"});
    int rows;
    int totalLinks;
    boolean summary;
    boolean totals;

    public static void main(String[] stringArray) {
        Print print = new Print();
        print.start(stringArray, "Print");
    }

    String[] options() {
        return new String[]{"-summary", "-totals"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tJust print the summary of classes", "\tJust print the totals of objects, sizes and refs"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-summary".equals(string)) {
            this.summary = true;
            return true;
        }
        if ("-totals".equals(string)) {
            this.totals = true;
            return true;
        }
        return super.parseOption(string, string2);
    }

    void printInfo() {
        if (!this.totals) {
            super.printInfo();
        }
    }

    protected void parseStart() {
        try {
            this.dump = new Heapdump(this.filename, false);
        }
        catch (Exception exception) {
            System.out.println("Unexpected error: " + exception);
            System.exit(0);
            return;
        }
        if (this.totals) {
            if (this.dump.version == 0) {
                System.out.println("");
                System.out.println("this is an old-style .phd file, please re-run Convert");
                System.out.println("");
            } else {
                System.out.println("");
                System.out.println("total objects = " + this.dump.totalObjects);
                System.out.println("total size = " + this.dump.totalSize);
                System.out.println("total refs = " + this.dump.totalRefs);
                System.out.println("");
            }
            System.exit(0);
        }
        super.parseStart();
    }

    protected void parseEnd() {
        super.parseEnd();
        if (!this.summary) {
            this.doc.addElement(this.table);
        }
        this.doc.println("");
        this.doc.println("total count " + this.totalCount + " total links " + this.totalLinks + " total size " + this.totalSize);
        this.doc.println("");
        this.doc.println("Summary of heap usage by class");
        this.doc.println("");
        this.createClasses();
        this.classes = this.classTable.values().toArray(new VertexClass[0]);
        Arrays.sort(this.classes, new Comparator(){

            public int compare(Object object, Object object2) {
                VertexClass vertexClass = (VertexClass)object;
                VertexClass vertexClass2 = (VertexClass)object2;
                return vertexClass2.totalSize - vertexClass.totalSize;
            }
        });
        this.table = new Table(new String[]{"Total size", "Instance size", "Count", "Class"});
        for (int i = 0; i < this.classes.length; ++i) {
            VertexClass vertexClass = this.classes[i];
            String string = vertexClass.type == 1 || vertexClass.type == 2 ? "" + vertexClass.instanceSize : "varies";
            this.table.addRow(new String[]{"" + vertexClass.totalSize, string, "" + vertexClass.ids.size(), "" + vertexClass});
        }
        this.doc.addElement(this.table);
        this.doc.println("");
        this.doc.println("Summary of heap usage by object size");
        this.doc.println("");
        this.table = new Table(new String[]{"Size", "Id", "Class"});
        IntegerArray integerArray = this.graph.biggestIds();
        int n = SvcdumpProperties.getIntProperty("findroots.maxbigobjects", 30);
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray.get(i);
            this.table.addRow(new String[]{"" + this.graph.getSize(n2), Print.hex(n2), this.getName(n2)});
        }
        this.doc.addElement(this.table);
    }

    void addRow(String[] stringArray) {
        if (this.summary) {
            return;
        }
        this.table.addRow(stringArray);
        if (this.rows++ > 10000) {
            this.doc.addElement(this.table);
            this.table = new Table();
            this.rows = 0;
        }
    }

    public void objectDump(int n, int n2, int n3, int n4, int[] nArray) {
        super.objectDump(n, n2, n3, n4, nArray);
        this.addRow(new String[]{"object", Print.hex(n), "" + n4, this.getString(n2)});
        this.totalLinks += nArray.length;
    }

    public void classDump(int n, int n2, int n3, int n4, int[] nArray) {
        super.classDump(n, n2, n3, n4, nArray);
        this.addRow(new String[]{"class", Print.hex(n), "" + n4, this.getString(n2)});
        this.totalLinks += nArray.length;
    }

    public void primitiveArrayDump(int n, int n2, int n3, int n4) {
        super.primitiveArrayDump(n, n2, n3, n4);
        this.addRow(new String[]{"primarray", Print.hex(n), "" + n4, "" + n2});
    }

    public void objectArrayDump(int n, int n2, int n3, int n4, int[] nArray) {
        super.objectArrayDump(n, n2, n3, n4, nArray);
        this.addRow(new String[]{"objarray", Print.hex(n), "" + n4, this.getString(n2)});
        this.totalLinks += nArray.length;
    }
}

