/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.util.IntegerArray;
import java.io.LineNumberReader;
import java.io.Reader;

public class JavatraceParser {
    HeapdumpContentHandler handler;
    LineNumberReader lnr;
    String currentLine;
    static int skip = 0;

    JavatraceParser(HeapdumpContentHandler heapdumpContentHandler, Reader reader) throws Exception {
        this.handler = heapdumpContentHandler;
        this.parse(reader);
    }

    void parse(Reader reader) throws Exception {
        this.lnr = new LineNumberReader(reader);
        this.skipHeader();
        while (this.currentLine != null) {
            int n = this.lnr.getLineNumber();
            if (this.currentLine.length() == 0) {
                System.out.println("blank line? " + n);
            } else {
                char c = this.currentLine.charAt(0);
                if (c != 'n' && c != 'a') {
                    System.out.println("strange line? " + n + ": " + this.currentLine);
                    break;
                }
                int n2 = 3;
                int n3 = this.currentLine.indexOf(32, n2);
                int n4 = this.currentLine.indexOf(32, n3 + 1) + 1;
                int n5 = this.currentLine.indexOf(32, n4);
                if (n5 == -1) {
                    n5 = this.currentLine.length();
                }
                int n6 = 0;
                try {
                    n6 = Integer.parseInt(this.currentLine.substring(n2, n3), 16);
                }
                catch (Exception exception) {
                    this.handler.error("bad address? " + n + ": " + this.currentLine);
                }
                if (c == 'a') {
                    int n7 = 0;
                    try {
                        n7 = Integer.parseInt(this.currentLine.substring(n4, n5), 10);
                    }
                    catch (Exception exception) {
                        this.handler.error("bad array size? " + n + ": " + this.currentLine);
                    }
                    this.handler.primitiveArrayDump(n6, 1, n7);
                } else {
                    String string = this.currentLine.substring(n4, n5);
                    IntegerArray integerArray = new IntegerArray();
                    int n8 = this.currentLine.indexOf(32, n5);
                    if (n8 != -1) {
                        int n9 = n8 + 1;
                        int n10 = 0;
                        while (n10 != -1) {
                            int n11 = n10 = this.currentLine.indexOf(32, n9);
                            if (n10 == -1 && n9 == (n11 = this.currentLine.length())) break;
                            int n12 = 0;
                            try {
                                n12 = Integer.parseInt(this.currentLine.substring(n9, n11), 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("bad number? " + n + ": " + this.currentLine);
                                return;
                            }
                            integerArray.add(n12);
                            n9 = n10 + 1;
                        }
                    }
                    if (this.currentLine.charAt(1) == 'c') {
                        this.handler.classDump(n6, string, integerArray.toArray(), 300);
                    } else {
                        this.handler.instanceDump(n6, string, integerArray.toArray(), integerArray.size() * 4 + 8);
                    }
                }
            }
            this.currentLine = this.lnr.readLine();
        }
    }

    void skipHeader() throws Exception {
        String string;
        while ((string = this.lnr.readLine()).length() == 0 || string.charAt(0) != 'n') {
        }
        this.currentLine = string;
        for (int i = 0; i < skip; ++i) {
            while ((string = this.lnr.readLine()).length() == 0 || string.charAt(0) == 'n' || string.charAt(0) == 'a') {
            }
            this.currentLine = this.lnr.readLine();
        }
    }
}

