/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.DigraphParser;
import com.ibm.jvm.findroots.Heapdump;
import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.HeapdumpParser;
import com.ibm.jvm.findroots.HeapdumpWriter;
import com.ibm.jvm.findroots.HprofParseFile;
import com.ibm.jvm.findroots.JavatraceParser;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.util.SvcdumpProperties;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Convert
extends Base
implements HeapdumpContentHandler {
    Hashtable classNames = new Hashtable();
    int currentClassId;
    Heapdump dumpWriter;
    HeapdumpWriter newDumpWriter;
    int jvmIndex = -1;
    boolean includeDead = false;
    boolean newFormat = false;

    String className() {
        return "Convert";
    }

    String[] options() {
        return new String[]{"-verbose", "-jvm <jvm index>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tPrint extra debugging info", "\tSpecify which jvm to use"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-jvm".equals(string)) {
            try {
                this.jvmIndex = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.err.println(string2 + " is not a valid number");
                this.usage();
            }
            return true;
        }
        if ("-includedead".equals(string)) {
            this.includeDead = true;
            return true;
        }
        if ("-new".equals(string)) {
            this.newFormat = true;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        new Convert(stringArray);
    }

    void printChoicesAndExit(Jvm[] jvmArray) {
        System.err.println("Choose a jvm from the following list:");
        for (int i = 0; i < jvmArray.length; ++i) {
            System.err.println("\tjvm index = " + i + " asid = " + Convert.hex(jvmArray[i].asid()) + " jvmp = " + Convert.hex(jvmArray[i].jvmp));
        }
        System.exit(1);
    }

    void createDumpWriter(String string) throws Exception {
        if (this.newFormat) {
            this.newDumpWriter = new HeapdumpWriter(string + ".phd");
        } else {
            this.dumpWriter = new Heapdump(string + ".phd", true);
        }
    }

    Convert(String[] stringArray) throws Exception {
        if (!SvcdumpProperties.getBooleanProperty("findroots.registered", false)) {
            System.err.println("Hi, thanks for downloading the latest version of FindRoots. Please");
            System.err.println("could you do me a big favour and drop me a line to let me know that you are");
            System.err.println("using this software. In return I will add your email address to a mailing list");
            System.err.println("to keep you informed of future developments. It would also be useful to know");
            System.err.println("how many people are using this for when it comes to funding additional work.");
            System.err.println("All you have to do is send an email to dgriff@hursley.ibm.com with the subject");
            System.err.println("\"FindRoots user\".");
            System.err.println("");
            System.err.println("Thanks!");
            System.err.println("");
            System.err.println("Dave");
            try {
                SvcdumpProperties.setProperty("findroots.registered", "true");
            }
            catch (Exception exception) {
                System.err.println("");
                System.err.println("Whoops, a problem occurred when trying to write to the .svcdumprc file in");
                System.err.println("your home directory: " + exception);
                System.err.println("To stop this message appearing again, please either create a .svcdumprc file");
                System.err.println("in your home directory containing the line \"findroots.registered=true\", or");
                System.err.println("set the system property \"-Dfindroots.registered=true\" when running.");
            }
        }
        this.parseOptions(stringArray);
        String string = stringArray[stringArray.length - 1];
        if (string.endsWith(".digraph")) {
            this.createDumpWriter(string);
            new DigraphParser(this, string);
        } else if (Dump.isSupportedSource(string).booleanValue()) {
            Dump dump = new Dump(string);
            if (verbose) {
                Dump.verbose = true;
            }
            Jvm jvm = null;
            Jvm[] jvmArray = dump.jvms();
            if (jvmArray.length > 1) {
                if (this.jvmIndex == -1) {
                    System.err.println("More than one JVM found, please use the -jvm");
                    System.err.println("option to specify which one you want.");
                    this.printChoicesAndExit(jvmArray);
                }
                if (this.jvmIndex >= jvmArray.length) {
                    System.err.println("Error - maximum value for jvm index = " + (jvmArray.length - 1));
                    System.exit(1);
                }
                jvm = jvmArray[this.jvmIndex];
            } else if (jvmArray.length == 0) {
                System.err.println("No JVM's were found in this dump!");
                System.exit(1);
            } else {
                jvm = jvmArray[0];
            }
            this.createDumpWriter(string);
            jvm.scanHeap(this, this.includeDead);
        } else {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.read();
            int n2 = fileInputStream.read();
            int n3 = fileInputStream.read();
            if (n == 74 && n2 == 65 && n3 == 86) {
                this.createDumpWriter(string);
                new HprofParseFile(this, string);
            } else if (n == 47 && n2 == 47 || n == 48 && n2 == 120) {
                this.createDumpWriter(string);
                new HeapdumpParser(this, string);
            } else {
                fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                InputStreamReader inputStreamReader = null;
                if (n == 42 && n2 == 42 && n3 == 42) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
                } else if (n == 92 && n2 == 92 && n3 == 92) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "Cp1047");
                } else if (n == 110 && n2 == 99 && n3 == 32) {
                    inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
                } else {
                    Convert.serror("Unknown data format: " + string);
                }
                this.createDumpWriter(string);
                new JavatraceParser(this, inputStreamReader);
            }
        }
        if (this.newFormat) {
            this.newDumpWriter.close();
        } else {
            this.dumpWriter.close();
        }
    }

    int classNameIndex(String string) {
        Integer n = (Integer)this.classNames.get(string);
        if (n == null) {
            n = new Integer(this.currentClassId++);
            this.classNames.put(string, n);
            this.dumpWriter.stringDump(string);
        }
        return n;
    }

    public void instanceDump(int n, String string, int[] nArray, int n2) {
        if (!this.newFormat) {
            this.dumpWriter.objectDump(n, this.classNameIndex(string), 0, n2, nArray);
        }
    }

    public void instanceDump(int n, int n2, int[] nArray) {
        if (this.newFormat) {
            this.newDumpWriter.objectDump(n, n2, nArray);
        }
    }

    public void classDump(int n, String string, int[] nArray, int n2) {
        if (!this.newFormat) {
            this.dumpWriter.classDump(n, this.classNameIndex(string), 0, n2, nArray);
        }
    }

    public void classDump(int n, int n2, String string, int n3, int[] nArray) {
        if (this.newFormat) {
            this.newDumpWriter.classDump(n, n2, string, n3, nArray);
        }
    }

    public void objectArrayDump(int n, String string, int[] nArray, int n2) {
        if (!this.newFormat) {
            this.dumpWriter.objectArrayDump(n, this.classNameIndex(string), 0, n2, nArray);
        }
    }

    public void objectArrayDump(int n, int n2, int[] nArray) {
        if (this.newFormat) {
            this.newDumpWriter.objectArrayDump(n, n2, nArray);
        }
    }

    public void primitiveArrayDump(int n, int n2, int n3) {
        if (this.newFormat) {
            this.newDumpWriter.primitiveArrayDump(n, n2 - 4, n3);
        } else {
            this.dumpWriter.primitiveArrayDump(n, n2, 0, (n3 << (n2 - 4 & 3)) + 8);
        }
    }

    public void addEdge(int n, int n2) {
        this.error("Unimplemented method");
    }

    static void serror(String string) {
        throw new Error(string);
    }

    public void error(String string) {
    }
}

