/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Vector;

class SDFFRegister
extends DvRegister {
    private Vector names = new Vector();
    private Vector values = new Vector();
    private long count;
    private long size;

    SDFFRegister() {
    }

    public DvAddress getAddressValue() {
        return null;
    }

    public String[] getStringArray() {
        String[] stringArray = new String[(int)this.count];
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((long)n < this.count) {
            String string = Long.toHexString((Long)this.values.get(n));
            while ((long)string.length() != 2L * this.size) {
                string = "0" + string;
            }
            String string2 = (String)this.names.get(n) + string;
            vector.add(string2);
            ++n;
        }
        Collections.sort(vector);
        n = 0;
        while ((long)n < this.count) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    public String getStringValue() {
        String string = "";
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((long)n < this.count) {
            String string2 = Long.toHexString((Long)this.values.get(n));
            while ((long)string2.length() != 2L * this.size) {
                string2 = "0" + string2;
            }
            String string3 = (String)this.names.get(n) + string2;
            vector.add(string3);
            ++n;
        }
        Collections.sort(vector);
        n = 0;
        while ((long)n < this.count) {
            if (0 == n % 4) {
                string = string + "\n   ";
            }
            string = string + (String)vector.get(n) + "   ";
            ++n;
        }
        if (string.equals("")) {
            string = "\n  --- No register data for this thread --- \n";
        }
        return string;
    }

    public String description() {
        return "";
    }

    public long getValue(int n) {
        return (Long)this.values.get(n);
    }

    public String getName(int n) {
        return (String)this.names.get(n);
    }

    public long getCount() {
        return this.count;
    }

    void printSdff(Sdff sdff) throws IOException {
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes(new String("REGISTER"));
        sdff.writeLong(0L);
        sdff.writeLong(0L);
        sdff.writeLong(0L);
        sdff.writeLong(0L);
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }

    public static SDFFRegister loadFromFile(long l, RandomAccessFile randomAccessFile) {
        DvUtils.writetoTrace("Entry to SDFFRegister:loadFromFile...");
        long l2 = l;
        DvUtils.writetoTrace("  .... Loading SDFFRegister object from file :" + l);
        SDFFRegister sDFFRegister = new SDFFRegister();
        try {
            randomAccessFile.seek(l2);
            long l3 = randomAccessFile.readLong();
            randomAccessFile.skipBytes(8);
            sDFFRegister.count = randomAccessFile.readLong();
            sDFFRegister.size = randomAccessFile.readLong();
            DvUtils.writetoTrace("  .... count of registers in this section is:" + sDFFRegister.count + " with size " + sDFFRegister.size);
            if (sDFFRegister.size != 4L && sDFFRegister.size != 8L && sDFFRegister.size != 16L) {
                sDFFRegister.count = 0L;
                sDFFRegister.size = 0L;
            }
            for (int i = 0; i < (int)sDFFRegister.count; ++i) {
                byte[] byArray = new byte[8];
                randomAccessFile.read(byArray);
                String string = new String(byArray, "ASCII");
                long l4 = randomAccessFile.readLong();
                sDFFRegister.names.add(string);
                sDFFRegister.values.add(new Long(l4));
            }
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFThread: loadFromFile", 0);
        }
        DvUtils.writetoTrace("Exit from SDFFRegister:loadFromFile");
        return sDFFRegister;
    }
}

