/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.SDFFEnvData;
import com.ibm.jvm.dump.sdff.SDFFLoaded;
import com.ibm.jvm.dump.sdff.SDFFMemoryMap;
import com.ibm.jvm.dump.sdff.SDFFThread;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class SDFFProcess
extends DvProcess {
    long id;
    long numThreads;
    long currentThread;
    long signalNumber;
    String signalName;
    String commandLine;
    boolean hasJavaThreads;
    Vector threads = new Vector();
    DvAddressSpace aSpace;
    long processOffset;
    long processLength;
    SDFFEnvData envInfo;
    SDFFLoaded loadList;

    public SDFFProcess(long l, long l2, long l3, long l4, String string, String string2, long l5, long l6, RandomAccessFile randomAccessFile, DvAddressSpace dvAddressSpace) {
        this.id = l;
        this.numThreads = l2;
        this.currentThread = l3;
        this.signalNumber = l4;
        this.signalName = string;
        this.commandLine = string2;
        this.processOffset = l5;
        this.processLength = l6;
        this.aSpace = dvAddressSpace;
        this.hasJavaThreads = false;
        byte[] byArray = SdffConstants.SEGMENT_Eye_SdffEnvData.getBytes();
        long l7 = this.processOffset + this.processLength;
        long l8 = this.processOffset;
        DvUtils.writetoTrace("Looking for EnvData eyecatcher...");
        l8 = DvUtils.findNextInFile(randomAccessFile, byArray, l8, l7, 1);
        DvUtils.writetoTrace("... returned offset is x" + Long.toHexString(l8));
        this.envInfo = -1L != l8 ? SDFFEnvData.loadFromFile(l8 - 8L, randomAccessFile) : null;
        byte[] byArray2 = SdffConstants.SEGMENT_Eye_SdffLoaded.getBytes();
        l7 = this.processOffset + this.processLength;
        long l9 = this.processOffset;
        DvUtils.writetoTrace("Looking for Loaded eyecatcher...");
        l9 = DvUtils.findNextInFile(randomAccessFile, byArray2, l9, l7, 1);
        DvUtils.writetoTrace("... returned offset is x" + Long.toHexString(l9));
        this.loadList = -1L != l9 ? SDFFLoaded.loadFromFile(l9 - 8L, randomAccessFile) : null;
        l7 = this.processOffset + this.processLength;
        int n = 0;
        byte[] byArray3 = SdffConstants.SEGMENT_Eye_SdffThread.getBytes();
        long l10 = this.processOffset;
        while (l10 != -1L) {
            DvUtils.writetoTrace("  Looking for Thread eyecatcher...");
            l10 = DvUtils.findNextInFile(randomAccessFile, byArray3, l10, l7, 1);
            DvUtils.writetoTrace("  ... returned offset is x" + Long.toHexString(l10));
            if (l10 == -1L) continue;
            ++n;
            SDFFThread sDFFThread = SDFFThread.loadFromFile(l10 - 8L, randomAccessFile);
            this.threads.add(sDFFThread);
            if (!this.hasJavaThreads && sDFFThread.isJava()) {
                this.hasJavaThreads = true;
            }
            try {
                randomAccessFile.seek(l10 - 8L);
                l10 += randomAccessFile.readLong();
            }
            catch (IOException iOException) {
                System.out.println("IOException in SDFFProcess");
            }
        }
    }

    public DvAddressSpace getAddressSpace() {
        return this.aSpace;
    }

    public String id() {
        return Long.toString(this.id);
    }

    public DvThread[] getThreads() {
        DvThread[] dvThreadArray = new DvThread[this.threads.size()];
        for (int i = 0; i < this.threads.size(); ++i) {
            dvThreadArray[i] = (DvThread)this.threads.get(i);
        }
        return dvThreadArray;
    }

    public boolean isJava() {
        return this.hasJavaThreads;
    }

    public byte[] getMetaData() {
        return null;
    }

    public String getSignal() {
        return this.signalName;
    }

    public DvThread getCurrentThread() {
        if (-1L == this.currentThread) {
            return null;
        }
        DvThread dvThread = null;
        for (int i = 0; i < this.threads.size(); ++i) {
            dvThread = (DvThread)this.threads.get(i);
            if (dvThread.id().equals(Long.toString(this.currentThread))) {
                return dvThread;
            }
            dvThread = null;
        }
        return dvThread;
    }

    public DvEnvData getEnvData() {
        return this.envInfo;
    }

    public DvLoaded getLoaded() {
        return this.loadList;
    }

    void printSdff(Sdff sdff, SDFFMemoryMap sDFFMemoryMap) throws IOException {
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.write(SdffConstants.SEGMENT_Eye_SdffProc.getBytes());
        sdff.writeLong(this.threads.size());
        sdff.writeLong(-1L);
        sdff.writeLong(this.signalNumber);
        sdff.writeBytes(this.signalName);
        long l2 = sdff.getFilePointer();
        this.envInfo.printSdff(sdff);
        sDFFMemoryMap.printLoaded(sdff);
        sdff.printLength(l2);
        Enumeration enumeration = this.threads.elements();
        while (enumeration.hasMoreElements()) {
            SDFFThread sDFFThread = (SDFFThread)enumeration.nextElement();
            sDFFThread.printSdff(sdff);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

