/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import com.ibm.jvm.dump.plugins.STGlobalData;

class GcHelperDetails {
    private final STGlobalData sTGlobalData;
    private int gcHelpers;
    private int gcHelpersTarget;
    private int gcHelpersCeiling;
    private int gcThreadCount;
    private String[] gcThreadName;
    private DvThread[] gcThread;

    GcHelperDetails(STGlobalData sTGlobalData) {
        this.sTGlobalData = sTGlobalData;
        this.gcHelpers = this.sTGlobalData.getIntItem("gcHelpers");
        this.gcHelpersTarget = this.sTGlobalData.getIntItem("gcHelpersTarget");
        this.gcHelpersCeiling = this.sTGlobalData.getIntItem("gcHelpersCeiling");
        if (this.gcHelpersCeiling == 0) {
            this.gcHelpersCeiling = this.gcHelpers;
        }
        this.gcThreadCount = this.gcHelpersCeiling;
        if (this.sTGlobalData.isGcThreadsChangeable()) {
            ++this.gcThreadCount;
        }
        this.gcThreadName = new String[this.gcThreadCount];
        this.gcThread = new DvThread[this.gcThreadCount];
        for (int i = 0; i < this.gcHelpersCeiling; ++i) {
            this.gcThreadName[i] = "GC Helper " + (i + 1);
        }
        if (this.sTGlobalData.isGcThreadsChangeable()) {
            this.gcThreadName[this.gcHelpersCeiling] = "GC Helper Reconfiguration Thread";
        }
        DvThread[] dvThreadArray = this.sTGlobalData.getCurrentProcess().getThreads();
        for (int i = 0; i < dvThreadArray.length; ++i) {
            for (int j = 0; j < this.gcThreadCount; ++j) {
                if (!DvUtils.getThreadName(dvThreadArray[i], this.sTGlobalData.getCurrentAddressSpace()).equals(this.gcThreadName[j])) continue;
                this.gcThread[j] = dvThreadArray[i];
            }
        }
    }

    void report(OutputStrategy outputStrategy) {
        outputStrategy.output("gcHelpers         :\n    Active        :  " + this.gcHelpers + "\n    Target        :  " + this.gcHelpersTarget);
        if (this.sTGlobalData.isGcThreadsChangeable()) {
            outputStrategy.output("\n    Ceiling       : " + this.gcHelpersCeiling);
        }
        outputStrategy.output("");
        outputStrategy.output("gc Helper Threads :");
        for (int i = 0; i < this.gcHelpersCeiling; ++i) {
            outputStrategy.output("    Name          : " + this.gcThreadName[i]);
            if (this.gcThread[i] != null) {
                outputStrategy.output("        Id        : 0x" + this.gcThread[i].id() + "\n        ExecEnv   : 0x" + this.gcThread[i].eeAddress().convertToHex() + "\n        MarkStack : 0x" + DvUtils.rJustifyZ(Long.toHexString(this.sTGlobalData.getMarkStackDetails().markStackForHelper(i).getAddressAsLong()), 0));
                continue;
            }
            outputStrategy.output("!!Can't be found");
        }
        if (this.gcThreadCount != this.gcHelpersCeiling) {
            outputStrategy.output("    Name          : " + this.gcThreadName[this.gcHelpersCeiling]);
            if (this.gcThread[this.gcHelpersCeiling] != null) {
                outputStrategy.output("\n        Id        : 0x" + this.gcThread[this.gcHelpersCeiling].id() + "\n        ExecEnv   : 0x" + this.gcThread[this.gcHelpersCeiling].eeAddress().convertToHex());
            } else {
                outputStrategy.output("!!Can't be found");
            }
        }
    }

    int getGcHelpersCeiling() {
        return this.gcHelpersCeiling;
    }
}

