/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMonitor;
import com.ibm.jvm.dump.format.DvMonitorsRepository;
import com.ibm.jvm.dump.format.DvObject;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvThreadDetails;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvGeneralSov;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.util.Hashtable;
import java.util.Vector;

public class DvMonitorsSov
extends CommandPlugin {
    private static boolean monitorsProcessed = false;
    private static long ptrLength = 4L;
    private static DvThreadDetails dvThreadDetails = null;
    private static DvAddressSpace as = null;
    private static boolean unknownSystem = false;
    private static String[] mySuffixes = new String[]{"sov"};
    private static String[] commandsSupported = new String[0];
    private static DvMonitorsSov selfRef;

    public DvMonitorsSov() {
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public String pluginName() {
        return "com.ibm.jvm.dump.plugins.DvMonitorsSov";
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static String checkLockingData() {
        long l;
        String string = null;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        long l2 = Long.parseLong(DvUtils.getJVMHint(dvAddressSpace, "LKGLOBALPTR"), 16);
        if (l2 == (l = Long.parseLong(DvUtils.getJVMHint(dvAddressSpace, "DGGLOBALPTR"), 16))) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.checkLKGLOBALPTR");
            string = "Sov Monitor data unavailable - LKGLOBALPTR (hint) error";
        }
        return string;
    }

    public Vector displayMonitorPoolInfo(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayMonitorPoolInfo");
        Vector<String> vector = new Vector<String>();
        if (string.equals(new String("javacore"))) {
            vector.add("1LKPOOLINFO");
            vector.add("Monitor pool info:");
            vector.add("2LKPOOLINIT");
            vector.add("  Initial monitor count: 32");
            vector.add("2LKPOOLEXPNUM");
            vector.add("  Minumum number of free moniors before expansion: 5");
            vector.add("2LKPOOLEXPBY");
            vector.add("  Pool will next be expanded by: <unknown>");
            vector.add("2LKPOOLTOTAL");
            vector.add("  Current total number of free monitors: <unknown>");
            vector.add("2LKPOOLFREE");
            vector.add("  Current number of free monitors: <unknown>");
            vector.add("NULL");
            vector.add("");
        } else {
            vector.add("");
            vector.add("Monitor pool info:");
            vector.add("  Initial monitor count: 32");
            vector.add("  Minumum number of free moniors before expansion: 5");
            vector.add("  Pool will next be expanded by: <unknown>");
            vector.add("  Current total number of free monitors: <unknown>");
            vector.add("  Current number of free monitors: <unknown>");
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayMonitorPoolInfo");
        return vector;
    }

    public Vector displayMonitorPoolDump(String string, DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayMonitorPoolDump(String, ObjectDetails)");
        Vector<Object> vector = new Vector<Object>();
        if (!monitorsProcessed) {
            DvMonitorsSov.processMonitors(vector);
        }
        if (string.equals(new String("javacore"))) {
            vector.addElement("1LKMONPOOLDUMP");
            vector.addElement("Monitor Pool Dump (flat & inflated object-monitors):");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Inflated Object-Monitors:");
        }
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (string.equals(new String("dis ls"))) {
            long l = Long.parseLong(DvUtils.getJVMHint(dvAddressSpace, "LKGLOBALPTR"), 16);
            long l2 = DvUtils.getControlBlockField("_lkgldata", "micb", l, dvAddressSpace);
            vector.add("     Information is from a table of inflated monitors:");
            vector.add("         monitor_index_cb_t 0x" + Long.toHexString(l2));
            vector.add("");
        }
        boolean bl = false;
        Hashtable hashtable = DvMonitorsRepository.getLockedObjectsByAddrHashtable();
        if (0 == hashtable.size()) {
            bl = true;
        }
        int n = 0;
        DvMonitor dvMonitor = DvMonitorsRepository.getInflMon(n);
        while (null != dvMonitor) {
            long l;
            if (string.equals(new String("javacore"))) {
                vector.add("2LKMONINUSE");
                vector.add("  sys_mon_t:0x" + Long.toHexString(dvMonitor.getSysMon()) + " infl_mon_t: 0x" + Long.toHexString(dvMonitor.getAddress()));
            }
            if (string.equals(new String("dis ls"))) {
                vector.add("(0x" + Long.toHexString(dvMonitor.getAddress()) + ")");
            }
            if (DvObjectsCommands.checkForKnownObject((l = dvMonitor.getObjectAddress()) - ptrLength)) {
                Object object;
                DvObject dvObject2 = null;
                if (!bl) {
                    dvObject2 = (DvObject)hashtable.get(new Long(l - ptrLength));
                } else {
                    object = new Long(l - ptrLength);
                    dvObject2 = DvObjectsCommands.scanner.getObjectDetails(l - ptrLength);
                    hashtable.put(object, dvObject2);
                }
                object = "";
                if (string.equals(new String("javacore"))) {
                    object = "    " + dvMonitor.getObjectName() + "@" + Long.toHexString(dvMonitor.getObjectAddress()) + "/" + Long.toHexString(dvMonitor.getObjectAddress() + 8L) + ":";
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && dvObject.address == dvObject2.address) {
                    object = "    (0x" + Long.toHexString(dvMonitor.getObjectAddress()) + ") " + dvMonitor.getObjectName();
                    vector.add(object);
                    object = "";
                }
                if (DvUtils.checkAddressInDump(dvAddressSpace.createAddress(dvMonitor.getOwnerAddress()), dvAddressSpace) && 0L != dvMonitor.getOwnerAddress()) {
                    long l3 = 4 == DvConsole.theDump.getSystemType() ? DvUtils.getControlBlockFieldInt("sys_mon", "monitor_usecount", dvMonitor.getSysMon(), dvAddressSpace) : DvUtils.getControlBlockFieldInt("sys_mon", "entry_count", dvMonitor.getSysMon(), dvAddressSpace);
                    if (string.equals(new String("javacore"))) {
                        object = (String)object + " owner \"" + dvMonitor.getOwnerName() + "\" (0x" + Long.toHexString(dvMonitor.getOwnerAddress()) + ") " + "entry count " + l3;
                    }
                    if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && dvObject.address == dvObject2.address) {
                        object = (String)object + "        inflated lock owned by " + DvUtils.rJustify("0x" + dvMonitor.getOwnerThreadID(), 10) + " \"" + dvMonitor.getOwnerName() + "\", entry count " + l3;
                    }
                } else if (dvObject2.lock && 0L == dvObject2.shapeBit) {
                    if (string.equals(new String("javacore"))) {
                        object = (String)object + " flat locked by thread ident " + DvUtils.rJustify(Long.toString(dvObject2.threadId), 8) + " " + DvUtils.rJustify("(0x" + Long.toHexString(dvObject2.threadId) + ")", 12) + ", entry count " + dvObject2.entryCount + " ";
                    }
                    if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && dvObject.address == dvObject2.address) {
                        DvThreadDetails.processThreads();
                        Object object2 = DvThreadDetails.getThreadDetailsById(Long.toHexString(dvObject2.threadId));
                        if (object2 != null) {
                            object = (String)object + "        flat locked by " + DvThreadDetails.getThreadID(object2) + " \"" + DvThreadDetails.getThreadName(object2) + "\"" + ", entry count " + dvObject2.entryCount + " ";
                        }
                    }
                } else {
                    boolean bl2 = false;
                    if (0L != dvObject2.init_thread) {
                        DvDump dvDump = DvConsole.theDump;
                        DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
                        DvThread[] dvThreadArray = dvProcess.getThreads();
                        for (int i = 0; i < dvThreadArray.length && !bl2; ++i) {
                            if (dvObject2.init_thread != dvThreadArray[i].eeAddress().getAddressAsLong()) continue;
                            object = (String)object + "        locked by 0x" + dvThreadArray[i].id();
                            bl2 = true;
                        }
                    }
                    if (string.equals(new String("javacore"))) {
                        object = (String)object + "<unowned>";
                    }
                    if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && dvObject.address == dvObject2.address) {
                        object = (String)object + "        <unowned>";
                    }
                }
                if (string.equals(new String("javacore"))) {
                    vector.addElement("3LKMONOBJECT");
                    vector.addElement(object);
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo")) && dvObject.address == dvObject2.address) {
                    vector.add(object);
                    this.waitAndEnterQ(string, dvMonitor, vector);
                }
                object = "";
            } else {
                if (string.equals(new String("javacore"))) {
                    vector.add("3LKWAITNOTIFY");
                    vector.add("    unknown object at: 0x" + Long.toHexString(l - ptrLength));
                }
                if (string.equals(new String("dis ls"))) {
                    vector.add("    unknown object at: 0x" + Long.toHexString(l - ptrLength));
                }
            }
            if (string.equals(new String("dis ls"))) {
                vector.add("");
            }
            dvMonitor = DvMonitorsRepository.getInflMon(++n);
        }
        if (string.equals(new String("javacore"))) {
            vector.add("NULL");
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayMonitorPoolDump(String, ObjectDetails)");
        return vector;
    }

    public Vector displaySysMonitorDump(String string) {
        long l;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displaySysMonitorDump");
        Vector<String> vector = new Vector<String>();
        if (!monitorsProcessed) {
            DvMonitorsSov.processMonitors(vector);
        }
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (string.equals(new String("javacore"))) {
            vector.add("1LKREGMONDUMP");
            vector.add("JVM System Monitor Dump (registered monitors): ");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Registered Monitors: ");
        }
        if (string.equals(new String("dis ls"))) {
            long l2 = Long.parseLong(DvUtils.getJVMHint(dvAddressSpace, "LKGLOBALPTR"), 16);
            l = DvUtils.getControlBlockField("_lkgldata", "reg", l2, dvAddressSpace);
            vector.add(" Pointer to first registry monitor (0x" + Long.toHexString(l) + ")");
            vector.add("");
        }
        int n = 0;
        DvMonitor dvMonitor = DvMonitorsRepository.getRegMon(n);
        while (null != dvMonitor) {
            l = dvMonitor.getSysMon();
            long l3 = dvMonitor.getOwnerAddress();
            if (string.equals(new String("dis ls"))) {
                vector.addAll(this.showReg(dvMonitor));
            }
            if (DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l3), dvAddressSpace) && 0L != l3) {
                long l4 = 0L;
                l4 = 4 == DvConsole.theDump.getSystemType() ? DvUtils.getControlBlockFieldInt("sys_mon", "monitor_usecount", l, dvAddressSpace) : DvUtils.getControlBlockFieldInt("sys_mon", "entry_count", l, dvAddressSpace);
                if (string.equals(new String("javacore"))) {
                    vector.add("2LKREGMON");
                    vector.add("    " + dvMonitor.getName() + ":" + "owner \"" + dvMonitor.getOwnerName() + "\" (0x" + Long.toHexString(l) + ")" + ", entry count " + l4);
                }
            } else if (string.equals(new String("javacore"))) {
                vector.add("2LKREGMON");
                vector.add("    " + dvMonitor.getName() + ": <unowned>");
            }
            if (!string.equals(new String("dis ls"))) {
                this.waitAndEnterQ(string, dvMonitor, vector);
            }
            dvMonitor = DvMonitorsRepository.getRegMon(++n);
        }
        if (string.equals(new String("javacore"))) {
            vector.add("NULL");
            vector.add("");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
        }
        DvUtils.writetoTrace("Exit:5 DvObjectsCommands.displaySysMonitorDump");
        return vector;
    }

    public static void processMonitors(Vector vector) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processMonitors");
        if (!monitorsProcessed) {
            Object object;
            int n;
            vector.add("\n\nAnalysis of Monitors started.... \n");
            DvMonitorsSov.processInflatedMonitors();
            DvMonitorsSov.processRegisteredMonitors();
            for (n = 0; n < DvThreadDetails.getThreadCount(); ++n) {
                long l;
                DvMonitor dvMonitor;
                long l2;
                DvMonitor dvMonitor2;
                object = DvThreadDetails.getThreadDetailsByPosition(n);
                long l3 = DvThreadDetails.getEnterMon(object);
                if (l3 != 0L && (dvMonitor2 = DvMonitorsRepository.getMonitorBySysMon(Long.toHexString(l3))) != null) {
                    Object object2 = DvThreadDetails.getThreadDetailsBySysthr(Long.toHexString(dvMonitor2.getOwnerAddress()));
                    DvThreadDetails.addBlockingThread(object, object2);
                }
                if ((l2 = DvThreadDetails.getWaitMon(object)) == 0L || (dvMonitor = DvMonitorsRepository.getMonitorByAddr(Long.toHexString(l2))) == null) continue;
                Object object3 = DvThreadDetails.getThreadDetailsBySysthr(Long.toHexString(dvMonitor.getOwnerAddress()));
                if (object3 == null && (l = dvMonitor.getObjectAddress()) != 0L) {
                    DvObject dvObject = DvObjectsCommands.scanner.getObjectDetails(l - ptrLength);
                    object3 = DvThreadDetails.getThreadDetailsById(Long.toHexString(dvObject.threadId));
                    if (object3 == null) {
                        boolean bl = false;
                        if (0L != dvObject.init_thread) {
                            DvDump dvDump = DvConsole.theDump;
                            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
                            DvThread[] dvThreadArray = dvProcess.getThreads();
                            for (int i = 0; i < dvThreadArray.length && !bl; ++i) {
                                if (dvObject.init_thread != dvThreadArray[i].eeAddress().getAddressAsLong()) continue;
                                object3 = DvThreadDetails.getThreadDetailsByEe(Long.toHexString(dvObject.init_thread));
                                bl = true;
                            }
                        }
                    }
                }
                DvThreadDetails.addBlockingThread(object, object3);
            }
            for (n = 0; n < DvThreadDetails.getThreadCount(); ++n) {
                object = null;
                Object object4 = DvThreadDetails.getThreadDetailsByPosition(n);
                if (DvThreadDetails.getProcessed(object4)) continue;
                object = object4;
                do {
                    DvThreadDetails.incDeadlocked(object);
                } while ((object = DvThreadDetails.getBlockingThread(object)) != null && !DvThreadDetails.getProcessed(object) && DvThreadDetails.getDeadlocked(object) < 3);
                if (object == null) {
                    object = object4;
                    while (object != null) {
                        DvThreadDetails.setProcessed(object, true);
                        DvThreadDetails.decDeadlocked(object);
                        object = DvThreadDetails.getBlockingThread(object);
                    }
                    continue;
                }
                DvThreadDetails.decDeadlocked(object);
                if (DvThreadDetails.getProcessed(object)) {
                    object = object4;
                    do {
                        DvThreadDetails.setProcessed(object, true);
                    } while (!DvThreadDetails.getProcessed(object = DvThreadDetails.getBlockingThread(object)));
                    continue;
                }
                object4 = object;
                do {
                    DvThreadDetails.setProcessed(object, true);
                } while (!DvThreadDetails.getProcessed(object = DvThreadDetails.getBlockingThread(object)));
                Vector vector2 = DvMonitorsRepository.getDeadlocksVector();
                vector2.addElement(object4);
            }
            monitorsProcessed = true;
            vector.add("\nAnalysis of Monitors ended. \n");
        }
    }

    private void waitAndEnterQ(String string, DvMonitor dvMonitor, Vector vector) {
        int n;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.waitAndEnterQ");
        if (0L < dvMonitor.getEnterSize()) {
            if (string.equals(new String("javacore"))) {
                vector.add("3LKENTERQ ");
                vector.add("       Waiting to enter:");
            }
            if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                vector.add("            Waiting to enter:");
            }
            n = 0;
            while ((long)n < dvMonitor.getEnterSize()) {
                if (string.equals(new String("javacore"))) {
                    vector.add("3LKWAITENTER ");
                    vector.add("          \"" + dvMonitor.getEnterName(n) + "\" (0x" + Long.toHexString(dvMonitor.getEnterAddress(n)) + ")");
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                    vector.add("              " + DvUtils.rJustify("0x" + dvMonitor.getEnterThreadID(n), 10) + " \"" + dvMonitor.getEnterName(n) + "\" ");
                }
                ++n;
            }
        }
        if (0L < dvMonitor.getWaiterSize()) {
            if (string.equals(new String("javacore"))) {
                vector.add("3LKNOTIFYQ");
                vector.add("       Waiting to be notified:");
            }
            if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                vector.add("            Waiting to be notified:");
            }
            n = 0;
            while ((long)n < dvMonitor.getWaiterSize()) {
                if (string.equals(new String("javacore"))) {
                    vector.add("3LKWAITNOTIFY");
                    vector.add("          \"" + dvMonitor.getWaiterName(n) + "\" (0x" + Long.toHexString(dvMonitor.getWaiterAddress(n)) + ")");
                }
                if (string.equals(new String("dis ls")) || string.equals(new String("dis lo"))) {
                    vector.add("              " + DvUtils.rJustify(dvMonitor.getWaiterThreadID(n), 10) + " " + " \"" + dvMonitor.getWaiterName(n) + "\" ");
                }
                ++n;
            }
            DvUtils.writetoTrace("Exit:DvObjectsCommands.waitAndEnterQ");
        }
    }

    public Vector showReg(DvMonitor dvMonitor) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.showReg(MonDetails)");
        Vector<String> vector = new Vector<String>();
        vector.add("(0x" + Long.toHexString(dvMonitor.getAddress()) + ") " + dvMonitor.getName());
        if (0L != dvMonitor.getOwnerAddress()) {
            vector.add("    owned by thread " + DvUtils.rJustify("0x" + dvMonitor.getOwnerThreadID(), 10) + " \"" + dvMonitor.getOwnerName() + "\"");
        }
        this.waitAndEnterQ("dis ls", dvMonitor, vector);
        vector.add("");
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.showReg(MonDetails)");
        return vector;
    }

    private static void processInflatedMonitors() {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processInflatedMonitors");
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        int n = DvConsole.theDump.getSystemType();
        long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        long l2 = DvUtils.getControlBlockField("_lkgldata", "micb", l, as);
        long l3 = DvUtils.getControlBlockField("monitor_index_cb_t", "table", l2, as);
        long l4 = DvUtils.getControlBlockFieldInt("monitor_index_cb_t", "count", l2, as);
        long l5 = 0L;
        int n2 = 1;
        try {
            l5 = as.readPointer(as.createAddress(l3)).getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 processInflatedMonitors DvAddressException");
            return;
        }
        l3 += ptrLength;
        if (l5 != 0L) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflatedMonitors(String, ObjectDetails)");
            return;
        }
        while (l4 - (long)n2 > 0L) {
            try {
                l5 = as.readPointer(as.createAddress(l3)).getAddressAsLong();
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace("Continue:3 DvObjectsCommands.processInflatedMonitors DvAddressException");
            }
            DvMonitor dvMonitor = new DvMonitor(l5, true, as);
            if (dvMonitor.isOwnedOrWaitedOn()) {
                DvMonitorsSov.processMonitor(dvMonitor);
                DvMonitorsRepository.addToInflatedMonList(dvMonitor);
            } else {
                DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processInflSub(long)");
            }
            ++n2;
            l3 += ptrLength;
        }
    }

    private static void processRegisteredMonitors() {
        long l;
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processRegisteredMonitors");
        long l2 = 0L;
        String string = "";
        String string2 = "";
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        try {
            long l3 = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
            long l4 = DvUtils.getControlBlockField("_lkgldata", "reg", l3, as);
            l = as.readPointer(as.createAddress(l4)).getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Exit:1 DvObjectsCommands.processRegisteredMonitors DvAddressException in displaySysMonitorDump Unable to get the first reg_mon");
            return;
        }
        while (l != 0L && DvUtils.checkAddressInDump(as.createAddress(l), as)) {
            DvMonitor dvMonitor = new DvMonitor(l, false, as);
            DvMonitorsSov.processMonitor(dvMonitor);
            DvMonitorsRepository.addToRegMonList(dvMonitor);
            l = DvUtils.getControlBlockField("reg_mon", "next", l, as);
        }
        DvUtils.writetoTrace("Exit:5 DvObjectsCommands.processRegisteredMonitors");
    }

    private static void processMonitor(DvMonitor dvMonitor) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.processMonitor(MonDetails monitor)");
        long l = dvMonitor.getWaitQ(0);
        long l2 = dvMonitor.getWaitQ(1);
        boolean bl = false;
        if (l == 0L) {
            l = l2;
            bl = true;
        }
        while (l != 0L) {
            long l3 = dvMonitor.getWaitQThread(l);
            dvMonitor.addWaiter(l3);
            Object object = DvThreadDetails.getThreadDetailsBySysthr(Long.toHexString(l3));
            if (null == object) {
                object = DvThreadDetails.createThreadDetails(l3, "Dummy!!!", 0L, 0L, "Dummy!!!");
                DvUtils.trace("\n !!!!!WARNING!!!!!WARNING!!!!!WARNING!!!!!\n\t Lock analysis has detected a problem whereby ...\n The waitQ thread identified by  \"" + Long.toHexString(l3) + "\"\n is specified in monitor with address 0x" + Long.toHexString(dvMonitor.getAddress()) + "\n and couldn't be located in threadsBySysthr\n" + "\tThis may be due to a corrupted heap or (more likely)\n" + "\ta dump taken during a GC cycle. Further errors likely for\n" + "\tthis lock as control block addresses may be wrong." + "\n !!!!!WARNING!!!!!WARNING!!!!!WARNING!!!!!\n", 0, true);
            }
            DvThreadDetails.addWaitMon(object, dvMonitor.getAddress());
            if ((l = dvMonitor.getNextWaitQ(l)) != 0L || bl) continue;
            l = l2;
            bl = true;
        }
    }

    public Vector displayJavaObjMonDump(String string) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.displayJavaObjMonDump(String)");
        Vector<String> vector = new Vector<String>();
        if (string.equals(new String("javacore"))) {
            vector.add("1LKOBJMONDUMP");
            vector.add("Java Object Monitor Dump (flat & inflated object-monitors):");
        }
        if (string.equals(new String("dis ls"))) {
            vector.add("");
            vector.add("Flat & Inflated Object-Monitors:");
        }
        boolean bl = false;
        Hashtable hashtable = DvMonitorsRepository.getLockedObjectsByAddrHashtable();
        if (0 == hashtable.size()) {
            bl = true;
        }
        int n = 0;
        Long l = DvGeneralSov.getLockedObject(n);
        while (null != l) {
            long l2 = l;
            DvObject dvObject = null;
            if (bl) {
                dvObject = DvObjectsCommands.scanner.getObjectDetails(l2);
                hashtable.put(l, dvObject);
            } else {
                dvObject = (DvObject)hashtable.get(l);
            }
            if (null == dvObject) {
                dvObject = DvObjectsCommands.scanner.getObjectDetails(l2);
                hashtable.put(l, dvObject);
            }
            if (0L == dvObject.shapeBit) {
                if (string.equals(new String("javacore"))) {
                    vector.add("2LKINFLATEDMON");
                    vector.add("    " + dvObject.objectName + "@" + Long.toHexString(dvObject.address) + "/" + Long.toHexString(dvObject.address + 8L));
                    vector.add("3LKINFLDETAILS");
                    vector.add("        locknflags " + Long.toHexString(dvObject.locknflags) + " flat locked by thread ident " + dvObject.threadId + ", entry count " + dvObject.entryCount);
                }
                if (string.equals(new String("dis ls"))) {
                    DvThreadDetails.processThreads();
                    Object object = DvThreadDetails.getThreadDetailsById(Long.toHexString(dvObject.threadId));
                    if (object != null) {
                        vector.add("");
                        vector.add("    (0x" + Long.toHexString(dvObject.address) + ") " + dvObject.objectName + " ");
                        vector.add("        flat locked by " + DvThreadDetails.getThreadID(object) + " \"" + DvThreadDetails.getThreadName(object) + "\", entry count " + dvObject.entryCount);
                    }
                    if (!monitorsProcessed) {
                        DvMonitorsSov.processMonitors(vector);
                    }
                    int n2 = 0;
                    DvMonitor dvMonitor = DvMonitorsRepository.getInflMon(n2);
                    while (null != dvMonitor) {
                        long l3 = dvMonitor.getObjectAddress();
                        if (l3 == dvObject.address && 0L < dvMonitor.getWaiterSize()) {
                            vector.add("            Waiting to be notified:");
                            int n3 = 0;
                            while ((long)n3 < dvMonitor.getWaiterSize()) {
                                vector.add("              " + DvUtils.rJustify("0x" + dvMonitor.getWaiterThreadID(n3), 10) + " \"" + dvMonitor.getWaiterName(n3) + "\" ");
                                ++n3;
                            }
                        }
                        dvMonitor = DvMonitorsRepository.getInflMon(++n2);
                    }
                }
            } else {
                if (string.equals(new String("javacore"))) {
                    vector.add("2LKINFLATEDMON");
                    vector.add("    " + dvObject.objectName + "@" + Long.toHexString(dvObject.address) + "/" + Long.toHexString(dvObject.address + 8L));
                    vector.add("3LKINFLDETAILS");
                    vector.add("        locknflags " + Long.toHexString(dvObject.locknflags) + " Monitor inflated infl_mon 0x" + Long.toHexString(dvObject.inflMon));
                }
                if (string.equals(new String("dis ls"))) {
                    vector.add("");
                    vector.addAll(DvMonitorsRepository.displayMonitorPoolDump("dis lo", dvObject));
                }
            }
            l = DvGeneralSov.getLockedObject(++n);
        }
        DvUtils.writetoTrace("Exit:1 DvObjectsCommands.displayJavaObjMonDump(String)");
        return vector;
    }
}

